/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.helper;

import com.oracle.js.parser.ECMAErrors;
import com.oracle.js.parser.JSErrorType;
import com.oracle.js.parser.JSType;
import com.oracle.js.parser.ParserException;
import com.oracle.js.parser.Source;
import com.oracle.js.parser.Token;
import com.oracle.js.parser.TokenType;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.Null;

public class NashornJSONParser {
    private final String source;
    private final JSContext context;
    private final int length;
    private int pos = 0;
    private static final int EOF = -1;
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String NULL = "null";
    private static final int STATE_EMPTY = 0;
    private static final int STATE_ELEMENT_PARSED = 1;
    private static final int STATE_COMMA_PARSED = 2;

    public NashornJSONParser(String source, JSContext context) {
        this.source = source;
        this.context = context;
        this.length = source.length();
    }

    public Object parse() {
        Object value = this.parseLiteral();
        this.skipWhiteSpace();
        if (this.pos < this.length) {
            throw this.expectedError(this.pos, "eof", NashornJSONParser.toString(this.peek()));
        }
        return value;
    }

    private Object parseLiteral() {
        this.skipWhiteSpace();
        int c = this.peek();
        if (c == -1) {
            throw this.expectedError(this.pos, "json literal", "eof");
        }
        switch (c) {
            case 123: {
                return this.parseObject();
            }
            case 91: {
                return this.parseArray();
            }
            case 34: {
                return this.parseString();
            }
            case 102: {
                return this.parseKeyword(FALSE, Boolean.FALSE);
            }
            case 116: {
                return this.parseKeyword(TRUE, Boolean.TRUE);
            }
            case 110: {
                return this.parseKeyword(NULL, (Object)Null.instance);
            }
        }
        if (NashornJSONParser.isDigit(c) || c == 45) {
            return this.parseNumber();
        }
        if (c == 46) {
            throw this.numberError(this.pos);
        }
        throw this.expectedError(this.pos, "json literal", NashornJSONParser.toString(c));
    }

    private Object parseObject() {
        DynamicObject jsobject = JSOrdinary.create(this.context, JSRealm.get(null));
        int state = 0;
        assert (this.peek() == 123);
        ++this.pos;
        block5: while (this.pos < this.length) {
            this.skipWhiteSpace();
            int c = this.peek();
            switch (c) {
                case 34: {
                    if (state == 1) {
                        throw this.expectedError(this.pos, ", or }", NashornJSONParser.toString(c));
                    }
                    String id = this.parseString();
                    this.expectColon();
                    Object value = this.parseLiteral();
                    this.addObjectProperty(jsobject, id, value);
                    state = 1;
                    continue block5;
                }
                case 44: {
                    if (state != 1) {
                        throw this.trailingCommaError(this.pos, NashornJSONParser.toString(c));
                    }
                    state = 2;
                    ++this.pos;
                    continue block5;
                }
                case 125: {
                    if (state == 2) {
                        throw this.trailingCommaError(this.pos, NashornJSONParser.toString(c));
                    }
                    ++this.pos;
                    return jsobject;
                }
            }
            throw this.expectedError(this.pos, ", or }", NashornJSONParser.toString(c));
        }
        throw this.expectedError(this.pos, ", or }", "eof");
    }

    private void addObjectProperty(DynamicObject object, String id, Object value) {
        JSObjectUtil.defineDataProperty(this.context, object, id, value, JSAttributes.getDefault());
    }

    private void expectColon() {
        this.skipWhiteSpace();
        int n = this.next();
        if (n != 58) {
            throw this.expectedError(this.pos - 1, ":", NashornJSONParser.toString(n));
        }
    }

    private Object parseArray() {
        DynamicObject jsarray = JSArray.createEmptyZeroLength(this.context, JSRealm.get(null));
        ScriptArray arrayData = JSAbstractArray.arrayGetArrayType(jsarray);
        int state = 0;
        assert (this.peek() == 91);
        ++this.pos;
        block4: while (this.pos < this.length) {
            this.skipWhiteSpace();
            int c = this.peek();
            switch (c) {
                case 44: {
                    if (state != 1) {
                        throw this.trailingCommaError(this.pos, NashornJSONParser.toString(c));
                    }
                    state = 2;
                    ++this.pos;
                    continue block4;
                }
                case 93: {
                    if (state == 2) {
                        throw this.trailingCommaError(this.pos, NashornJSONParser.toString(c));
                    }
                    ++this.pos;
                    return jsarray;
                }
            }
            if (state == 1) {
                throw this.expectedError(this.pos, ", or ]", NashornJSONParser.toString(c));
            }
            long index = arrayData.length(jsarray);
            arrayData = arrayData.setElement(jsarray, index, this.parseLiteral(), true);
            JSAbstractArray.arraySetArrayType(jsarray, arrayData);
            state = 1;
        }
        throw this.expectedError(this.pos, ", or ]", "eof");
    }

    private String parseString() {
        int start = ++this.pos;
        StringBuilder sb = null;
        while (this.pos < this.length) {
            int c = this.next();
            if (c <= 31) {
                throw this.syntaxError(this.pos, "String contains control character");
            }
            if (c == 92) {
                if (sb == null) {
                    sb = new StringBuilder(this.pos - start + 16);
                }
                sb.append(this.source, start, this.pos - 1);
                sb.append(this.parseEscapeSequence());
                start = this.pos;
                continue;
            }
            if (c != 34) continue;
            if (sb != null) {
                sb.append(this.source, start, this.pos - 1);
                return sb.toString();
            }
            return this.source.substring(start, this.pos - 1);
        }
        throw this.error(NashornJSONParser.lexerMessage("missing.close.quote", new String[0]), this.pos, this.length);
    }

    private char parseEscapeSequence() {
        int c = this.next();
        switch (c) {
            case 34: {
                return '\"';
            }
            case 92: {
                return '\\';
            }
            case 47: {
                return '/';
            }
            case 98: {
                return '\b';
            }
            case 102: {
                return '\f';
            }
            case 110: {
                return '\n';
            }
            case 114: {
                return '\r';
            }
            case 116: {
                return '\t';
            }
            case 117: {
                return this.parseUnicodeEscape();
            }
        }
        throw this.error(NashornJSONParser.lexerMessage("invalid.escape.char", new String[0]), this.pos - 1, this.length);
    }

    private char parseUnicodeEscape() {
        return (char)(this.parseHexDigit() << 12 | this.parseHexDigit() << 8 | this.parseHexDigit() << 4 | this.parseHexDigit());
    }

    private int parseHexDigit() {
        int c = this.next();
        if (c >= 48 && c <= 57) {
            return c - 48;
        }
        if (c >= 65 && c <= 70) {
            return c + 10 - 65;
        }
        if (c >= 97 && c <= 102) {
            return c + 10 - 97;
        }
        throw this.error(NashornJSONParser.lexerMessage("invalid.hex", new String[0]), this.pos - 1, this.length);
    }

    private static boolean isDigit(int c) {
        return c >= 48 && c <= 57;
    }

    private void skipDigits() {
        int c;
        while (this.pos < this.length && NashornJSONParser.isDigit(c = this.peek())) {
            ++this.pos;
        }
    }

    private Number parseNumber() {
        double d;
        int start = this.pos;
        int c = this.next();
        if (c == 45) {
            c = this.next();
        }
        if (!NashornJSONParser.isDigit(c)) {
            throw this.numberError(start);
        }
        if (c != 48) {
            this.skipDigits();
        }
        if (this.peek() == 46) {
            ++this.pos;
            if (!NashornJSONParser.isDigit(this.next())) {
                throw this.numberError(this.pos - 1);
            }
            this.skipDigits();
        }
        if ((c = this.peek()) == 101 || c == 69) {
            ++this.pos;
            c = this.next();
            if (c == 45 || c == 43) {
                c = this.next();
            }
            if (!NashornJSONParser.isDigit(c)) {
                throw this.numberError(this.pos - 1);
            }
            this.skipDigits();
        }
        if (JSType.isRepresentableAsInt(d = Double.parseDouble(this.source.substring(start, this.pos)))) {
            return (int)d;
        }
        if (JSType.isRepresentableAsLong(d)) {
            return (long)d;
        }
        return d;
    }

    private Object parseKeyword(String keyword, Object value) {
        if (!this.source.regionMatches(this.pos, keyword, 0, keyword.length())) {
            throw this.expectedError(this.pos, "json literal", "ident");
        }
        this.pos += keyword.length();
        return value;
    }

    private int peek() {
        if (this.pos >= this.length) {
            return -1;
        }
        return this.source.charAt(this.pos);
    }

    private int next() {
        int next = this.peek();
        ++this.pos;
        return next;
    }

    private void skipWhiteSpace() {
        block3: while (this.pos < this.length) {
            switch (this.peek()) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    ++this.pos;
                    continue block3;
                }
            }
            return;
        }
    }

    private static String toString(int c) {
        return c == -1 ? "eof" : String.valueOf((char)c);
    }

    ParserException error(String message, int start, int length) throws ParserException {
        long token = Token.toDesc(TokenType.STRING, start, length);
        int pos = Token.descPosition(token);
        Source src = Source.sourceFor("<json>", this.source);
        int lineNum = src.getLine(pos);
        int columnNum = src.getColumn(pos);
        return new ParserException(JSErrorType.SyntaxError, message, src, lineNum, columnNum, token);
    }

    private ParserException error(String message, int start) {
        return this.error(message, start, this.length);
    }

    private ParserException numberError(int start) {
        return this.error(NashornJSONParser.lexerMessage("json.invalid.number", new String[0]), start);
    }

    private ParserException expectedError(int start, String expected, String found) {
        return this.context.isOptionNashornCompatibilityMode() ? this.error(NashornJSONParser.parserMessage("expected", expected, found), start) : NashornJSONParser.expectedErrorV8(start, found);
    }

    private static ParserException expectedErrorV8(int start, String found) {
        char c = found.charAt(0);
        String entity = c == '\"' ? "string" : (Character.isDigit(c) ? "number" : String.format("token %s", found));
        String message = String.format("Unexpected %s in JSON at position %d", entity, start);
        return new ParserException(message);
    }

    private ParserException syntaxError(int start, String reason) {
        String message = ECMAErrors.getMessage("syntax.error.invalid.json", reason);
        return this.error(message, start);
    }

    private static String lexerMessage(String msgId, String ... args) {
        return ECMAErrors.getMessage("lexer.error." + msgId, args);
    }

    private static String parserMessage(String msgId, String ... args) {
        return ECMAErrors.getMessage("parser.error." + msgId, args);
    }

    private ParserException trailingCommaError(int start, String found) {
        return this.context.isOptionNashornCompatibilityMode() ? this.error(NashornJSONParser.parserMessage("trailing.comma.in.json", new String[0]), start) : NashornJSONParser.expectedErrorV8(start, found);
    }
}

