/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.js.builtins.ArrayPrototypeBuiltins;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.PromisePrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.PropertyNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.arguments.AccessFunctionNode;
import com.oracle.truffle.js.nodes.arguments.AccessIndexedArgumentNode;
import com.oracle.truffle.js.nodes.control.ThrowNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.promise.NewPromiseCapabilityNode;
import com.oracle.truffle.js.nodes.promise.PerformPromiseThenNode;
import com.oracle.truffle.js.nodes.promise.PromiseResolveNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSPromise;
import com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class PromisePrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<PromisePrototype> {
    public static final JSBuiltinsContainer BUILTINS = new PromisePrototypeBuiltins();

    protected PromisePrototypeBuiltins() {
        super("Promise.prototype", PromisePrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, PromisePrototype builtinEnum) {
        switch (builtinEnum) {
            case then: {
                return PromisePrototypeBuiltinsFactory.ThenNodeGen.create(context, builtin, PromisePrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case catch_: {
                return PromisePrototypeBuiltinsFactory.CatchNodeGen.create(context, builtin, PromisePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case finally_: {
                return PromisePrototypeBuiltinsFactory.FinallyNodeGen.create(context, builtin, PromisePrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static abstract class FinallyNode
    extends PromiseMethodNode {
        @Node.Child
        private IsCallableNode isCallable = IsCallableNode.create();
        @Node.Child
        private PropertyGetNode getThen;
        @Node.Child
        private JSFunctionCallNode callThen;
        @Node.Child
        private PropertySetNode setConstructor;
        @Node.Child
        private PropertySetNode setOnFinally;
        static final HiddenKey VALUE_KEY = new HiddenKey("Value");

        protected FinallyNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.getThen = PropertyGetNode.create("then", false, context);
            this.callThen = JSFunctionCallNode.createCall();
        }

        @Specialization(guards={"isJSObject(promise)"})
        protected Object doObject(DynamicObject promise, Object onFinally) {
            Object catchFinally;
            Object thenFinally;
            DynamicObject constructor = this.speciesConstructor(promise);
            assert (JSRuntime.isConstructor(constructor));
            if (!this.isCallable.executeBoolean(onFinally)) {
                thenFinally = onFinally;
                catchFinally = onFinally;
            } else {
                thenFinally = this.createFinallyFunction(constructor, onFinally, true);
                catchFinally = this.createFinallyFunction(constructor, onFinally, false);
            }
            return this.callThen.executeCall(JSArguments.create(promise, this.getThen.getValue(promise), thenFinally, catchFinally));
        }

        @Specialization(guards={"!isJSObject(thisObj)"})
        protected DynamicObject doNotObject(Object thisObj, Object onFinally) {
            throw Errors.createTypeErrorIncompatibleReceiver(thisObj);
        }

        private DynamicObject createFinallyFunction(DynamicObject constructor, Object onFinally, boolean thenFinally) {
            if (this.setConstructor == null || this.setOnFinally == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.setConstructor = (PropertySetNode)this.insert(PropertySetNode.createSetHidden(JSPromise.PROMISE_FINALLY_CONSTRUCTOR, this.getContext()));
                this.setOnFinally = (PropertySetNode)this.insert(PropertySetNode.createSetHidden(JSPromise.PROMISE_ON_FINALLY, this.getContext()));
            }
            JSFunctionData functionData = thenFinally ? this.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.PromiseThenFinally, c -> FinallyNode.createPromiseFinallyFunction(c, true)) : this.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.PromiseCatchFinally, c -> FinallyNode.createPromiseFinallyFunction(c, false));
            DynamicObject function = JSFunction.create(this.getRealm(), functionData);
            this.setConstructor.setValue(function, constructor);
            this.setOnFinally.setValue(function, onFinally);
            return function;
        }

        private static JSFunctionData createPromiseFinallyFunction(final JSContext context, final boolean thenFinally) {
            class PromiseFinallyRootNode
            extends JavaScriptRootNode {
                @Node.Child
                private JavaScriptNode valueNode = AccessIndexedArgumentNode.create(0);
                @Node.Child
                private PropertyGetNode getConstructor = PropertyGetNode.createGetHidden(JSPromise.PROMISE_FINALLY_CONSTRUCTOR, context);
                @Node.Child
                private PropertyGetNode getOnFinally = PropertyGetNode.createGetHidden(JSPromise.PROMISE_ON_FINALLY, context);
                @Node.Child
                private PromiseResolveNode promiseResolve = PromiseResolveNode.create(context);
                @Node.Child
                private JSFunctionCallNode callFinally = JSFunctionCallNode.createCall();
                @Node.Child
                private PropertyGetNode getThen = PropertyGetNode.create("then", false, context);
                @Node.Child
                private JSFunctionCallNode callThen = JSFunctionCallNode.createCall();
                @Node.Child
                private PropertySetNode setValue = PropertySetNode.createSetHidden(VALUE_KEY, context);

                PromiseFinallyRootNode() {
                }

                public Object execute(VirtualFrame frame) {
                    DynamicObject functionObject = JSFrameUtil.getFunctionObject((Frame)frame);
                    DynamicObject onFinally = (DynamicObject)this.getOnFinally.getValue(functionObject);
                    assert (JSRuntime.isCallable(onFinally));
                    Object result = this.callFinally.executeCall(JSArguments.createZeroArg((Object)Undefined.instance, onFinally));
                    DynamicObject constructor = (DynamicObject)this.getConstructor.getValue(functionObject);
                    assert (JSRuntime.isConstructor(constructor));
                    DynamicObject promise = this.promiseResolve.execute(constructor, result);
                    Object value = this.valueNode.execute(frame);
                    Object thunk = this.createHandlerFunction(value);
                    return this.callThen.executeCall(JSArguments.create(promise, this.getThen.getValue(promise), thunk));
                }

                private Object createHandlerFunction(Object value) {
                    JSFunctionData functionData = thenFinally ? context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.PromiseValueThunk, c -> FinallyNode.createValueThunk(c)) : context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.PromiseThrower, c -> FinallyNode.createThrower(c));
                    DynamicObject function = JSFunction.create(this.getRealm(), functionData);
                    this.setValue.setValue(function, value);
                    return function;
                }
            }
            return JSFunctionData.createCallOnly(context, (CallTarget)new PromiseFinallyRootNode().getCallTarget(), 1, "");
        }

        static JSFunctionData createThrower(JSContext context) {
            return FinallyNode.createThunkImpl(context, ThrowNode.create(PropertyNode.createGetHidden(context, AccessFunctionNode.create(), VALUE_KEY), context));
        }

        static JSFunctionData createValueThunk(JSContext context) {
            return FinallyNode.createThunkImpl(context, PropertyNode.createGetHidden(context, AccessFunctionNode.create(), VALUE_KEY));
        }

        private static JSFunctionData createThunkImpl(JSContext context, final JavaScriptNode expression) {
            RootCallTarget callTarget = new JavaScriptRootNode(){
                @Node.Child
                private JavaScriptNode body;
                {
                    this.body = expression;
                }

                public Object execute(VirtualFrame frame) {
                    return this.body.execute(frame);
                }
            }.getCallTarget();
            return JSFunctionData.createCallOnly(context, (CallTarget)callTarget, 0, "");
        }
    }

    public static abstract class CatchNode
    extends JSBuiltinNode {
        @Node.Child
        private PropertyGetNode getThen;
        @Node.Child
        private JSFunctionCallNode callThen;

        protected CatchNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.getThen = PropertyGetNode.create("then", false, context);
            this.callThen = JSFunctionCallNode.createCall();
        }

        @Specialization
        protected Object doObject(Object promise, Object onRejected) {
            return this.callThen.executeCall(JSArguments.create(promise, this.getThen.getValue(promise), new Object[]{Undefined.instance, onRejected}));
        }
    }

    public static abstract class ThenNode
    extends PromiseMethodNode {
        @Node.Child
        private NewPromiseCapabilityNode newPromiseCapability;
        @Node.Child
        private PerformPromiseThenNode performPromiseThen;

        protected ThenNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.newPromiseCapability = NewPromiseCapabilityNode.create(context);
            this.performPromiseThen = PerformPromiseThenNode.create(context);
        }

        @Specialization(guards={"isJSPromise(promise)"})
        protected DynamicObject doPromise(DynamicObject promise, Object onFulfilled, Object onRejected) {
            DynamicObject constructor = this.speciesConstructor(promise);
            this.getContext().notifyPromiseHook(-1, promise);
            PromiseCapabilityRecord resultCapability = this.newPromiseCapability.execute(constructor);
            return this.performPromiseThen.execute(promise, onFulfilled, onRejected, resultCapability);
        }

        @Specialization(guards={"!isJSPromise(thisObj)"})
        protected DynamicObject doNotPromise(Object thisObj, Object onFulfilled, Object onRejected) {
            throw Errors.createTypeErrorIncompatibleReceiver(thisObj);
        }
    }

    @ImportStatic(value={JSPromise.class})
    public static abstract class PromiseMethodNode
    extends JSBuiltinNode {
        @Node.Child
        private ArrayPrototypeBuiltins.ArraySpeciesConstructorNode speciesConstructorNode;

        protected PromiseMethodNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.speciesConstructorNode = ArrayPrototypeBuiltins.ArraySpeciesConstructorNode.create(context, false);
        }

        protected final DynamicObject speciesConstructor(DynamicObject promise) {
            return this.speciesConstructorNode.speciesConstructor(promise, this.getRealm().getPromiseConstructor());
        }
    }

    public static enum PromisePrototype implements BuiltinEnum<PromisePrototype>
    {
        then(2),
        catch_(1),
        finally_(1);

        private final int length;

        private PromisePrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }
}

