/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins.intl;

import com.ibm.icu.number.IntegerWidth;
import com.ibm.icu.number.LocalizedNumberFormatter;
import com.ibm.icu.number.Notation;
import com.ibm.icu.number.NumberFormatter;
import com.ibm.icu.number.Precision;
import com.ibm.icu.number.Scale;
import com.ibm.icu.number.SimpleNotation;
import com.ibm.icu.text.FormattedValue;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.NumberingSystem;
import com.ibm.icu.util.Currency;
import com.ibm.icu.util.MeasureUnit;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.builtins.intl.NumberFormatFunctionBuiltins;
import com.oracle.truffle.js.builtins.intl.NumberFormatPrototypeBuiltins;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.builtins.intl.JSNumberFormatObject;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.IntlUtil;
import com.oracle.truffle.js.runtime.util.LazyValue;
import java.math.RoundingMode;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;

public final class JSNumberFormat
extends JSNonProxy
implements JSConstructorFactory.WithFunctions,
PrototypeSupplier {
    public static final String CLASS_NAME = "NumberFormat";
    public static final String PROTOTYPE_NAME = "NumberFormat.prototype";
    static final HiddenKey BOUND_OBJECT_KEY = new HiddenKey("NumberFormat");
    public static final JSNumberFormat INSTANCE = new JSNumberFormat();
    private static final LazyValue<UnmodifiableEconomicMap<NumberFormat.Field, String>> fieldToTypeMap = new LazyValue<UnmodifiableEconomicMap>(JSNumberFormat::initializeFieldToTypeMap);

    private JSNumberFormat() {
    }

    public static boolean isJSNumberFormat(Object obj) {
        return obj instanceof JSNumberFormatObject;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return this.getClassName();
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject ctor) {
        JSContext ctx = realm.getContext();
        DynamicObject numberFormatPrototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(ctx, numberFormatPrototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, numberFormatPrototype, NumberFormatPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putBuiltinAccessorProperty(numberFormatPrototype, (Object)"format", JSNumberFormat.createFormatFunctionGetter(realm, ctx), Undefined.instance);
        JSObjectUtil.putToStringTag(numberFormatPrototype, "Intl.NumberFormat");
        return numberFormatPrototype;
    }

    @CompilerDirectives.TruffleBoundary
    public static int currencyDigits(String currencyCode) {
        try {
            int digits = java.util.Currency.getInstance(currencyCode).getDefaultFractionDigits();
            return digits == -1 ? 2 : digits;
        }
        catch (IllegalArgumentException e) {
            return 2;
        }
    }

    @Override
    public Shape makeInitialShape(JSContext ctx, DynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, ctx);
        return initialShape;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm, NumberFormatFunctionBuiltins.BUILTINS);
    }

    public static DynamicObject create(JSContext context, JSRealm realm) {
        InternalState state = new InternalState();
        JSObjectFactory factory = context.getNumberFormatFactory();
        JSNumberFormatObject obj = new JSNumberFormatObject(factory.getShape(realm), state);
        factory.initProto(obj, realm);
        assert (JSNumberFormat.isJSNumberFormat((Object)obj));
        return context.trackAllocation(obj);
    }

    private static Notation notationToICUNotation(String notation, String compactDisplay) {
        SimpleNotation icuNotation;
        switch (notation) {
            case "standard": {
                icuNotation = Notation.simple();
                break;
            }
            case "scientific": {
                icuNotation = Notation.scientific();
                break;
            }
            case "engineering": {
                icuNotation = Notation.engineering();
                break;
            }
            case "compact": {
                icuNotation = "long".equals(compactDisplay) ? Notation.compactLong() : Notation.compactShort();
                break;
            }
            default: {
                throw Errors.shouldNotReachHere(notation);
            }
        }
        return icuNotation;
    }

    private static NumberFormatter.UnitWidth currencyDisplayToUnitWidth(String currencyDisplay) {
        NumberFormatter.UnitWidth unitWidth;
        switch (currencyDisplay) {
            case "code": {
                unitWidth = NumberFormatter.UnitWidth.ISO_CODE;
                break;
            }
            case "symbol": {
                unitWidth = NumberFormatter.UnitWidth.SHORT;
                break;
            }
            case "narrowSymbol": {
                unitWidth = NumberFormatter.UnitWidth.NARROW;
                break;
            }
            case "name": {
                unitWidth = NumberFormatter.UnitWidth.FULL_NAME;
                break;
            }
            default: {
                throw Errors.shouldNotReachHere(currencyDisplay);
            }
        }
        return unitWidth;
    }

    private static NumberFormatter.UnitWidth unitDisplayToUnitWidth(String unitDisplay) {
        NumberFormatter.UnitWidth unitWidth;
        switch (unitDisplay) {
            case "short": {
                unitWidth = NumberFormatter.UnitWidth.SHORT;
                break;
            }
            case "narrow": {
                unitWidth = NumberFormatter.UnitWidth.NARROW;
                break;
            }
            case "long": {
                unitWidth = NumberFormatter.UnitWidth.FULL_NAME;
                break;
            }
            default: {
                throw Errors.shouldNotReachHere(unitDisplay);
            }
        }
        return unitWidth;
    }

    private static MeasureUnit unitToMeasureUnit(String unit) {
        MeasureUnit measureUnit;
        switch (unit) {
            case "acre": {
                measureUnit = MeasureUnit.ACRE;
                break;
            }
            case "bit": {
                measureUnit = MeasureUnit.BIT;
                break;
            }
            case "byte": {
                measureUnit = MeasureUnit.BYTE;
                break;
            }
            case "celsius": {
                measureUnit = MeasureUnit.CELSIUS;
                break;
            }
            case "centimeter": {
                measureUnit = MeasureUnit.CENTIMETER;
                break;
            }
            case "day": {
                measureUnit = MeasureUnit.DAY;
                break;
            }
            case "degree": {
                measureUnit = MeasureUnit.DEGREE;
                break;
            }
            case "fahrenheit": {
                measureUnit = MeasureUnit.FAHRENHEIT;
                break;
            }
            case "fluid-ounce": {
                measureUnit = MeasureUnit.FLUID_OUNCE;
                break;
            }
            case "foot": {
                measureUnit = MeasureUnit.FOOT;
                break;
            }
            case "gallon": {
                measureUnit = MeasureUnit.GALLON;
                break;
            }
            case "gigabit": {
                measureUnit = MeasureUnit.GIGABIT;
                break;
            }
            case "gigabyte": {
                measureUnit = MeasureUnit.GIGABYTE;
                break;
            }
            case "gram": {
                measureUnit = MeasureUnit.GRAM;
                break;
            }
            case "hectare": {
                measureUnit = MeasureUnit.HECTARE;
                break;
            }
            case "hour": {
                measureUnit = MeasureUnit.HOUR;
                break;
            }
            case "inch": {
                measureUnit = MeasureUnit.INCH;
                break;
            }
            case "kilobit": {
                measureUnit = MeasureUnit.KILOBIT;
                break;
            }
            case "kilobyte": {
                measureUnit = MeasureUnit.KILOBYTE;
                break;
            }
            case "kilogram": {
                measureUnit = MeasureUnit.KILOGRAM;
                break;
            }
            case "kilometer": {
                measureUnit = MeasureUnit.KILOMETER;
                break;
            }
            case "liter": {
                measureUnit = MeasureUnit.LITER;
                break;
            }
            case "megabit": {
                measureUnit = MeasureUnit.MEGABIT;
                break;
            }
            case "megabyte": {
                measureUnit = MeasureUnit.MEGABYTE;
                break;
            }
            case "meter": {
                measureUnit = MeasureUnit.METER;
                break;
            }
            case "mile": {
                measureUnit = MeasureUnit.MILE;
                break;
            }
            case "mile-scandinavian": {
                measureUnit = MeasureUnit.MILE_SCANDINAVIAN;
                break;
            }
            case "milliliter": {
                measureUnit = MeasureUnit.MILLILITER;
                break;
            }
            case "millimeter": {
                measureUnit = MeasureUnit.MILLIMETER;
                break;
            }
            case "millisecond": {
                measureUnit = MeasureUnit.MILLISECOND;
                break;
            }
            case "minute": {
                measureUnit = MeasureUnit.MINUTE;
                break;
            }
            case "month": {
                measureUnit = MeasureUnit.MONTH;
                break;
            }
            case "ounce": {
                measureUnit = MeasureUnit.OUNCE;
                break;
            }
            case "percent": {
                measureUnit = MeasureUnit.PERCENT;
                break;
            }
            case "petabyte": {
                measureUnit = MeasureUnit.PETABYTE;
                break;
            }
            case "pound": {
                measureUnit = MeasureUnit.POUND;
                break;
            }
            case "second": {
                measureUnit = MeasureUnit.SECOND;
                break;
            }
            case "stone": {
                measureUnit = MeasureUnit.STONE;
                break;
            }
            case "terabit": {
                measureUnit = MeasureUnit.TERABIT;
                break;
            }
            case "terabyte": {
                measureUnit = MeasureUnit.TERABYTE;
                break;
            }
            case "week": {
                measureUnit = MeasureUnit.WEEK;
                break;
            }
            case "yard": {
                measureUnit = MeasureUnit.YARD;
                break;
            }
            case "year": {
                measureUnit = MeasureUnit.YEAR;
                break;
            }
            default: {
                throw Errors.shouldNotReachHere(unit);
            }
        }
        return measureUnit;
    }

    private static NumberFormatter.SignDisplay signDisplay(String signDisplay, boolean accounting) {
        switch (signDisplay) {
            case "auto": {
                return accounting ? NumberFormatter.SignDisplay.ACCOUNTING : NumberFormatter.SignDisplay.AUTO;
            }
            case "never": {
                return NumberFormatter.SignDisplay.NEVER;
            }
            case "always": {
                return accounting ? NumberFormatter.SignDisplay.ACCOUNTING_ALWAYS : NumberFormatter.SignDisplay.ALWAYS;
            }
            case "exceptZero": {
                return accounting ? NumberFormatter.SignDisplay.ACCOUNTING_EXCEPT_ZERO : NumberFormatter.SignDisplay.EXCEPT_ZERO;
            }
        }
        throw Errors.shouldNotReachHere(signDisplay);
    }

    private static FormattedValue formattedValue(InternalState state, Number x) {
        LocalizedNumberFormatter numberFormatter = state.getNumberFormatter();
        return numberFormatter.format(x);
    }

    @CompilerDirectives.TruffleBoundary
    public static String format(DynamicObject numberFormatObj, Object n) {
        InternalState state = JSNumberFormat.getInternalState(numberFormatObj);
        Number x = JSNumberFormat.toInternalNumberRepresentation(JSRuntime.toNumeric(n));
        return JSNumberFormat.formattedValue(state, x).toString();
    }

    private static UnmodifiableEconomicMap<NumberFormat.Field, String> initializeFieldToTypeMap() {
        CompilerAsserts.neverPartOfCompilation();
        EconomicMap map = EconomicMap.create((int)6);
        map.put((Object)NumberFormat.Field.DECIMAL_SEPARATOR, (Object)"decimal");
        map.put((Object)NumberFormat.Field.FRACTION, (Object)"fraction");
        map.put((Object)NumberFormat.Field.GROUPING_SEPARATOR, (Object)"group");
        map.put((Object)NumberFormat.Field.CURRENCY, (Object)"currency");
        map.put((Object)NumberFormat.Field.MEASURE_UNIT, (Object)"unit");
        map.put((Object)NumberFormat.Field.EXPONENT_SYMBOL, (Object)"exponentSeparator");
        map.put((Object)NumberFormat.Field.EXPONENT_SIGN, (Object)"exponentMinusSign");
        map.put((Object)NumberFormat.Field.EXPONENT, (Object)"exponentInteger");
        map.put((Object)NumberFormat.Field.COMPACT, (Object)"compact");
        return map;
    }

    private static String fieldToType(NumberFormat.Field field) {
        return (String)fieldToTypeMap.get().get((Object)field);
    }

    @CompilerDirectives.TruffleBoundary
    public static DynamicObject formatToParts(JSContext context, JSRealm realm, DynamicObject numberFormatObj, Object n) {
        InternalState state = JSNumberFormat.getInternalState(numberFormatObj);
        Number x = JSNumberFormat.toInternalNumberRepresentation(JSRuntime.toNumeric(n));
        FormattedValue formattedValue = JSNumberFormat.formattedValue(state, x);
        AttributedCharacterIterator fit = formattedValue.toCharacterIterator();
        String formatted = formattedValue.toString();
        List<DynamicObject> resultParts = JSNumberFormat.innerFormatToParts(context, realm, fit, x.doubleValue(), formatted, null, "percent".equals(state.getStyle()));
        return JSArray.createConstant(context, realm, resultParts.toArray());
    }

    static List<DynamicObject> innerFormatToParts(JSContext context, JSRealm realm, AttributedCharacterIterator iterator, double value, String formattedValue, String unit, boolean stylePercent) {
        ArrayList<DynamicObject> resultParts = new ArrayList<DynamicObject>();
        int i = iterator.getBeginIndex();
        while (i < iterator.getEndIndex()) {
            iterator.setIndex(i);
            Map<AttributedCharacterIterator.Attribute, Object> attributes = iterator.getAttributes();
            Set<AttributedCharacterIterator.Attribute> attKeySet = attributes.keySet();
            if (!attKeySet.isEmpty()) {
                Iterator<AttributedCharacterIterator.Attribute> iterator2 = attKeySet.iterator();
                if (!iterator2.hasNext()) continue;
                AttributedCharacterIterator.Attribute a = iterator2.next();
                if (a instanceof NumberFormat.Field) {
                    String type;
                    String run = formattedValue.substring(iterator.getRunStart(), iterator.getRunLimit());
                    if (a == NumberFormat.Field.INTEGER) {
                        type = Double.isNaN(value) ? "nan" : (Double.isInfinite(value) ? "infinity" : "integer");
                    } else if (a == NumberFormat.Field.SIGN) {
                        type = JSNumberFormat.isPlusSign(run) ? "plusSign" : "minusSign";
                    } else if (a == NumberFormat.Field.PERCENT) {
                        type = stylePercent ? "percentSign" : "unit";
                    } else {
                        type = JSNumberFormat.fieldToType((NumberFormat.Field)a);
                        assert (type != null) : a;
                    }
                    resultParts.add(IntlUtil.makePart(context, realm, type, run, unit));
                    i = iterator.getRunLimit();
                    continue;
                }
                throw Errors.shouldNotReachHere();
            }
            String run = formattedValue.substring(iterator.getRunStart(), iterator.getRunLimit());
            resultParts.add(IntlUtil.makePart(context, realm, "literal", run, unit));
            i = iterator.getRunLimit();
        }
        return resultParts;
    }

    private static boolean isPlusSign(String str) {
        return str.length() == 1 && str.charAt(0) == '+';
    }

    private static Number toInternalNumberRepresentation(Object o) {
        if (o instanceof SafeInteger) {
            return ((SafeInteger)o).doubleValue();
        }
        if (o instanceof Double) {
            return Double.isNaN((Double)o) ? Double.NaN : (Double)o;
        }
        if (o instanceof Number) {
            return (Number)o;
        }
        if (o instanceof BigInt) {
            return ((BigInt)o).bigIntegerValue();
        }
        throw Errors.shouldNotReachHere();
    }

    @CompilerDirectives.TruffleBoundary
    public static DynamicObject resolvedOptions(JSContext context, JSRealm realm, DynamicObject numberFormatObj) {
        InternalState state = JSNumberFormat.getInternalState(numberFormatObj);
        return state.toResolvedOptionsObject(context, realm);
    }

    public static InternalState getInternalState(DynamicObject obj) {
        assert (JSNumberFormat.isJSNumberFormat(obj));
        return ((JSNumberFormatObject)obj).getInternalState();
    }

    private static CallTarget createGetFormatCallTarget(final JSContext context) {
        return Truffle.getRuntime().createCallTarget((RootNode)new JavaScriptRootNode(context.getLanguage(), null, null){
            private final BranchProfile errorBranch;
            @Node.Child
            private PropertySetNode setBoundObjectNode;
            {
                super(lang, sourceSection, frameDescriptor);
                this.errorBranch = BranchProfile.create();
                this.setBoundObjectNode = PropertySetNode.createSetHidden(BOUND_OBJECT_KEY, context);
            }

            public Object execute(VirtualFrame frame) {
                Object[] frameArgs = frame.getArguments();
                Object numberFormatObj = JSArguments.getThisObject(frameArgs);
                if (JSNumberFormat.isJSNumberFormat(numberFormatObj)) {
                    InternalState state = JSNumberFormat.getInternalState((DynamicObject)numberFormatObj);
                    if (state == null) {
                        this.errorBranch.enter();
                        throw Errors.createTypeErrorMethodCalledOnNonObjectOrWrongType("format");
                    }
                    if (state.boundFormatFunction == null) {
                        JSFunctionData formatFunctionData = context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.NumberFormatFormat, c -> JSNumberFormat.createFormatFunctionData(c));
                        DynamicObject formatFn = JSFunction.create(this.getRealm(), formatFunctionData);
                        this.setBoundObjectNode.setValue(formatFn, numberFormatObj);
                        state.boundFormatFunction = formatFn;
                    }
                    return state.boundFormatFunction;
                }
                this.errorBranch.enter();
                throw Errors.createTypeErrorTypeXExpected(JSNumberFormat.CLASS_NAME);
            }
        });
    }

    private static JSFunctionData createFormatFunctionData(final JSContext context) {
        return JSFunctionData.createCallOnly(context, (CallTarget)Truffle.getRuntime().createCallTarget((RootNode)new JavaScriptRootNode(context.getLanguage(), null, null){
            @Node.Child
            private PropertyGetNode getBoundObjectNode;
            {
                super(lang, sourceSection, frameDescriptor);
                this.getBoundObjectNode = PropertyGetNode.createGetHidden(BOUND_OBJECT_KEY, context);
            }

            public Object execute(VirtualFrame frame) {
                Object[] arguments = frame.getArguments();
                DynamicObject thisObj = (DynamicObject)this.getBoundObjectNode.getValue(JSArguments.getFunctionObject(arguments));
                assert (JSNumberFormat.isJSNumberFormat(thisObj));
                JSDynamicObject n = JSArguments.getUserArgumentCount(arguments) > 0 ? JSArguments.getUserArgument(arguments, 0) : Undefined.instance;
                return JSNumberFormat.format(thisObj, (Object)n);
            }
        }), 1, "");
    }

    private static DynamicObject createFormatFunctionGetter(JSRealm realm, JSContext context) {
        JSFunctionData fd = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.NumberFormatGetFormat, c -> {
            CallTarget ct = JSNumberFormat.createGetFormatCallTarget(context);
            return JSFunctionData.create(context, ct, ct, 0, "get format", false, false, false, true);
        });
        return JSFunction.create(realm, fd);
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getNumberFormatPrototype();
    }

    public static class InternalState
    extends BasicInternalState {
        private String style;
        private String currency;
        private String currencyDisplay;
        private String currencySign;
        private String unit;
        private String unitDisplay;
        private boolean useGrouping;
        private String notation;
        private String compactDisplay;
        private String signDisplay;
        DynamicObject boundFormatFunction;

        @Override
        void fillResolvedOptions(JSContext context, JSRealm realm, DynamicObject result) {
            JSObjectUtil.defineDataProperty(context, result, "locale", this.getLocale(), JSAttributes.getDefault());
            JSObjectUtil.defineDataProperty(context, result, "numberingSystem", this.getNumberingSystem(), JSAttributes.getDefault());
            JSObjectUtil.defineDataProperty(context, result, "style", this.style, JSAttributes.getDefault());
            if (this.currency != null) {
                JSObjectUtil.defineDataProperty(context, result, "currency", this.currency, JSAttributes.getDefault());
            }
            if (this.currencyDisplay != null) {
                JSObjectUtil.defineDataProperty(context, result, "currencyDisplay", this.currencyDisplay, JSAttributes.getDefault());
            }
            if (this.currencySign != null) {
                JSObjectUtil.defineDataProperty(context, result, "currencySign", this.currencySign, JSAttributes.getDefault());
            }
            if (this.unit != null) {
                JSObjectUtil.defineDataProperty(context, result, "unit", this.unit, JSAttributes.getDefault());
            }
            if (this.unitDisplay != null) {
                JSObjectUtil.defineDataProperty(context, result, "unitDisplay", this.unitDisplay, JSAttributes.getDefault());
            }
            super.fillResolvedOptions(context, realm, result);
            JSObjectUtil.defineDataProperty(context, result, "useGrouping", this.useGrouping, JSAttributes.getDefault());
            JSObjectUtil.defineDataProperty(context, result, "notation", this.notation, JSAttributes.getDefault());
            if (this.compactDisplay != null) {
                JSObjectUtil.defineDataProperty(context, result, "compactDisplay", this.compactDisplay, JSAttributes.getDefault());
            }
            JSObjectUtil.defineDataProperty(context, result, "signDisplay", this.signDisplay, JSAttributes.getDefault());
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void initializeNumberFormatter() {
            super.initializeNumberFormatter();
            LocalizedNumberFormatter formatter = this.getNumberFormatter();
            formatter = (LocalizedNumberFormatter)formatter.notation(JSNumberFormat.notationToICUNotation(this.notation, this.compactDisplay));
            if (!this.useGrouping) {
                formatter = (LocalizedNumberFormatter)formatter.grouping(NumberFormatter.GroupingStrategy.OFF);
            }
            if ("currency".equals(this.style)) {
                formatter = (LocalizedNumberFormatter)formatter.unit((MeasureUnit)Currency.getInstance((String)this.currency));
                formatter = (LocalizedNumberFormatter)formatter.unitWidth(JSNumberFormat.currencyDisplayToUnitWidth(this.currencyDisplay));
            } else if ("percent".equals(this.style)) {
                formatter = (LocalizedNumberFormatter)formatter.unit(MeasureUnit.PERCENT);
                formatter = (LocalizedNumberFormatter)formatter.scale(Scale.powerOfTen((int)2));
            } else if ("unit".equals(this.style)) {
                String per = "-per-";
                int index = this.unit.indexOf(per);
                if (index == -1) {
                    formatter = (LocalizedNumberFormatter)formatter.unit(JSNumberFormat.unitToMeasureUnit(this.unit));
                } else {
                    String numerator = this.unit.substring(0, index);
                    String denominator = this.unit.substring(index + per.length());
                    formatter = (LocalizedNumberFormatter)formatter.unit(JSNumberFormat.unitToMeasureUnit(numerator));
                    formatter = (LocalizedNumberFormatter)formatter.perUnit(JSNumberFormat.unitToMeasureUnit(denominator));
                }
                formatter = (LocalizedNumberFormatter)formatter.unitWidth(JSNumberFormat.unitDisplayToUnitWidth(this.unitDisplay));
            }
            formatter = (LocalizedNumberFormatter)formatter.sign(JSNumberFormat.signDisplay(this.signDisplay, "accounting".equals(this.currencySign)));
            this.setNumberFormatter(formatter);
        }

        public String getStyle() {
            return this.style;
        }

        public void setStyle(String style) {
            this.style = style;
        }

        public String getCurrency() {
            return this.currency;
        }

        public void setCurrency(String currency) {
            this.currency = currency;
        }

        public void setCurrencyDisplay(String currencyDisplay) {
            this.currencyDisplay = currencyDisplay;
        }

        public void setCurrencySign(String currencySign) {
            this.currencySign = currencySign;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }

        public void setUnitDisplay(String unitDisplay) {
            this.unitDisplay = unitDisplay;
        }

        public void setGroupingUsed(boolean useGrouping) {
            this.useGrouping = useGrouping;
        }

        public void setNotation(String notation) {
            this.notation = notation;
        }

        public void setCompactDisplay(String compactDisplay) {
            this.compactDisplay = compactDisplay;
        }

        public void setSignDisplay(String signDisplay) {
            this.signDisplay = signDisplay;
        }
    }

    public static class BasicInternalState {
        private LocalizedNumberFormatter numberFormatter;
        private Locale javaLocale;
        private String locale;
        private String numberingSystem;
        private int minimumIntegerDigits;
        private Integer minimumFractionDigits;
        private Integer maximumFractionDigits;
        private Integer minimumSignificantDigits;
        private Integer maximumSignificantDigits;

        DynamicObject toResolvedOptionsObject(JSContext context, JSRealm realm) {
            DynamicObject resolvedOptions = JSOrdinary.create(context, realm);
            this.fillResolvedOptions(context, realm, resolvedOptions);
            return resolvedOptions;
        }

        void fillResolvedOptions(JSContext context, JSRealm realm, DynamicObject result) {
            JSObjectUtil.defineDataProperty(context, result, "minimumIntegerDigits", this.minimumIntegerDigits, JSAttributes.getDefault());
            if (this.minimumFractionDigits != null) {
                JSObjectUtil.defineDataProperty(context, result, "minimumFractionDigits", this.minimumFractionDigits, JSAttributes.getDefault());
            }
            if (this.maximumFractionDigits != null) {
                JSObjectUtil.defineDataProperty(context, result, "maximumFractionDigits", this.maximumFractionDigits, JSAttributes.getDefault());
            }
            if (this.minimumSignificantDigits != null) {
                JSObjectUtil.defineDataProperty(context, result, "minimumSignificantDigits", this.minimumSignificantDigits, JSAttributes.getDefault());
            }
            if (this.maximumSignificantDigits != null) {
                JSObjectUtil.defineDataProperty(context, result, "maximumSignificantDigits", this.maximumSignificantDigits, JSAttributes.getDefault());
            }
        }

        @CompilerDirectives.TruffleBoundary
        public void resolveLocaleAndNumberingSystem(JSContext ctx, String[] locales, String numberingSystemOpt) {
            Locale selectedLocale = IntlUtil.selectedLocale(ctx, locales);
            Locale strippedLocale = selectedLocale.stripExtensions();
            if (strippedLocale.toLanguageTag().equals("und")) {
                selectedLocale = ctx.getLocale();
                strippedLocale = selectedLocale.stripExtensions();
            }
            Locale.Builder builder = new Locale.Builder();
            builder.setLocale(strippedLocale);
            String nuType = selectedLocale.getUnicodeLocaleType("nu");
            if (nuType != null && IntlUtil.isValidNumberingSystem(nuType) && (numberingSystemOpt == null || numberingSystemOpt.equals(nuType))) {
                this.numberingSystem = nuType;
                builder.setUnicodeLocaleKeyword("nu", nuType);
            }
            this.locale = builder.build().toLanguageTag();
            if (numberingSystemOpt != null && IntlUtil.isValidNumberingSystem(numberingSystemOpt)) {
                this.numberingSystem = numberingSystemOpt;
                builder.setUnicodeLocaleKeyword("nu", numberingSystemOpt);
            }
            this.javaLocale = builder.build();
            if (this.numberingSystem == null) {
                this.numberingSystem = IntlUtil.defaultNumberingSystemName(ctx, this.javaLocale);
            }
        }

        @CompilerDirectives.TruffleBoundary
        public void initializeNumberFormatter() {
            LocalizedNumberFormatter formatter = (LocalizedNumberFormatter)NumberFormatter.withLocale((Locale)this.javaLocale).roundingMode(RoundingMode.HALF_UP);
            formatter = (LocalizedNumberFormatter)formatter.symbols(NumberingSystem.getInstanceByName((String)this.numberingSystem));
            formatter = (LocalizedNumberFormatter)formatter.integerWidth(IntegerWidth.zeroFillTo((int)this.minimumIntegerDigits));
            if (this.minimumSignificantDigits != null) {
                formatter = (LocalizedNumberFormatter)formatter.precision(Precision.minMaxSignificantDigits((int)this.minimumSignificantDigits, (int)this.maximumSignificantDigits));
            } else if (this.minimumFractionDigits != null) {
                formatter = (LocalizedNumberFormatter)formatter.precision((Precision)Precision.minMaxFraction((int)this.minimumFractionDigits, (int)this.maximumFractionDigits));
            }
            this.numberFormatter = formatter;
        }

        public LocalizedNumberFormatter getNumberFormatter() {
            return this.numberFormatter;
        }

        public void setNumberFormatter(LocalizedNumberFormatter numberFormatter) {
            this.numberFormatter = numberFormatter;
        }

        public Locale getJavaLocale() {
            return this.javaLocale;
        }

        public String getLocale() {
            return this.locale;
        }

        public String getNumberingSystem() {
            return this.numberingSystem;
        }

        public void setMinimumIntegerDigits(int minimumIntegerDigits) {
            this.minimumIntegerDigits = minimumIntegerDigits;
        }

        public int getMinimumIntegerDigits() {
            return this.minimumIntegerDigits;
        }

        public void setMinimumFractionDigits(int minimumFractionDigits) {
            this.minimumFractionDigits = minimumFractionDigits;
        }

        public Integer getMinimumFractionDigits() {
            return this.minimumFractionDigits;
        }

        public void setMaximumFractionDigits(int maximumFractionDigits) {
            this.maximumFractionDigits = maximumFractionDigits;
        }

        public Integer getMaximumFractionDigits() {
            return this.maximumFractionDigits;
        }

        public void setMinimumSignificantDigits(int minimumSignificantDigits) {
            this.minimumSignificantDigits = minimumSignificantDigits;
        }

        public Integer getMinimumSignificantDigits() {
            return this.minimumSignificantDigits;
        }

        public void setMaximumSignificantDigits(int maximumSignificantDigits) {
            this.maximumSignificantDigits = maximumSignificantDigits;
        }

        public Integer getMaximumSignificantDigits() {
            return this.maximumSignificantDigits;
        }
    }
}

