/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.GetPrototypeNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSAdapter;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSDictionary;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.builtins.JSRegExp;
import com.oracle.truffle.js.runtime.builtins.JSString;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSLazyString;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSProperty;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.DebugCounter;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.util.concurrent.locks.Lock;

public abstract class PropertyCacheNode<T extends CacheNode<T>>
extends JavaScriptBaseNode {
    protected final Object key;
    protected final JSContext context;
    @Node.Child
    protected T cacheNode;
    @CompilerDirectives.CompilationFinal
    private Assumption invalidationAssumption;
    private static final DebugCounter polymorphicCount = DebugCounter.create("Polymorphic property cache count");
    private static final DebugCounter megamorphicCount = DebugCounter.create("Megamorphic property cache count");
    private static final DebugCounter cacheAssumptionInitializedCount = DebugCounter.create("Property cache assumptions initialized");
    private static final DebugCounter cacheAssumptionInvalidatedCount = DebugCounter.create("Property cache assumptions invalidated");
    private static final DebugCounter propertyAssumptionCheckFailedCount = DebugCounter.create("Property assumption checks failed");
    private static final DebugCounter constantObjectCheckFailedCount = DebugCounter.create("Constant object checks failed");
    private static final DebugCounter traversePrototypeShapeCheckCount = DebugCounter.create("TraversePrototypeShapeCheckNode count");
    private static final DebugCounter traversePrototypeChainShapeCheckCount = DebugCounter.create("TraversePrototypeChainShapeCheckNode count");

    public PropertyCacheNode(Object key, JSContext context) {
        this.key = key;
        this.context = context;
        assert (JSRuntime.isPropertyKey(key) || key instanceof HiddenKey);
    }

    public final Object getKey() {
        return this.key;
    }

    protected abstract T createGenericPropertyNode();

    protected abstract T createCachedPropertyNode(Property var1, Object var2, int var3, Object var4, T var5);

    protected abstract T createUndefinedPropertyNode(Object var1, Object var2, int var3, Object var4);

    protected abstract T createJavaPropertyNodeMaybe(Object var1, int var2);

    protected abstract T createTruffleObjectPropertyNode();

    protected abstract boolean canCombineShapeCheck(Shape var1, Shape var2, Object var3, int var4, Object var5, Property var6);

    protected abstract T createCombinedIcPropertyNode(Shape var1, Shape var2, Object var3, int var4, Object var5, Property var6);

    @CompilerDirectives.TruffleBoundary
    protected T specialize(Object thisObj) {
        return this.specialize(thisObj, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    protected T specialize(Object thisObj, Object value) {
        CacheNode res;
        Lock lock = this.getLock();
        lock.lock();
        try {
            T currentHead = this.cacheNode;
            do {
                assert (currentHead == this.cacheNode);
                int cachedCount = 0;
                boolean invalid = false;
                boolean generic = false;
                res = null;
                T c = currentHead;
                while (c != null) {
                    if (((CacheNode)((Object)c)).isGeneric()) {
                        generic = true;
                        res = (CacheNode)((Object)c);
                        assert (((CacheNode)((Object)c)).next == null);
                        break;
                    }
                    ++cachedCount;
                    if (!((CacheNode)((Object)c)).isValid()) {
                        invalid = true;
                        break;
                    }
                    ((CacheNode)((Object)c)).sweep();
                    if (res == null && ((CacheNode)((Object)c)).accepts(thisObj) && ((CacheNode)((Object)c)).acceptsValue(value)) {
                        res = c;
                    } else if (this.isUnexpectedConstantObject(c, thisObj)) {
                        invalid = true;
                        break;
                    }
                    c = ((CacheNode)((Object)c)).next;
                }
                if (invalid) {
                    this.checkForUnstableAssumption(currentHead, thisObj);
                    currentHead = this.rewriteCached(currentHead, PropertyCacheNode.filterValid(currentHead));
                    this.traceAssumptionInvalidated();
                    res = null;
                    continue;
                }
                if (res != null) continue;
                assert (!generic);
                T newNode = this.createSpecialization(thisObj, currentHead, cachedCount, value);
                if (newNode == null) {
                    currentHead = this.cacheNode;
                    continue;
                }
                res = newNode;
                assert (res.getParent() != null);
            } while (res == null);
        }
        finally {
            lock.unlock();
        }
        if (!(res.isGeneric() || res.accepts(thisObj) && res.acceptsValue(value))) {
            throw Errors.shouldNotReachHere();
        }
        return (T)((Object)res);
    }

    protected T createSpecialization(Object thisObj, T currentHead, int cachedCount, Object value) {
        int depth = 0;
        CacheNode specialized = null;
        DynamicObject store = null;
        if (JSDynamicObject.isJSDynamicObject(thisObj)) {
            if (!JSAdapter.isJSAdapter(thisObj) && !JSProxy.isJSProxy(thisObj) || this.key instanceof HiddenKey) {
                store = (DynamicObject)thisObj;
            }
        } else if (JSRuntime.isForeignObject(thisObj)) {
            assert (!JSDynamicObject.isJSDynamicObject(thisObj));
            specialized = (CacheNode)((Object)this.createTruffleObjectPropertyNode());
        } else {
            store = PropertyCacheNode.wrapPrimitive(thisObj, this.context);
        }
        while (store != null) {
            Shape existingShape;
            if (DynamicObjectLibrary.getUncached().updateShape(store)) {
                return this.retryCache();
            }
            Shape cacheShape = store.getShape();
            if (JSDictionary.isJSDictionaryObject(store)) {
                return this.rewriteToGeneric(currentHead, cachedCount, "dictionary object");
            }
            if (JSConfig.MergeShapes && cachedCount > 0 && PropertyCacheNode.tryMergeShapes(cacheShape, currentHead)) {
                DynamicObjectLibrary.getUncached().updateShape(store);
                return this.retryCache();
            }
            Property property = cacheShape.getProperty(this.key);
            if (JSConfig.MergeCompatibleLocations && cachedCount == 1 && depth == 0 && !(((CacheNode)((Object)currentHead)).receiverCheck instanceof CombinedShapeCheckNode) && (existingShape = ((CacheNode)((Object)currentHead)).receiverCheck.getShape()) != null && property != null && this.shapesHaveCommonLayoutForKey(existingShape, cacheShape) && this.canCombineShapeCheck(existingShape, cacheShape, thisObj, depth, value, property)) {
                return this.rewriteToCombinedIC(existingShape, cacheShape, thisObj, depth, value, property);
            }
            if (property != null) {
                specialized = this.createCachedPropertyNode(property, thisObj, depth, value, currentHead);
                if (specialized != null) break;
                return null;
            }
            if (PropertyCacheNode.alwaysUseStore(store, this.key)) {
                specialized = this.createUndefinedPropertyNode(thisObj, store, depth, value);
                break;
            }
            if (this.isOwnProperty()) break;
            if ((store = (DynamicObject)JSRuntime.toJavaNull(JSObject.getPrototype(store))) == null) continue;
            ++depth;
        }
        if (cachedCount >= this.context.getPropertyCacheLimit() || specialized != null && specialized.isGeneric()) {
            return this.rewriteToGeneric(currentHead, cachedCount, "cache limit reached");
        }
        if (specialized == null) {
            specialized = this.createUndefinedPropertyNode(thisObj, thisObj, depth, value);
        }
        return (T)((Object)this.insertCached((T)((Object)specialized), currentHead, cachedCount));
    }

    private T rewriteToCombinedIC(Shape parentShape, Shape cacheShape, Object thisObj, int depth, Object value, Property property) {
        assert (this.shapesHaveCommonLayoutForKey(parentShape, cacheShape));
        T newNode = this.createCombinedIcPropertyNode(parentShape, cacheShape, thisObj, depth, value, property);
        assert (newNode != null);
        this.invalidateCache();
        this.insert((Node)newNode);
        this.cacheNode = newNode;
        return newNode;
    }

    protected final boolean shapesHaveCommonLayoutForKey(Shape shape1, Shape shape2) {
        Class incomingType;
        Class cachedType = shape1.getLayoutClass();
        if (cachedType == (incomingType = shape2.getLayoutClass())) {
            Property cachedProperty = shape1.getProperty(this.key);
            Property incomingProperty = shape2.getProperty(this.key);
            if (incomingProperty != null && incomingProperty.equals(cachedProperty)) {
                Location cachedLocation = cachedProperty.getLocation();
                Location incomingLocation = incomingProperty.getLocation();
                return incomingLocation == cachedLocation;
            }
        }
        return false;
    }

    protected static boolean alwaysUseStore(DynamicObject store, Object key) {
        return JSProxy.isJSProxy(store) || JSArrayBufferView.isJSArrayBufferView(store) && PropertyCacheNode.isNonIntegerIndex(key) || key instanceof HiddenKey;
    }

    protected final void deoptimize() {
        if (this.invalidationAssumption == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
        } else if (CompilerDirectives.inCompiledCode()) {
            try {
                this.invalidationAssumption.check();
            }
            catch (InvalidAssumptionException invalidAssumptionException) {
                // empty catch block
            }
        }
    }

    protected T retryCache() {
        if (this.invalidationAssumption == null) {
            this.invalidationAssumption = Truffle.getRuntime().createAssumption("PropertyCacheNode");
            cacheAssumptionInitializedCount.inc();
            this.reportPolymorphicSpecialize();
        }
        return null;
    }

    protected void invalidateCache() {
        if (this.invalidationAssumption != null) {
            this.invalidationAssumption.invalidate("PropertyCacheNode invalidation");
            this.invalidationAssumption = Truffle.getRuntime().createAssumption("PropertyCacheNode");
            cacheAssumptionInvalidatedCount.inc();
        }
    }

    protected T insertCached(T specialized, T currentHead, int cachedCount) {
        assert (currentHead == this.cacheNode);
        this.invalidateCache();
        this.insert((Node)specialized);
        ((CacheNode)((Object)specialized)).setNext(currentHead);
        this.cacheNode = specialized;
        if (cachedCount > 0) {
            polymorphicCount.inc();
        }
        this.traceRewriteInsert((Node)specialized, cachedCount);
        if (JSConfig.TracePolymorphicPropertyAccess && cachedCount > 0) {
            System.out.printf("POLYMORPHIC PROPERTY ACCESS key='%s' %s\n%s\n---\n", this.key, this.getEncapsulatingSourceSection(), ((CacheNode)((Object)specialized)).debugString());
        }
        return specialized;
    }

    protected T rewriteToGeneric(T currentHead, int cachedCount, String reason) {
        assert (currentHead == this.cacheNode);
        T newNode = this.createGenericPropertyNode();
        this.invalidateCache();
        this.insert((Node)newNode);
        this.cacheNode = newNode;
        if (cachedCount > 0 && cachedCount >= this.context.getPropertyCacheLimit()) {
            megamorphicCount.inc();
            this.reportPolymorphicSpecialize();
        }
        this.traceRewriteMegamorphic((Node)newNode, reason);
        return newNode;
    }

    protected T rewriteCached(T currentHead, T newHead) {
        assert (currentHead == this.cacheNode);
        this.invalidateCache();
        this.cacheNode = newHead;
        return newHead;
    }

    protected static <T extends CacheNode<T>> boolean tryMergeShapes(Shape cacheShape, T head) {
        assert (cacheShape.isValid());
        boolean result = false;
        T cur = head;
        while (cur != null) {
            Shape other;
            if (cur.receiverCheck != null && cacheShape != (other = cur.receiverCheck.getShape()) && other != null && other.isValid()) {
                assert (cacheShape.isValid());
                result |= cacheShape.tryMerge(other) != null;
                if (!cacheShape.isValid()) break;
            }
            cur = cur.next;
        }
        return result;
    }

    protected void checkForUnstableAssumption(T head, Object thisObj) {
        T cur = head;
        while (cur != null) {
            ReceiverCheckNode check = ((CacheNode)((Object)cur)).receiverCheck;
            if (check != null) {
                if (check.isUnstable()) {
                    this.setPropertyAssumptionCheckEnabled(false);
                    propertyAssumptionCheckFailedCount.inc();
                }
                if (this.isUnexpectedConstantObject(cur, thisObj)) {
                    ((ConstantObjectReceiverCheck)((Object)check)).clearExpectedObject();
                    this.setPropertyAssumptionCheckEnabled(false);
                    constantObjectCheckFailedCount.inc();
                    this.traceRewriteEvictFinal((Node)cur);
                }
            }
            cur = ((CacheNode)((Object)cur)).next;
        }
    }

    private boolean isUnexpectedConstantObject(T cache, Object thisObj) {
        return ((CacheNode)((Object)cache)).receiverCheck instanceof ConstantObjectReceiverCheck && ((ConstantObjectReceiverCheck)((Object)((CacheNode)((Object)cache)).receiverCheck)).getExpectedObject() != thisObj;
    }

    protected static <T extends CacheNode<T>> T filterValid(T cache) {
        if (cache == null) {
            return null;
        }
        Object filteredNext = PropertyCacheNode.filterValid(((CacheNode)((Object)cache)).next);
        if (((CacheNode)((Object)cache)).isValid()) {
            if (filteredNext == ((CacheNode)((Object)cache)).next) {
                return (T)cache;
            }
            return ((CacheNode)((Object)cache)).withNext(filteredNext);
        }
        return filteredNext;
    }

    protected static final DynamicObject wrapPrimitive(Object thisObject, JSContext context) {
        TruffleObject wrapper = JSRuntime.toObjectFromPrimitive(context, thisObject, false);
        return JSDynamicObject.isJSDynamicObject(wrapper) ? (JSDynamicObject)wrapper : null;
    }

    protected final AbstractShapeCheckNode createShapeCheckNode(Shape shape, JSDynamicObject thisObj, int depth, boolean isConstantObjectFinal, boolean isDefine) {
        if (depth == 0) {
            return this.createShapeCheckNodeDepth0(shape, thisObj, isConstantObjectFinal, isDefine);
        }
        if (depth == 1) {
            return this.createShapeCheckNodeDepth1(shape, thisObj, depth, isConstantObjectFinal);
        }
        return this.createShapeCheckNodeDeeper(shape, thisObj, depth, isConstantObjectFinal);
    }

    private AbstractShapeCheckNode createShapeCheckNodeDepth0(Shape shape, JSDynamicObject thisObj, boolean isConstantObjectFinal, boolean isDefine) {
        if (this.isGlobal() && !isDefine && this.isPropertyAssumptionCheckEnabled() && JSShape.getPropertyAssumption(shape, this.key).isValid()) {
            return new AssumptionShapeCheckNode(shape, this.key, this.getContext());
        }
        if (isConstantObjectFinal) {
            assert (!isDefine);
            if (this.isPropertyAssumptionCheckEnabled() && JSShape.getPropertyAssumption(shape, this.key).isValid()) {
                return new ConstantObjectAssumptionShapeCheckNode(shape, thisObj, this.key, this.getContext());
            }
            return new ConstantObjectShapeCheckNode(shape, thisObj);
        }
        assert (!isConstantObjectFinal);
        return new ShapeCheckNode(shape);
    }

    private AbstractShapeCheckNode createShapeCheckNodeDepth1(Shape shape, JSDynamicObject thisObj, int depth, boolean isConstantObjectFinal) {
        assert (depth == 1);
        if (PropertyCacheNode.prototypesInShape(thisObj, depth) && this.propertyAssumptionsValid(thisObj, depth, isConstantObjectFinal)) {
            return isConstantObjectFinal ? new ConstantObjectPrototypeShapeCheckNode(shape, thisObj, this.key, this.getContext()) : new PrototypeShapeCheckNode(shape, thisObj, this.key, this.getContext());
        }
        traversePrototypeShapeCheckCount.inc();
        return new TraversePrototypeShapeCheckNode(shape, thisObj);
    }

    private AbstractShapeCheckNode createShapeCheckNodeDeeper(Shape shape, JSDynamicObject thisObj, int depth, boolean isConstantObjectFinal) {
        assert (depth > 1);
        if (PropertyCacheNode.prototypesInShape(thisObj, depth) && this.propertyAssumptionsValid(thisObj, depth, isConstantObjectFinal)) {
            return isConstantObjectFinal ? new ConstantObjectPrototypeChainShapeCheckNode(shape, thisObj, this.key, depth, this.getContext()) : new PrototypeChainShapeCheckNode(shape, thisObj, this.key, depth, this.getContext());
        }
        traversePrototypeChainShapeCheckCount.inc();
        return new TraversePrototypeChainShapeCheckNode(shape, thisObj, depth);
    }

    protected static boolean prototypesInShape(DynamicObject thisObj, int depth) {
        DynamicObject depthObject = thisObj;
        for (int i = 0; i < depth; ++i) {
            if (!JSShape.isPrototypeInShape(depthObject.getShape())) {
                return false;
            }
            depthObject = JSObject.getPrototype(depthObject);
        }
        return true;
    }

    protected final boolean propertyAssumptionsValid(DynamicObject thisObj, int depth, boolean checkDepth0) {
        if (!this.getContext().isSingleRealm()) {
            return false;
        }
        DynamicObject depthObject = thisObj;
        Shape depthShape = depthObject.getShape();
        if (checkDepth0 && !JSShape.getPropertyAssumption(depthShape, this.key).isValid()) {
            return false;
        }
        for (int i = 0; i < depth; ++i) {
            if ((depth != 0 || checkDepth0) && !JSShape.getPrototypeAssumption(depthShape).isValid()) {
                return false;
            }
            depthShape = (depthObject = JSObject.getPrototype(depthObject)).getShape();
            if (JSShape.getPropertyAssumption(depthShape, this.key, true).isValid()) continue;
            return false;
        }
        return true;
    }

    protected final ReceiverCheckNode createPrimitiveReceiverCheck(Object thisObj, int depth) {
        if (depth == 0) {
            return new InstanceofCheckNode(thisObj.getClass(), this.context);
        }
        assert (JSRuntime.isJSPrimitive(thisObj));
        DynamicObject wrapped = PropertyCacheNode.wrapPrimitive(thisObj, this.context);
        AbstractShapeCheckNode prototypeShapeCheck = PropertyCacheNode.prototypesInShape(wrapped, depth) && this.propertyAssumptionsValid(wrapped, depth, false) ? new PrototypeChainCheckNode(wrapped.getShape(), wrapped, this.key, depth, this.context) : new TraversePrototypeChainCheckNode(wrapped.getShape(), wrapped, depth, JSObject.getJSClass(wrapped));
        return new PrimitiveReceiverCheckNode(thisObj.getClass(), prototypeShapeCheck);
    }

    protected abstract boolean isGlobal();

    protected abstract boolean isOwnProperty();

    public final JSContext getContext() {
        return this.context;
    }

    protected abstract boolean isPropertyAssumptionCheckEnabled();

    protected abstract void setPropertyAssumptionCheckEnabled(boolean var1);

    public NodeCost getCost() {
        if (this.cacheNode == null) {
            return NodeCost.UNINITIALIZED;
        }
        if (((CacheNode)((Object)this.cacheNode)).isGeneric()) {
            return NodeCost.MEGAMORPHIC;
        }
        if (((CacheNode)((Object)this.cacheNode)).getNext() == null) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    protected static boolean isArrayLengthProperty(Property property) {
        return JSProperty.isProxy(property) && JSProperty.getConstantProxy(property) instanceof JSArray.ArrayLengthProxyProperty;
    }

    protected static boolean isFunctionLengthProperty(Property property) {
        return JSProperty.isProxy(property) && JSProperty.getConstantProxy(property) instanceof JSFunction.FunctionLengthPropertyProxy;
    }

    protected static boolean isFunctionNameProperty(Property property) {
        return JSProperty.isProxy(property) && JSProperty.getConstantProxy(property) instanceof JSFunction.FunctionNamePropertyProxy;
    }

    protected static boolean isClassPrototypeProperty(Property property) {
        return JSProperty.isProxy(property) && JSProperty.getConstantProxy(property) instanceof JSFunction.ClassPrototypeProxyProperty;
    }

    protected static boolean isStringLengthProperty(Property property) {
        return JSProperty.isProxy(property) && JSProperty.getConstantProxy(property) instanceof JSString.StringLengthProxyProperty;
    }

    protected static boolean isLazyRegexResultIndexProperty(Property property) {
        return JSProperty.isProxy(property) && JSProperty.getConstantProxy(property) instanceof JSRegExp.LazyRegexResultIndexProxyProperty;
    }

    protected static boolean isLazyNamedCaptureGroupProperty(Property property) {
        return JSProperty.isProxy(property) && JSProperty.getConstantProxy(property) instanceof JSRegExp.LazyNamedCaptureGroupProperty;
    }

    protected static boolean isNonIntegerIndex(Object key) {
        assert (!(key instanceof String) || "Infinity".equals(key) || JSRuntime.canonicalNumericIndexString((String)key) == Undefined.instance);
        return "Infinity".equals(key);
    }

    private void traceRewriteInsert(Node newNode, int cacheDepth) {
        if (TruffleOptions.TraceRewrites) {
            PrintStream out = System.out;
            out.printf("[truffle]   rewrite %-50s |Property %s |Node %s (%d/%d)%n", new Object[]{this, this.key, newNode, cacheDepth, this.getContext().getPropertyCacheLimit()});
        }
    }

    private void traceRewriteMegamorphic(Node newNode, String reason) {
        if (TruffleOptions.TraceRewrites) {
            PrintStream out = System.out;
            out.printf("[truffle]   rewrite %-50s |Property %s |Node %s |Reason %s (limit %d)%n", new Object[]{this, this.key, newNode, reason, this.getContext().getPropertyCacheLimit()});
        }
    }

    protected void traceRewriteEvictFinal(Node evicted) {
        if (TruffleOptions.TraceRewrites) {
            PrintStream out = System.out;
            out.printf("[truffle]   rewrite %-50s |Property %s |Node %s |Reason evict final%n", new Object[]{this, this.key, evicted});
        }
    }

    private void traceAssumptionInvalidated() {
        if (TruffleOptions.TraceRewrites) {
            PrintStream out = System.out;
            out.printf("[truffle]   rewrite %-50s |Property %s |Reason assumption invalidated%n", new Object[]{this, this.key});
        }
    }

    protected String getAccessorKey(String getset) {
        return PropertyCacheNode.getAccessorKey(getset, this.getKey());
    }

    @CompilerDirectives.TruffleBoundary
    protected static String getAccessorKey(String getset, Object key) {
        String origKey;
        assert (JSRuntime.isString(key));
        String string = origKey = key instanceof String ? (String)key : ((JSLazyString)key).toString();
        if (origKey.length() > 0 && Character.isLetter(origKey.charAt(0))) {
            return getset + origKey.substring(0, 1).toUpperCase() + origKey.substring(1);
        }
        return null;
    }

    protected static DynamicObjectLibrary createCachedAccess(Object key, ReceiverCheckNode receiverCheck, DynamicObject store) {
        assert (key != null);
        if (receiverCheck instanceof AbstractAssumptionShapeCheckNode) {
            return (DynamicObjectLibrary)DynamicObjectLibrary.getFactory().create((Object)store);
        }
        if (receiverCheck instanceof AbstractShapeCheckNode && !(receiverCheck instanceof AbstractAssumptionShapeCheckNode)) {
            return (DynamicObjectLibrary)DynamicObjectLibrary.getFactory().create((Object)store);
        }
        return (DynamicObjectLibrary)DynamicObjectLibrary.getFactory().createDispatched(5);
    }

    public static abstract class CacheNode<T extends CacheNode<T>>
    extends JavaScriptBaseNode {
        @Node.Child
        protected T next;
        @Node.Child
        protected ReceiverCheckNode receiverCheck;

        protected CacheNode(ReceiverCheckNode receiverCheck) {
            this.receiverCheck = receiverCheck;
        }

        protected CacheNode(T next, ReceiverCheckNode receiverCheck) {
            this.next = next;
            this.receiverCheck = receiverCheck;
        }

        protected final T getNext() {
            return this.next;
        }

        protected final void setNext(T to) {
            this.next = to;
        }

        protected T withNext(T newNext) {
            CacheNode copy = (CacheNode)this.copy();
            copy.next = newNext;
            return (T)((Object)copy);
        }

        protected final boolean isGeneric() {
            return this.receiverCheck == null;
        }

        protected final boolean accepts(Object thisObj) {
            return this.receiverCheck == null || this.receiverCheck.accept(thisObj);
        }

        protected boolean isValid() {
            return this.receiverCheck == null || this.receiverCheck.isValid();
        }

        protected boolean acceptsValue(Object value) {
            assert (value == null);
            return true;
        }

        protected boolean sweep() {
            return false;
        }

        protected String debugString() {
            CompilerAsserts.neverPartOfCompilation();
            if (this.receiverCheck != null) {
                return ((Object)((Object)this)).getClass().getSimpleName() + "<check=" + (Object)((Object)this.receiverCheck) + ", shape=" + this.receiverCheck.getShape() + ">\n" + (this.next == null ? "" : ((CacheNode)((Object)this.next)).debugString());
            }
            return null;
        }

        public final NodeCost getCost() {
            return NodeCost.NONE;
        }
    }

    protected static final class ForeignLanguageCheckNode
    extends ReceiverCheckNode {
        protected ForeignLanguageCheckNode() {
        }

        @Override
        public boolean accept(Object thisObj) {
            return JSRuntime.isForeignObject(thisObj);
        }

        @Override
        public DynamicObject getStore(Object thisObj) {
            throw Errors.shouldNotReachHere();
        }
    }

    protected static final class JSClassCheckNode
    extends ReceiverCheckNode {
        private final JSClass jsclass;

        protected JSClassCheckNode(JSClass jsclass) {
            this.jsclass = jsclass;
        }

        @Override
        public boolean accept(Object thisObj) {
            return JSClass.isInstance(thisObj, this.jsclass);
        }

        @Override
        public DynamicObject getStore(Object thisObj) {
            return (DynamicObject)thisObj;
        }
    }

    protected static final class TraversePrototypeChainCheckNode
    extends AbstractShapeCheckNode {
        private final PrototypeSupplier jsclass;
        @Node.Children
        private final ShapeCheckNode[] shapeCheckNodes;
        @Node.Children
        private final GetPrototypeNode[] getPrototypeNodes;

        public TraversePrototypeChainCheckNode(Shape shape, DynamicObject thisObj, int depth, JSClass jsclass) {
            super(shape);
            assert (depth >= 1);
            this.jsclass = (PrototypeSupplier)((Object)jsclass);
            this.shapeCheckNodes = new ShapeCheckNode[depth];
            this.getPrototypeNodes = new GetPrototypeNode[depth - 1];
            Shape depthShape = shape;
            DynamicObject depthProto = thisObj;
            for (int i = 0; i < depth; ++i) {
                depthProto = JSObject.getPrototype(depthProto);
                depthShape = depthProto.getShape();
                this.shapeCheckNodes[i] = new ShapeCheckNode(depthShape);
                if (i >= depth - 1) continue;
                this.getPrototypeNodes[i] = GetPrototypeNode.create();
            }
        }

        @Override
        @ExplodeLoop
        public boolean accept(Object thisObj) {
            DynamicObject current = this.jsclass.getIntrinsicDefaultProto(this.getRealm());
            boolean result = true;
            for (int i = 0; i < this.shapeCheckNodes.length; ++i) {
                result = this.shapeCheckNodes[i].accept(current);
                if (!result) {
                    return false;
                }
                if (i >= this.shapeCheckNodes.length - 1) continue;
                current = this.getPrototypeNodes[i].executeDynamicObject(current);
            }
            return result;
        }

        @Override
        @ExplodeLoop
        public DynamicObject getStore(Object thisObj) {
            DynamicObject proto = this.jsclass.getIntrinsicDefaultProto(this.getRealm());
            for (int i = 0; i < this.getPrototypeNodes.length; ++i) {
                proto = this.getPrototypeNodes[i].executeDynamicObject(proto);
            }
            return proto;
        }

        @Override
        public int getDepth() {
            return this.shapeCheckNodes.length;
        }

        @Override
        @ExplodeLoop
        public boolean isValid() {
            for (int i = 0; i < this.shapeCheckNodes.length; ++i) {
                if (this.shapeCheckNodes[i].isValid()) continue;
                return false;
            }
            return true;
        }
    }

    protected static final class PrototypeChainCheckNode
    extends AbstractAssumptionShapeCheckNode {
        private final DynamicObject prototype;
        @Node.Children
        private final AssumptionShapeCheckNode[] shapeCheckNodes;

        public PrototypeChainCheckNode(Shape shape, DynamicObject thisObj, Object key, int depth, JSContext context) {
            super(shape, context);
            assert (depth >= 1);
            this.shapeCheckNodes = new AssumptionShapeCheckNode[depth];
            Shape depthShape = shape;
            DynamicObject depthProto = thisObj;
            for (int i = 0; i < depth; ++i) {
                Assumption stablePrototypeAssumption = JSShape.getPrototypeAssumption(depthShape);
                depthProto = JSObject.getPrototype(depthProto);
                depthShape = depthProto.getShape();
                this.shapeCheckNodes[i] = new AssumptionShapeCheckNode(depthShape, key, context, true, stablePrototypeAssumption);
            }
            this.prototype = depthProto;
        }

        @Override
        public boolean accept(Object thisObj) {
            return true;
        }

        @Override
        public DynamicObject getStore(Object thisObj) {
            return this.prototype;
        }

        @Override
        public int getDepth() {
            return this.shapeCheckNodes.length;
        }

        @Override
        @ExplodeLoop
        public boolean isValid() {
            if (!this.context.isSingleRealm()) {
                return false;
            }
            for (int i = 0; i < this.shapeCheckNodes.length; ++i) {
                if (this.shapeCheckNodes[i].isValid()) continue;
                return false;
            }
            return true;
        }
    }

    protected static final class TraversePrototypeShapeCheckNode
    extends AbstractShapeCheckNode {
        private final Assumption shapeValidAssumption;
        @Node.Child
        private ShapeCheckNode protoShapeCheck;
        @Node.Child
        private GetPrototypeNode getPrototypeNode;

        public TraversePrototypeShapeCheckNode(Shape shape, DynamicObject thisObj) {
            super(shape);
            this.shapeValidAssumption = shape.getValidAssumption();
            this.protoShapeCheck = new ShapeCheckNode(JSObject.getPrototype(thisObj).getShape());
            this.getPrototypeNode = GetPrototypeNode.create();
        }

        @Override
        public boolean accept(Object thisObj) {
            if (JSDynamicObject.isJSDynamicObject(thisObj)) {
                DynamicObject jsobj = (DynamicObject)thisObj;
                if (this.getShape().check(jsobj)) {
                    return this.protoShapeCheck.accept(this.getPrototypeNode.executeDynamicObject(jsobj));
                }
            }
            return false;
        }

        @Override
        public DynamicObject getStore(Object thisObj) {
            return this.getPrototypeNode.executeDynamicObject((DynamicObject)thisObj);
        }

        @Override
        public int getDepth() {
            return 1;
        }

        @Override
        public boolean isValid() {
            if (!this.shapeValidAssumption.isValid()) {
                return false;
            }
            return this.protoShapeCheck.isValid();
        }
    }

    protected static final class TraversePrototypeChainShapeCheckNode
    extends AbstractShapeCheckNode {
        private final Assumption shapeValidAssumption;
        @Node.Children
        private final ShapeCheckNode[] shapeCheckNodes;
        @Node.Children
        private final GetPrototypeNode[] getPrototypeNodes;

        public TraversePrototypeChainShapeCheckNode(Shape shape, DynamicObject thisObj, int depth) {
            super(shape);
            this.shapeValidAssumption = shape.getValidAssumption();
            this.shapeCheckNodes = new ShapeCheckNode[depth];
            this.getPrototypeNodes = new GetPrototypeNode[depth];
            Shape depthShape = shape;
            DynamicObject depthProto = thisObj;
            for (int i = 0; i < depth; ++i) {
                depthProto = JSObject.getPrototype(depthProto);
                depthShape = depthProto.getShape();
                this.shapeCheckNodes[i] = new ShapeCheckNode(depthShape);
                this.getPrototypeNodes[i] = GetPrototypeNode.create();
            }
        }

        @Override
        @ExplodeLoop
        public boolean accept(Object thisObj) {
            if (!JSDynamicObject.isJSDynamicObject(thisObj)) {
                return false;
            }
            DynamicObject current = (DynamicObject)thisObj;
            boolean result = this.getShape().check(current);
            if (!result) {
                return false;
            }
            for (int i = 0; i < this.shapeCheckNodes.length; ++i) {
                result = this.shapeCheckNodes[i].accept(current = this.getPrototypeNodes[i].executeDynamicObject(current));
                if (result) continue;
                return false;
            }
            return result;
        }

        @Override
        @ExplodeLoop
        public DynamicObject getStore(Object thisObj) {
            DynamicObject proto = (DynamicObject)thisObj;
            for (int i = 0; i < this.shapeCheckNodes.length; ++i) {
                proto = this.getPrototypeNodes[i].executeDynamicObject(proto);
            }
            return proto;
        }

        @Override
        public int getDepth() {
            return this.shapeCheckNodes.length;
        }

        @Override
        @ExplodeLoop
        public boolean isValid() {
            if (!this.shapeValidAssumption.isValid()) {
                return false;
            }
            for (int i = 0; i < this.shapeCheckNodes.length; ++i) {
                if (this.shapeCheckNodes[i].isValid()) continue;
                return false;
            }
            return true;
        }
    }

    protected static final class ConstantObjectPrototypeShapeCheckNode
    extends AbstractAssumptionShapeCheckNode
    implements ConstantObjectReceiverCheck {
        private final Assumption shapeValidAssumption;
        private final Assumption unchangedAssumption;
        private final Assumption stableProtoAssumption;
        private final Assumption protoShapeValidAssumption;
        private final Assumption protoUnchangedAssumption;
        private final WeakReference<JSDynamicObject> expectedObjectRef;
        private final WeakReference<DynamicObject> prototype;

        public ConstantObjectPrototypeShapeCheckNode(Shape shape, JSDynamicObject thisObj, Object key, JSContext context) {
            super(shape, context);
            this.shapeValidAssumption = shape.getValidAssumption();
            this.unchangedAssumption = JSShape.getPropertyAssumption(shape, key);
            this.stableProtoAssumption = JSShape.getPrototypeAssumption(shape);
            DynamicObject finalProto = JSObject.getPrototype(thisObj);
            Shape protoShape = finalProto.getShape();
            this.protoShapeValidAssumption = protoShape.getValidAssumption();
            this.protoUnchangedAssumption = JSShape.getPropertyAssumption(protoShape, key, true);
            this.expectedObjectRef = new WeakReference<JSDynamicObject>(thisObj);
            this.prototype = new WeakReference<DynamicObject>(finalProto);
        }

        @Override
        public boolean accept(Object thisObj) {
            JSDynamicObject expectedObj = (JSDynamicObject)((Object)this.expectedObjectRef.get());
            if (thisObj != expectedObj) {
                return false;
            }
            assert (this.prototype.get() != null);
            return true;
        }

        @Override
        public DynamicObject getStore(Object thisObj) {
            return (DynamicObject)this.prototype.get();
        }

        @Override
        public int getDepth() {
            return 1;
        }

        @Override
        public boolean isValid() {
            if (!this.context.isSingleRealm()) {
                return false;
            }
            if (!this.shapeValidAssumption.isValid()) {
                return false;
            }
            if (!this.unchangedAssumption.isValid()) {
                return false;
            }
            if (!this.stableProtoAssumption.isValid()) {
                return false;
            }
            if (!this.protoShapeValidAssumption.isValid()) {
                return false;
            }
            if (!this.protoUnchangedAssumption.isValid()) {
                return false;
            }
            if (this.expectedObjectRef.get() == null) {
                return false;
            }
            return this.prototype.get() != null;
        }

        @Override
        protected boolean isUnstable() {
            return this.shapeValidAssumption.isValid() && !this.unchangedAssumption.isValid();
        }

        @Override
        public Object getExpectedObject() {
            return this.expectedObjectRef.get();
        }

        @Override
        public void clearExpectedObject() {
            this.expectedObjectRef.clear();
        }
    }

    protected static final class ConstantObjectPrototypeChainShapeCheckNode
    extends AbstractAssumptionShapeCheckNode
    implements ConstantObjectReceiverCheck {
        private final Assumption shapeValidAssumption;
        private final Assumption shapeUnchangedAssumption;
        private final WeakReference<JSDynamicObject> expectedObjectRef;
        private final WeakReference<DynamicObject> prototype;
        @Node.Children
        private final AssumptionShapeCheckNode[] shapeCheckNodes;

        public ConstantObjectPrototypeChainShapeCheckNode(Shape shape, JSDynamicObject thisObj, Object key, int depth, JSContext context) {
            super(shape, context);
            this.shapeValidAssumption = shape.getValidAssumption();
            this.shapeUnchangedAssumption = JSShape.getPropertyAssumption(shape, key);
            this.expectedObjectRef = new WeakReference<JSDynamicObject>(thisObj);
            this.shapeCheckNodes = new AssumptionShapeCheckNode[depth];
            Shape depthShape = shape;
            JSDynamicObject depthProto = thisObj;
            for (int i = 0; i < depth; ++i) {
                Assumption stablePrototypeAssumption = JSShape.getPrototypeAssumption(depthShape);
                depthProto = JSObject.getPrototype(depthProto);
                depthShape = depthProto.getShape();
                this.shapeCheckNodes[i] = new AssumptionShapeCheckNode(depthShape, key, context, true, stablePrototypeAssumption);
            }
            this.prototype = new WeakReference<JSDynamicObject>(depthProto);
        }

        @Override
        public boolean accept(Object thisObj) {
            JSDynamicObject expectedObj = (JSDynamicObject)((Object)this.expectedObjectRef.get());
            if (thisObj != expectedObj) {
                return false;
            }
            assert (this.prototype.get() != null);
            return true;
        }

        @Override
        public DynamicObject getStore(Object thisObj) {
            return (DynamicObject)this.prototype.get();
        }

        @Override
        public int getDepth() {
            return this.shapeCheckNodes.length;
        }

        @Override
        @ExplodeLoop
        public boolean isValid() {
            if (!this.context.isSingleRealm()) {
                return false;
            }
            if (!this.shapeValidAssumption.isValid()) {
                return false;
            }
            if (!this.shapeUnchangedAssumption.isValid()) {
                return false;
            }
            if (this.expectedObjectRef.get() == null) {
                return false;
            }
            if (this.prototype.get() == null) {
                return false;
            }
            for (int i = 0; i < this.shapeCheckNodes.length; ++i) {
                if (this.shapeCheckNodes[i].isValid()) continue;
                return false;
            }
            return true;
        }

        @Override
        protected boolean isUnstable() {
            return this.shapeValidAssumption.isValid() && !this.shapeUnchangedAssumption.isValid();
        }

        @Override
        public Object getExpectedObject() {
            return this.expectedObjectRef.get();
        }

        @Override
        public void clearExpectedObject() {
            this.expectedObjectRef.clear();
        }
    }

    protected static final class ConstantObjectAssumptionShapeCheckNode
    extends AbstractAssumptionShapeCheckNode
    implements ConstantObjectReceiverCheck {
        private final Assumption shapeValidAssumption;
        private final Assumption unchangedAssumption;
        private final WeakReference<JSDynamicObject> expectedObjectRef;

        public ConstantObjectAssumptionShapeCheckNode(Shape shape, JSDynamicObject thisObj, Object key, JSContext context) {
            super(shape, context);
            this.shapeValidAssumption = shape.getValidAssumption();
            this.unchangedAssumption = JSShape.getPropertyAssumption(shape, key);
            this.expectedObjectRef = new WeakReference<JSDynamicObject>(thisObj);
        }

        @Override
        public boolean accept(Object thisObj) {
            JSDynamicObject expectedObj = (JSDynamicObject)((Object)this.expectedObjectRef.get());
            return thisObj == expectedObj;
        }

        @Override
        public DynamicObject getStore(Object thisObj) {
            return (JSDynamicObject)((Object)thisObj);
        }

        @Override
        public boolean isValid() {
            if (!this.context.isSingleRealm()) {
                return false;
            }
            if (!this.shapeValidAssumption.isValid()) {
                return false;
            }
            if (!this.unchangedAssumption.isValid()) {
                return false;
            }
            return this.expectedObjectRef.get() != null;
        }

        @Override
        protected boolean isUnstable() {
            return this.shapeValidAssumption.isValid() && !this.unchangedAssumption.isValid();
        }

        @Override
        public Object getExpectedObject() {
            return this.expectedObjectRef.get();
        }

        @Override
        public void clearExpectedObject() {
            this.expectedObjectRef.clear();
        }
    }

    protected static final class ConstantObjectShapeCheckNode
    extends AbstractShapeCheckNode
    implements ConstantObjectReceiverCheck {
        private final Assumption shapeValidAssumption;
        private final WeakReference<JSDynamicObject> expectedObjectRef;

        public ConstantObjectShapeCheckNode(Shape shape, JSDynamicObject thisObj) {
            super(shape);
            this.shapeValidAssumption = shape.getValidAssumption();
            this.expectedObjectRef = new WeakReference<JSDynamicObject>(thisObj);
        }

        @Override
        public boolean accept(Object thisObj) {
            JSDynamicObject expectedObj = (JSDynamicObject)((Object)this.expectedObjectRef.get());
            if (thisObj != expectedObj) {
                return false;
            }
            assert (expectedObj != null);
            return super.accept(thisObj);
        }

        @Override
        public DynamicObject getStore(Object thisObj) {
            return (JSDynamicObject)((Object)thisObj);
        }

        @Override
        public boolean isValid() {
            if (!this.shapeValidAssumption.isValid()) {
                return false;
            }
            return this.expectedObjectRef.get() != null;
        }

        @Override
        public Object getExpectedObject() {
            return this.expectedObjectRef.get();
        }

        @Override
        public void clearExpectedObject() {
            this.expectedObjectRef.clear();
        }
    }

    protected static interface ConstantObjectReceiverCheck {
        public Object getExpectedObject();

        public void clearExpectedObject();
    }

    protected static final class PrototypeChainShapeCheckNode
    extends AbstractAssumptionShapeCheckNode {
        private final Assumption shapeValidAssumption;
        private final DynamicObject prototype;
        @Node.Children
        private final AssumptionShapeCheckNode[] shapeCheckNodes;

        public PrototypeChainShapeCheckNode(Shape shape, DynamicObject thisObj, Object key, int depth, JSContext context) {
            super(shape, context);
            this.shapeValidAssumption = shape.getValidAssumption();
            this.shapeCheckNodes = new AssumptionShapeCheckNode[depth];
            Shape depthShape = shape;
            DynamicObject depthProto = thisObj;
            for (int i = 0; i < depth; ++i) {
                Assumption stablePrototypeAssumption = i == 0 ? null : JSShape.getPrototypeAssumption(depthShape);
                depthProto = JSObject.getPrototype(depthProto);
                depthShape = depthProto.getShape();
                this.shapeCheckNodes[i] = new AssumptionShapeCheckNode(depthShape, key, context, true, stablePrototypeAssumption);
            }
            this.prototype = depthProto;
        }

        @Override
        public DynamicObject getStore(Object thisObj) {
            return this.prototype;
        }

        @Override
        public int getDepth() {
            return this.shapeCheckNodes.length;
        }

        @Override
        @ExplodeLoop
        public boolean isValid() {
            if (!this.context.isSingleRealm()) {
                return false;
            }
            if (!this.shapeValidAssumption.isValid()) {
                return false;
            }
            for (int i = 0; i < this.shapeCheckNodes.length; ++i) {
                if (this.shapeCheckNodes[i].isValid()) continue;
                return false;
            }
            return true;
        }
    }

    protected static final class PrototypeShapeCheckNode
    extends AbstractAssumptionShapeCheckNode {
        private final Assumption notObsoletedAssumption;
        private final Assumption protoNotObsoletedAssumption;
        private final Assumption protoUnchangedAssumption;
        private final DynamicObject prototype;

        public PrototypeShapeCheckNode(Shape shape, DynamicObject thisObj, Object key, JSContext context) {
            super(shape, context);
            this.notObsoletedAssumption = shape.getValidAssumption();
            DynamicObject finalProto = JSObject.getPrototype(thisObj);
            Shape protoShape = finalProto.getShape();
            this.protoNotObsoletedAssumption = protoShape.getValidAssumption();
            this.protoUnchangedAssumption = JSShape.getPropertyAssumption(protoShape, key, true);
            this.prototype = finalProto;
        }

        @Override
        public DynamicObject getStore(Object thisObj) {
            return this.prototype;
        }

        @Override
        public int getDepth() {
            return 1;
        }

        @Override
        public boolean isValid() {
            if (!this.context.isSingleRealm()) {
                return false;
            }
            if (!this.notObsoletedAssumption.isValid()) {
                return false;
            }
            if (!this.protoNotObsoletedAssumption.isValid()) {
                return false;
            }
            return this.protoUnchangedAssumption.isValid();
        }
    }

    protected static final class AssumptionShapeCheckNode
    extends AbstractAssumptionShapeCheckNode {
        private final Assumption shapeValidAssumption;
        private final Assumption unchangedShapeAssumption;
        private final Assumption stablePrototypeAssumption;

        protected AssumptionShapeCheckNode(Shape shape, Object key, JSContext context, Assumption unchangedAssumption, Assumption stablePrototypeAssumption) {
            super(shape, context);
            this.shapeValidAssumption = shape.getValidAssumption();
            this.unchangedShapeAssumption = unchangedAssumption;
            this.stablePrototypeAssumption = stablePrototypeAssumption;
        }

        public AssumptionShapeCheckNode(Shape shape, Object key, JSContext context) {
            this(shape, key, context, JSShape.getPropertyAssumption(shape, key, false), null);
        }

        public AssumptionShapeCheckNode(Shape shape, Object key, JSContext context, boolean prototype, Assumption stablePrototypeAssumption) {
            this(shape, key, context, JSShape.getPropertyAssumption(shape, key, prototype), stablePrototypeAssumption);
        }

        @Override
        public boolean accept(Object thisObj) {
            return true;
        }

        @Override
        public DynamicObject getStore(Object thisObj) {
            return (JSDynamicObject)((Object)thisObj);
        }

        @Override
        public boolean isValid() {
            if (!this.context.isSingleRealm()) {
                return false;
            }
            if (!this.shapeValidAssumption.isValid()) {
                return false;
            }
            if (!this.unchangedShapeAssumption.isValid()) {
                return false;
            }
            return this.stablePrototypeAssumption == null || this.stablePrototypeAssumption.isValid();
        }

        @Override
        protected boolean isUnstable() {
            return this.shapeValidAssumption.isValid() && !this.unchangedShapeAssumption.isValid();
        }
    }

    protected static abstract class AbstractAssumptionShapeCheckNode
    extends AbstractShapeCheckNode {
        protected final JSContext context;

        protected AbstractAssumptionShapeCheckNode(Shape shape, JSContext context) {
            super(shape);
            this.context = context;
        }
    }

    public static final class ShapeCheckNode
    extends AbstractShapeCheckNode {
        private final Assumption shapeValidAssumption;

        public ShapeCheckNode(Shape shape) {
            super(shape);
            this.shapeValidAssumption = shape.getValidAssumption();
        }

        @Override
        public DynamicObject getStore(Object thisObj) {
            return (DynamicObject)this.getShape().getLayoutClass().cast(thisObj);
        }

        @Override
        public boolean isValid() {
            return this.shapeValidAssumption.isValid();
        }
    }

    protected static final class PrimitiveReceiverCheckNode
    extends ReceiverCheckNode {
        private final Class<?> type;
        @Node.Child
        private AbstractShapeCheckNode prototypeShapeCheck;

        protected PrimitiveReceiverCheckNode(Class<?> type, AbstractShapeCheckNode prototypeShapeCheck) {
            this.type = type;
            this.prototypeShapeCheck = prototypeShapeCheck;
        }

        @Override
        public boolean accept(Object thisObj) {
            if (this.type.isInstance(thisObj)) {
                return this.prototypeShapeCheck.accept(thisObj);
            }
            return false;
        }

        @Override
        public DynamicObject getStore(Object thisObj) {
            return this.prototypeShapeCheck.getStore(thisObj);
        }

        @Override
        public boolean isValid() {
            return this.prototypeShapeCheck.isValid();
        }
    }

    protected static final class InstanceofCheckNode
    extends ReceiverCheckNode {
        protected final Class<?> type;
        @Node.Child
        private JSToObjectNode toObject;

        protected InstanceofCheckNode(Class<?> type, JSContext context) {
            this.type = type;
            this.toObject = JSToObjectNode.createToObjectNoCheckNoForeign(context);
        }

        @Override
        public boolean accept(Object thisObj) {
            return this.type.isInstance(thisObj);
        }

        @Override
        public DynamicObject getStore(Object thisObj) {
            return (DynamicObject)this.toObject.execute(thisObj);
        }
    }

    protected static final class NullCheckNode
    extends ReceiverCheckNode {
        protected NullCheckNode() {
        }

        @Override
        public boolean accept(Object thisObj) {
            return thisObj == null;
        }

        @Override
        public DynamicObject getStore(Object thisObj) {
            throw Errors.shouldNotReachHere();
        }
    }

    protected static abstract class AbstractShapeCheckNode
    extends ReceiverCheckNode {
        private final Shape shape;

        protected AbstractShapeCheckNode(Shape shape) {
            this.shape = shape;
        }

        @Override
        public abstract DynamicObject getStore(Object var1);

        @Override
        public final Shape getShape() {
            return this.shape;
        }

        @Override
        public boolean accept(Object thisObj) {
            return this.shape.getLayoutClass().isInstance(thisObj) && this.shape.check((DynamicObject)thisObj);
        }

        public int getDepth() {
            return 0;
        }

        @Override
        public abstract boolean isValid();
    }

    protected static class CombinedShapeCheckNode
    extends ReceiverCheckNode {
        private final Shape shape1;
        private final Shape shape2;

        CombinedShapeCheckNode(Shape shape1, Shape shape2) {
            assert (shape1.getLayoutClass() == shape2.getLayoutClass());
            this.shape1 = shape1;
            this.shape2 = shape2;
        }

        @Override
        public boolean accept(Object thisObj) {
            return this.shape1.getLayoutClass().isInstance(thisObj) && (this.shape1.check((DynamicObject)thisObj) || this.shape2.check((DynamicObject)thisObj));
        }

        @Override
        public DynamicObject getStore(Object thisObj) {
            return (DynamicObject)this.shape1.getLayoutClass().cast(thisObj);
        }
    }

    protected static abstract class ReceiverCheckNode
    extends JavaScriptBaseNode {
        protected ReceiverCheckNode() {
        }

        public abstract boolean accept(Object var1);

        public abstract DynamicObject getStore(Object var1);

        public Shape getShape() {
            return null;
        }

        public boolean isValid() {
            return true;
        }

        protected boolean isUnstable() {
            return false;
        }

        public final NodeCost getCost() {
            return NodeCost.NONE;
        }
    }
}

