/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.objects.Accessor;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSOrdinaryObject;
import com.oracle.truffle.js.runtime.objects.JSProperty;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.objects.PropertyProxy;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.DefinePropertyUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;

public final class JSDictionary
extends JSNonProxy {
    public static final String CLASS_NAME = "Object";
    private static final HiddenKey HASHMAP_PROPERTY_NAME = new HiddenKey("%hashMap");
    public static final JSDictionary INSTANCE = new JSDictionary();

    private JSDictionary() {
    }

    public static boolean isJSDictionaryObject(Object obj) {
        return JSDynamicObject.isJSDynamicObject(obj) && JSDictionary.isJSDictionaryObject((DynamicObject)obj);
    }

    public static boolean isJSDictionaryObject(DynamicObject obj) {
        return JSDictionary.isInstance(obj, (JSClass)INSTANCE);
    }

    @Override
    public String getClassName(DynamicObject object) {
        return CLASS_NAME;
    }

    @Override
    public String toDisplayStringImpl(DynamicObject obj, int depth, boolean allowSideEffects) {
        return this.defaultToString(obj);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getOwnHelper(DynamicObject store, Object thisObj, Object key, Node encapsulatingNode) {
        PropertyDescriptor desc = (PropertyDescriptor)JSDictionary.getHashMap(store).get(key);
        if (desc != null) {
            return JSDictionary.getValue(desc, thisObj, encapsulatingNode);
        }
        return super.getOwnHelper(store, thisObj, key, encapsulatingNode);
    }

    public static Object getValue(PropertyDescriptor property, Object receiver, Node encapsulatingNode) {
        if (property.isAccessorDescriptor()) {
            DynamicObject getter = (DynamicObject)property.getGet();
            if (getter != Undefined.instance) {
                return JSRuntime.call(getter, receiver, JSArguments.EMPTY_ARGUMENTS_ARRAY, encapsulatingNode);
            }
            return Undefined.instance;
        }
        assert (property.isDataDescriptor());
        return property.getValue();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public List<Object> getOwnPropertyKeys(DynamicObject thisObj, boolean strings, boolean symbols) {
        assert (JSDictionary.isJSDictionaryObject(thisObj));
        List<Object> keys = JSDictionary.ordinaryOwnPropertyKeysSlow(thisObj, strings, symbols);
        for (Object key : JSDictionary.getHashMap(thisObj).getKeys()) {
            if (!symbols && key instanceof Symbol || !strings && key instanceof String) continue;
            keys.add(key);
        }
        Collections.sort(keys, JSRuntime::comparePropertyKeys);
        return keys;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean delete(DynamicObject thisObj, Object key, boolean isStrict) {
        EconomicMap<Object, PropertyDescriptor> hashMap = JSDictionary.getHashMap(thisObj);
        PropertyDescriptor desc = (PropertyDescriptor)hashMap.get(key);
        if (desc != null) {
            if (!desc.getConfigurable()) {
                if (isStrict) {
                    throw Errors.createTypeErrorNotConfigurableProperty(key);
                }
                return false;
            }
            hashMap.removeKey(key);
            return true;
        }
        return super.delete(thisObj, key, isStrict);
    }

    @Override
    public boolean delete(DynamicObject thisObj, long index, boolean isStrict) {
        return this.delete(thisObj, String.valueOf(index), isStrict);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean hasOwnProperty(DynamicObject thisObj, Object key) {
        if (JSDictionary.getHashMap(thisObj).containsKey(key)) {
            return true;
        }
        return super.hasOwnProperty(thisObj, key);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean set(DynamicObject thisObj, long index, Object value, Object receiver, boolean isStrict, Node encapsulatingNode) {
        String key = Boundaries.stringValueOf(index);
        return JSDictionary.dictionaryObjectSet(thisObj, key, value, receiver, isStrict, encapsulatingNode);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean set(DynamicObject thisObj, Object key, Object value, Object receiver, boolean isStrict, Node encapsulatingNode) {
        return JSDictionary.dictionaryObjectSet(thisObj, key, value, receiver, isStrict, encapsulatingNode);
    }

    protected static boolean dictionaryObjectSet(DynamicObject thisObj, Object key, Object value, Object receiver, boolean isStrict, Node encapsulatingNode) {
        if (receiver != thisObj) {
            return JSDictionary.ordinarySetWithReceiver(thisObj, key, value, receiver, isStrict, encapsulatingNode);
        }
        PropertyDescriptor property = (PropertyDescriptor)JSDictionary.getHashMap(thisObj).get(key);
        if (property != null) {
            return JSDictionary.setValue(key, property, thisObj, receiver, value, isStrict, encapsulatingNode);
        }
        Property entry = DefinePropertyUtil.getPropertyByKey(thisObj, key);
        if (entry != null) {
            return JSProperty.setValue(entry, thisObj, receiver, value, isStrict, encapsulatingNode);
        }
        return JSDictionary.setPropertySlow(thisObj, key, value, receiver, isStrict, false, encapsulatingNode);
    }

    private static boolean setValue(Object key, PropertyDescriptor property, DynamicObject store, Object thisObj, Object value, boolean isStrict, Node encapsulatingNode) {
        if (property.isAccessorDescriptor()) {
            DynamicObject setter = (DynamicObject)property.getSet();
            if (setter != Undefined.instance) {
                JSRuntime.call(setter, thisObj, new Object[]{value}, encapsulatingNode);
                return true;
            }
            if (isStrict) {
                throw Errors.createTypeErrorCannotSetAccessorProperty(key, store);
            }
            return false;
        }
        assert (property.isDataDescriptor());
        if (property.getWritable()) {
            property.setValue(value);
            return true;
        }
        if (isStrict) {
            throw Errors.createTypeErrorNotWritableProperty(key, thisObj);
        }
        return false;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public PropertyDescriptor getOwnProperty(DynamicObject thisObj, Object key) {
        assert (JSRuntime.isPropertyKey(key));
        PropertyDescriptor prop = (PropertyDescriptor)JSDictionary.getHashMap(thisObj).get(key);
        if (prop != null) {
            return prop;
        }
        return super.getOwnProperty(thisObj, key);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean defineOwnProperty(DynamicObject thisObj, Object key, PropertyDescriptor desc, boolean doThrow) {
        if (!this.hasOwnProperty(thisObj, key) && JSObject.isExtensible(thisObj)) {
            JSDictionary.getHashMap(thisObj).put(key, (Object)desc);
            return true;
        }
        JSDictionary.makeOrdinaryObject(thisObj, "defineOwnProperty");
        return super.defineOwnProperty(thisObj, key, desc, doThrow);
    }

    static EconomicMap<Object, PropertyDescriptor> getHashMap(DynamicObject obj) {
        assert (JSDictionary.isJSDictionaryObject(obj));
        Property hashMapProperty = obj.getShape().getProperty((Object)HASHMAP_PROPERTY_NAME);
        return (EconomicMap)hashMapProperty.get(obj, false);
    }

    public static void makeDictionaryObject(DynamicObject obj, String reason) {
        CompilerAsserts.neverPartOfCompilation();
        if (!JSOrdinary.isJSOrdinaryObject(obj)) {
            return;
        }
        Shape currentShape = obj.getShape();
        assert (!JSDictionary.isJSDictionaryObject(obj) && currentShape.getProperty((Object)HASHMAP_PROPERTY_NAME) == null);
        JSContext context = JSObject.getJSContext(obj);
        Shape newRootShape = JSDictionary.makeEmptyShapeForNewType(context, currentShape, INSTANCE, obj);
        assert (JSShape.hasExternalProperties(newRootShape.getFlags()));
        DynamicObjectLibrary lib = DynamicObjectLibrary.getUncached();
        List allProperties = currentShape.getPropertyListInternal(true);
        ArrayList<Object> archive = new ArrayList<Object>(allProperties.size());
        for (Property prop : allProperties) {
            Object key = prop.getKey();
            Object value = lib.getOrDefault(obj, key, null);
            assert (value != null);
            archive.add(value);
        }
        lib.resetShape(obj, newRootShape);
        EconomicMap hashMap = EconomicMap.create();
        for (int i = 0; i < archive.size(); ++i) {
            Property p = (Property)allProperties.get(i);
            Object key = p.getKey();
            if (newRootShape.hasProperty(key)) continue;
            Object value = archive.get(i);
            if (key instanceof HiddenKey || JSProperty.isProxy(p)) {
                if (p.getLocation().isConstant()) {
                    lib.putConstant(obj, key, value, p.getFlags());
                    continue;
                }
                lib.putWithFlags(obj, key, value, p.getFlags());
                continue;
            }
            hashMap.put(key, (Object)JSDictionary.toPropertyDescriptor(p, value));
        }
        JSObjectUtil.putHiddenProperty(obj, HASHMAP_PROPERTY_NAME, hashMap);
        assert (JSDictionary.isJSDictionaryObject(obj) && obj.getShape().getProperty((Object)HASHMAP_PROPERTY_NAME) != null);
    }

    private static Shape makeEmptyShapeForNewType(JSContext context, Shape currentShape, JSClass jsclass, DynamicObject fromObject) {
        Property prototypeProperty = JSShape.getPrototypeProperty(currentShape);
        if (!prototypeProperty.getLocation().isConstant()) {
            return context.makeEmptyShapeWithPrototypeInObject(jsclass);
        }
        JSDynamicObject prototype = JSObjectUtil.getPrototype(fromObject);
        if (prototype == Null.instance) {
            return context.makeEmptyShapeWithNullPrototype(jsclass);
        }
        return JSObjectUtil.getProtoChildShape(prototype, jsclass, context);
    }

    private static PropertyDescriptor toPropertyDescriptor(Property p, Object value) {
        PropertyDescriptor desc;
        if (JSProperty.isAccessor(p)) {
            desc = PropertyDescriptor.createAccessor(((Accessor)value).getGetter(), ((Accessor)value).getSetter());
            desc.setConfigurable(JSProperty.isConfigurable(p));
            desc.setEnumerable(JSProperty.isEnumerable(p));
        } else {
            assert (JSProperty.isData(p));
            desc = PropertyDescriptor.createData(value, JSProperty.isEnumerable(p), JSProperty.isWritable(p), JSProperty.isConfigurable(p));
        }
        return desc;
    }

    private static void makeOrdinaryObject(DynamicObject obj, String reason) {
        Object value;
        CompilerAsserts.neverPartOfCompilation();
        EconomicMap<Object, PropertyDescriptor> hashMap = JSDictionary.getHashMap(obj);
        Shape oldShape = obj.getShape();
        JSContext context = JSObject.getJSContext(obj);
        Shape newRootShape = JSDictionary.makeEmptyShapeForNewType(context, oldShape, JSOrdinary.INSTANCE, obj);
        DynamicObjectLibrary lib = DynamicObjectLibrary.getUncached();
        List allProperties = oldShape.getPropertyListInternal(true);
        ArrayList<AbstractMap.SimpleImmutableEntry<Property, Object>> archive = new ArrayList<AbstractMap.SimpleImmutableEntry<Property, Object>>(allProperties.size());
        for (Property prop : allProperties) {
            Object key = prop.getKey();
            value = lib.getOrDefault(obj, key, null);
            if (HASHMAP_PROPERTY_NAME.equals(key)) continue;
            archive.add(new AbstractMap.SimpleImmutableEntry<Property, Object>(prop, value));
        }
        lib.resetShape(obj, newRootShape);
        for (int i = 0; i < archive.size(); ++i) {
            Map.Entry e = (Map.Entry)archive.get(i);
            Property p = (Property)e.getKey();
            Object key = p.getKey();
            if (newRootShape.hasProperty(key)) continue;
            Object value2 = e.getValue();
            if (p.getLocation().isConstant()) {
                lib.putConstant(obj, key, value2, p.getFlags());
                continue;
            }
            lib.putWithFlags(obj, key, value2, p.getFlags());
        }
        MapCursor cursor = hashMap.getEntries();
        while (cursor.advance()) {
            Object key = cursor.getKey();
            PropertyDescriptor desc = (PropertyDescriptor)cursor.getValue();
            if (desc.isDataDescriptor()) {
                value = desc.getValue();
                assert (!(value instanceof Accessor) && !(value instanceof PropertyProxy));
                JSObjectUtil.defineDataProperty(obj, key, value, desc.getFlags());
                continue;
            }
            JSObjectUtil.defineAccessorProperty(obj, key, new Accessor((DynamicObject)desc.getGet(), (DynamicObject)desc.getSet()), desc.getFlags());
        }
        assert (JSOrdinary.isJSOrdinaryObject(obj) && obj.getShape().getProperty((Object)HASHMAP_PROPERTY_NAME) == null);
    }

    public static Shape makeDictionaryShape(JSContext context, DynamicObject prototype) {
        assert (prototype != Null.instance);
        return JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context);
    }

    public static DynamicObject create(JSContext context, JSRealm realm) {
        JSObjectFactory factory = context.getDictionaryObjectFactory();
        JSOrdinaryObject obj = JSOrdinaryObject.create(factory.getShape(realm));
        factory.initProto(obj, realm);
        JSObjectUtil.putHiddenProperty(obj, HASHMAP_PROPERTY_NAME, JSDictionary.newHashMap());
        return context.trackAllocation(obj);
    }

    private static EconomicMap<Object, PropertyDescriptor> newHashMap() {
        return EconomicMap.create();
    }

    @Override
    public boolean usesOrdinaryGetOwnProperty() {
        return false;
    }
}

