/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.array.dyn;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.array.DynamicArray;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractJSObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.ArrayCopy;
import com.oracle.truffle.js.runtime.array.dyn.ContiguousJSObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.HolesJSObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.ZeroBasedObjectArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;

public final class ZeroBasedJSObjectArray
extends AbstractJSObjectArray {
    private static final ZeroBasedJSObjectArray ZERO_BASED_JSOBJECT_ARRAY = new ZeroBasedJSObjectArray(0, ZeroBasedJSObjectArray.createCache());

    public static <T> ZeroBasedJSObjectArray makeZeroBasedJSObjectArray(DynamicObject object, int length, int usedLength, T[] array, int integrityLevel) {
        ZeroBasedJSObjectArray arrayType = (ZeroBasedJSObjectArray)ZeroBasedJSObjectArray.createZeroBasedJSObjectArray().setIntegrityLevel(integrityLevel);
        JSAbstractArray.arraySetLength(object, length);
        JSAbstractArray.arraySetUsedLength(object, usedLength);
        JSAbstractArray.arraySetArray(object, array);
        return arrayType;
    }

    public static ZeroBasedJSObjectArray createZeroBasedJSObjectArray() {
        return ZERO_BASED_JSOBJECT_ARRAY;
    }

    private ZeroBasedJSObjectArray(int integrityLevel, DynamicArray.DynamicArrayCache cache) {
        super(integrityLevel, cache);
    }

    @Override
    public boolean isSupported(DynamicObject object, long index) {
        return ZeroBasedJSObjectArray.isSupportedZeroBased(object, (int)index);
    }

    @Override
    public DynamicObject getInBoundsFastJSObject(DynamicObject object, int index) {
        return this.castNonNull(ZeroBasedJSObjectArray.getArray(object)[index]);
    }

    @Override
    public void setInBoundsFast(DynamicObject object, int index, JSDynamicObject value) {
        ZeroBasedJSObjectArray.getArray((DynamicObject)object)[index] = ZeroBasedJSObjectArray.checkNonNull(value);
    }

    @Override
    protected int prepareInBoundsFast(DynamicObject object, long index) {
        return (int)index;
    }

    @Override
    protected int prepareInBounds(DynamicObject object, int index, ScriptArray.ProfileHolder profile) {
        ZeroBasedJSObjectArray.prepareInBoundsZeroBased(object, index, profile);
        return index;
    }

    @Override
    protected int prepareSupported(DynamicObject object, int index, ScriptArray.ProfileHolder profile) {
        this.prepareSupportedZeroBased(object, index, profile);
        return index;
    }

    @Override
    protected void setLengthLess(DynamicObject object, long length, ScriptArray.ProfileHolder profile) {
        this.setLengthLessZeroBased(object, length, profile);
    }

    @Override
    public ContiguousJSObjectArray toContiguous(DynamicObject object, long index, Object value) {
        JSDynamicObject[] array = ZeroBasedJSObjectArray.getArray(object);
        int length = this.lengthInt(object);
        int usedLength = ZeroBasedJSObjectArray.getUsedLength(object);
        ContiguousJSObjectArray newArray = ContiguousJSObjectArray.makeContiguousJSObjectArray(object, length, array, 0L, 0, usedLength, this.integrityLevel);
        if (JSConfig.TraceArrayTransitions) {
            ZeroBasedJSObjectArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    public HolesJSObjectArray toHoles(DynamicObject object, long index, Object value) {
        JSDynamicObject[] array = ZeroBasedJSObjectArray.getArray(object);
        int length = this.lengthInt(object);
        int usedLength = ZeroBasedJSObjectArray.getUsedLength(object);
        HolesJSObjectArray newArray = HolesJSObjectArray.makeHolesJSObjectArray(object, length, array, 0L, 0, usedLength, 0, this.integrityLevel);
        if (JSConfig.TraceArrayTransitions) {
            ZeroBasedJSObjectArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    public ZeroBasedObjectArray toObject(DynamicObject object, long index, Object value) {
        JSDynamicObject[] array = ZeroBasedJSObjectArray.getArray(object);
        int length = this.lengthInt(object);
        int usedLength = ZeroBasedJSObjectArray.getUsedLength(object);
        Object[] doubleCopy = ArrayCopy.jsobjectToObject(array, 0, usedLength);
        ZeroBasedObjectArray newArray = ZeroBasedObjectArray.makeZeroBasedObjectArray(object, length, usedLength, doubleCopy, this.integrityLevel);
        if (JSConfig.TraceArrayTransitions) {
            ZeroBasedJSObjectArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    public long firstElementIndex(DynamicObject object) {
        return 0L;
    }

    @Override
    public long lastElementIndex(DynamicObject object) {
        return ZeroBasedJSObjectArray.getUsedLength(object) - 1;
    }

    @Override
    public ScriptArray removeRangeImpl(DynamicObject object, long start, long end) {
        JSDynamicObject[] array = ZeroBasedJSObjectArray.getArray(object);
        int usedLength = ZeroBasedJSObjectArray.getUsedLength(object);
        long moveLength = (long)usedLength - end;
        if (moveLength > 0L) {
            System.arraycopy(array, (int)end, array, (int)start, (int)moveLength);
        }
        return this;
    }

    @Override
    public ScriptArray shiftRangeImpl(DynamicObject object, long from) {
        int usedLength = ZeroBasedJSObjectArray.getUsedLength(object);
        if (from < (long)usedLength) {
            return ContiguousJSObjectArray.makeContiguousJSObjectArray(object, (long)this.lengthInt(object) - from, ZeroBasedJSObjectArray.getArray(object), -from, (int)from, (int)((long)usedLength - from), this.integrityLevel);
        }
        return this.removeRangeImpl(object, 0L, from);
    }

    @Override
    public ScriptArray addRangeImpl(DynamicObject object, long offset, int size) {
        return this.addRangeImplZeroBased(object, offset, size);
    }

    @Override
    public boolean hasHoles(DynamicObject object) {
        int length = this.lengthInt(object);
        int usedLength = ZeroBasedJSObjectArray.getUsedLength(object);
        return usedLength < length;
    }

    @Override
    protected ZeroBasedJSObjectArray withIntegrityLevel(int newIntegrityLevel) {
        return new ZeroBasedJSObjectArray(newIntegrityLevel, this.cache);
    }

    @Override
    public long nextElementIndex(DynamicObject object, long index) {
        return this.nextElementIndexZeroBased(object, index);
    }
}

