/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.parser.env;

import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.NodeFactory;
import com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import com.oracle.truffle.js.nodes.control.BreakTarget;
import com.oracle.truffle.js.nodes.control.ContinueTarget;
import com.oracle.truffle.js.parser.env.Environment;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.graalvm.collections.EconomicMap;

public class FunctionEnvironment
extends Environment {
    private static final String RETURN_SLOT_IDENTIFIER = "<return>";
    static final String ARGUMENTS_SLOT_IDENTIFIER = "<arguments>";
    static final String THIS_SLOT_IDENTIFIER = "<this>";
    static final String SUPER_SLOT_IDENTIFIER = "<super>";
    static final String NEW_TARGET_SLOT_IDENTIFIER = "<new.target>";
    static final String YIELD_VALUE_SLOT_IDENTIFIER = "<yieldvalue>";
    static final String ASYNC_CONTEXT_SLOT_IDENTIFIER = "<asynccontext>";
    static final String ASYNC_RESULT_SLOT_IDENTIFIER = "<asyncresult>";
    private static final String YIELD_RESULT_SLOT_IDENTIFIER = "<yieldresult>";
    public static final String DYNAMIC_SCOPE_IDENTIFIER = "<evalscope>";
    private final FunctionEnvironment parent;
    private final FrameDescriptor frameDescriptor;
    private EconomicMap<FrameSlot, Integer> parameters;
    private final boolean isStrictMode;
    private FrameSlot returnSlot;
    private FrameSlot blockScopeSlot;
    private String functionName = "";
    private String internalFunctionName = "";
    private boolean isNamedExpression;
    private boolean needsParentFrame;
    private boolean frozen;
    private int breakNodeCount;
    private int continueNodeCount;
    private boolean hasReturn;
    private boolean hasYield;
    private boolean hasAwait;
    private List<BreakTarget> jumpTargetStack;
    private boolean directArgumentsAccess;
    private final boolean isGlobal;
    private final boolean isEval;
    private final boolean isDirectEval;
    private final boolean isArrowFunction;
    private final boolean isGeneratorFunction;
    private final boolean isDerivedConstructor;
    private final boolean isAsyncFunction;
    private final boolean hasSyntheticArguments;
    private boolean hasRestParameter;
    private boolean simpleParameterList = true;
    private boolean isDynamicallyScoped;
    private boolean needsNewTarget;
    private final boolean inDirectEval;

    public FunctionEnvironment(Environment parent, NodeFactory factory, JSContext context, boolean isStrictMode, boolean isEval, boolean isDirectEval, boolean isArrowFunction, boolean isGeneratorFunction, boolean isDerivedConstructor, boolean isAsyncFunction, boolean isGlobal, boolean hasSyntheticArguments) {
        super(parent, factory, context);
        this.isDirectEval = isDirectEval;
        this.isAsyncFunction = isAsyncFunction;
        this.isStrictMode = isStrictMode;
        this.isEval = isEval;
        this.isArrowFunction = isArrowFunction;
        this.isGeneratorFunction = isGeneratorFunction;
        this.isDerivedConstructor = isDerivedConstructor;
        this.isGlobal = isGlobal;
        this.hasSyntheticArguments = hasSyntheticArguments;
        this.parent = parent == null ? null : parent.function();
        this.frameDescriptor = factory.createFrameDescriptor();
        this.inDirectEval = isDirectEval || parent != null && parent.function() != null && parent.function().inDirectEval();
    }

    @Override
    public FunctionEnvironment function() {
        return this;
    }

    @Override
    public FrameSlot declareLocalVar(Object name) {
        assert (!this.isFrozen()) : name;
        return this.getFunctionFrameDescriptor().findOrAddFrameSlot(name, FrameSlotKind.Illegal);
    }

    public FrameSlot getReturnSlot() {
        if (this.returnSlot == null) {
            this.returnSlot = this.declareLocalVar(RETURN_SLOT_IDENTIFIER);
        }
        return this.returnSlot;
    }

    public FrameSlot getAsyncResultSlot() {
        return this.declareLocalVar(ASYNC_RESULT_SLOT_IDENTIFIER);
    }

    public FrameSlot getAsyncContextSlot() {
        return this.declareLocalVar(ASYNC_CONTEXT_SLOT_IDENTIFIER);
    }

    public FrameSlot getYieldResultSlot() {
        return this.declareLocalVar(YIELD_RESULT_SLOT_IDENTIFIER);
    }

    public FrameSlot getOrCreateBlockScopeSlot() {
        if (this.blockScopeSlot == null) {
            this.blockScopeSlot = this.declareLocalVar(ScopeFrameNode.BLOCK_SCOPE_IDENTIFIER);
        }
        return this.blockScopeSlot;
    }

    public FrameSlot getBlockScopeSlot() {
        return this.blockScopeSlot;
    }

    public boolean isEval() {
        return this.isEval;
    }

    public boolean isArrowFunction() {
        return this.isArrowFunction;
    }

    public boolean isGeneratorFunction() {
        return this.isGeneratorFunction;
    }

    @Override
    public FrameDescriptor getBlockFrameDescriptor() {
        return this.getFunctionFrameDescriptor();
    }

    @Override
    protected FrameSlot findBlockFrameSlot(Object name) {
        return this.getFunctionFrameDescriptor().findFrameSlot(name);
    }

    private <T extends BreakTarget> T pushJumpTarget(T target) {
        if (this.jumpTargetStack == null) {
            this.jumpTargetStack = new ArrayList<BreakTarget>(4);
        }
        this.jumpTargetStack.add(target);
        return target;
    }

    private void popJumpTarget(BreakTarget target) {
        assert (this.jumpTargetStack != null && this.jumpTargetStack.get(this.jumpTargetStack.size() - 1) == target);
        this.jumpTargetStack.remove(this.jumpTargetStack.size() - 1);
    }

    public JumpTargetCloseable<ContinueTarget> pushContinueTarget(Object label) {
        ContinueTarget target = ContinueTarget.forLoop(label, -1);
        this.pushJumpTarget(target);
        return new JumpTargetCloseable(this, (BreakTarget)target);
    }

    public JumpTargetCloseable<BreakTarget> pushBreakTarget(Object label) {
        BreakTarget target = label == null ? BreakTarget.forSwitch() : BreakTarget.forLabel(label, -1);
        this.pushJumpTarget(target);
        return new JumpTargetCloseable(this, target);
    }

    public BreakTarget findBreakTarget(Object label) {
        ++this.breakNodeCount;
        return this.findJumpTarget(label, BreakTarget.class, true);
    }

    public ContinueTarget findContinueTarget(Object label) {
        ++this.continueNodeCount;
        return this.findJumpTarget(label, ContinueTarget.class, false);
    }

    private <T extends BreakTarget> T findJumpTarget(Object label, Class<T> targetClass, boolean direct) {
        BreakTarget applicableTarget = null;
        ListIterator<BreakTarget> iterator = this.jumpTargetStack.listIterator(this.jumpTargetStack.size());
        while (iterator.hasPrevious()) {
            BreakTarget target = iterator.previous();
            if (direct || label == null) {
                if (label != null && !label.equals(target.getLabel()) || !targetClass.isInstance(target)) continue;
                return (T)((BreakTarget)targetClass.cast(target));
            }
            assert (!direct);
            if (targetClass.isInstance(target)) {
                applicableTarget = (BreakTarget)targetClass.cast(target);
            }
            if (!label.equals(target.getLabel())) continue;
            assert (applicableTarget != null) : "Illegal or duplicate label";
            return (T)applicableTarget;
        }
        throw new NoSuchElementException("jump target not found");
    }

    public boolean hasReturn() {
        return this.hasReturn;
    }

    public void addReturn() {
        this.hasReturn = true;
    }

    public boolean hasAwait() {
        return this.hasAwait;
    }

    public void addAwait() {
        this.hasAwait = true;
    }

    public boolean hasYield() {
        return this.hasYield;
    }

    public void addYield() {
        this.hasYield = true;
    }

    public void setDirectArgumentsAccess(boolean directArgumentsAccess) {
        this.directArgumentsAccess = directArgumentsAccess;
    }

    public boolean isDirectArgumentsAccess() {
        return this.directArgumentsAccess;
    }

    public void addMappedParameter(FrameSlot slot, int index) {
        assert (slot != null && JSFrameUtil.isParam(slot)) : slot;
        if (this.parameters == null) {
            this.parameters = EconomicMap.create();
        }
        this.parameters.put((Object)slot, (Object)index);
    }

    protected final int getMappedParameterIndex(FrameSlot slot) {
        return (Integer)this.parameters.get((Object)slot, (Object)-1);
    }

    public final String getFunctionName() {
        return this.functionName;
    }

    public final void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public final String getInternalFunctionName() {
        return this.internalFunctionName;
    }

    public final void setInternalFunctionName(String internalFunctionName) {
        this.internalFunctionName = internalFunctionName;
    }

    public final void setNamedFunctionExpression(boolean isNamedExpression) {
        this.isNamedExpression = isNamedExpression;
    }

    protected final boolean isNamedFunctionExpression() {
        return this.isNamedExpression;
    }

    public final boolean needsParentFrame() {
        return this.needsParentFrame;
    }

    public final void setNeedsParentFrame(boolean needsParentFrame) {
        if (this.frozen && needsParentFrame != this.needsParentFrame) {
            throw FunctionEnvironment.errorFrozenEnv();
        }
        this.needsParentFrame = needsParentFrame;
    }

    private static RuntimeException errorFrozenEnv() {
        return new IllegalStateException("frozen function environment cannot be mutated");
    }

    public void freeze() {
        if (this.frozen) {
            return;
        }
        this.frozen = true;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public boolean isDeepFrozen() {
        return this.isFrozen() && (this.getParentFunction() == null || this.getParentFunction().isDeepFrozen());
    }

    public final boolean hasMappedParameters() {
        return this.parameters != null;
    }

    @Override
    public final FrameDescriptor getFunctionFrameDescriptor() {
        return this.frameDescriptor;
    }

    @Override
    public final boolean isStrictMode() {
        return this.isStrictMode;
    }

    public final FunctionEnvironment getParentFunction() {
        return this.parent;
    }

    public final FunctionEnvironment getParentFunction(int level) {
        assert (level >= 0);
        if (level == 0) {
            return this;
        }
        return this.parent.getParentFunction(level - 1);
    }

    public final FunctionEnvironment getNonArrowParentFunction() {
        if (this.isArrowFunction() || this.isDirectEval()) {
            return this.getParentFunction().getNonArrowParentFunction();
        }
        return this;
    }

    @Override
    public FrameSlot[] getParentSlots() {
        return ScopeFrameNode.EMPTY_FRAME_SLOT_ARRAY;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public boolean hasSyntheticArguments() {
        return this.hasSyntheticArguments;
    }

    public boolean returnsLastStatementResult() {
        return this.isGlobal() || this.isDirectEval() || this.hasSyntheticArguments();
    }

    public void setIsDynamicallyScoped(boolean isDynamicallyScoped) {
        this.isDynamicallyScoped = isDynamicallyScoped;
    }

    @Override
    public boolean isDynamicallyScoped() {
        return this.isDynamicallyScoped;
    }

    @Override
    public boolean isDynamicScopeContext() {
        return this.isDynamicallyScoped() || this.isCallerContextEval() || super.isDynamicScopeContext();
    }

    @Override
    public Environment getVariableEnvironment() {
        if (this.isCallerContextEval()) {
            return this.getParentFunction().getVariableEnvironment();
        }
        return this;
    }

    public boolean isDirectEval() {
        return this.isDirectEval;
    }

    public boolean isIndirectEval() {
        return this.isEval() && !this.isDirectEval();
    }

    public boolean isCallerContextEval() {
        return this.isDirectEval() && !this.isStrictMode() && !this.isGlobal();
    }

    public boolean inDirectEval() {
        return this.inDirectEval;
    }

    public void setNeedsNewTarget(boolean needsNewTarget) {
        this.needsNewTarget = needsNewTarget;
    }

    public void setRestParameter(boolean restParameter) {
        this.hasRestParameter = restParameter;
    }

    public boolean hasRestParameter() {
        return this.hasRestParameter;
    }

    public void setSimpleParameterList(boolean simpleParameterList) {
        this.simpleParameterList = simpleParameterList;
    }

    public boolean hasSimpleParameterList() {
        return this.simpleParameterList;
    }

    public int getLeadingArgumentCount() {
        return this.needsNewTarget ? 1 : 0;
    }

    public int getTrailingArgumentCount() {
        return 0;
    }

    public boolean isDerivedConstructor() {
        return this.isDerivedConstructor;
    }

    public int getThisFunctionLevel() {
        int level = 0;
        FunctionEnvironment currentFunction = this;
        while (currentFunction.isArrowFunction() || currentFunction.isDirectEval()) {
            currentFunction.setNeedsParentFrame(true);
            currentFunction = currentFunction.getParentFunction();
            ++level;
        }
        return level;
    }

    public int getOutermostFunctionLevel() {
        int level = 0;
        FunctionEnvironment currentFunction = this;
        while (currentFunction.getParentFunction() != null) {
            currentFunction.setNeedsParentFrame(true);
            currentFunction = currentFunction.getParentFunction();
            ++level;
        }
        return level;
    }

    public boolean isAsyncFunction() {
        return this.isAsyncFunction;
    }

    public boolean isAsyncGeneratorFunction() {
        return this.isAsyncFunction && this.isGeneratorFunction;
    }

    public static class JumpTargetCloseable<T extends BreakTarget>
    implements AutoCloseable {
        private final T target;
        private final int prevBreakCount;
        private final int prevContinueCount;
        final /* synthetic */ FunctionEnvironment this$0;

        protected JumpTargetCloseable(T target) {
            this.this$0 = this$0;
            this.prevBreakCount = this.this$0.breakNodeCount;
            this.prevContinueCount = this.this$0.continueNodeCount;
            this.target = target;
        }

        public T getTarget() {
            return this.target;
        }

        @Override
        public void close() {
            this.this$0.popJumpTarget(this.target);
        }

        private boolean hasBreak() {
            return this.this$0.breakNodeCount != this.prevBreakCount;
        }

        private boolean hasContinue() {
            return this.this$0.continueNodeCount != this.prevContinueCount;
        }

        public JavaScriptNode wrapContinueTargetNode(JavaScriptNode child) {
            boolean hasContinue = this.hasContinue();
            return hasContinue ? this.this$0.factory.createContinueTarget(child, (ContinueTarget)this.target) : child;
        }

        public JavaScriptNode wrapBreakTargetNode(JavaScriptNode child) {
            assert (((BreakTarget)this.target).getLabel() == null);
            boolean hasBreak = this.hasBreak();
            return hasBreak ? this.this$0.factory.createDirectBreakTarget(child) : child;
        }

        public JavaScriptNode wrapLabelBreakTargetNode(JavaScriptNode child) {
            assert (((BreakTarget)this.target).getLabel() != null);
            boolean hasBreak = this.hasBreak();
            return hasBreak ? this.this$0.factory.createLabel(child, (BreakTarget)this.target) : child;
        }
    }
}

