/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.promise;

import com.oracle.js.parser.ir.Module;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.EnumerableOwnPropertyNamesNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.arguments.AccessIndexedArgumentNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.control.TryCatchNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.promise.NewPromiseCapabilityNode;
import com.oracle.truffle.js.nodes.promise.PerformPromiseThenNode;
import com.oracle.truffle.js.nodes.promise.PromiseReactionJobNode;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSPromise;
import com.oracle.truffle.js.runtime.objects.JSModuleRecord;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import com.oracle.truffle.js.runtime.objects.PromiseReactionRecord;
import com.oracle.truffle.js.runtime.objects.ScriptOrModule;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.Pair;
import com.oracle.truffle.js.runtime.util.Triple;
import com.oracle.truffle.js.runtime.util.UnmodifiableArrayList;
import java.util.HashMap;
import java.util.Set;

public class ImportCallNode
extends JavaScriptNode {
    private static final HiddenKey CURRENT_MODULE_RECORD = new HiddenKey("%currentModuleRecord");
    private static final String ASSERTIONS = "assert";
    @Node.Child
    private JavaScriptNode argRefNode;
    @Node.Child
    private JavaScriptNode activeScriptOrModuleNode;
    @Node.Child
    private NewPromiseCapabilityNode newPromiseCapabilityNode;
    @Node.Child
    private JSToStringNode toStringNode;
    @Node.Child
    private PromiseReactionJobNode promiseReactionJobNode;
    @Node.Child
    private JavaScriptNode optionsRefNode;
    @Node.Child
    private JSFunctionCallNode callRejectNode;
    @Node.Child
    private TryCatchNode.GetErrorObjectNode getErrorObjectNode;
    @Node.Child
    private InteropLibrary exceptions;
    @Node.Child
    private EnumerableOwnPropertyNamesNode enumerableOwnPropertyNamesNode;
    @Node.Child
    private PropertyGetNode getAssertionsNode;
    private final JSContext context;

    protected ImportCallNode(JSContext context, JavaScriptNode argRefNode, JavaScriptNode activeScriptOrModuleNode, JavaScriptNode optionsRefNode) {
        this.context = context;
        this.argRefNode = argRefNode;
        this.activeScriptOrModuleNode = activeScriptOrModuleNode;
        this.optionsRefNode = optionsRefNode;
        this.newPromiseCapabilityNode = NewPromiseCapabilityNode.create(context);
        this.toStringNode = JSToStringNode.create();
        this.promiseReactionJobNode = PromiseReactionJobNode.create(context);
    }

    public static ImportCallNode create(JSContext context, JavaScriptNode argRefNode, JavaScriptNode activeScriptOrModuleNode) {
        return new ImportCallNode(context, argRefNode, activeScriptOrModuleNode, null);
    }

    public static ImportCallNode createWithOptions(JSContext context, JavaScriptNode specifierRefNode, JavaScriptNode activeScriptOrModuleNode, JavaScriptNode optionsRefNode) {
        return new ImportCallNode(context, specifierRefNode, activeScriptOrModuleNode, optionsRefNode);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object referencingScriptOrModule = this.getActiveScriptOrModule(frame);
        Object specifier = this.argRefNode.execute(frame);
        if (this.context.getContextOptions().isImportAssertions() && this.optionsRefNode != null) {
            return this.executeAssertions(frame, referencingScriptOrModule, specifier);
        }
        return this.executeWithoutAssertions(referencingScriptOrModule, specifier);
    }

    private Object executeWithoutAssertions(Object referencingScriptOrModule, Object specifier) {
        String specifierString;
        try {
            specifierString = this.toStringNode.executeString(specifier);
        }
        catch (Throwable ex) {
            if (TryCatchNode.shouldCatch(ex, this.exceptions())) {
                return this.newRejectedPromiseFromException(ex);
            }
            throw ex;
        }
        return this.hostImportModuleDynamically(referencingScriptOrModule, Module.ModuleRequest.create(specifierString), this.newPromiseCapability());
    }

    private Object executeAssertions(VirtualFrame frame, Object referencingScriptOrModule, Object specifier) {
        String specifierString;
        assert (this.optionsRefNode != null);
        if (this.enumerableOwnPropertyNamesNode == null || this.getAssertionsNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.enumerableOwnPropertyNamesNode = (EnumerableOwnPropertyNamesNode)this.insert(EnumerableOwnPropertyNamesNode.createKeys(this.context));
            this.getAssertionsNode = (PropertyGetNode)this.insert(PropertyGetNode.create(ASSERTIONS, this.context));
        }
        Object options = this.optionsRefNode.execute(frame);
        PromiseCapabilityRecord promiseCapability = this.newPromiseCapability();
        try {
            specifierString = this.toStringNode.executeString(specifier);
        }
        catch (Throwable ex) {
            if (TryCatchNode.shouldCatch(ex, this.exceptions())) {
                return this.newRejectedPromiseFromException(ex);
            }
            throw ex;
        }
        HashMap<String, String> assertions = Boundaries.hashMapCreate();
        if (options != Undefined.instance) {
            Object assertionsObj;
            if (!JSRuntime.isObject(options)) {
                return this.rejectPromise(promiseCapability, "The second argument to import() must be an object");
            }
            try {
                assertionsObj = this.getAssertionsNode.getValue(options);
            }
            catch (Throwable ex) {
                if (TryCatchNode.shouldCatch(ex, this.exceptions())) {
                    return this.newRejectedPromiseFromException(ex);
                }
                throw ex;
            }
            if (assertionsObj != Undefined.instance) {
                UnmodifiableArrayList<? extends Object> keys;
                if (!JSRuntime.isObject(assertionsObj)) {
                    return this.rejectPromise(promiseCapability, "The 'assert' option must be an object");
                }
                DynamicObject obj = (DynamicObject)assertionsObj;
                try {
                    keys = this.enumerableOwnPropertyNamesNode.execute(obj);
                }
                catch (Throwable ex) {
                    if (TryCatchNode.shouldCatch(ex, this.exceptions())) {
                        return this.newRejectedPromiseFromException(ex);
                    }
                    throw ex;
                }
                for (int i = 0; i < keys.size(); ++i) {
                    Object value;
                    String key;
                    try {
                        key = (String)keys.get(i);
                        value = JSObject.get(obj, key);
                    }
                    catch (Throwable ex) {
                        if (TryCatchNode.shouldCatch(ex, this.exceptions())) {
                            return this.newRejectedPromiseFromException(ex);
                        }
                        throw ex;
                    }
                    if (!JSRuntime.isString(value)) {
                        return this.rejectPromise(promiseCapability, "Import assertion value must be a string");
                    }
                    Boundaries.mapPut(assertions, key, JSRuntime.toStringIsString(value));
                }
            }
        }
        return this.hostImportModuleDynamically(referencingScriptOrModule, Module.ModuleRequest.create(specifierString, assertions), promiseCapability);
    }

    private Object rejectPromise(PromiseCapabilityRecord promiseCapability, String errorMessage) {
        if (this.callRejectNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.callRejectNode = (JSFunctionCallNode)this.insert(JSFunctionCallNode.createCall());
        }
        this.callRejectNode.executeCall(JSArguments.createOneArg((Object)Undefined.instance, promiseCapability.getReject(), (Object)Errors.createTypeError(errorMessage, (Node)this)));
        return promiseCapability.getPromise();
    }

    private Object getActiveScriptOrModule(VirtualFrame frame) {
        if (this.activeScriptOrModuleNode != null) {
            return this.activeScriptOrModuleNode.execute(frame);
        }
        return new ScriptOrModule(this.context, this.getEncapsulatingSourceSection().getSource());
    }

    private DynamicObject hostImportModuleDynamically(Object referencingScriptOrModule, Module.ModuleRequest moduleRequest, PromiseCapabilityRecord promiseCapability) {
        JSRealm realm = this.getRealm();
        if (this.context.hasImportModuleDynamicallyCallbackBeenSet()) {
            DynamicObject promise = this.context.hostImportModuleDynamically(realm, (ScriptOrModule)referencingScriptOrModule, moduleRequest);
            if (promise == null) {
                return this.newRejectedPromiseFromException((Throwable)((Object)ImportCallNode.createTypeErrorCannotImport(moduleRequest.getSpecifier())));
            }
            assert (JSPromise.isJSPromise(promise));
            return promise;
        }
        this.context.promiseEnqueueJob(realm, this.createImportModuleDynamicallyJob((ScriptOrModule)referencingScriptOrModule, moduleRequest, promiseCapability));
        return promiseCapability.getPromise();
    }

    private PromiseCapabilityRecord newPromiseCapability() {
        if (this.newPromiseCapabilityNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.newPromiseCapabilityNode = (NewPromiseCapabilityNode)this.insert(NewPromiseCapabilityNode.create(this.context));
        }
        return this.newPromiseCapabilityNode.executeDefault();
    }

    private DynamicObject newRejectedPromiseFromException(Throwable ex) {
        if (this.callRejectNode == null || this.getErrorObjectNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.callRejectNode = (JSFunctionCallNode)this.insert(JSFunctionCallNode.createCall());
            this.getErrorObjectNode = (TryCatchNode.GetErrorObjectNode)this.insert(TryCatchNode.GetErrorObjectNode.create(this.context));
        }
        PromiseCapabilityRecord promiseCapability = this.newPromiseCapability();
        this.callRejectNode.executeCall(JSArguments.createOneArg((Object)Undefined.instance, promiseCapability.getReject(), this.getErrorObjectNode.execute(ex)));
        return promiseCapability.getPromise();
    }

    private InteropLibrary exceptions() {
        InteropLibrary e = this.exceptions;
        if (e == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.exceptions = e = (InteropLibrary)this.insert((Node)InteropLibrary.getFactory().createDispatched(5));
        }
        return e;
    }

    @CompilerDirectives.TruffleBoundary
    private static JSException createTypeErrorCannotImport(String specifier) {
        return Errors.createError("Cannot dynamically import module: " + specifier);
    }

    public DynamicObject createImportModuleDynamicallyJob(ScriptOrModule referencingScriptOrModule, Module.ModuleRequest moduleRequest, PromiseCapabilityRecord promiseCapability) {
        if (this.context.isOptionTopLevelAwait()) {
            Triple<ScriptOrModule, Module.ModuleRequest, PromiseCapabilityRecord> request = new Triple<ScriptOrModule, Module.ModuleRequest, PromiseCapabilityRecord>(referencingScriptOrModule, moduleRequest, promiseCapability);
            PromiseCapabilityRecord startModuleLoadCapability = this.newPromiseCapability();
            PromiseReactionRecord startModuleLoad = PromiseReactionRecord.create(startModuleLoadCapability, this.createImportModuleDynamicallyHandler(), true);
            return this.promiseReactionJobNode.execute(startModuleLoad, request);
        }
        Pair<ScriptOrModule, Module.ModuleRequest> request = new Pair<ScriptOrModule, Module.ModuleRequest>(referencingScriptOrModule, moduleRequest);
        return this.promiseReactionJobNode.execute(PromiseReactionRecord.create(promiseCapability, this.createImportModuleDynamicallyHandler(), true), request);
    }

    private DynamicObject createImportModuleDynamicallyHandler() {
        JSFunctionData functionData = this.context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.ImportModuleDynamically, c -> ImportCallNode.createImportModuleDynamicallyHandlerImpl(c));
        return JSFunction.create(this.getRealm(), functionData);
    }

    private static JSFunctionData createImportModuleDynamicallyHandlerImpl(JSContext context) {
        class TopLevelAwaitImportModuleDynamicallyRootNode
        extends ImportModuleDynamicallyRootNode {
            @Node.Child
            private PerformPromiseThenNode promiseThenNode;
            @Node.Child
            private JSFunctionCallNode callPromiseReaction;
            @Node.Child
            private TryCatchNode.GetErrorObjectNode getErrorObjectNode;
            @Node.Child
            private InteropLibrary exceptions;
            final /* synthetic */ JSContext val$context;

            TopLevelAwaitImportModuleDynamicallyRootNode(JSContext jSContext) {
                this.val$context = jSContext;
                class ImportModuleDynamicallyRootNode
                extends JavaScriptRootNode {
                    @Node.Child
                    protected JavaScriptNode argumentNode = AccessIndexedArgumentNode.create(0);
                    final /* synthetic */ JSContext val$context;

                    ImportModuleDynamicallyRootNode(JSContext jSContext) {
                        this.val$context = jSContext;
                    }

                    public Object execute(VirtualFrame frame) {
                        Pair request = (Pair)this.argumentNode.execute(frame);
                        ScriptOrModule referencingScriptOrModule = (ScriptOrModule)request.getFirst();
                        Module.ModuleRequest moduleRequest = (Module.ModuleRequest)request.getSecond();
                        JSModuleRecord moduleRecord = this.val$context.getEvaluator().hostResolveImportedModule(this.val$context, referencingScriptOrModule, moduleRequest);
                        return this.finishDynamicImport(this.getRealm(), moduleRecord, referencingScriptOrModule, moduleRequest);
                    }

                    protected Object finishDynamicImport(JSRealm realm, JSModuleRecord moduleRecord, ScriptOrModule referencingScriptOrModule, Module.ModuleRequest moduleRequest) {
                        this.val$context.getEvaluator().moduleInstantiation(realm, moduleRecord);
                        this.val$context.getEvaluator().moduleEvaluation(realm, moduleRecord);
                        if (moduleRecord.getEvaluationError() != null) {
                            throw JSRuntime.rethrow(moduleRecord.getEvaluationError());
                        }
                        assert (moduleRecord == this.val$context.getEvaluator().hostResolveImportedModule(this.val$context, referencingScriptOrModule, moduleRequest));
                        assert (moduleRecord.isEvaluated());
                        return this.val$context.getEvaluator().getModuleNamespace(moduleRecord);
                    }
                }
                super(jSContext);
                this.promiseThenNode = PerformPromiseThenNode.create(this.val$context);
                this.callPromiseReaction = JSFunctionCallNode.createCall();
            }

            @Override
            public Object execute(VirtualFrame frame) {
                Triple request = (Triple)this.argumentNode.execute(frame);
                ScriptOrModule referencingScriptOrModule = (ScriptOrModule)request.getFirst();
                Module.ModuleRequest moduleRequest = (Module.ModuleRequest)request.getSecond();
                PromiseCapabilityRecord moduleLoadedCapability = (PromiseCapabilityRecord)request.getThird();
                try {
                    JSModuleRecord moduleRecord = this.val$context.getEvaluator().hostResolveImportedModule(this.val$context, referencingScriptOrModule, moduleRequest);
                    JSRealm realm = this.getRealm();
                    if (moduleRecord.isTopLevelAsync()) {
                        this.val$context.getEvaluator().moduleInstantiation(realm, moduleRecord);
                        Object innerPromise = this.val$context.getEvaluator().moduleEvaluation(realm, moduleRecord);
                        assert (JSPromise.isJSPromise(innerPromise));
                        DynamicObject resolve = this.createFinishDynamicImportCapabilityCallback(this.val$context, realm, moduleRecord, false);
                        DynamicObject reject = this.createFinishDynamicImportCapabilityCallback(this.val$context, realm, moduleRecord, true);
                        this.promiseThenNode.execute((DynamicObject)innerPromise, resolve, reject, moduleLoadedCapability);
                    } else {
                        Object result = this.finishDynamicImport(realm, moduleRecord, referencingScriptOrModule, moduleRequest);
                        if (moduleRecord.isAsyncEvaluating()) {
                            PromiseCapabilityRecord topLevelCapability = moduleRecord.getTopLevelCapability();
                            this.promiseThenNode.execute(topLevelCapability.getPromise(), moduleLoadedCapability.getResolve(), moduleLoadedCapability.getReject(), null);
                        } else {
                            this.callPromiseReaction.executeCall(JSArguments.create((Object)Undefined.instance, moduleLoadedCapability.getResolve(), result));
                        }
                    }
                }
                catch (Throwable t) {
                    if (this.shouldCatch(t)) {
                        Object errorObject = this.getErrorObjectNode.execute(t);
                        this.callPromiseReaction.executeCall(JSArguments.create((Object)Undefined.instance, moduleLoadedCapability.getReject(), errorObject));
                    }
                    throw t;
                }
                return Undefined.instance;
            }

            private boolean shouldCatch(Throwable exception) {
                if (this.getErrorObjectNode == null || this.exceptions == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.getErrorObjectNode = (TryCatchNode.GetErrorObjectNode)this.insert(TryCatchNode.GetErrorObjectNode.create(this.val$context));
                    this.exceptions = (InteropLibrary)this.insert((Node)InteropLibrary.getFactory().createDispatched(5));
                }
                return TryCatchNode.shouldCatch(exception, this.exceptions);
            }

            private DynamicObject createFinishDynamicImportCapabilityCallback(JSContext cx, JSRealm realm, JSModuleRecord moduleRecord, boolean onReject) {
                JSContext.BuiltinFunctionKey cacheKey = onReject ? JSContext.BuiltinFunctionKey.FinishImportModuleDynamicallyReject : JSContext.BuiltinFunctionKey.FinishImportModuleDynamicallyResolve;
                JSFunctionData functionData = cx.getOrCreateBuiltinFunctionData(cacheKey, c -> this.createFinishDynamicImportNormalImpl((JSContext)c, onReject));
                DynamicObject resolveFunction = JSFunction.create(realm, functionData);
                JSObjectUtil.putHiddenProperty(resolveFunction, CURRENT_MODULE_RECORD, moduleRecord);
                return resolveFunction;
            }

            private JSFunctionData createFinishDynamicImportNormalImpl(final JSContext cx, final boolean onReject) {
                class FinishDynamicImportNormalRootNode
                extends JavaScriptRootNode {
                    FinishDynamicImportNormalRootNode() {
                    }

                    public Object execute(VirtualFrame frame) {
                        DynamicObject thisFunction = (DynamicObject)JSArguments.getFunctionObject(frame.getArguments());
                        JSModuleRecord moduleRecord = (JSModuleRecord)JSObjectUtil.getHiddenProperty(thisFunction, CURRENT_MODULE_RECORD);
                        assert (moduleRecord != null);
                        if (onReject) {
                            assert (moduleRecord.getEvaluationError() != null);
                            throw JSRuntime.rethrow(moduleRecord.getEvaluationError());
                        }
                        return cx.getEvaluator().getModuleNamespace(moduleRecord);
                    }
                }
                RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)new FinishDynamicImportNormalRootNode());
                return JSFunctionData.createCallOnly(cx, (CallTarget)callTarget, 0, "");
            }
        }
        ImportModuleDynamicallyRootNode root = context.isOptionTopLevelAwait() ? new TopLevelAwaitImportModuleDynamicallyRootNode(context) : new ImportModuleDynamicallyRootNode(context);
        RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)root);
        return JSFunctionData.createCallOnly(context, (CallTarget)callTarget, 0, "");
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        if (this.optionsRefNode == null) {
            return ImportCallNode.create(this.context, ImportCallNode.cloneUninitialized(this.argRefNode, materializedTags), ImportCallNode.cloneUninitialized(this.activeScriptOrModuleNode, materializedTags));
        }
        return ImportCallNode.createWithOptions(this.context, ImportCallNode.cloneUninitialized(this.argRefNode, materializedTags), ImportCallNode.cloneUninitialized(this.activeScriptOrModuleNode, materializedTags), ImportCallNode.cloneUninitialized(this.optionsRefNode, materializedTags));
    }
}

