/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.control;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.arguments.AccessIndexedArgumentNode;
import com.oracle.truffle.js.nodes.control.AsyncGeneratorRejectNode;
import com.oracle.truffle.js.nodes.control.AsyncGeneratorResolveNode;
import com.oracle.truffle.js.nodes.function.InternalCallNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.promise.NewPromiseCapabilityNode;
import com.oracle.truffle.js.nodes.promise.PerformPromiseThenNode;
import com.oracle.truffle.js.nodes.promise.PromiseResolveNode;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSPromise;
import com.oracle.truffle.js.runtime.objects.AsyncGeneratorRequest;
import com.oracle.truffle.js.runtime.objects.Completion;
import com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.ArrayDeque;

public class AsyncGeneratorResumeNextNode
extends JavaScriptBaseNode {
    @Node.Child
    private PropertyGetNode getGeneratorStateNode;
    @Node.Child
    private PropertySetNode setGeneratorStateNode;
    @Node.Child
    private PropertyGetNode getAsyncGeneratorQueueNode;
    @Node.Child
    private JSFunctionCallNode callPromiseResolveNode;
    @Node.Child
    private PerformPromiseThenNode performPromiseThenNode;
    @Node.Child
    private NewPromiseCapabilityNode newPromiseCapabilityNode;
    @Node.Child
    private AsyncGeneratorResolveNode asyncGeneratorResolveNode;
    @Node.Child
    private AsyncGeneratorRejectNode asyncGeneratorRejectNode;
    @Node.Child
    private PropertySetNode setGeneratorNode;
    @Node.Child
    private PropertySetNode setPromiseIsHandledNode;
    @Node.Child
    private PromiseResolveNode promiseResolveNode;
    private final ConditionProfile abruptProf = ConditionProfile.createBinaryProfile();
    protected final JSContext context;
    static final HiddenKey RETURN_PROCESSOR_GENERATOR = new HiddenKey("Generator");

    protected AsyncGeneratorResumeNextNode(JSContext context) {
        this.context = context;
        this.getGeneratorStateNode = PropertyGetNode.createGetHidden(JSFunction.ASYNC_GENERATOR_STATE_ID, context);
        this.setGeneratorStateNode = PropertySetNode.createSetHidden(JSFunction.ASYNC_GENERATOR_STATE_ID, context);
        this.getAsyncGeneratorQueueNode = PropertyGetNode.createGetHidden(JSFunction.ASYNC_GENERATOR_QUEUE_ID, context);
        this.asyncGeneratorResolveNode = AsyncGeneratorResolveNode.create(context);
    }

    public static AsyncGeneratorResumeNextNode create(JSContext context) {
        return new WithCall(context);
    }

    public static AsyncGeneratorResumeNextNode createTailCall(JSContext context) {
        return new AsyncGeneratorResumeNextNode(context);
    }

    public final Object execute(VirtualFrame frame, DynamicObject generator) {
        AsyncGeneratorRequest next;
        JSFunction.AsyncGeneratorState state;
        while (true) {
            state = (JSFunction.AsyncGeneratorState)((Object)this.getGeneratorStateNode.getValue(generator));
            assert (state != JSFunction.AsyncGeneratorState.Executing);
            if (state == JSFunction.AsyncGeneratorState.AwaitingReturn) {
                return Undefined.instance;
            }
            ArrayDeque queue = (ArrayDeque)this.getAsyncGeneratorQueueNode.getValue(generator);
            if (queue.isEmpty()) {
                return Undefined.instance;
            }
            next = (AsyncGeneratorRequest)queue.peekFirst();
            if (this.abruptProf.profile(next.isAbruptCompletion())) {
                if (state == JSFunction.AsyncGeneratorState.SuspendedStart) {
                    state = JSFunction.AsyncGeneratorState.Completed;
                    this.setGeneratorStateNode.setValue(generator, (Object)state);
                }
                if (state != JSFunction.AsyncGeneratorState.Completed) break;
                if (next.isReturn()) {
                    this.enterReturnBranch();
                    this.setGeneratorStateNode.setValue(generator, (Object)JSFunction.AsyncGeneratorState.AwaitingReturn);
                    DynamicObject promise = this.promiseResolve(next.getCompletionValue());
                    DynamicObject onFulfilled = this.createAsyncGeneratorReturnProcessorFulfilledFunction(generator);
                    DynamicObject onRejected = this.createAsyncGeneratorReturnProcessorRejectedFunction(generator);
                    PromiseCapabilityRecord throwawayCapability = this.newThrowawayCapability();
                    this.performPromiseThenNode.execute(promise, onFulfilled, onRejected, throwawayCapability);
                    return Undefined.instance;
                }
                assert (next.isThrow());
                this.enterThrowBranch();
                this.asyncGeneratorRejectNode.performReject(frame, generator, next.getCompletionValue());
                continue;
            }
            if (state != JSFunction.AsyncGeneratorState.Completed) break;
            this.asyncGeneratorResolveNode.performResolve(frame, generator, (Object)Undefined.instance, true);
        }
        assert (state == JSFunction.AsyncGeneratorState.SuspendedStart || state == JSFunction.AsyncGeneratorState.SuspendedYield);
        this.setGeneratorStateNode.setValue(generator, (Object)JSFunction.AsyncGeneratorState.Executing);
        return this.performResumeNext(generator, next.getCompletion());
    }

    private DynamicObject promiseResolve(Object value) {
        if (this.context.usePromiseResolve()) {
            if (this.promiseResolveNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.promiseResolveNode = (PromiseResolveNode)this.insert(PromiseResolveNode.create(this.context));
            }
            return this.promiseResolveNode.execute(this.getRealm().getPromiseConstructor(), value);
        }
        if (this.callPromiseResolveNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.callPromiseResolveNode = (JSFunctionCallNode)this.insert(JSFunctionCallNode.createCall());
        }
        PromiseCapabilityRecord promiseCapability = this.newPromiseCapability();
        this.callPromiseResolveNode.executeCall(JSArguments.createOneArg((Object)Undefined.instance, promiseCapability.getResolve(), value));
        return promiseCapability.getPromise();
    }

    protected Object performResumeNext(DynamicObject generator, Completion completion) {
        return completion;
    }

    private void enterReturnBranch() {
        if (this.performPromiseThenNode == null || this.setGeneratorNode == null || this.setPromiseIsHandledNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.performPromiseThenNode = (PerformPromiseThenNode)this.insert(PerformPromiseThenNode.create(this.context));
            this.setGeneratorNode = (PropertySetNode)this.insert(PropertySetNode.createSetHidden(RETURN_PROCESSOR_GENERATOR, this.context));
            this.setPromiseIsHandledNode = (PropertySetNode)this.insert(PropertySetNode.createSetHidden(JSPromise.PROMISE_IS_HANDLED, this.context));
        }
    }

    private PromiseCapabilityRecord newPromiseCapability() {
        if (this.newPromiseCapabilityNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.newPromiseCapabilityNode = (NewPromiseCapabilityNode)this.insert(NewPromiseCapabilityNode.create(this.context));
        }
        return this.newPromiseCapabilityNode.executeDefault();
    }

    private PromiseCapabilityRecord newThrowawayCapability() {
        if (this.context.getEcmaScriptVersion() >= 10) {
            return null;
        }
        if (this.setPromiseIsHandledNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.setPromiseIsHandledNode = (PropertySetNode)this.insert(PropertySetNode.createSetHidden(JSPromise.PROMISE_IS_HANDLED, this.context));
        }
        PromiseCapabilityRecord throwawayCapability = this.newPromiseCapability();
        this.setPromiseIsHandledNode.setValueBoolean(throwawayCapability.getPromise(), true);
        return throwawayCapability;
    }

    private void enterThrowBranch() {
        if (this.asyncGeneratorRejectNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.asyncGeneratorRejectNode = (AsyncGeneratorRejectNode)this.insert(AsyncGeneratorRejectNode.create(this.context));
        }
    }

    private DynamicObject createAsyncGeneratorReturnProcessorFulfilledFunction(DynamicObject generator) {
        JSFunctionData functionData = this.context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.AsyncGeneratorReturnFulfilled, c -> AsyncGeneratorResumeNextNode.createAsyncGeneratorReturnProcessorFulfilledImpl(c));
        DynamicObject function = JSFunction.create(this.getRealm(), functionData);
        this.setGeneratorNode.setValue(function, generator);
        return function;
    }

    private static JSFunctionData createAsyncGeneratorReturnProcessorFulfilledImpl(JSContext context) {
        class AsyncGeneratorReturnFulfilledRootNode
        extends JavaScriptRootNode {
            @Node.Child
            private JavaScriptNode valueNode = AccessIndexedArgumentNode.create(0);
            @Node.Child
            private AsyncGeneratorResolveNode asyncGeneratorResolveNode = AsyncGeneratorResolveNode.create(this.val$context);
            @Node.Child
            private PropertyGetNode getGenerator = PropertyGetNode.createGetHidden(RETURN_PROCESSOR_GENERATOR, this.val$context);
            @Node.Child
            private PropertySetNode setGeneratorState = PropertySetNode.createSetHidden(JSFunction.ASYNC_GENERATOR_STATE_ID, this.val$context);
            final /* synthetic */ JSContext val$context;

            AsyncGeneratorReturnFulfilledRootNode(JSContext jSContext) {
                this.val$context = jSContext;
            }

            public Object execute(VirtualFrame frame) {
                DynamicObject functionObject = JSFrameUtil.getFunctionObject((Frame)frame);
                DynamicObject generatorObject = (DynamicObject)this.getGenerator.getValue(functionObject);
                this.setGeneratorState.setValue(generatorObject, (Object)JSFunction.AsyncGeneratorState.Completed);
                Object value = this.valueNode.execute(frame);
                return this.asyncGeneratorResolveNode.execute(frame, generatorObject, value, true);
            }
        }
        RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)new AsyncGeneratorReturnFulfilledRootNode(context));
        return JSFunctionData.createCallOnly(context, (CallTarget)callTarget, 1, "");
    }

    private DynamicObject createAsyncGeneratorReturnProcessorRejectedFunction(DynamicObject generator) {
        JSFunctionData functionData = this.context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.AsyncGeneratorReturnRejected, c -> AsyncGeneratorResumeNextNode.createAsyncGeneratorReturnProcessorRejectedImpl(c));
        DynamicObject function = JSFunction.create(this.getRealm(), functionData);
        this.setGeneratorNode.setValue(function, generator);
        return function;
    }

    private static JSFunctionData createAsyncGeneratorReturnProcessorRejectedImpl(JSContext context) {
        class AsyncGeneratorReturnRejectedRootNode
        extends JavaScriptRootNode {
            @Node.Child
            private JavaScriptNode reasonNode = AccessIndexedArgumentNode.create(0);
            @Node.Child
            private AsyncGeneratorRejectNode asyncGeneratorRejectNode = AsyncGeneratorRejectNode.create(this.val$context);
            @Node.Child
            private PropertyGetNode getGenerator = PropertyGetNode.createGetHidden(RETURN_PROCESSOR_GENERATOR, this.val$context);
            @Node.Child
            private PropertySetNode setGeneratorState = PropertySetNode.createSetHidden(JSFunction.ASYNC_GENERATOR_STATE_ID, this.val$context);
            final /* synthetic */ JSContext val$context;

            AsyncGeneratorReturnRejectedRootNode(JSContext jSContext) {
                this.val$context = jSContext;
            }

            public Object execute(VirtualFrame frame) {
                DynamicObject functionObject = JSFrameUtil.getFunctionObject((Frame)frame);
                DynamicObject generatorObject = (DynamicObject)this.getGenerator.getValue(functionObject);
                this.setGeneratorState.setValue(generatorObject, (Object)JSFunction.AsyncGeneratorState.Completed);
                Object reason = this.reasonNode.execute(frame);
                return this.asyncGeneratorRejectNode.execute(frame, generatorObject, reason);
            }
        }
        RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)new AsyncGeneratorReturnRejectedRootNode(context));
        return JSFunctionData.createCallOnly(context, (CallTarget)callTarget, 1, "");
    }

    private static class WithCall
    extends AsyncGeneratorResumeNextNode {
        @Node.Child
        private PropertyGetNode getGeneratorTarget;
        @Node.Child
        private PropertyGetNode getGeneratorContext;
        @Node.Child
        private InternalCallNode callNode;

        protected WithCall(JSContext context) {
            super(context);
            this.getGeneratorTarget = PropertyGetNode.createGetHidden(JSFunction.ASYNC_GENERATOR_TARGET_ID, context);
            this.getGeneratorContext = PropertyGetNode.createGetHidden(JSFunction.ASYNC_GENERATOR_CONTEXT_ID, context);
            this.callNode = InternalCallNode.create();
        }

        @Override
        protected Object performResumeNext(DynamicObject generator, Completion completion) {
            CallTarget generatorTarget = (CallTarget)this.getGeneratorTarget.getValue(generator);
            Object generatorContext = this.getGeneratorContext.getValue(generator);
            this.callNode.execute(generatorTarget, JSArguments.createResumeArguments(generatorContext, generator, completion));
            return Undefined.instance;
        }
    }
}

