/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSNodeUtil;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.CopyDataPropertiesNode;
import com.oracle.truffle.js.nodes.access.CreateObjectNode;
import com.oracle.truffle.js.nodes.access.JSWriteFrameSlotNode;
import com.oracle.truffle.js.nodes.access.ObjectLiteralNodeFactory;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import com.oracle.truffle.js.nodes.cast.JSToPropertyKeyNode;
import com.oracle.truffle.js.nodes.function.ClassDefinitionNode;
import com.oracle.truffle.js.nodes.function.FunctionNameHolder;
import com.oracle.truffle.js.nodes.function.SetFunctionNameNode;
import com.oracle.truffle.js.nodes.instrumentation.JSTags;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.objects.Accessor;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSProperty;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.Arrays;
import java.util.Set;

public class ObjectLiteralNode
extends JavaScriptNode {
    @Node.Children
    private final ObjectLiteralMemberNode[] members;
    @Node.Child
    private CreateObjectNode objectCreateNode;

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.LiteralTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }

    public Object getNodeObject() {
        return JSTags.createNodeObjectDescriptor("literalType", JSTags.LiteralTag.Type.ObjectLiteral.name());
    }

    public static ObjectLiteralMemberNode newDataMember(String name, boolean isStatic, boolean enumerable, JavaScriptNode valueNode, boolean isField) {
        return new ObjectLiteralDataMemberNode(name, isStatic, enumerable ? JSAttributes.getDefault() : JSAttributes.getDefaultNotEnumerable(), valueNode, isField);
    }

    public static ObjectLiteralMemberNode newAccessorMember(String name, boolean isStatic, boolean enumerable, JavaScriptNode getterNode, JavaScriptNode setterNode) {
        return new ObjectLiteralAccessorMemberNode(name, isStatic, JSAttributes.fromConfigurableEnumerable(true, enumerable), getterNode, setterNode);
    }

    public static ObjectLiteralMemberNode newComputedDataMember(JavaScriptNode name, boolean isStatic, boolean enumerable, JavaScriptNode valueNode, boolean isField, boolean isAnonymousFunctionDefinition) {
        return ObjectLiteralNodeFactory.ComputedObjectLiteralDataMemberNodeGen.create(name, isStatic, enumerable ? JSAttributes.getDefault() : JSAttributes.getDefaultNotEnumerable(), valueNode, isField, isAnonymousFunctionDefinition);
    }

    public static ObjectLiteralMemberNode newComputedAccessorMember(JavaScriptNode name, boolean isStatic, boolean enumerable, JavaScriptNode getter, JavaScriptNode setter) {
        return new ComputedObjectLiteralAccessorMemberNode(name, isStatic, JSAttributes.fromConfigurableEnumerable(true, enumerable), getter, setter);
    }

    public static ObjectLiteralMemberNode newDataMember(Object name, boolean isStatic, int attributes, JavaScriptNode valueNode) {
        return new ObjectLiteralDataMemberNode(name, isStatic, attributes, valueNode, false);
    }

    public static ObjectLiteralMemberNode newAccessorMember(Object name, boolean isStatic, int attributes, JavaScriptNode getterNode, JavaScriptNode setterNode) {
        return new ObjectLiteralAccessorMemberNode(name, isStatic, attributes, getterNode, setterNode);
    }

    public static ObjectLiteralMemberNode newComputedDataMember(JavaScriptNode name, boolean isStatic, int attributes, JavaScriptNode valueNode) {
        return ObjectLiteralNodeFactory.ComputedObjectLiteralDataMemberNodeGen.create(name, isStatic, attributes, valueNode, false, false);
    }

    public static ObjectLiteralMemberNode newPrivateFieldMember(JavaScriptNode name, boolean isStatic, JavaScriptNode valueNode, JSWriteFrameSlotNode writePrivateNode) {
        return new PrivateFieldMemberNode(name, isStatic, valueNode, writePrivateNode);
    }

    public static ObjectLiteralMemberNode newPrivateMethodMember(boolean isStatic, JavaScriptNode valueNode, JSWriteFrameSlotNode writePrivateNode) {
        return new PrivateMethodMemberNode(isStatic, valueNode, writePrivateNode);
    }

    public static ObjectLiteralMemberNode newPrivateAccessorMember(boolean isStatic, JavaScriptNode getterNode, JavaScriptNode setterNode, JSWriteFrameSlotNode writePrivateNode) {
        return new PrivateAccessorMemberNode(isStatic, getterNode, setterNode, writePrivateNode);
    }

    public static ObjectLiteralMemberNode newProtoMember(String name, boolean isStatic, JavaScriptNode valueNode) {
        assert ("__proto__".equals(name));
        return new ObjectLiteralProtoMemberNode(isStatic, valueNode);
    }

    public static ObjectLiteralMemberNode newSpreadObjectMember(boolean isStatic, JavaScriptNode valueNode) {
        return new ObjectLiteralSpreadMemberNode(isStatic, JSAttributes.getDefault(), valueNode);
    }

    public static ObjectLiteralMemberNode newStaticBlockMember(JavaScriptNode valueNode) {
        return new ObjectLiteralDataMemberNode(null, true, JSAttributes.getDefaultNotEnumerable(), valueNode, true);
    }

    public ObjectLiteralNode(ObjectLiteralMemberNode[] members, CreateObjectNode objectCreateNode) {
        this.members = members;
        this.objectCreateNode = objectCreateNode;
    }

    public static ObjectLiteralNode create(JSContext context, ObjectLiteralMemberNode[] members) {
        if (members.length > 0 && members[0] instanceof ObjectLiteralProtoMemberNode) {
            return new ObjectLiteralNode(Arrays.copyOfRange(members, 1, members.length), CreateObjectNode.createOrdinaryWithPrototype(context, ((ObjectLiteralProtoMemberNode)members[0]).valueNode));
        }
        if (members.length > 256 && ObjectLiteralNode.onlyDataMembers(members)) {
            return ObjectLiteralNode.createDictionaryObject(context, members);
        }
        return new ObjectLiteralNode(members, CreateObjectNode.create(context));
    }

    private static boolean onlyDataMembers(ObjectLiteralMemberNode[] members) {
        for (ObjectLiteralMemberNode member : members) {
            if (member instanceof ObjectLiteralDataMemberNode) continue;
            return false;
        }
        return true;
    }

    private static ObjectLiteralNode createDictionaryObject(JSContext context, ObjectLiteralMemberNode[] members) {
        ObjectLiteralMemberNode[] newMembers = new ObjectLiteralMemberNode[members.length];
        for (int i = 0; i < members.length; ++i) {
            ObjectLiteralDataMemberNode member = (ObjectLiteralDataMemberNode)members[i];
            newMembers[i] = new DictionaryObjectDataMemberNode(member.name, member.isStatic, member.attributes, member.valueNode);
        }
        return new ObjectLiteralNode(newMembers, CreateObjectNode.createDictionary(context));
    }

    public DynamicObject execute(VirtualFrame frame) {
        DynamicObject ret = this.objectCreateNode.execute(frame);
        return this.executeWithObject(frame, ret);
    }

    @ExplodeLoop
    public DynamicObject executeWithObject(VirtualFrame frame, DynamicObject ret) {
        JSContext context = this.objectCreateNode.getContext();
        for (int i = 0; i < this.members.length; ++i) {
            this.members[i].executeVoid(frame, ret, context);
        }
        return ret;
    }

    @Override
    public boolean isResultAlwaysOfType(Class<?> clazz) {
        return clazz == DynamicObject.class;
    }

    static CharSequence reasonResolved(Object key) {
        CompilerAsserts.neverPartOfCompilation();
        if (TruffleOptions.TraceRewrites) {
            return String.format("resolved property %s", key);
        }
        return "resolved property";
    }

    static CharSequence reasonNewShapeAssumptionInvalidated(Object key) {
        CompilerAsserts.neverPartOfCompilation();
        if (TruffleOptions.TraceRewrites) {
            return String.format("new shape assumption invalidated (property %s)", key);
        }
        return "new shape assumption invalidated";
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return new ObjectLiteralNode(ObjectLiteralMemberNode.cloneUninitialized(this.members, materializedTags), this.objectCreateNode.copyUninitialized(materializedTags));
    }

    private static class PrivateAccessorMemberNode
    extends ObjectLiteralMemberNode {
        @Node.Child
        private JavaScriptNode getterNode;
        @Node.Child
        private JavaScriptNode setterNode;
        @Node.Child
        private JSWriteFrameSlotNode writePrivateNode;

        PrivateAccessorMemberNode(boolean isStatic, JavaScriptNode getterNode, JavaScriptNode setterNode, JSWriteFrameSlotNode writePrivateNode) {
            super(isStatic, JSAttributes.getDefaultNotEnumerable(), false, false);
            this.getterNode = getterNode;
            this.setterNode = setterNode;
            this.writePrivateNode = writePrivateNode;
        }

        @Override
        public final void executeVoid(VirtualFrame frame, DynamicObject receiver, DynamicObject homeObject, JSContext context) {
            Object getter = null;
            Object setter = null;
            if (this.getterNode != null) {
                getter = PrivateAccessorMemberNode.evaluateWithHomeObject(this.getterNode, frame, homeObject);
            }
            if (this.setterNode != null) {
                setter = PrivateAccessorMemberNode.evaluateWithHomeObject(this.setterNode, frame, homeObject);
            }
            assert (getter != null || setter != null);
            Accessor accessor = new Accessor((DynamicObject)getter, (DynamicObject)setter);
            this.writePrivateNode.executeWrite(frame, accessor);
        }

        @Override
        protected ObjectLiteralMemberNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new PrivateAccessorMemberNode(this.isStatic, JavaScriptNode.cloneUninitialized(this.getterNode, materializedTags), JavaScriptNode.cloneUninitialized(this.setterNode, materializedTags), JavaScriptNode.cloneUninitialized(this.writePrivateNode, materializedTags));
        }
    }

    private static class PrivateMethodMemberNode
    extends ObjectLiteralMemberNode {
        @Node.Child
        private JavaScriptNode valueNode;
        @Node.Child
        private JSWriteFrameSlotNode writePrivateNode;

        PrivateMethodMemberNode(boolean isStatic, JavaScriptNode valueNode, JSWriteFrameSlotNode writePrivateNode) {
            super(isStatic, JSAttributes.getDefaultNotEnumerable(), false, false);
            this.valueNode = valueNode;
            this.writePrivateNode = writePrivateNode;
        }

        @Override
        public final void executeVoid(VirtualFrame frame, DynamicObject receiver, DynamicObject homeObject, JSContext context) {
            Object value = PrivateMethodMemberNode.evaluateWithHomeObject(this.valueNode, frame, homeObject);
            this.writePrivateNode.executeWrite(frame, value);
        }

        @Override
        protected ObjectLiteralMemberNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new PrivateMethodMemberNode(this.isStatic, JavaScriptNode.cloneUninitialized(this.valueNode, materializedTags), JavaScriptNode.cloneUninitialized(this.writePrivateNode, materializedTags));
        }
    }

    private static class PrivateFieldMemberNode
    extends ObjectLiteralMemberNode {
        @Node.Child
        private JavaScriptNode keyNode;
        @Node.Child
        private JavaScriptNode valueNode;
        @Node.Child
        private JSWriteFrameSlotNode writePrivateNode;

        PrivateFieldMemberNode(JavaScriptNode key, boolean isStatic, JavaScriptNode valueNode, JSWriteFrameSlotNode writePrivateNode) {
            super(isStatic, JSAttributes.getDefaultNotEnumerable(), true, false);
            this.keyNode = key;
            this.valueNode = valueNode;
            this.writePrivateNode = writePrivateNode;
        }

        @Override
        public final void executeVoid(VirtualFrame frame, DynamicObject receiver, DynamicObject homeObject, JSContext context) {
            this.writePrivateNode.execute(frame);
        }

        @Override
        public Object evaluateKey(VirtualFrame frame) {
            return this.keyNode.execute(frame);
        }

        @Override
        public Object evaluateValue(VirtualFrame frame, DynamicObject homeObject) {
            return PrivateFieldMemberNode.evaluateWithHomeObject(this.valueNode, frame, homeObject);
        }

        @Override
        protected ObjectLiteralMemberNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new PrivateFieldMemberNode(JavaScriptNode.cloneUninitialized(this.keyNode, materializedTags), this.isStatic, JavaScriptNode.cloneUninitialized(this.valueNode, materializedTags), JavaScriptNode.cloneUninitialized(this.writePrivateNode, materializedTags));
        }
    }

    private static class DictionaryObjectDataMemberNode
    extends ObjectLiteralMemberNode {
        private final Object name;
        @Node.Child
        private JavaScriptNode valueNode;

        DictionaryObjectDataMemberNode(Object name, boolean isStatic, int attributes, JavaScriptNode valueNode) {
            super(isStatic, attributes);
            assert (JSRuntime.isPropertyKey(name));
            this.name = name;
            this.valueNode = valueNode;
        }

        @Override
        public final void executeVoid(VirtualFrame frame, DynamicObject receiver, DynamicObject homeObject, JSContext context) {
            Object value = DictionaryObjectDataMemberNode.evaluateWithHomeObject(this.valueNode, frame, homeObject);
            PropertyDescriptor propDesc = PropertyDescriptor.createData(value, this.attributes);
            JSObject.defineOwnProperty(receiver, this.name, propDesc, true);
        }

        @Override
        protected ObjectLiteralMemberNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new DictionaryObjectDataMemberNode(this.name, this.isStatic, this.attributes, JavaScriptNode.cloneUninitialized(this.valueNode, materializedTags));
        }
    }

    private static class ObjectLiteralSpreadMemberNode
    extends ObjectLiteralMemberNode {
        @Node.Child
        private JavaScriptNode valueNode;
        @Node.Child
        private JSToObjectNode toObjectNode;
        @Node.Child
        private CopyDataPropertiesNode copyDataPropertiesNode;

        ObjectLiteralSpreadMemberNode(boolean isStatic, int attributes, JavaScriptNode valueNode) {
            super(isStatic, attributes);
            this.valueNode = valueNode;
        }

        @Override
        public final void executeVoid(VirtualFrame frame, DynamicObject receiver, DynamicObject target, JSContext context) {
            Object sourceValue = this.valueNode.execute(frame);
            if (JSGuards.isNullOrUndefined(sourceValue)) {
                return;
            }
            if (this.toObjectNode == null || this.copyDataPropertiesNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toObjectNode = (JSToObjectNode)this.insert(JSToObjectNode.createToObjectNoCheck(context));
                this.copyDataPropertiesNode = (CopyDataPropertiesNode)this.insert(CopyDataPropertiesNode.create(context));
            }
            Object from = this.toObjectNode.execute(sourceValue);
            this.copyDataPropertiesNode.execute(target, from);
        }

        @Override
        protected ObjectLiteralMemberNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new ObjectLiteralSpreadMemberNode(this.isStatic, this.attributes, JavaScriptNode.cloneUninitialized(this.valueNode, materializedTags));
        }
    }

    private static class ObjectLiteralProtoMemberNode
    extends ObjectLiteralMemberNode {
        @Node.Child
        protected JavaScriptNode valueNode;

        ObjectLiteralProtoMemberNode(boolean isStatic, JavaScriptNode valueNode) {
            super(isStatic, 0);
            this.valueNode = valueNode;
        }

        @Override
        public final void executeVoid(VirtualFrame frame, DynamicObject receiver, DynamicObject homeObject, JSContext context) {
            Object value = this.valueNode.execute(frame);
            if (JSDynamicObject.isJSDynamicObject(value)) {
                if (value == Undefined.instance) {
                    return;
                }
                JSObject.setPrototype(receiver, (DynamicObject)value);
            }
        }

        @Override
        protected ObjectLiteralMemberNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new ObjectLiteralProtoMemberNode(this.isStatic, JavaScriptNode.cloneUninitialized(this.valueNode, materializedTags));
        }
    }

    private static class ComputedObjectLiteralAccessorMemberNode
    extends ObjectLiteralMemberNode {
        @Node.Child
        private JavaScriptNode propertyKey;
        @Node.Child
        private JavaScriptNode getterNode;
        @Node.Child
        private JavaScriptNode setterNode;
        @Node.Child
        private JSToPropertyKeyNode toPropertyKey;
        @Node.Child
        private SetFunctionNameNode setFunctionName;
        private final boolean isGetterAnonymousFunction;
        private final boolean isSetterAnonymousFunction;

        ComputedObjectLiteralAccessorMemberNode(JavaScriptNode key, boolean isStatic, int attributes, JavaScriptNode getter, JavaScriptNode setter) {
            super(isStatic, attributes);
            this.propertyKey = JSToPropertyKeyNode.JSToPropertyKeyWrapperNode.create(key);
            this.getterNode = getter;
            this.setterNode = setter;
            this.toPropertyKey = JSToPropertyKeyNode.create();
            this.isGetterAnonymousFunction = ComputedObjectLiteralAccessorMemberNode.isAnonymousFunctionDefinition(getter);
            this.isSetterAnonymousFunction = ComputedObjectLiteralAccessorMemberNode.isAnonymousFunctionDefinition(setter);
            this.setFunctionName = this.isGetterAnonymousFunction || this.isSetterAnonymousFunction ? SetFunctionNameNode.create() : null;
        }

        @Override
        public final void executeVoid(VirtualFrame frame, DynamicObject receiver, DynamicObject homeObject, JSContext context) {
            Object key = this.evaluateKey(frame);
            Object getterV = null;
            Object setterV = null;
            if (this.getterNode != null) {
                getterV = ComputedObjectLiteralAccessorMemberNode.evaluateWithHomeObject(this.getterNode, frame, homeObject);
                if (this.isGetterAnonymousFunction) {
                    this.setFunctionName.execute(getterV, key, "get");
                }
            }
            if (this.setterNode != null) {
                setterV = ComputedObjectLiteralAccessorMemberNode.evaluateWithHomeObject(this.setterNode, frame, homeObject);
                if (this.isSetterAnonymousFunction) {
                    this.setFunctionName.execute(setterV, key, "set");
                }
            }
            assert (getterV != null || setterV != null);
            PropertyDescriptor propDesc = PropertyDescriptor.createAccessor((DynamicObject)getterV, (DynamicObject)setterV, this.attributes);
            JSRuntime.definePropertyOrThrow(receiver, key, propDesc);
        }

        @Override
        public Object evaluateKey(VirtualFrame frame) {
            Object key = this.propertyKey.execute(frame);
            return this.toPropertyKey.execute(key);
        }

        @Override
        protected ObjectLiteralMemberNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new ComputedObjectLiteralAccessorMemberNode(JavaScriptNode.cloneUninitialized(this.propertyKey, materializedTags), this.isStatic, this.attributes, JavaScriptNode.cloneUninitialized(this.getterNode, materializedTags), JavaScriptNode.cloneUninitialized(this.setterNode, materializedTags));
        }
    }

    public static abstract class ComputedObjectLiteralDataMemberNode
    extends ObjectLiteralMemberNode {
        @Node.Child
        private JavaScriptNode propertyKey;
        @Node.Child
        protected JavaScriptNode valueNode;
        @Node.Child
        private JSToPropertyKeyNode toPropertyKey;
        @Node.Child
        protected SetFunctionNameNode setFunctionName;

        ComputedObjectLiteralDataMemberNode(JavaScriptNode key, boolean isStatic, int attributes, JavaScriptNode valueNode, boolean isField, boolean isAnonymousFunctionDefinition) {
            super(isStatic, attributes, isField, isAnonymousFunctionDefinition);
            this.propertyKey = key;
            this.valueNode = valueNode;
            this.toPropertyKey = JSToPropertyKeyNode.create();
            this.setFunctionName = ComputedObjectLiteralDataMemberNode.isAnonymousFunctionDefinition(valueNode) ? SetFunctionNameNode.create() : null;
        }

        @Specialization(guards={"!isFieldOrStaticBlock", "!isAnonymousFunctionDefinition", "setFunctionName==null", "!isMethodNode(valueNode)"}, limit="3")
        public final void doNoFieldNoFunctionDef(VirtualFrame frame, DynamicObject receiver, DynamicObject homeObject, JSContext context, @CachedLibrary(value="receiver") DynamicObjectLibrary dynamicObject) {
            Object key = this.evaluateKey(frame);
            Object value = this.valueNode.execute(frame);
            dynamicObject.put(receiver, key, value);
        }

        @Specialization
        public final void doGeneric(VirtualFrame frame, DynamicObject receiver, DynamicObject homeObject, JSContext context) {
            Object value;
            JavaScriptNode unwrappedValueNode;
            if (this.isFieldOrStaticBlock) {
                return;
            }
            Object key = this.evaluateKey(frame);
            if (this.isAnonymousFunctionDefinition && (unwrappedValueNode = JSNodeUtil.getWrappedNode(this.valueNode)) instanceof ClassDefinitionNode) {
                value = ((ClassDefinitionNode)unwrappedValueNode).executeWithClassName(frame, key);
            } else {
                value = ComputedObjectLiteralDataMemberNode.evaluateWithHomeObject(this.valueNode, frame, homeObject);
                if (this.setFunctionName != null) {
                    this.setFunctionName.execute(value, key);
                }
            }
            PropertyDescriptor propDesc = PropertyDescriptor.createData(value, this.attributes);
            JSRuntime.definePropertyOrThrow(receiver, key, propDesc);
        }

        @Override
        public Object evaluateKey(VirtualFrame frame) {
            Object key = this.propertyKey.execute(frame);
            return this.toPropertyKey.execute(key);
        }

        @Override
        public Object evaluateValue(VirtualFrame frame, DynamicObject homeObject) {
            return ComputedObjectLiteralDataMemberNode.evaluateWithHomeObject(this.valueNode, frame, homeObject);
        }

        @Override
        protected ObjectLiteralMemberNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return ObjectLiteralNodeFactory.ComputedObjectLiteralDataMemberNodeGen.create(JavaScriptNode.cloneUninitialized(this.propertyKey, materializedTags), this.isStatic, this.attributes, JavaScriptNode.cloneUninitialized(this.valueNode, materializedTags), this.isFieldOrStaticBlock, this.isAnonymousFunctionDefinition);
        }
    }

    private static class ObjectLiteralAccessorMemberNode
    extends CachingObjectLiteralMemberNode {
        @Node.Child
        protected JavaScriptNode getterNode;
        @Node.Child
        protected JavaScriptNode setterNode;

        ObjectLiteralAccessorMemberNode(Object name, boolean isStatic, int attributes, JavaScriptNode getter, JavaScriptNode setter) {
            super(name, isStatic, attributes, false);
            this.getterNode = getter;
            this.setterNode = setter;
        }

        @Override
        public final void executeVoid(VirtualFrame frame, DynamicObject receiver, DynamicObject homeObject, JSContext context) {
            Object getterV = null;
            Object setterV = null;
            if (this.getterNode != null) {
                getterV = ObjectLiteralAccessorMemberNode.evaluateWithHomeObject(this.getterNode, frame, homeObject);
            }
            if (this.setterNode != null) {
                setterV = ObjectLiteralAccessorMemberNode.evaluateWithHomeObject(this.setterNode, frame, homeObject);
            }
            assert (getterV != null || setterV != null);
            this.execute(receiver, getterV, setterV, context);
        }

        private void execute(DynamicObject obj, Object getterV, Object setterV, JSContext context) {
            DynamicObjectLibrary dynamicObjectLib = this.dynamicObjectLibrary(context);
            DynamicObject getter = (DynamicObject)getterV;
            DynamicObject setter = (DynamicObject)setterV;
            if ((this.getterNode == null || this.setterNode == null) && JSProperty.isAccessor(dynamicObjectLib.getPropertyFlagsOrDefault(obj, this.name, 0))) {
                Accessor existing = (Accessor)dynamicObjectLib.getOrDefault(obj, this.name, null);
                getter = getter == null ? existing.getGetter() : getter;
                setter = setter == null ? existing.getSetter() : setter;
            }
            Accessor accessor = new Accessor(getter, setter);
            dynamicObjectLib.putWithFlags(obj, this.name, (Object)accessor, this.attributes | 8);
        }

        @Override
        protected ObjectLiteralMemberNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new ObjectLiteralAccessorMemberNode(this.name, this.isStatic, this.attributes, JavaScriptNode.cloneUninitialized(this.getterNode, materializedTags), JavaScriptNode.cloneUninitialized(this.setterNode, materializedTags));
        }
    }

    private static class ObjectLiteralDataMemberNode
    extends CachingObjectLiteralMemberNode {
        @Node.Child
        protected JavaScriptNode valueNode;

        ObjectLiteralDataMemberNode(Object name, boolean isStatic, int attributes, JavaScriptNode valueNode, boolean isFieldOrStaticBlock) {
            super(name, isStatic, attributes, isFieldOrStaticBlock);
            this.valueNode = valueNode;
        }

        @Override
        public final void executeVoid(VirtualFrame frame, DynamicObject receiver, DynamicObject homeObject, JSContext context) {
            Object value = ObjectLiteralDataMemberNode.evaluateWithHomeObject(this.valueNode, frame, homeObject);
            this.execute(receiver, value, context);
        }

        @Override
        public Object evaluateValue(VirtualFrame frame, DynamicObject homeObject) {
            return ObjectLiteralDataMemberNode.evaluateWithHomeObject(this.valueNode, frame, homeObject);
        }

        private void execute(DynamicObject obj, Object value, JSContext context) {
            if (this.isFieldOrStaticBlock) {
                return;
            }
            DynamicObjectLibrary dynamicObjectLib = this.dynamicObjectLibrary(context);
            dynamicObjectLib.putWithFlags(obj, this.name, value, (int)this.attributes);
        }

        @Override
        protected ObjectLiteralMemberNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new ObjectLiteralDataMemberNode(this.name, this.isStatic, this.attributes, JavaScriptNode.cloneUninitialized(this.valueNode, materializedTags), this.isFieldOrStaticBlock);
        }
    }

    private static abstract class CachingObjectLiteralMemberNode
    extends ObjectLiteralMemberNode {
        protected final Object name;
        @CompilerDirectives.CompilationFinal
        private DynamicObjectLibrary dynamicObjectLibrary;

        CachingObjectLiteralMemberNode(Object name, boolean isStatic, int attributes, boolean isFieldOrStaticBlock) {
            super(isStatic, attributes, isFieldOrStaticBlock, false);
            assert (JSRuntime.isPropertyKey(name) || name == null && isStatic && isFieldOrStaticBlock) : name;
            this.name = name;
        }

        @Override
        public final Object evaluateKey(VirtualFrame frame) {
            return this.name;
        }

        protected final DynamicObjectLibrary dynamicObjectLibrary(JSContext context) {
            DynamicObjectLibrary dynamicObjectLib = this.dynamicObjectLibrary;
            if (dynamicObjectLib == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.dynamicObjectLibrary = dynamicObjectLib = (DynamicObjectLibrary)this.insert((Node)JSObjectUtil.createDispatched(this.name, context.getPropertyCacheLimit()));
                JSObjectUtil.checkForNoSuchPropertyOrMethod(context, this.name);
            }
            return dynamicObjectLib;
        }
    }

    public static abstract class ObjectLiteralMemberNode
    extends JavaScriptBaseNode {
        public static final ObjectLiteralMemberNode[] EMPTY = new ObjectLiteralMemberNode[0];
        protected final boolean isStatic;
        protected final byte attributes;
        protected final boolean isFieldOrStaticBlock;
        protected final boolean isAnonymousFunctionDefinition;

        public ObjectLiteralMemberNode(boolean isStatic, int attributes) {
            this(isStatic, attributes, false, false);
        }

        public ObjectLiteralMemberNode(boolean isStatic, int attributes, boolean isFieldOrStaticBlock, boolean isAnonymousFunctionDefinition) {
            assert (attributes == (attributes & 7));
            this.isStatic = isStatic;
            this.attributes = (byte)attributes;
            this.isFieldOrStaticBlock = isFieldOrStaticBlock;
            this.isAnonymousFunctionDefinition = isAnonymousFunctionDefinition;
        }

        public abstract void executeVoid(VirtualFrame var1, DynamicObject var2, DynamicObject var3, JSContext var4);

        public final void executeVoid(VirtualFrame frame, DynamicObject obj, JSContext context) {
            this.executeVoid(frame, obj, obj, context);
        }

        public Object evaluateKey(VirtualFrame frame) {
            throw Errors.shouldNotReachHere();
        }

        public Object evaluateValue(VirtualFrame frame, DynamicObject homeObject) {
            throw Errors.shouldNotReachHere();
        }

        public final boolean isStatic() {
            return this.isStatic;
        }

        public final boolean isFieldOrStaticBlock() {
            return this.isFieldOrStaticBlock;
        }

        public final boolean isAnonymousFunctionDefinition() {
            return this.isAnonymousFunctionDefinition;
        }

        static boolean isAnonymousFunctionDefinition(JavaScriptNode expression) {
            return expression instanceof FunctionNameHolder && ((FunctionNameHolder)((Object)expression)).isAnonymous();
        }

        protected static boolean isMethodNode(JavaScriptNode valueNode) {
            return valueNode instanceof MakeMethodNode;
        }

        protected static Object evaluateWithHomeObject(JavaScriptNode valueNode, VirtualFrame frame, DynamicObject obj) {
            if (ObjectLiteralMemberNode.isMethodNode(valueNode)) {
                return ((MakeMethodNode)valueNode).executeWithObject(frame, obj);
            }
            return valueNode.execute(frame);
        }

        protected abstract ObjectLiteralMemberNode copyUninitialized(Set<Class<? extends Tag>> var1);

        public static ObjectLiteralMemberNode[] cloneUninitialized(ObjectLiteralMemberNode[] members, Set<Class<? extends Tag>> materializedTags) {
            ObjectLiteralMemberNode[] copy = (ObjectLiteralMemberNode[])members.clone();
            for (int i = 0; i < copy.length; ++i) {
                copy[i] = copy[i].copyUninitialized(materializedTags);
            }
            return copy;
        }
    }

    public static final class MakeMethodNode
    extends JavaScriptNode
    implements FunctionNameHolder.Delegate {
        @Node.Child
        private JavaScriptNode functionNode;
        @Node.Child
        private PropertySetNode makeMethodNode;

        private MakeMethodNode(JSContext context, JavaScriptNode functionNode) {
            this.functionNode = functionNode;
            this.makeMethodNode = PropertySetNode.createSetHidden(JSFunction.HOME_OBJECT_ID, context);
        }

        private MakeMethodNode(JSContext context, JavaScriptNode functionNode, HiddenKey key) {
            this.functionNode = functionNode;
            this.makeMethodNode = PropertySetNode.createSetHidden(key, context);
        }

        public static JavaScriptNode create(JSContext context, JavaScriptNode functionNode) {
            return new MakeMethodNode(context, functionNode);
        }

        public static JavaScriptNode createWithKey(JSContext context, JavaScriptNode functionNode, HiddenKey key) {
            return new MakeMethodNode(context, functionNode, key);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return this.functionNode.execute(frame);
        }

        public Object executeWithObject(VirtualFrame frame, DynamicObject obj) {
            Object function = this.execute(frame);
            this.makeMethodNode.setValue(function, obj);
            return function;
        }

        @Override
        public FunctionNameHolder getFunctionNameHolder() {
            return (FunctionNameHolder)((Object)this.functionNode);
        }

        @Override
        protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return MakeMethodNode.create(this.makeMethodNode.getContext(), MakeMethodNode.cloneUninitialized(this.functionNode, materializedTags));
        }
    }
}

