/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins.intl;

import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.util.ULocale;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.builtins.intl.SegmentIteratorPrototypeBuiltins;
import com.oracle.truffle.js.builtins.intl.SegmenterFunctionBuiltins;
import com.oracle.truffle.js.builtins.intl.SegmenterPrototypeBuiltins;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.builtins.intl.JSSegmenterIteratorObject;
import com.oracle.truffle.js.runtime.builtins.intl.JSSegmenterObject;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.CompilableFunction;
import com.oracle.truffle.js.runtime.util.IntlUtil;
import java.util.Locale;

public final class JSSegmenter
extends JSNonProxy
implements JSConstructorFactory.WithFunctions,
PrototypeSupplier {
    public static final String CLASS_NAME = "Segmenter";
    public static final String PROTOTYPE_NAME = "Segmenter.prototype";
    public static final String ITERATOR_CLASS_NAME = "Segment Iterator";
    public static final String ITERATOR_PROTOTYPE_NAME = "Segment Iterator.prototype";
    public static final JSSegmenter INSTANCE = new JSSegmenter();

    private JSSegmenter() {
    }

    public static boolean isJSSegmenter(Object obj) {
        return obj instanceof JSSegmenterObject;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return this.getClassName();
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject ctor) {
        JSContext ctx = realm.getContext();
        DynamicObject segmenterPrototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(ctx, segmenterPrototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, segmenterPrototype, SegmenterPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(segmenterPrototype, "Intl.Segmenter");
        return segmenterPrototype;
    }

    @Override
    public Shape makeInitialShape(JSContext ctx, DynamicObject prototype) {
        return JSObjectUtil.getProtoChildShape(prototype, INSTANCE, ctx);
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm, SegmenterFunctionBuiltins.BUILTINS);
    }

    public static DynamicObject create(JSContext context) {
        InternalState state = new InternalState();
        JSRealm realm = context.getRealm();
        JSObjectFactory factory = context.getSegmenterFactory();
        JSSegmenterObject obj = new JSSegmenterObject(factory.getShape(realm), state);
        factory.initProto(obj, realm);
        assert (JSSegmenter.isJSSegmenter((Object)obj));
        return context.trackAllocation(obj);
    }

    public static DynamicObject createSegmentIterator(JSContext context, DynamicObject segmenter, String value) {
        BreakIterator icuIterator = JSSegmenter.createBreakIterator(segmenter, value);
        Granularity granularity = JSSegmenter.getGranularity(segmenter);
        IteratorState iteratorState = new IteratorState(value, icuIterator, granularity, null, 0);
        JSObjectFactory factory = context.getSegmentIteratorFactory();
        JSRealm realm = context.getRealm();
        JSSegmenterIteratorObject segmentIterator = new JSSegmenterIteratorObject(factory.getShape(realm), iteratorState);
        factory.initProto(segmentIterator, realm);
        return context.trackAllocation(segmentIterator);
    }

    @CompilerDirectives.TruffleBoundary
    public static void setLocale(JSContext ctx, InternalState state, String[] locales) {
        Locale selectedLocale = IntlUtil.selectedLocale(ctx, locales);
        Locale strippedLocale = selectedLocale.stripExtensions();
        if (strippedLocale.toLanguageTag().equals("und")) {
            selectedLocale = ctx.getLocale();
            strippedLocale = selectedLocale.stripExtensions();
        }
        state.locale = strippedLocale.toLanguageTag();
        state.javaLocale = strippedLocale;
    }

    @CompilerDirectives.TruffleBoundary
    public static void setupInternalBreakIterator(InternalState state, String granularity) {
        state.javaLocale = Locale.forLanguageTag(state.locale);
        switch (granularity) {
            case "grapheme": {
                state.granularity = Granularity.GRAPHEME;
                break;
            }
            case "word": {
                state.granularity = Granularity.WORD;
                break;
            }
            case "sentence": {
                state.granularity = Granularity.SENTENCE;
                break;
            }
            default: {
                throw Errors.shouldNotReachHere(String.format("Segmenter with granularity, %s, is not supported", granularity));
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static BreakIterator createBreakIterator(DynamicObject segmenterObj, String text) {
        InternalState state = JSSegmenter.getInternalState(segmenterObj);
        ULocale ulocale = ULocale.forLocale((Locale)state.javaLocale);
        BreakIterator icuIterator = state.granularity.getIterator(ulocale);
        icuIterator.setText(text);
        return icuIterator;
    }

    public static Granularity getGranularity(DynamicObject segmenterObj) {
        InternalState state = JSSegmenter.getInternalState(segmenterObj);
        return state.granularity;
    }

    @CompilerDirectives.TruffleBoundary
    public static DynamicObject resolvedOptions(JSContext context, DynamicObject segmenterObj) {
        InternalState state = JSSegmenter.getInternalState(segmenterObj);
        return state.toResolvedOptionsObject(context);
    }

    public static InternalState getInternalState(DynamicObject segmenterObj) {
        assert (JSSegmenter.isJSSegmenter(segmenterObj));
        return ((JSSegmenterObject)segmenterObj).getInternalState();
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getSegmenterPrototype();
    }

    public static Shape makeInitialSegmentIteratorShape(JSContext ctx, DynamicObject prototype) {
        return JSObjectUtil.getProtoChildShape(prototype, JSOrdinary.BARE_INSTANCE, ctx);
    }

    public static boolean isJSSegmenterIterator(Object obj) {
        return obj instanceof JSSegmenterIteratorObject;
    }

    private static CallTarget createPropertyGetterCallTarget(JSContext context, final CompilableFunction<IteratorState, Object> getter) {
        return Truffle.getRuntime().createCallTarget((RootNode)new JavaScriptRootNode(context.getLanguage(), null, null){

            public Object execute(VirtualFrame frame) {
                Object obj = JSArguments.getThisObject(frame.getArguments());
                if (JSSegmenter.isJSSegmenterIterator(obj)) {
                    return getter.apply(((JSSegmenterIteratorObject)((Object)obj)).getIteratorState());
                }
                throw Errors.createTypeErrorTypeXExpected(JSSegmenter.ITERATOR_CLASS_NAME);
            }
        });
    }

    public static DynamicObject createSegmentIteratorPrototype(JSContext context, JSRealm realm) {
        DynamicObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(realm, realm.getIteratorPrototype());
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, SegmentIteratorPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(prototype, ITERATOR_CLASS_NAME);
        JSFunctionData breakTypeFd = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.SegmenterBreakType, c -> {
            CallTarget ct = JSSegmenter.createPropertyGetterCallTarget(context, it -> it.getBreakType() != null ? it.getBreakType() : Undefined.instance);
            return JSFunctionData.createCallOnly(c, ct, 0, "get breakType");
        });
        DynamicObject breakTypeGetter = JSFunction.create(realm, breakTypeFd);
        JSObjectUtil.putBuiltinAccessorProperty(prototype, (Object)"breakType", breakTypeGetter, Undefined.instance);
        JSFunctionData positionFd = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.SegmenterPosition, c -> JSFunctionData.createCallOnly(context, JSSegmenter.createPropertyGetterCallTarget(context, IteratorState::getIndex), 0, "get index"));
        DynamicObject positionGetter = JSFunction.create(realm, positionFd);
        JSObjectUtil.putBuiltinAccessorProperty(prototype, (Object)"index", positionGetter, Undefined.instance);
        return prototype;
    }

    public static class InternalState {
        private String locale;
        private Locale javaLocale;
        Granularity granularity = Granularity.GRAPHEME;

        DynamicObject toResolvedOptionsObject(JSContext context) {
            DynamicObject result = JSOrdinary.create(context);
            JSObjectUtil.defineDataProperty(result, "locale", this.locale, JSAttributes.getDefault());
            JSObjectUtil.defineDataProperty(result, "granularity", this.granularity.getName(), JSAttributes.getDefault());
            return result;
        }
    }

    public static enum Granularity implements IcuIteratorHelper
    {
        GRAPHEME("grapheme"){

            @Override
            @CompilerDirectives.TruffleBoundary
            public BreakIterator getIterator(ULocale locale) {
                return BreakIterator.getCharacterInstance((ULocale)locale);
            }

            @Override
            public String getBreakType(int icuStatus) {
                return null;
            }
        }
        ,
        WORD("word"){

            @Override
            @CompilerDirectives.TruffleBoundary
            public BreakIterator getIterator(ULocale locale) {
                return BreakIterator.getWordInstance((ULocale)locale);
            }

            @Override
            public String getBreakType(int icuStatus) {
                return icuStatus == 0 ? "none" : "word";
            }
        }
        ,
        SENTENCE("sentence"){

            @Override
            @CompilerDirectives.TruffleBoundary
            public BreakIterator getIterator(ULocale locale) {
                return BreakIterator.getSentenceInstance((ULocale)locale);
            }

            @Override
            public String getBreakType(int icuStatus) {
                return icuStatus == 0 ? "sep" : "term";
            }
        };

        private String name;

        private Granularity(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    static interface IcuIteratorHelper {
        public BreakIterator getIterator(ULocale var1);

        public String getBreakType(int var1);
    }

    public static class IteratorState {
        private String iteratedString;
        private BreakIterator breakIterator;
        private Granularity granularity;
        private String breakType;
        private int index;

        public IteratorState(String iteratedObject, BreakIterator breakIterator, Granularity granularity, String breakType, int index) {
            this.iteratedString = iteratedObject;
            this.breakIterator = breakIterator;
            this.granularity = granularity;
            this.breakType = breakType;
            this.index = index;
        }

        public String getIteratedString() {
            return this.iteratedString;
        }

        public Granularity getSegmenterGranularity() {
            return this.granularity;
        }

        public String getBreakType() {
            return this.breakType;
        }

        public int getIndex() {
            return this.index;
        }

        public BreakIterator getBreakIterator() {
            return this.breakIterator;
        }

        public void setIteratedString(String iteratedString) {
            this.iteratedString = iteratedString;
        }

        public void setBreakType(String breakType) {
            this.breakType = breakType;
        }

        public void setIndex(int index) {
            this.index = index;
        }
    }
}

