/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.builtins.JSFunction;

public abstract class JavaScriptRealmBoundaryRootNode
extends JavaScriptRootNode {
    @CompilerDirectives.CompilationFinal
    private boolean seenException;
    @CompilerDirectives.CompilationFinal
    private boolean seenNullRealm;

    protected JavaScriptRealmBoundaryRootNode(JavaScriptLanguage lang, SourceSection sourceSection, FrameDescriptor frameDescriptor) {
        super(lang, sourceSection, frameDescriptor);
    }

    public final Object execute(VirtualFrame frame) {
        boolean enterContext;
        JSRealm realm;
        JSContext context = this.getContext();
        CompilerAsserts.partialEvaluationConstant((Object)context);
        JSRealm currentRealm = this.getRealm();
        if (context.neverCreatedChildRealms()) {
            assert (currentRealm == JSFunction.getRealm(JSFrameUtil.getFunctionObject((Frame)frame)));
            realm = currentRealm;
            enterContext = false;
        } else {
            realm = JSFunction.getRealm(JSFrameUtil.getFunctionObject((Frame)frame));
            enterContext = realm != currentRealm;
        }
        Object prev = null;
        TruffleContext childContext = null;
        if (enterContext) {
            childContext = realm.getTruffleContext();
            prev = childContext.enter((Node)this);
        }
        try {
            Object object = this.executeInRealm(frame);
            return object;
        }
        catch (JSException ex) {
            if (!this.seenException) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.seenException = true;
            }
            if (ex.getRealm() == null) {
                if (!this.seenNullRealm) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenNullRealm = true;
                }
                ex.setRealm(realm);
            }
            throw ex;
        }
        catch (StackOverflowError ex) {
            CompilerDirectives.transferToInterpreter();
            throw Errors.createRangeErrorStackOverflow((Node)this);
        }
        finally {
            if (enterContext) {
                childContext.leave((Node)this, prev);
            }
        }
    }

    protected abstract Object executeInRealm(VirtualFrame var1);

    protected abstract JSContext getContext();

    protected JSRealm getRealm() {
        return this.getContext().getRealm();
    }
}

