/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.wasm;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.cast.JSToInt32Node;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.wasm.ToWebAssemblyValueNodeGen;
import com.oracle.truffle.js.runtime.JSRuntime;

public abstract class ToWebAssemblyValueNode
extends JavaScriptBaseNode {
    @Node.Child
    JSToInt32Node toInt32Node;
    @Node.Child
    JSToNumberNode toNumberNode = JSToNumberNode.create();

    protected ToWebAssemblyValueNode() {
        this.toInt32Node = JSToInt32Node.create();
    }

    public static ToWebAssemblyValueNode create() {
        return ToWebAssemblyValueNodeGen.create();
    }

    public abstract Object execute(Object var1, String var2);

    @Specialization
    protected Object convert(Object value, String type) {
        assert (!"i64".equals(type));
        if ("i32".equals(type)) {
            return this.toInt32Node.executeInt(value);
        }
        Number numberValue = this.toNumberNode.executeNumber(value);
        double doubleValue = JSRuntime.toDouble(numberValue);
        if ("f32".equals(type)) {
            return Float.valueOf((float)doubleValue);
        }
        assert ("f64".equals(type));
        return doubleValue;
    }
}

