/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.array.JSGetLengthNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectArrayNodeGen;
import com.oracle.truffle.js.nodes.interop.ImportValueNode;
import com.oracle.truffle.js.nodes.unary.JSUnaryNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@ImportStatic(value={JSConfig.class})
public abstract class JSToObjectArrayNode
extends JavaScriptBaseNode {
    protected final JSContext context;
    protected final boolean nullOrUndefinedAsEmptyArray;

    protected JSToObjectArrayNode(JSContext context, boolean nullOrUndefinedAsEmptyArray) {
        this.context = Objects.requireNonNull(context);
        this.nullOrUndefinedAsEmptyArray = nullOrUndefinedAsEmptyArray;
    }

    public abstract Object[] executeObjectArray(Object var1);

    public static JSToObjectArrayNode create(JSContext context) {
        return JSToObjectArrayNode.create(context, false);
    }

    public static JSToObjectArrayNode create(JSContext context, boolean nullOrUndefinedAsEmptyArray) {
        return JSToObjectArrayNodeGen.create(context, nullOrUndefinedAsEmptyArray);
    }

    public static JavaScriptNode create(JSContext context, JavaScriptNode operand) {
        class Unary
        extends JSUnaryNode {
            @Node.Child
            private JSToObjectArrayNode toObjectArray;
            final /* synthetic */ JSContext val$context;

            Unary(JavaScriptNode javaScriptNode) {
                this.val$context = javaScriptNode;
                super(operandNode);
                this.toObjectArray = JSToObjectArrayNode.create(this.val$context);
            }

            @Override
            public Object execute(VirtualFrame frame, Object operandValue) {
                return this.toObjectArray.executeObjectArray(operandValue);
            }

            @Override
            public Object execute(VirtualFrame frame) {
                return this.execute(frame, this.operandNode.execute(frame));
            }

            @Override
            protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
                return new Unary(Unary.cloneUninitialized(this.getOperand(), materializedTags), this.val$context);
            }
        }
        return new Unary(operand, context);
    }

    @Specialization(guards={"isJSObject(obj)"})
    protected Object[] toArray(DynamicObject obj, @Cached(value="create(context)") JSGetLengthNode getLengthNode, @Cached(value="create(context)") ReadElementNode readNode) {
        long len = getLengthNode.executeLong(obj);
        if (len > (long)this.context.getContextOptions().getMaxApplyArgumentLength()) {
            CompilerDirectives.transferToInterpreter();
            throw Errors.createRangeErrorTooManyArguments();
        }
        int iLen = (int)len;
        assert (JSRuntime.longIsRepresentableAsInt(len));
        Object[] arr = new Object[iLen];
        for (int index = 0; index < iLen; ++index) {
            Object value;
            arr[index] = value = readNode.executeWithTargetAndIndex((Object)obj, index);
        }
        return arr;
    }

    @Specialization(guards={"isUndefined(value)"})
    protected Object[] doUndefined(Object value) {
        return this.emptyArrayOrObjectError(value);
    }

    @Specialization(guards={"isJSNull(value)"})
    protected Object[] doNull(Object value) {
        return this.emptyArrayOrObjectError(value);
    }

    @Specialization
    protected Object[] toArrayString(CharSequence value) {
        return this.notAnObjectError(value);
    }

    @Specialization
    protected Object[] toArrayInt(int value) {
        return this.notAnObjectError(value);
    }

    @Specialization
    protected Object[] toArrayDouble(double value) {
        return this.notAnObjectError(value);
    }

    @Specialization
    protected Object[] toArrayBoolean(boolean value) {
        return this.notAnObjectError(value);
    }

    private Object[] emptyArrayOrObjectError(Object value) {
        if (this.nullOrUndefinedAsEmptyArray) {
            return ScriptArray.EMPTY_OBJECT_ARRAY;
        }
        return this.notAnObjectError(value);
    }

    private Object[] notAnObjectError(Object value) {
        if (this.context.isOptionNashornCompatibilityMode()) {
            throw Errors.createTypeError("Function.prototype.apply expects an Array for second argument");
        }
        throw Errors.createTypeErrorNotAnObject(value);
    }

    @Specialization
    protected Object[] passArray(Object[] array) {
        if (array.length > this.context.getContextOptions().getMaxApplyArgumentLength()) {
            CompilerDirectives.transferToInterpreter();
            throw Errors.createRangeErrorTooManyArguments();
        }
        return array;
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"isList(value)"})
    protected Object[] doList(Object value) {
        List list = (List)value;
        if (list.size() > this.context.getContextOptions().getMaxApplyArgumentLength()) {
            CompilerDirectives.transferToInterpreter();
            throw Errors.createRangeErrorTooManyArguments();
        }
        return list.toArray();
    }

    @Specialization(guards={"isForeignObject(obj)"}, limit="InteropLibraryLimit")
    protected Object[] doForeignObject(Object obj, @CachedLibrary(value="obj") InteropLibrary interop, @Cached(value="create()") BranchProfile hasPropertiesBranch, @Cached(value="create()") ImportValueNode foreignConvertNode) {
        try {
            if (!interop.hasArrayElements(obj)) {
                throw Errors.createTypeError("foreign Object reports not to have a SIZE");
            }
            long len = interop.getArraySize(obj);
            if (len > (long)this.context.getContextOptions().getMaxApplyArgumentLength()) {
                CompilerDirectives.transferToInterpreter();
                throw Errors.createRangeErrorTooManyArguments();
            }
            int iLen = (int)len;
            Object[] arr = new Object[iLen];
            if (len > 0L) {
                hasPropertiesBranch.enter();
                for (int i = 0; i < iLen; ++i) {
                    arr[i] = foreignConvertNode.executeWithTarget(interop.readArrayElement(obj, (long)i));
                }
            }
            return arr;
        }
        catch (InvalidArrayIndexException | UnsupportedMessageException e) {
            throw Errors.createTypeErrorNotAnObject(obj);
        }
    }

    @Fallback
    protected Object[] doFallback(Object value) {
        assert (!JSRuntime.isObject(value));
        return this.notAnObjectError(value);
    }
}

