/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.GetIteratorNode;
import com.oracle.truffle.js.nodes.access.IteratorCloseNode;
import com.oracle.truffle.js.nodes.access.IteratorStepNode;
import com.oracle.truffle.js.nodes.access.IteratorValueNode;
import com.oracle.truffle.js.nodes.cast.JSStringListFromIterableNodeGen;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class JSStringListFromIterableNode
extends JavaScriptBaseNode {
    protected final JSContext context;

    protected JSStringListFromIterableNode(JSContext context) {
        this.context = context;
    }

    public abstract List<String> executeIterable(Object var1);

    public static JSStringListFromIterableNode create(JSContext context) {
        return JSStringListFromIterableNodeGen.create(context);
    }

    @Specialization(guards={"isString(s)"})
    @CompilerDirectives.TruffleBoundary
    protected static List<String> stringToList(Object s) {
        int[] codePoints = JSRuntime.toStringIsString(s).codePoints().toArray();
        int length = codePoints.length;
        ArrayList<String> result = new ArrayList<String>(length);
        for (int i = 0; i < length; ++i) {
            result.add(new String(codePoints, i, 1));
        }
        return result;
    }

    @Specialization(guards={"!isUndefined(iterable)", "!isString(iterable)"})
    protected static List<String> toArray(DynamicObject iterable, @Cached(value="create(context)") GetIteratorNode getIteratorNode, @Cached(value="create(context)") IteratorStepNode iteratorStepNode, @Cached(value="create(context)") IteratorValueNode iteratorValueNode, @Cached(value="create(context)") IteratorCloseNode iteratorCloseNode) {
        IteratorRecord iteratorRecord = getIteratorNode.execute(iterable);
        ArrayList<String> list = new ArrayList<String>();
        Object next = true;
        while (!JSStringListFromIterableNode.isFalse(next)) {
            next = iteratorStepNode.execute(iteratorRecord);
            if (JSStringListFromIterableNode.isFalse(next)) continue;
            Object nextValue = iteratorValueNode.execute((DynamicObject)next);
            if (!JSRuntime.isString(nextValue)) {
                iteratorCloseNode.executeAbrupt(iteratorRecord.getIterator());
                throw Errors.createTypeError("nonString value encountered!");
            }
            Boundaries.listAdd(list, JSRuntime.toString(nextValue));
        }
        return list;
    }

    private static boolean isFalse(Object o) {
        return o == Boolean.FALSE;
    }

    @Specialization(guards={"isUndefined(value)"})
    protected List<String> doUndefined(Object value) {
        return Collections.emptyList();
    }
}

