/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSProxyHasPropertyNode;
import com.oracle.truffle.js.nodes.binary.InNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=InNode.class)
public final class InNodeGen
extends InNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @Node.Child
    private JSProxyHasPropertyNode proxy_proxyHasPropertyNode_;

    private InNodeGen(JSContext context, JavaScriptNode left, JavaScriptNode right) {
        super(context, left, right);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object leftNodeValue_ = this.leftNode.execute(frameValue);
        Object rightNodeValue_ = this.rightNode.execute(frameValue);
        if ((state_0 & 0x1FF) != 0) {
            Object rightNodeValue__;
            if ((state_0 & 3) != 0 && JSTypes.isDynamicObject(rightNodeValue_)) {
                rightNodeValue__ = (DynamicObject)rightNodeValue_;
                if ((state_0 & 1) != 0 && JSGuards.isJSObject(rightNodeValue__) && !JSGuards.isJSProxy(rightNodeValue__)) {
                    return this.doObject(leftNodeValue_, (DynamicObject)rightNodeValue__);
                }
                if ((state_0 & 2) != 0 && JSGuards.isJSProxy(rightNodeValue__)) {
                    return this.doProxy(leftNodeValue_, (DynamicObject)rightNodeValue__, this.proxy_proxyHasPropertyNode_);
                }
            }
            if ((state_0 & 0xC) != 0) {
                if ((state_0 & 4) != 0 && JSGuards.isForeignObject(rightNodeValue_)) {
                    return this.doForeign(leftNodeValue_, rightNodeValue_);
                }
                if ((state_0 & 8) != 0 && JSGuards.isNullOrUndefined(rightNodeValue_)) {
                    return InNode.doNullOrUndefined(leftNodeValue_, rightNodeValue_);
                }
            }
            if ((state_0 & 0x10) != 0 && rightNodeValue_ instanceof Symbol) {
                rightNodeValue__ = (Symbol)rightNodeValue_;
                return InNode.doSymbol(leftNodeValue_, (Symbol)rightNodeValue__);
            }
            if ((state_0 & 0x20) != 0 && JSTypesGen.isImplicitString((state_0 & 0xE00) >>> 9, rightNodeValue_)) {
                rightNodeValue__ = JSTypesGen.asImplicitString((state_0 & 0xE00) >>> 9, rightNodeValue_);
                return InNode.doString(leftNodeValue_, (String)rightNodeValue__);
            }
            if ((state_0 & 0x40) != 0 && rightNodeValue_ instanceof SafeInteger) {
                rightNodeValue__ = (SafeInteger)rightNodeValue_;
                return InNode.doSafeInteger(leftNodeValue_, (SafeInteger)rightNodeValue__);
            }
            if ((state_0 & 0x80) != 0 && rightNodeValue_ instanceof BigInt) {
                rightNodeValue__ = (BigInt)rightNodeValue_;
                return InNode.doBigInt(leftNodeValue_, (BigInt)rightNodeValue__);
            }
            if ((state_0 & 0x100) != 0 && !JSGuards.isTruffleObject(rightNodeValue_)) {
                return InNode.doNotTruffleObject(leftNodeValue_, rightNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 0x1F8) != 0) {
            return JSTypesGen.expectBoolean(this.execute(frameValue));
        }
        Object leftNodeValue_ = this.leftNode.execute(frameValue);
        Object rightNodeValue_ = this.rightNode.execute(frameValue);
        if ((state_0 & 7) != 0) {
            if ((state_0 & 3) != 0 && JSTypes.isDynamicObject(rightNodeValue_)) {
                DynamicObject rightNodeValue__ = (DynamicObject)rightNodeValue_;
                if ((state_0 & 1) != 0 && JSGuards.isJSObject(rightNodeValue__) && !JSGuards.isJSProxy(rightNodeValue__)) {
                    return this.doObject(leftNodeValue_, rightNodeValue__);
                }
                if ((state_0 & 2) != 0 && JSGuards.isJSProxy(rightNodeValue__)) {
                    return this.doProxy(leftNodeValue_, rightNodeValue__, this.proxy_proxyHasPropertyNode_);
                }
            }
            if ((state_0 & 4) != 0 && JSGuards.isForeignObject(rightNodeValue_)) {
                return this.doForeign(leftNodeValue_, rightNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectBoolean(this.executeAndSpecialize(leftNodeValue_, rightNodeValue_));
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        try {
            if ((state_0 & 0x1F8) == 0 && (state_0 & 0x1FF) != 0) {
                this.executeBoolean(frameValue);
                return;
            }
            this.execute(frameValue);
            return;
        }
        catch (UnexpectedResultException ex) {
            return;
        }
    }

    private Object executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state_0 = this.state_0_;
        try {
            Object rightNodeValue_;
            if (JSTypes.isDynamicObject(rightNodeValue)) {
                rightNodeValue_ = (DynamicObject)rightNodeValue;
                if (JSGuards.isJSObject(rightNodeValue_) && !JSGuards.isJSProxy(rightNodeValue_)) {
                    this.state_0_ = state_0 |= 1;
                    lock.unlock();
                    hasLock = false;
                    Boolean bl = this.doObject(leftNodeValue, (DynamicObject)rightNodeValue_);
                    return bl;
                }
                if (JSGuards.isJSProxy(rightNodeValue_)) {
                    this.proxy_proxyHasPropertyNode_ = (JSProxyHasPropertyNode)super.insert((Node)JSProxyHasPropertyNode.create(this.context));
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    Boolean bl = this.doProxy(leftNodeValue, (DynamicObject)rightNodeValue_, this.proxy_proxyHasPropertyNode_);
                    return bl;
                }
            }
            if (JSGuards.isForeignObject(rightNodeValue)) {
                this.state_0_ = state_0 |= 4;
                lock.unlock();
                hasLock = false;
                rightNodeValue_ = this.doForeign(leftNodeValue, rightNodeValue);
                return rightNodeValue_;
            }
            if (JSGuards.isNullOrUndefined(rightNodeValue)) {
                this.state_0_ = state_0 |= 8;
                lock.unlock();
                hasLock = false;
                rightNodeValue_ = InNode.doNullOrUndefined(leftNodeValue, rightNodeValue);
                return rightNodeValue_;
            }
            if (rightNodeValue instanceof Symbol) {
                rightNodeValue_ = (Symbol)rightNodeValue;
                this.state_0_ = state_0 |= 0x10;
                lock.unlock();
                hasLock = false;
                Object object = InNode.doSymbol(leftNodeValue, (Symbol)rightNodeValue_);
                return object;
            }
            int stringCast1 = JSTypesGen.specializeImplicitString(rightNodeValue);
            if (stringCast1 != 0) {
                String rightNodeValue_2 = JSTypesGen.asImplicitString(stringCast1, rightNodeValue);
                state_0 |= stringCast1 << 9;
                this.state_0_ = state_0 |= 0x20;
                lock.unlock();
                hasLock = false;
                Object object = InNode.doString(leftNodeValue, rightNodeValue_2);
                return object;
            }
            if (rightNodeValue instanceof SafeInteger) {
                SafeInteger rightNodeValue_3 = (SafeInteger)rightNodeValue;
                this.state_0_ = state_0 |= 0x40;
                lock.unlock();
                hasLock = false;
                Object object = InNode.doSafeInteger(leftNodeValue, rightNodeValue_3);
                return object;
            }
            if (rightNodeValue instanceof BigInt) {
                BigInt rightNodeValue_4 = (BigInt)rightNodeValue;
                this.state_0_ = state_0 |= 0x80;
                lock.unlock();
                hasLock = false;
                Object object = InNode.doBigInt(leftNodeValue, rightNodeValue_4);
                return object;
            }
            if (!JSGuards.isTruffleObject(rightNodeValue)) {
                this.state_0_ = state_0 |= 0x100;
                lock.unlock();
                hasLock = false;
                Object object = InNode.doNotTruffleObject(leftNodeValue, rightNodeValue);
                return object;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.leftNode, this.rightNode}, new Object[]{leftNodeValue, rightNodeValue});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 0x1FF) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & 0x1FF & (state_0 & 0x1FF) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        Object[] data = new Object[10];
        data[0] = 0;
        int state_0 = this.state_0_;
        Object[] s = new Object[3];
        s[0] = "doObject";
        s[1] = (state_0 & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "doProxy";
        if ((state_0 & 2) != 0) {
            s[1] = (byte)1;
            ArrayList<List<JSProxyHasPropertyNode>> cached = new ArrayList<List<JSProxyHasPropertyNode>>();
            cached.add(Arrays.asList(this.proxy_proxyHasPropertyNode_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "doForeign";
        s[1] = (state_0 & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "doNullOrUndefined";
        s[1] = (state_0 & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        s = new Object[3];
        s[0] = "doSymbol";
        s[1] = (state_0 & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[5] = s;
        s = new Object[3];
        s[0] = "doString";
        s[1] = (state_0 & 0x20) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[6] = s;
        s = new Object[3];
        s[0] = "doSafeInteger";
        s[1] = (state_0 & 0x40) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[7] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        s[1] = (state_0 & 0x80) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[8] = s;
        s = new Object[3];
        s[0] = "doNotTruffleObject";
        s[1] = (state_0 & 0x100) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[9] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static InNode create(JSContext context, JavaScriptNode left, JavaScriptNode right) {
        return new InNodeGen(context, left, right);
    }
}

