/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.array.JSArrayDeleteRangeNode;
import com.oracle.truffle.js.nodes.array.JSArrayNextElementIndexNode;
import com.oracle.truffle.js.nodes.control.DeletePropertyNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSArrayDeleteRangeNode.class)
public final class JSArrayDeleteRangeNodeGen
extends JSArrayDeleteRangeNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @Node.Child
    private DenseArrayData denseArray_cache;
    @Node.Child
    private SparseArrayData sparseArray_cache;
    @Node.Child
    private DeletePropertyNode uncached_deletePropertyNode_;
    @Node.Child
    private JSArrayNextElementIndexNode uncached_nextElementIndexNode_;

    private JSArrayDeleteRangeNodeGen(JSContext context, boolean orThrow) {
        super(context, orThrow);
    }

    @Override
    @ExplodeLoop
    public void execute(DynamicObject arg0Value, ScriptArray arg1Value, long arg2Value, long arg3Value) {
        int state_0 = this.state_0_;
        if (state_0 != 0) {
            if ((state_0 & 1) != 0) {
                DenseArrayData s1_ = this.denseArray_cache;
                while (s1_ != null) {
                    if (s1_.cachedArrayType_.isInstance(arg1Value)) {
                        assert (!s1_.cachedArrayType_.isHolesType());
                        this.denseArray(arg0Value, arg1Value, arg2Value, arg3Value, s1_.cachedArrayType_, s1_.deletePropertyNode_);
                        return;
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state_0 & 2) != 0) {
                SparseArrayData s2_ = this.sparseArray_cache;
                while (s2_ != null) {
                    if (s2_.cachedArrayType_.isInstance(arg1Value)) {
                        assert (s2_.cachedArrayType_.isHolesType());
                        this.sparseArray(arg0Value, arg1Value, arg2Value, arg3Value, s2_.cachedArrayType_, s2_.deletePropertyNode_, s2_.nextElementIndexNode_);
                        return;
                    }
                    s2_ = s2_.next_;
                }
            }
            if ((state_0 & 4) != 0) {
                this.doUncached(arg0Value, arg1Value, arg2Value, arg3Value, this.uncached_deletePropertyNode_, this.uncached_nextElementIndexNode_);
                return;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAndSpecialize(DynamicObject arg0Value, ScriptArray arg1Value, long arg2Value, long arg3Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state_0 = this.state_0_;
        int exclude = this.exclude_;
        try {
            if ((exclude & 1) == 0) {
                ScriptArray cachedArrayType__;
                int count1_ = 0;
                DenseArrayData s1_ = this.denseArray_cache;
                if ((state_0 & 1) != 0) {
                    while (s1_ != null) {
                        if (s1_.cachedArrayType_.isInstance(arg1Value)) {
                            assert (!s1_.cachedArrayType_.isHolesType());
                            break;
                        }
                        s1_ = s1_.next_;
                        ++count1_;
                    }
                }
                if (s1_ == null && (cachedArrayType__ = arg1Value).isInstance(arg1Value) && !cachedArrayType__.isHolesType() && count1_ < 5) {
                    s1_ = (DenseArrayData)super.insert((Node)new DenseArrayData(this.denseArray_cache));
                    s1_.cachedArrayType_ = cachedArrayType__;
                    s1_.deletePropertyNode_ = s1_.insertAccessor(DeletePropertyNode.create(this.orThrow, this.context));
                    this.denseArray_cache = s1_;
                    this.state_0_ = state_0 |= 1;
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    this.denseArray(arg0Value, arg1Value, arg2Value, arg3Value, s1_.cachedArrayType_, s1_.deletePropertyNode_);
                    return;
                }
            }
            if ((exclude & 2) == 0) {
                ScriptArray cachedArrayType__1;
                int count2_ = 0;
                SparseArrayData s2_ = this.sparseArray_cache;
                if ((state_0 & 2) != 0) {
                    while (s2_ != null) {
                        if (s2_.cachedArrayType_.isInstance(arg1Value)) {
                            assert (s2_.cachedArrayType_.isHolesType());
                            break;
                        }
                        s2_ = s2_.next_;
                        ++count2_;
                    }
                }
                if (s2_ == null && (cachedArrayType__1 = arg1Value).isInstance(arg1Value) && cachedArrayType__1.isHolesType() && count2_ < 5) {
                    s2_ = (SparseArrayData)super.insert((Node)new SparseArrayData(this.sparseArray_cache));
                    s2_.cachedArrayType_ = cachedArrayType__1;
                    s2_.deletePropertyNode_ = s2_.insertAccessor(DeletePropertyNode.create(this.orThrow, this.context));
                    s2_.nextElementIndexNode_ = s2_.insertAccessor(JSArrayNextElementIndexNode.create(this.context));
                    this.sparseArray_cache = s2_;
                    this.state_0_ = state_0 |= 2;
                }
                if (s2_ != null) {
                    lock.unlock();
                    hasLock = false;
                    this.sparseArray(arg0Value, arg1Value, arg2Value, arg3Value, s2_.cachedArrayType_, s2_.deletePropertyNode_, s2_.nextElementIndexNode_);
                    return;
                }
            }
            this.uncached_deletePropertyNode_ = (DeletePropertyNode)super.insert((Node)DeletePropertyNode.create(this.orThrow, this.context));
            this.uncached_nextElementIndexNode_ = (JSArrayNextElementIndexNode)super.insert((Node)JSArrayNextElementIndexNode.create(this.context));
            this.exclude_ = exclude |= 3;
            this.denseArray_cache = null;
            this.sparseArray_cache = null;
            state_0 &= 0xFFFFFFFC;
            this.state_0_ = state_0 |= 4;
            lock.unlock();
            hasLock = false;
            this.doUncached(arg0Value, arg1Value, arg2Value, arg3Value, this.uncached_deletePropertyNode_, this.uncached_nextElementIndexNode_);
            return;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & state_0 - 1) == 0) {
            DenseArrayData s1_ = this.denseArray_cache;
            SparseArrayData s2_ = this.sparseArray_cache;
            if (!(s1_ != null && s1_.next_ != null || s2_ != null && s2_.next_ != null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[4];
        data[0] = 0;
        int state_0 = this.state_0_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "denseArray";
        if ((state_0 & 1) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            DenseArrayData s1_ = this.denseArray_cache;
            while (s1_ != null) {
                cached.add(Arrays.asList(new Object[]{s1_.cachedArrayType_, s1_.deletePropertyNode_}));
                s1_ = s1_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = (exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "sparseArray";
        if ((state_0 & 2) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            SparseArrayData s2_ = this.sparseArray_cache;
            while (s2_ != null) {
                cached.add(Arrays.asList(new Object[]{s2_.cachedArrayType_, s2_.deletePropertyNode_, s2_.nextElementIndexNode_}));
                s2_ = s2_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = (exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "doUncached";
        if ((state_0 & 4) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(new JavaScriptBaseNode[]{this.uncached_deletePropertyNode_, this.uncached_nextElementIndexNode_}));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[3] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static JSArrayDeleteRangeNode create(JSContext context, boolean orThrow) {
        return new JSArrayDeleteRangeNodeGen(context, orThrow);
    }

    @GeneratedBy(value=JSArrayDeleteRangeNode.class)
    private static final class SparseArrayData
    extends Node {
        @Node.Child
        SparseArrayData next_;
        @CompilerDirectives.CompilationFinal
        ScriptArray cachedArrayType_;
        @Node.Child
        DeletePropertyNode deletePropertyNode_;
        @Node.Child
        JSArrayNextElementIndexNode nextElementIndexNode_;

        SparseArrayData(SparseArrayData next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }

    @GeneratedBy(value=JSArrayDeleteRangeNode.class)
    private static final class DenseArrayData
    extends Node {
        @Node.Child
        DenseArrayData next_;
        @CompilerDirectives.CompilationFinal
        ScriptArray cachedArrayType_;
        @Node.Child
        DeletePropertyNode deletePropertyNode_;

        DenseArrayData(DenseArrayData next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

