/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.array.ArrayLengthNode;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=ArrayLengthNode.class)
public final class ArrayLengthNodeFactory {

    @GeneratedBy(value=ArrayLengthNode.SetArrayLengthOrDeleteNode.class)
    public static final class SetArrayLengthOrDeleteNodeGen
    extends ArrayLengthNode.SetArrayLengthOrDeleteNode
    implements Introspection.Provider {
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @CompilerDirectives.CompilationFinal
        private CachedData cached_cache;
        @CompilerDirectives.CompilationFinal
        private ConditionProfile generic_mustDeleteProfile_;
        @CompilerDirectives.CompilationFinal
        private ScriptArray.ProfileHolder generic_setLengthProfile_;

        private SetArrayLengthOrDeleteNodeGen(boolean strict) {
            super(strict);
        }

        @Override
        @ExplodeLoop
        public void executeVoid(DynamicObject arg0Value, int arg1Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0) {
                if ((state_0 & 1) != 0) {
                    CachedData s1_ = this.cached_cache;
                    while (s1_ != null) {
                        if (s1_.arrayType_.isInstance(ArrayLengthNode.getArrayType(arg0Value))) {
                            this.doCached(arg0Value, arg1Value, s1_.arrayType_, s1_.setLengthProfile_);
                            return;
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state_0 & 2) != 0) {
                    this.doGeneric(arg0Value, arg1Value, this.generic_mustDeleteProfile_, this.generic_setLengthProfile_);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(arg0Value, arg1Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeAndSpecialize(DynamicObject arg0Value, int arg1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            try {
                if (exclude == 0) {
                    ScriptArray arrayType__;
                    int count1_ = 0;
                    CachedData s1_ = this.cached_cache;
                    if ((state_0 & 1) != 0) {
                        while (s1_ != null && !s1_.arrayType_.isInstance(ArrayLengthNode.getArrayType(arg0Value))) {
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && (arrayType__ = ArrayLengthNode.getArrayType(arg0Value)).isInstance(ArrayLengthNode.getArrayType(arg0Value)) && count1_ < 4) {
                        s1_ = new CachedData(this.cached_cache);
                        s1_.arrayType_ = arrayType__;
                        s1_.setLengthProfile_ = ScriptArray.createSetLengthProfile();
                        this.cached_cache = s1_;
                        this.state_0_ = state_0 |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        this.doCached(arg0Value, arg1Value, s1_.arrayType_, s1_.setLengthProfile_);
                        return;
                    }
                }
                this.generic_mustDeleteProfile_ = ConditionProfile.createBinaryProfile();
                this.generic_setLengthProfile_ = ScriptArray.createSetLengthProfile();
                this.exclude_ = exclude |= 1;
                this.cached_cache = null;
                state_0 &= 0xFFFFFFFE;
                this.state_0_ = state_0 |= 2;
                lock.unlock();
                hasLock = false;
                this.doGeneric(arg0Value, arg1Value, this.generic_mustDeleteProfile_, this.generic_setLengthProfile_);
                return;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            CachedData s1_;
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0 && ((s1_ = this.cached_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            ArrayList<List<Object>> cached;
            Object[] data = new Object[3];
            data[0] = 0;
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            Object[] s = new Object[3];
            s[0] = "doCached";
            if ((state_0 & 1) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList<List<Object>>();
                CachedData s1_ = this.cached_cache;
                while (s1_ != null) {
                    cached.add(Arrays.asList(s1_.arrayType_, s1_.setLengthProfile_));
                    s1_ = s1_.next_;
                }
                s[2] = cached;
            } else {
                s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "doGeneric";
            if ((state_0 & 2) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.generic_mustDeleteProfile_, this.generic_setLengthProfile_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ArrayLengthNode.SetArrayLengthOrDeleteNode create(boolean strict) {
            return new SetArrayLengthOrDeleteNodeGen(strict);
        }

        @GeneratedBy(value=ArrayLengthNode.SetArrayLengthOrDeleteNode.class)
        private static final class CachedData {
            @CompilerDirectives.CompilationFinal
            CachedData next_;
            @CompilerDirectives.CompilationFinal
            ScriptArray arrayType_;
            @CompilerDirectives.CompilationFinal
            ScriptArray.ProfileHolder setLengthProfile_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }
        }
    }

    @GeneratedBy(value=ArrayLengthNode.SetArrayLengthNode.class)
    public static final class SetArrayLengthNodeGen
    extends ArrayLengthNode.SetArrayLengthNode
    implements Introspection.Provider {
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @CompilerDirectives.CompilationFinal
        private CachedData cached_cache;
        @CompilerDirectives.CompilationFinal
        private ConditionProfile generic_sealedProfile_;
        @CompilerDirectives.CompilationFinal
        private ScriptArray.ProfileHolder generic_setLengthProfile_;

        private SetArrayLengthNodeGen(boolean strict) {
            super(strict);
        }

        @Override
        @ExplodeLoop
        public void executeVoid(DynamicObject arg0Value, int arg1Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0) {
                if ((state_0 & 1) != 0) {
                    CachedData s1_ = this.cached_cache;
                    while (s1_ != null) {
                        if (s1_.arrayType_.isInstance(ArrayLengthNode.getArrayType(arg0Value))) {
                            this.doCached(arg0Value, arg1Value, s1_.arrayType_, s1_.setLengthProfile_);
                            return;
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state_0 & 2) != 0) {
                    this.doGeneric(arg0Value, arg1Value, this.generic_sealedProfile_, this.generic_setLengthProfile_);
                    return;
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(arg0Value, arg1Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeAndSpecialize(DynamicObject arg0Value, int arg1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            try {
                if (exclude == 0) {
                    ScriptArray arrayType__;
                    int count1_ = 0;
                    CachedData s1_ = this.cached_cache;
                    if ((state_0 & 1) != 0) {
                        while (s1_ != null && !s1_.arrayType_.isInstance(ArrayLengthNode.getArrayType(arg0Value))) {
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && (arrayType__ = ArrayLengthNode.getArrayType(arg0Value)).isInstance(ArrayLengthNode.getArrayType(arg0Value)) && count1_ < 4) {
                        s1_ = new CachedData(this.cached_cache);
                        s1_.arrayType_ = arrayType__;
                        s1_.setLengthProfile_ = ScriptArray.createSetLengthProfile();
                        this.cached_cache = s1_;
                        this.state_0_ = state_0 |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        this.doCached(arg0Value, arg1Value, s1_.arrayType_, s1_.setLengthProfile_);
                        return;
                    }
                }
                this.generic_sealedProfile_ = ConditionProfile.createBinaryProfile();
                this.generic_setLengthProfile_ = ScriptArray.createSetLengthProfile();
                this.exclude_ = exclude |= 1;
                this.cached_cache = null;
                state_0 &= 0xFFFFFFFE;
                this.state_0_ = state_0 |= 2;
                lock.unlock();
                hasLock = false;
                this.doGeneric(arg0Value, arg1Value, this.generic_sealedProfile_, this.generic_setLengthProfile_);
                return;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            CachedData s1_;
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0 && ((s1_ = this.cached_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            ArrayList<List<Object>> cached;
            Object[] data = new Object[3];
            data[0] = 0;
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            Object[] s = new Object[3];
            s[0] = "doCached";
            if ((state_0 & 1) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList<List<Object>>();
                CachedData s1_ = this.cached_cache;
                while (s1_ != null) {
                    cached.add(Arrays.asList(s1_.arrayType_, s1_.setLengthProfile_));
                    s1_ = s1_.next_;
                }
                s[2] = cached;
            } else {
                s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "doGeneric";
            if ((state_0 & 2) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                cached.add(Arrays.asList(this.generic_sealedProfile_, this.generic_setLengthProfile_));
                s[2] = cached;
            } else {
                s[1] = (byte)0;
            }
            data[2] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ArrayLengthNode.SetArrayLengthNode create(boolean strict) {
            return new SetArrayLengthNodeGen(strict);
        }

        @GeneratedBy(value=ArrayLengthNode.SetArrayLengthNode.class)
        private static final class CachedData {
            @CompilerDirectives.CompilationFinal
            CachedData next_;
            @CompilerDirectives.CompilationFinal
            ScriptArray arrayType_;
            @CompilerDirectives.CompilationFinal
            ScriptArray.ProfileHolder setLengthProfile_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }
        }
    }

    @GeneratedBy(value=ArrayLengthNode.ArrayLengthReadNode.class)
    public static final class ArrayLengthReadNodeGen
    extends ArrayLengthNode.ArrayLengthReadNode
    implements Introspection.Provider {
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @CompilerDirectives.CompilationFinal
        private IntLengthData intLength_cache;
        @CompilerDirectives.CompilationFinal
        private LongLengthData longLength_cache;

        private ArrayLengthReadNodeGen() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @ExplodeLoop
        public Object executeObject(DynamicObject arg0Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0) {
                if ((state_0 & 1) != 0) {
                    IntLengthData s1_ = this.intLength_cache;
                    while (s1_ != null) {
                        if (s1_.arrayType_.isInstance(ArrayLengthNode.getArrayType(arg0Value))) {
                            assert (ArrayLengthNode.ArrayLengthReadNode.isLengthAlwaysInt(s1_.arrayType_));
                            return ArrayLengthNode.ArrayLengthReadNode.doIntLength(arg0Value, s1_.arrayType_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state_0 & 2) != 0) {
                    LongLengthData s2_ = this.longLength_cache;
                    while (s2_ != null) {
                        if (s2_.arrayType_.isInstance(ArrayLengthNode.getArrayType(arg0Value))) {
                            return ArrayLengthNode.ArrayLengthReadNode.doLongLength(arg0Value, s2_.arrayType_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state_0 & 4) != 0) {
                    try {
                        return ArrayLengthNode.ArrayLengthReadNode.doUncachedIntLength(arg0Value);
                    }
                    catch (UnexpectedResultException ex) {
                        Lock lock = this.getLock();
                        lock.lock();
                        try {
                            this.exclude_ |= 4;
                            this.state_0_ &= 0xFFFFFFFB;
                        }
                        finally {
                            lock.unlock();
                        }
                        return ex.getResult();
                    }
                }
                if ((state_0 & 8) != 0) {
                    return ArrayLengthNode.ArrayLengthReadNode.doUncachedLongLength(arg0Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @ExplodeLoop
        public int executeInt(DynamicObject arg0Value) throws UnexpectedResultException {
            int state_0 = this.state_0_;
            if ((state_0 & 5) != 0) {
                if ((state_0 & 1) != 0) {
                    IntLengthData s1_ = this.intLength_cache;
                    while (s1_ != null) {
                        if (s1_.arrayType_.isInstance(ArrayLengthNode.getArrayType(arg0Value))) {
                            assert (ArrayLengthNode.ArrayLengthReadNode.isLengthAlwaysInt(s1_.arrayType_));
                            return ArrayLengthNode.ArrayLengthReadNode.doIntLength(arg0Value, s1_.arrayType_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state_0 & 4) != 0) {
                    try {
                        return ArrayLengthNode.ArrayLengthReadNode.doUncachedIntLength(arg0Value);
                    }
                    catch (UnexpectedResultException ex) {
                        Lock lock = this.getLock();
                        lock.lock();
                        try {
                            this.exclude_ |= 4;
                            this.state_0_ &= 0xFFFFFFFB;
                        }
                        finally {
                            lock.unlock();
                        }
                        return JSTypesGen.expectInteger(ex.getResult());
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return JSTypesGen.expectInteger(this.executeAndSpecialize(arg0Value));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private Object executeAndSpecialize(DynamicObject arg0Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            try {
                if ((exclude & 1) == 0) {
                    Object arrayType__;
                    int count1_ = 0;
                    IntLengthData s1_ = this.intLength_cache;
                    if ((state_0 & 1) != 0) {
                        while (s1_ != null) {
                            if (s1_.arrayType_.isInstance(ArrayLengthNode.getArrayType(arg0Value))) {
                                assert (ArrayLengthNode.ArrayLengthReadNode.isLengthAlwaysInt(s1_.arrayType_));
                                break;
                            }
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && ((ScriptArray)(arrayType__ = ArrayLengthNode.getArrayType(arg0Value))).isInstance(ArrayLengthNode.getArrayType(arg0Value)) && ArrayLengthNode.ArrayLengthReadNode.isLengthAlwaysInt((ScriptArray)arrayType__) && count1_ < 4) {
                        s1_ = new IntLengthData(this.intLength_cache);
                        s1_.arrayType_ = arrayType__;
                        this.intLength_cache = s1_;
                        this.state_0_ = state_0 |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        arrayType__ = ArrayLengthNode.ArrayLengthReadNode.doIntLength(arg0Value, s1_.arrayType_);
                        return arrayType__;
                    }
                }
                if ((exclude & 2) == 0) {
                    ScriptArray arrayType__1;
                    int count2_ = 0;
                    LongLengthData s2_ = this.longLength_cache;
                    if ((state_0 & 2) != 0) {
                        while (s2_ != null && !s2_.arrayType_.isInstance(ArrayLengthNode.getArrayType(arg0Value))) {
                            s2_ = s2_.next_;
                            ++count2_;
                        }
                    }
                    if (s2_ == null && (arrayType__1 = ArrayLengthNode.getArrayType(arg0Value)).isInstance(ArrayLengthNode.getArrayType(arg0Value)) && count2_ < 4) {
                        s2_ = new LongLengthData(this.longLength_cache);
                        s2_.arrayType_ = arrayType__1;
                        this.longLength_cache = s2_;
                        this.exclude_ = exclude |= 1;
                        this.intLength_cache = null;
                        state_0 &= 0xFFFFFFFE;
                        this.state_0_ = state_0 |= 2;
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        Double d = ArrayLengthNode.ArrayLengthReadNode.doLongLength(arg0Value, s2_.arrayType_);
                        return d;
                    }
                }
                if ((exclude & 4) == 0) {
                    this.exclude_ = exclude |= 3;
                    this.intLength_cache = null;
                    this.longLength_cache = null;
                    state_0 &= 0xFFFFFFFC;
                    this.state_0_ = state_0 |= 4;
                    try {
                        lock.unlock();
                        hasLock = false;
                        Integer count2_ = ArrayLengthNode.ArrayLengthReadNode.doUncachedIntLength(arg0Value);
                        return count2_;
                    }
                    catch (UnexpectedResultException ex) {
                        lock.lock();
                        try {
                            this.exclude_ |= 4;
                            this.state_0_ &= 0xFFFFFFFB;
                        }
                        finally {
                            lock.unlock();
                        }
                        Object object = ex.getResult();
                        if (hasLock) {
                            lock.unlock();
                        }
                        return object;
                    }
                }
                this.exclude_ = exclude |= 7;
                this.intLength_cache = null;
                this.longLength_cache = null;
                state_0 &= 0xFFFFFFF8;
                this.state_0_ = state_0 |= 8;
                lock.unlock();
                hasLock = false;
                Double d = ArrayLengthNode.ArrayLengthReadNode.doUncachedLongLength(arg0Value);
                return d;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0) {
                IntLengthData s1_ = this.intLength_cache;
                LongLengthData s2_ = this.longLength_cache;
                if (!(s1_ != null && s1_.next_ != null || s2_ != null && s2_.next_ != null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public Introspection getIntrospectionData() {
            ArrayList<List<ScriptArray>> cached;
            Object[] data = new Object[5];
            data[0] = 0;
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            Object[] s = new Object[3];
            s[0] = "doIntLength";
            if ((state_0 & 1) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList<List<ScriptArray>>();
                IntLengthData s1_ = this.intLength_cache;
                while (s1_ != null) {
                    cached.add(Arrays.asList(s1_.arrayType_));
                    s1_ = s1_.next_;
                }
                s[2] = cached;
            } else {
                s[1] = (exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
            }
            data[1] = s;
            s = new Object[3];
            s[0] = "doLongLength";
            if ((state_0 & 2) != 0) {
                s[1] = (byte)1;
                cached = new ArrayList();
                LongLengthData s2_ = this.longLength_cache;
                while (s2_ != null) {
                    cached.add(Arrays.asList(s2_.arrayType_));
                    s2_ = s2_.next_;
                }
                s[2] = cached;
            } else {
                s[1] = (exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
            }
            data[2] = s;
            s = new Object[3];
            s[0] = "doUncachedIntLength";
            s[1] = (state_0 & 4) != 0 ? Byte.valueOf((byte)1) : ((exclude & 4) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
            data[3] = s;
            s = new Object[3];
            s[0] = "doUncachedLongLength";
            s[1] = (state_0 & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
            data[4] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static ArrayLengthNode.ArrayLengthReadNode create() {
            return new ArrayLengthReadNodeGen();
        }

        @GeneratedBy(value=ArrayLengthNode.ArrayLengthReadNode.class)
        private static final class LongLengthData {
            @CompilerDirectives.CompilationFinal
            LongLengthData next_;
            @CompilerDirectives.CompilationFinal
            ScriptArray arrayType_;

            LongLengthData(LongLengthData next_) {
                this.next_ = next_;
            }
        }

        @GeneratedBy(value=ArrayLengthNode.ArrayLengthReadNode.class)
        private static final class IntLengthData {
            @CompilerDirectives.CompilationFinal
            IntLengthData next_;
            @CompilerDirectives.CompilationFinal
            ScriptArray arrayType_;

            IntLengthData(IntLengthData next_) {
                this.next_ = next_;
            }
        }
    }
}

