/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.IsJSClassNode;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=IsJSClassNode.class)
public final class IsJSClassNodeGen
extends IsJSClassNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @CompilerDirectives.CompilationFinal
    private IsInstanceShapeData isInstanceShape_cache;

    private IsJSClassNodeGen(JSClass jsclass, JavaScriptNode operand) {
        super(jsclass, operand);
    }

    @Override
    @ExplodeLoop
    public Object execute(VirtualFrame frameValue, Object operandNodeValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 3) != 0 && JSTypes.isDynamicObject(operandNodeValue)) {
            DynamicObject operandNodeValue_ = (DynamicObject)operandNodeValue;
            if ((state_0 & 1) != 0) {
                IsInstanceShapeData s1_ = this.isInstanceShape_cache;
                while (s1_ != null) {
                    if (s1_.cachedShape_.check(operandNodeValue_)) {
                        return IsJSClassNode.doIsInstanceShape(operandNodeValue_, s1_.cachedShape_, s1_.cachedResult_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state_0 & 2) != 0) {
                return this.doIsInstanceObject(operandNodeValue_);
            }
        }
        if ((state_0 & 4) != 0) {
            return this.doIsInstance(operandNodeValue);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue);
    }

    @Override
    @ExplodeLoop
    public boolean executeBoolean(Object operandNodeValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 3) != 0 && JSTypes.isDynamicObject(operandNodeValue)) {
            DynamicObject operandNodeValue_ = (DynamicObject)operandNodeValue;
            if ((state_0 & 1) != 0) {
                IsInstanceShapeData s1_ = this.isInstanceShape_cache;
                while (s1_ != null) {
                    if (s1_.cachedShape_.check(operandNodeValue_)) {
                        return IsJSClassNode.doIsInstanceShape(operandNodeValue_, s1_.cachedShape_, s1_.cachedResult_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state_0 & 2) != 0) {
                return this.doIsInstanceObject(operandNodeValue_);
            }
        }
        if ((state_0 & 4) != 0) {
            return this.doIsInstance(operandNodeValue);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue);
    }

    @Override
    @ExplodeLoop
    public Object execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object operandNodeValue_ = this.operandNode.execute(frameValue);
        if ((state_0 & 3) != 0 && JSTypes.isDynamicObject(operandNodeValue_)) {
            DynamicObject operandNodeValue__ = (DynamicObject)operandNodeValue_;
            if ((state_0 & 1) != 0) {
                IsInstanceShapeData s1_ = this.isInstanceShape_cache;
                while (s1_ != null) {
                    if (s1_.cachedShape_.check(operandNodeValue__)) {
                        return IsJSClassNode.doIsInstanceShape(operandNodeValue__, s1_.cachedShape_, s1_.cachedResult_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state_0 & 2) != 0) {
                return this.doIsInstanceObject(operandNodeValue__);
            }
        }
        if ((state_0 & 4) != 0) {
            return this.doIsInstance(operandNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue_);
    }

    @Override
    @ExplodeLoop
    public boolean executeBoolean(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object operandNodeValue_ = this.operandNode.execute(frameValue);
        if ((state_0 & 3) != 0 && JSTypes.isDynamicObject(operandNodeValue_)) {
            DynamicObject operandNodeValue__ = (DynamicObject)operandNodeValue_;
            if ((state_0 & 1) != 0) {
                IsInstanceShapeData s1_ = this.isInstanceShape_cache;
                while (s1_ != null) {
                    if (s1_.cachedShape_.check(operandNodeValue__)) {
                        return IsJSClassNode.doIsInstanceShape(operandNodeValue__, s1_.cachedShape_, s1_.cachedResult_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state_0 & 2) != 0) {
                return this.doIsInstanceObject(operandNodeValue__);
            }
        }
        if ((state_0 & 4) != 0) {
            return this.doIsInstance(operandNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(operandNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.executeBoolean(frameValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeAndSpecialize(Object operandNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state_0 = this.state_0_;
        int exclude = this.exclude_;
        try {
            if (JSTypes.isDynamicObject(operandNodeValue)) {
                DynamicObject operandNodeValue_ = (DynamicObject)operandNodeValue;
                if ((exclude & 1) == 0) {
                    Shape cachedShape__;
                    int count1_ = 0;
                    IsInstanceShapeData s1_ = this.isInstanceShape_cache;
                    if ((state_0 & 1) != 0) {
                        while (s1_ != null && !s1_.cachedShape_.check(operandNodeValue_)) {
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && (cachedShape__ = operandNodeValue_.getShape()).check(operandNodeValue_) && count1_ < 1) {
                        s1_ = new IsInstanceShapeData(this.isInstanceShape_cache);
                        s1_.cachedShape_ = cachedShape__;
                        s1_.cachedResult_ = this.doIsInstance(operandNodeValue_);
                        this.isInstanceShape_cache = s1_;
                        this.state_0_ = state_0 |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        boolean bl = IsJSClassNode.doIsInstanceShape(operandNodeValue_, s1_.cachedShape_, s1_.cachedResult_);
                        return bl;
                    }
                }
                if ((exclude & 2) == 0) {
                    this.exclude_ = exclude |= 1;
                    this.isInstanceShape_cache = null;
                    state_0 &= 0xFFFFFFFE;
                    this.state_0_ = state_0 |= 2;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = this.doIsInstanceObject(operandNodeValue_);
                    return bl;
                }
            }
            this.exclude_ = exclude |= 3;
            this.isInstanceShape_cache = null;
            state_0 &= 0xFFFFFFFC;
            this.state_0_ = state_0 |= 4;
            lock.unlock();
            hasLock = false;
            boolean bl = this.doIsInstance(operandNodeValue);
            return bl;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        IsInstanceShapeData s1_;
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & state_0 - 1) == 0 && ((s1_ = this.isInstanceShape_cache) == null || s1_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        Object[] data = new Object[4];
        data[0] = 0;
        int state_0 = this.state_0_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doIsInstanceShape";
        if ((state_0 & 1) != 0) {
            s[1] = (byte)1;
            ArrayList<List<Object>> cached = new ArrayList<List<Object>>();
            IsInstanceShapeData s1_ = this.isInstanceShape_cache;
            while (s1_ != null) {
                cached.add(Arrays.asList(s1_.cachedShape_, s1_.cachedResult_));
                s1_ = s1_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = (exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doIsInstanceObject";
        s[1] = (state_0 & 2) != 0 ? Byte.valueOf((byte)1) : ((exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[2] = s;
        s = new Object[3];
        s[0] = "doIsInstance";
        s[1] = (state_0 & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static IsJSClassNode create(JSClass jsclass, JavaScriptNode operand) {
        return new IsJSClassNodeGen(jsclass, operand);
    }

    @GeneratedBy(value=IsJSClassNode.class)
    private static final class IsInstanceShapeData {
        @CompilerDirectives.CompilationFinal
        IsInstanceShapeData next_;
        @CompilerDirectives.CompilationFinal
        Shape cachedShape_;
        @CompilerDirectives.CompilationFinal
        boolean cachedResult_;

        IsInstanceShapeData(IsInstanceShapeData next_) {
            this.next_ = next_;
        }
    }
}

