/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.intl;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.intl.RelativeTimeFormatPrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.intl.JSRelativeTimeFormat;

public final class RelativeTimeFormatPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<RelativeTimeFormatPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new RelativeTimeFormatPrototypeBuiltins();

    protected RelativeTimeFormatPrototypeBuiltins() {
        super("RelativeTimeFormat.prototype", RelativeTimeFormatPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, RelativeTimeFormatPrototype builtinEnum) {
        switch (builtinEnum) {
            case resolvedOptions: {
                return RelativeTimeFormatPrototypeBuiltinsFactory.JSRelativeTimeFormatResolvedOptionsNodeGen.create(context, builtin, RelativeTimeFormatPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case format: {
                return RelativeTimeFormatPrototypeBuiltinsFactory.JSRelativeTimeFormatFormatNodeGen.create(context, builtin, RelativeTimeFormatPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case formatToParts: {
                return RelativeTimeFormatPrototypeBuiltinsFactory.JSRelativeTimeFormatFormatToPartsNodeGen.create(context, builtin, RelativeTimeFormatPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static abstract class JSRelativeTimeFormatFormatToPartsNode
    extends JSBuiltinNode {
        public JSRelativeTimeFormatFormatToPartsNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSRelativeTimeFormat(relativeTimeFormat)"})
        public Object doFormatToParts(DynamicObject relativeTimeFormat, Object value, Object unit, @Cached(value="create()") JSToStringNode toStringNode, @Cached(value="create()") JSToNumberNode toNumberNode) {
            return JSRelativeTimeFormat.formatToParts(this.getContext(), relativeTimeFormat, JSRuntime.doubleValue(toNumberNode.executeNumber(value)), toStringNode.executeString(unit));
        }

        @Specialization(guards={"!isJSRelativeTimeFormat(bummer)"})
        public void throwTypeError(Object bummer, Object value, Object unit) {
            throw Errors.createTypeErrorTypeXExpected("RelativeTimeFormat");
        }
    }

    public static abstract class JSRelativeTimeFormatFormatNode
    extends JSBuiltinNode {
        public JSRelativeTimeFormatFormatNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSRelativeTimeFormat(relativeTimeFormat)"})
        public String doFormat(DynamicObject relativeTimeFormat, Object value, Object unit, @Cached(value="create()") JSToStringNode toStringNode, @Cached(value="create()") JSToNumberNode toNumberNode) {
            return JSRelativeTimeFormat.format(relativeTimeFormat, JSRuntime.doubleValue(toNumberNode.executeNumber(value)), toStringNode.executeString(unit));
        }

        @Specialization(guards={"!isJSRelativeTimeFormat(bummer)"})
        public void throwTypeError(Object bummer, Object value, Object unit) {
            throw Errors.createTypeErrorTypeXExpected("RelativeTimeFormat");
        }
    }

    public static abstract class JSRelativeTimeFormatResolvedOptionsNode
    extends JSBuiltinNode {
        public JSRelativeTimeFormatResolvedOptionsNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(guards={"isJSRelativeTimeFormat(relativeTimeFormat)"})
        public Object doResolvedOptions(DynamicObject relativeTimeFormat) {
            return JSRelativeTimeFormat.resolvedOptions(this.getContext(), relativeTimeFormat);
        }

        @Specialization(guards={"!isJSRelativeTimeFormat(bummer)"})
        public void doResolvedOptions(Object bummer) {
            throw Errors.createTypeErrorTypeXExpected("RelativeTimeFormat");
        }
    }

    public static enum RelativeTimeFormatPrototype implements BuiltinEnum<RelativeTimeFormatPrototype>
    {
        resolvedOptions(0),
        format(2),
        formatToParts(2);

        private final int length;

        private RelativeTimeFormatPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }
}

