/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.commonjs;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.js.builtins.GlobalBuiltins;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

final class CommonJSResolution {
    private static final String JS_EXT = ".js";
    private static final String JSON_EXT = ".json";
    private static final String NODE_EXT = ".node";
    public static final String INDEX_JS = "index.js";
    private static final String INDEX_JSON = "index.json";
    private static final String INDEX_NODE = "index.node";
    public static final String PACKAGE_JSON = "package.json";
    private static final String NODE_MODULES = "node_modules";
    public static final String PACKAGE_JSON_MAIN_PROPERTY_NAME = "main";
    public static final String PACKAGE_JSON_TYPE_PROPERTY_NAME = "type";
    public static final String PACKAGE_JSON_MODULE_VALUE = "module";
    private static final String[] CORE_MODULES = new String[]{"assert", "async_hooks", "buffer", "child_process", "cluster", "console", "constants", "crypto", "dgram", "diagnostics_channel", "dns", "domain", "events", "fs", "http", "http2", "https", "inspector", "module", "net", "os", "path", "perf_hooks", "process", "punycode", "querystring", "readline", "repl", "stream", "string_decoder", "sys", "timers", "tls", "trace_events", "tty", "url", "util", "v8", "vm", "wasi", "worker_threads", "zlib"};

    private CommonJSResolution() {
    }

    static boolean isCoreModule(String moduleIdentifier) {
        return Arrays.asList(CORE_MODULES).contains(moduleIdentifier);
    }

    static String getCurrentFileNameFromStack() {
        FrameInstance callerFrame = Truffle.getRuntime().getCallerFrame();
        if (callerFrame != null) {
            SourceSection encapsulatingSourceSection = null;
            if (callerFrame.getCallNode() != null) {
                encapsulatingSourceSection = callerFrame.getCallNode().getEncapsulatingSourceSection();
            } else {
                RootNode frameRootNode = JSFunction.getFrameRootNode(callerFrame);
                if (frameRootNode != null) {
                    encapsulatingSourceSection = frameRootNode.getEncapsulatingSourceSection();
                }
            }
            if (encapsulatingSourceSection != null && encapsulatingSourceSection.getSource() != null) {
                Source source = encapsulatingSourceSection.getSource();
                return source.getPath();
            }
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    static TruffleFile resolve(JSContext context, String moduleIdentifier, TruffleFile entryPath) {
        TruffleFile module;
        if ("".equals(moduleIdentifier)) {
            return null;
        }
        TruffleLanguage.Env env = context.getRealm().getEnv();
        TruffleFile currentWorkingPath = entryPath;
        if (moduleIdentifier.charAt(0) == '/') {
            currentWorkingPath = CommonJSResolution.getFileSystemRootPath(env);
        }
        if (CommonJSResolution.isPathFileName(moduleIdentifier) && (module = CommonJSResolution.loadAsFileOrDirectory(context, env, CommonJSResolution.joinPaths(env, currentWorkingPath, moduleIdentifier))) != null) {
            return module;
        }
        return CommonJSResolution.loadNodeModulesOrSelfReference(context, env, moduleIdentifier, currentWorkingPath);
    }

    private static TruffleFile loadNodeModulesOrSelfReference(JSContext cx, TruffleLanguage.Env env, String moduleIdentifier, TruffleFile startFolder) {
        List<TruffleFile> nodeModulesPaths = CommonJSResolution.getNodeModulesPaths(startFolder);
        for (TruffleFile s : nodeModulesPaths) {
            TruffleFile module = CommonJSResolution.loadAsFileOrDirectory(cx, env, CommonJSResolution.joinPaths(env, s, moduleIdentifier));
            if (module == null) continue;
            return module;
        }
        return null;
    }

    public static TruffleFile loadIndex(TruffleLanguage.Env env, TruffleFile modulePath) {
        TruffleFile indexJs = CommonJSResolution.joinPaths(env, modulePath, INDEX_JS);
        if (CommonJSResolution.fileExists(indexJs)) {
            return indexJs;
        }
        TruffleFile indexJson = CommonJSResolution.joinPaths(env, modulePath, INDEX_JSON);
        if (CommonJSResolution.fileExists(indexJson)) {
            return indexJson;
        }
        if (CommonJSResolution.fileExists(CommonJSResolution.joinPaths(env, modulePath, INDEX_NODE))) {
            return null;
        }
        return null;
    }

    static TruffleFile loadAsFile(TruffleLanguage.Env env, TruffleFile modulePath) {
        if (CommonJSResolution.fileExists(modulePath)) {
            return modulePath;
        }
        TruffleFile moduleJs = env.getPublicTruffleFile(modulePath.toString() + JS_EXT);
        if (CommonJSResolution.fileExists(moduleJs)) {
            return moduleJs;
        }
        TruffleFile moduleJson = env.getPublicTruffleFile(modulePath.toString() + JSON_EXT);
        if (CommonJSResolution.fileExists(moduleJson)) {
            return moduleJson;
        }
        if (CommonJSResolution.fileExists(env.getPublicTruffleFile(modulePath.toString() + NODE_EXT))) {
            return null;
        }
        return null;
    }

    public static List<TruffleFile> getNodeModulesPaths(TruffleFile path) {
        ArrayList<TruffleFile> list = new ArrayList<TruffleFile>();
        List<TruffleFile> paths = CommonJSResolution.getAllParentPaths(path);
        for (TruffleFile p : paths) {
            if (p.endsWith(NODE_MODULES)) {
                list.add(p);
                continue;
            }
            TruffleFile truffleFile = p.resolve(NODE_MODULES);
            list.add(truffleFile);
        }
        return list;
    }

    private static TruffleFile loadAsFileOrDirectory(JSContext cx, TruffleLanguage.Env env, TruffleFile modulePath) {
        TruffleFile maybeFile = CommonJSResolution.loadAsFile(env, modulePath);
        if (maybeFile == null) {
            return CommonJSResolution.loadAsDirectory(cx, env, modulePath);
        }
        return maybeFile;
    }

    private static List<TruffleFile> getAllParentPaths(TruffleFile from) {
        ArrayList<TruffleFile> paths = new ArrayList<TruffleFile>();
        for (TruffleFile p = from; p != null; p = p.getParent()) {
            paths.add(p);
        }
        return paths;
    }

    private static TruffleFile loadAsDirectory(JSContext cx, TruffleLanguage.Env env, TruffleFile modulePath) {
        TruffleFile packageJson = CommonJSResolution.joinPaths(env, modulePath, PACKAGE_JSON);
        if (CommonJSResolution.fileExists(packageJson)) {
            DynamicObject jsonObj = CommonJSResolution.loadJsonObject(packageJson, cx);
            if (JSDynamicObject.isJSDynamicObject(jsonObj)) {
                Object main = JSObject.get(jsonObj, (Object)PACKAGE_JSON_MAIN_PROPERTY_NAME);
                if (!JSRuntime.isString(main)) {
                    return CommonJSResolution.loadIndex(env, modulePath);
                }
                TruffleFile module = CommonJSResolution.joinPaths(env, modulePath, JSRuntime.safeToString(main));
                TruffleFile asFile = CommonJSResolution.loadAsFile(env, module);
                if (asFile != null) {
                    return asFile;
                }
                return CommonJSResolution.loadIndex(env, module);
            }
        } else {
            return CommonJSResolution.loadIndex(env, modulePath);
        }
        return null;
    }

    public static DynamicObject loadJsonObject(TruffleFile jsonFile, JSContext context) {
        try {
            if (CommonJSResolution.fileExists(jsonFile)) {
                Source source = null;
                JSRealm realm = context.getRealm();
                TruffleFile file = GlobalBuiltins.resolveRelativeFilePath(jsonFile.toString(), realm.getEnv());
                if (file.isRegularFile(new LinkOption[0])) {
                    source = CommonJSResolution.sourceFromTruffleFile(file);
                }
                if (source == null) {
                    return null;
                }
                DynamicObject parse = (DynamicObject)realm.getJsonParseFunctionObject();
                String jsonString = source.getCharacters().toString();
                Object jsonObj = JSFunction.call(JSArguments.create(parse, parse, jsonString));
                if (JSDynamicObject.isJSDynamicObject(jsonObj)) {
                    return (DynamicObject)jsonObj;
                }
            }
            return null;
        }
        catch (IllegalArgumentException | SecurityException | UnsupportedOperationException e) {
            throw Errors.createErrorFromException(e);
        }
    }

    private static Source sourceFromTruffleFile(TruffleFile file) {
        try {
            return Source.newBuilder((String)"js", (TruffleFile)file).build();
        }
        catch (IOException | IllegalArgumentException | SecurityException | UnsupportedOperationException e) {
            return null;
        }
    }

    public static boolean fileExists(TruffleFile modulePath) {
        return modulePath.exists(new LinkOption[0]) && modulePath.isRegularFile(new LinkOption[0]);
    }

    private static boolean isPathFileName(String moduleIdentifier) {
        return moduleIdentifier.startsWith("/") || moduleIdentifier.startsWith("./") || moduleIdentifier.startsWith("../");
    }

    public static TruffleFile joinPaths(TruffleLanguage.Env env, TruffleFile p1, String p2) {
        Objects.requireNonNull(p1);
        String pathSeparator = env.getFileNameSeparator();
        String pathName = p1.normalize().toString();
        TruffleFile truffleFile = env.getPublicTruffleFile(pathName + pathSeparator + p2);
        return truffleFile.normalize();
    }

    private static TruffleFile getFileSystemRootPath(TruffleLanguage.Env env) {
        TruffleFile root;
        TruffleFile last = root = env.getCurrentWorkingDirectory();
        while (root != null) {
            last = root;
            root = root.getParent();
        }
        return last;
    }
}

