/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.array.dyn;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.array.DynamicArray;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractConstantArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractConstantEmptyArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractWritableArray;
import com.oracle.truffle.js.runtime.array.dyn.ArrayCopy;
import com.oracle.truffle.js.runtime.array.dyn.HolesDoubleArray;
import com.oracle.truffle.js.runtime.array.dyn.ZeroBasedDoubleArray;
import com.oracle.truffle.js.runtime.array.dyn.ZeroBasedObjectArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;

public final class ConstantDoubleArray
extends AbstractConstantArray {
    private static final ConstantDoubleArray CONSTANT_DOUBLE_ARRAY = new ConstantDoubleArray(0, ConstantDoubleArray.createCache());

    public static ConstantDoubleArray createConstantDoubleArray() {
        return CONSTANT_DOUBLE_ARRAY;
    }

    private ConstantDoubleArray(int integrityLevel, DynamicArray.DynamicArrayCache cache) {
        super(integrityLevel, cache);
    }

    @Override
    public Object getElementInBounds(DynamicObject object, int index, boolean condition) {
        return ConstantDoubleArray.getElementDouble(object, index, condition);
    }

    public static double getElementDouble(DynamicObject object, int index, boolean condition) {
        return ConstantDoubleArray.getArray(object, condition)[index];
    }

    public static double[] getArray(DynamicObject object) {
        return (double[])JSAbstractArray.arrayGetArray(object);
    }

    public static double[] getArray(DynamicObject object, boolean condition) {
        return (double[])JSAbstractArray.arrayGetArray(object, condition);
    }

    @Override
    public int lengthInt(DynamicObject object, boolean condition) {
        return ConstantDoubleArray.getArray(object, condition).length;
    }

    @Override
    public boolean hasElement(DynamicObject object, long index, boolean condition) {
        return index >= 0L && index < (long)ConstantDoubleArray.getArray(object, condition).length;
    }

    @Override
    public Object[] toArray(DynamicObject object) {
        return ArrayCopy.doubleToObject(ConstantDoubleArray.getArray(object));
    }

    @Override
    public ScriptArray deleteElementImpl(DynamicObject object, long index, boolean strict, boolean condition) {
        return this.createWriteableDouble(object, index, HolesDoubleArray.HOLE_VALUE_DOUBLE, condition, ScriptArray.ProfileHolder.empty()).deleteElementImpl(object, index, condition, condition);
    }

    @Override
    public ScriptArray setLengthImpl(DynamicObject object, long length, boolean condition, ScriptArray.ProfileHolder profile) {
        return this.createWriteableDouble(object, length - 1L, HolesDoubleArray.HOLE_VALUE_DOUBLE, condition, ScriptArray.ProfileHolder.empty()).setLengthImpl(object, length, condition, profile);
    }

    @Override
    public ZeroBasedDoubleArray createWriteableInt(DynamicObject object, long index, int value, boolean condition, ScriptArray.ProfileHolder profile) {
        return this.createWriteableDouble(object, index, value, condition, profile);
    }

    @Override
    public ZeroBasedDoubleArray createWriteableDouble(DynamicObject object, long index, double value, boolean condition, ScriptArray.ProfileHolder profile) {
        double[] doubleCopy = ArrayCopy.doubleToDouble(ConstantDoubleArray.getArray(object, condition));
        ZeroBasedDoubleArray newArray = ZeroBasedDoubleArray.makeZeroBasedDoubleArray(object, doubleCopy.length, doubleCopy.length, doubleCopy, this.integrityLevel);
        if (JSConfig.TraceArrayTransitions) {
            ConstantDoubleArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    public AbstractWritableArray createWriteableJSObject(DynamicObject object, long index, DynamicObject value, boolean condition, ScriptArray.ProfileHolder profile) {
        return this.createWriteableObject(object, index, value, condition, profile);
    }

    @Override
    public ZeroBasedObjectArray createWriteableObject(DynamicObject object, long index, Object value, boolean condition, ScriptArray.ProfileHolder profile) {
        Object[] doubleCopy = ArrayCopy.doubleToObject(ConstantDoubleArray.getArray(object, condition));
        ZeroBasedObjectArray newArray = ZeroBasedObjectArray.makeZeroBasedObjectArray(object, doubleCopy.length, doubleCopy.length, doubleCopy, this.integrityLevel);
        if (JSConfig.TraceArrayTransitions) {
            ConstantDoubleArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    public ScriptArray removeRangeImpl(DynamicObject object, long start, long end) {
        double[] array = ConstantDoubleArray.getArray(object);
        if ((long)array.length - (end - start) == 0L) {
            AbstractConstantEmptyArray.setCapacity(object, 0L);
        } else {
            double[] newArray = new double[array.length - (int)(end - start)];
            System.arraycopy(array, 0, newArray, 0, (int)start);
            System.arraycopy(array, (int)end, newArray, (int)start, (int)((long)array.length - end));
            JSAbstractArray.arraySetArray(object, newArray);
        }
        return this;
    }

    @Override
    public ScriptArray addRangeImpl(DynamicObject object, long offset, int size) {
        double[] array = ConstantDoubleArray.getArray(object);
        if (array.length == 0) {
            AbstractConstantEmptyArray.setCapacity(object, size);
            return this;
        }
        double[] newArray = new double[array.length + size];
        System.arraycopy(array, 0, newArray, 0, (int)offset);
        System.arraycopy(array, (int)offset, newArray, (int)offset + size, (int)((long)array.length - offset));
        JSAbstractArray.arraySetArray(object, newArray);
        return this;
    }

    @Override
    protected DynamicArray withIntegrityLevel(int newIntegrityLevel) {
        return new ConstantDoubleArray(newIntegrityLevel, this.cache);
    }
}

