/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.objects.JSLazyString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSToObjectNode.class)
public final class JSToObjectNodeGen
extends JSToObjectNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private volatile int state_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @CompilerDirectives.CompilationFinal
    private JSObjectNoCheckShapeData jSObjectNoCheckShape_cache;
    @CompilerDirectives.CompilationFinal
    private JSObjectCheckShapeData jSObjectCheckShape_cache;
    @CompilerDirectives.CompilationFinal
    private JSClass jSObjectCheckJSClass_cachedClass_;

    private JSToObjectNodeGen(JSContext context, boolean checkForNullOrUndefined, boolean fromWith, boolean allowForeign) {
        super(context, checkForNullOrUndefined, fromWith, allowForeign);
    }

    @Override
    @ExplodeLoop
    public Object execute(Object arg0Value) {
        int state = this.state_;
        if ((state & 1) != 0 && arg0Value instanceof Boolean) {
            boolean arg0Value_ = (Boolean)arg0Value;
            return this.doBoolean(arg0Value_);
        }
        if ((state & 2) != 0 && arg0Value instanceof JSLazyString) {
            JSLazyString arg0Value_ = (JSLazyString)arg0Value;
            return this.doJSLazyString(arg0Value_);
        }
        if ((state & 4) != 0 && JSTypesGen.isImplicitString((state & 0xF0000) >>> 16, arg0Value)) {
            String arg0Value_ = JSTypesGen.asImplicitString((state & 0xF0000) >>> 16, arg0Value);
            return this.doString(arg0Value_);
        }
        if ((state & 8) != 0 && arg0Value instanceof Integer) {
            int arg0Value_ = (Integer)arg0Value;
            return this.doInt(arg0Value_);
        }
        if ((state & 0x10) != 0 && JSTypesGen.isImplicitDouble((state & 0xF00000) >>> 20, arg0Value)) {
            double arg0Value_ = JSTypesGen.asImplicitDouble((state & 0xF00000) >>> 20, arg0Value);
            return this.doDouble(arg0Value_);
        }
        if ((state & 0x20) != 0 && arg0Value instanceof BigInt) {
            BigInt arg0Value_ = (BigInt)arg0Value;
            return this.doBigInt(arg0Value_);
        }
        if ((state & 0x40) != 0 && JSGuards.isJavaNumber(arg0Value)) {
            return this.doNumber(arg0Value);
        }
        if ((state & 0x80) != 0 && arg0Value instanceof Symbol) {
            Symbol arg0Value_ = (Symbol)arg0Value;
            return this.doSymbol(arg0Value_);
        }
        if ((state & 0x3F00) != 0 && JSTypes.isDynamicObject(arg0Value)) {
            DynamicObject arg0Value_ = (DynamicObject)arg0Value;
            if ((state & 0x100) != 0) {
                JSObjectNoCheckShapeData s9_ = this.jSObjectNoCheckShape_cache;
                while (s9_ != null) {
                    if (s9_.shape_.check(arg0Value_)) {
                        assert (JSGuards.isJSObjectShape(s9_.shape_));
                        assert (!this.isCheckForNullOrUndefined());
                        return this.doJSObjectNoCheckShape(arg0Value_, s9_.shape_);
                    }
                    s9_ = s9_.next_;
                }
            }
            if ((state & 0x200) != 0 && JSGuards.isJSType(arg0Value_)) {
                assert (!this.isCheckForNullOrUndefined());
                return this.doJSObjectNoCheck(arg0Value_);
            }
            if ((state & 0x400) != 0) {
                JSObjectCheckShapeData s11_ = this.jSObjectCheckShape_cache;
                while (s11_ != null) {
                    if (s11_.shape_.check(arg0Value_)) {
                        assert (JSGuards.isJSObjectShape(s11_.shape_));
                        assert (JSToObjectNode.isNotNullOrUndefined(s11_.shape_));
                        assert (this.isCheckForNullOrUndefined());
                        return this.doJSObjectCheckShape(arg0Value_, s11_.shape_);
                    }
                    s11_ = s11_.next_;
                }
            }
            if ((state & 0x800) != 0) {
                assert (this.isCheckForNullOrUndefined());
                assert (this.jSObjectCheckJSClass_cachedClass_ != null);
                if (this.jSObjectCheckJSClass_cachedClass_.isInstance(arg0Value_)) {
                    return this.doJSObjectCheckJSClass(arg0Value_, this.jSObjectCheckJSClass_cachedClass_);
                }
            }
            if ((state & 0x1000) != 0 && JSGuards.isJSObject(arg0Value_)) {
                assert (this.isCheckForNullOrUndefined());
                return this.doJSObjectCheck(arg0Value_);
            }
            if ((state & 0x2000) != 0 && JSGuards.isNullOrUndefined(arg0Value_)) {
                assert (this.isCheckForNullOrUndefined());
                return this.doNullOrUndefined(arg0Value_);
            }
        }
        if ((state & 0xC000) != 0) {
            if ((state & 0x4000) != 0 && JSGuards.isForeignObject(arg0Value)) {
                return this.doForeignTruffleObject(arg0Value);
            }
            if (!((state & 0x8000) == 0 || JSGuards.isBoolean(arg0Value) || JSGuards.isNumber(arg0Value) || JSGuards.isString(arg0Value) || JSGuards.isSymbol(arg0Value) || JSGuards.isJSObject(arg0Value) || JSGuards.isForeignObject(arg0Value))) {
                return this.doJavaGeneric(arg0Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    private Object executeAndSpecialize(Object arg0Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_ = (Boolean)arg0Value;
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                DynamicObject dynamicObject = this.doBoolean(arg0Value_);
                return dynamicObject;
            }
            if (arg0Value instanceof JSLazyString) {
                JSLazyString arg0Value_ = (JSLazyString)arg0Value;
                this.state_ = state |= 2;
                lock.unlock();
                hasLock = false;
                DynamicObject dynamicObject = this.doJSLazyString(arg0Value_);
                return dynamicObject;
            }
            int stringCast0 = JSTypesGen.specializeImplicitString(arg0Value);
            if (stringCast0 != 0) {
                String arg0Value_2 = JSTypesGen.asImplicitString(stringCast0, arg0Value);
                state |= stringCast0 << 16;
                this.state_ = state |= 4;
                lock.unlock();
                hasLock = false;
                DynamicObject dynamicObject = this.doString(arg0Value_2);
                return dynamicObject;
            }
            if (arg0Value instanceof Integer) {
                int arg0Value_ = (Integer)arg0Value;
                this.state_ = state |= 8;
                lock.unlock();
                hasLock = false;
                DynamicObject arg0Value_2 = this.doInt(arg0Value_);
                return arg0Value_2;
            }
            int doubleCast0 = JSTypesGen.specializeImplicitDouble(arg0Value);
            if (doubleCast0 != 0) {
                double arg0Value_3 = JSTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                state |= doubleCast0 << 20;
                this.state_ = state |= 0x10;
                lock.unlock();
                hasLock = false;
                DynamicObject dynamicObject = this.doDouble(arg0Value_3);
                return dynamicObject;
            }
            if (arg0Value instanceof BigInt) {
                BigInt arg0Value_ = (BigInt)arg0Value;
                this.state_ = state |= 0x20;
                lock.unlock();
                hasLock = false;
                DynamicObject arg0Value_3 = this.doBigInt(arg0Value_);
                return arg0Value_3;
            }
            if (JSGuards.isJavaNumber(arg0Value)) {
                this.state_ = state |= 0x40;
                lock.unlock();
                hasLock = false;
                DynamicObject arg0Value_ = this.doNumber(arg0Value);
                return arg0Value_;
            }
            if (arg0Value instanceof Symbol) {
                Symbol arg0Value_ = (Symbol)arg0Value;
                this.state_ = state |= 0x80;
                lock.unlock();
                hasLock = false;
                DynamicObject arg0Value_3 = this.doSymbol(arg0Value_);
                return arg0Value_3;
            }
            if (JSTypes.isDynamicObject(arg0Value)) {
                DynamicObject arg0Value_ = (DynamicObject)arg0Value;
                if ((exclude & 1) == 0) {
                    Shape shape__;
                    int count9_ = 0;
                    JSObjectNoCheckShapeData s9_ = this.jSObjectNoCheckShape_cache;
                    if ((state & 0x100) != 0) {
                        while (s9_ != null) {
                            if (s9_.shape_.check(arg0Value_)) {
                                assert (JSGuards.isJSObjectShape(s9_.shape_));
                                assert (!this.isCheckForNullOrUndefined());
                                break;
                            }
                            s9_ = s9_.next_;
                            ++count9_;
                        }
                    }
                    if (s9_ == null && (shape__ = arg0Value_.getShape()).check(arg0Value_) && JSGuards.isJSObjectShape(shape__) && !this.isCheckForNullOrUndefined() && count9_ < 1) {
                        s9_ = new JSObjectNoCheckShapeData(this.jSObjectNoCheckShape_cache);
                        s9_.shape_ = shape__;
                        this.jSObjectNoCheckShape_cache = s9_;
                        this.state_ = state |= 0x100;
                    }
                    if (s9_ != null) {
                        lock.unlock();
                        hasLock = false;
                        shape__ = this.doJSObjectNoCheckShape(arg0Value_, s9_.shape_);
                        return shape__;
                    }
                }
                if (JSGuards.isJSType(arg0Value_) && !this.isCheckForNullOrUndefined()) {
                    this.exclude_ = exclude |= 1;
                    this.jSObjectNoCheckShape_cache = null;
                    state &= 0xFFFFFEFF;
                    this.state_ = state |= 0x200;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject count9_ = this.doJSObjectNoCheck(arg0Value_);
                    return count9_;
                }
                if ((exclude & 2) == 0) {
                    Shape shape__1;
                    int count11_ = 0;
                    JSObjectCheckShapeData s11_ = this.jSObjectCheckShape_cache;
                    if ((state & 0x400) != 0) {
                        while (s11_ != null) {
                            if (s11_.shape_.check(arg0Value_)) {
                                assert (JSGuards.isJSObjectShape(s11_.shape_));
                                assert (JSToObjectNode.isNotNullOrUndefined(s11_.shape_));
                                assert (this.isCheckForNullOrUndefined());
                                break;
                            }
                            s11_ = s11_.next_;
                            ++count11_;
                        }
                    }
                    if (s11_ == null && (shape__1 = arg0Value_.getShape()).check(arg0Value_) && JSGuards.isJSObjectShape(shape__1) && JSToObjectNode.isNotNullOrUndefined(shape__1) && this.isCheckForNullOrUndefined() && count11_ < 1) {
                        s11_ = new JSObjectCheckShapeData(this.jSObjectCheckShape_cache);
                        s11_.shape_ = shape__1;
                        this.jSObjectCheckShape_cache = s11_;
                        this.state_ = state |= 0x400;
                    }
                    if (s11_ != null) {
                        lock.unlock();
                        hasLock = false;
                        DynamicObject dynamicObject = this.doJSObjectCheckShape(arg0Value_, s11_.shape_);
                        return dynamicObject;
                    }
                }
                if ((exclude & 4) == 0) {
                    JSClass jSObjectCheckJSClass_cachedClass__;
                    boolean JSObjectCheckJSClass_duplicateFound_ = false;
                    if ((state & 0x800) != 0) {
                        assert (this.isCheckForNullOrUndefined());
                        assert (this.jSObjectCheckJSClass_cachedClass_ != null);
                        if (this.jSObjectCheckJSClass_cachedClass_.isInstance(arg0Value_)) {
                            JSObjectCheckJSClass_duplicateFound_ = true;
                        }
                    }
                    if (!JSObjectCheckJSClass_duplicateFound_ && this.isCheckForNullOrUndefined() && (jSObjectCheckJSClass_cachedClass__ = JSGuards.getJSClassIfObject(arg0Value_)) != null && jSObjectCheckJSClass_cachedClass__.isInstance(arg0Value_) && (state & 0x800) == 0) {
                        this.jSObjectCheckJSClass_cachedClass_ = jSObjectCheckJSClass_cachedClass__;
                        this.exclude_ = exclude |= 2;
                        this.jSObjectCheckShape_cache = null;
                        state &= 0xFFFFFBFF;
                        this.state_ = state |= 0x800;
                        JSObjectCheckJSClass_duplicateFound_ = true;
                    }
                    if (JSObjectCheckJSClass_duplicateFound_) {
                        lock.unlock();
                        hasLock = false;
                        DynamicObject dynamicObject = this.doJSObjectCheckJSClass(arg0Value_, this.jSObjectCheckJSClass_cachedClass_);
                        return dynamicObject;
                    }
                }
                if (JSGuards.isJSObject(arg0Value_) && this.isCheckForNullOrUndefined()) {
                    this.exclude_ = exclude |= 6;
                    this.jSObjectCheckShape_cache = null;
                    state &= 0xFFFFF3FF;
                    this.state_ = state |= 0x1000;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.doJSObjectCheck(arg0Value_);
                    return dynamicObject;
                }
                if (JSGuards.isNullOrUndefined(arg0Value_) && this.isCheckForNullOrUndefined()) {
                    this.state_ = state |= 0x2000;
                    lock.unlock();
                    hasLock = false;
                    DynamicObject dynamicObject = this.doNullOrUndefined(arg0Value_);
                    return dynamicObject;
                }
            }
            if (JSGuards.isForeignObject(arg0Value)) {
                this.state_ = state |= 0x4000;
                lock.unlock();
                hasLock = false;
                Object object = this.doForeignTruffleObject(arg0Value);
                return object;
            }
            if (!(JSGuards.isBoolean(arg0Value) || JSGuards.isNumber(arg0Value) || JSGuards.isString(arg0Value) || JSGuards.isSymbol(arg0Value) || JSGuards.isJSObject(arg0Value) || JSGuards.isForeignObject(arg0Value))) {
                this.state_ = state |= 0x8000;
                lock.unlock();
                hasLock = false;
                Object object = this.doJavaGeneric(arg0Value);
                return object;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if ((state & 0xFFFF) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 0xFFFF & (state & 0xFFFF) - 1) == 0) {
            JSObjectNoCheckShapeData s9_ = this.jSObjectNoCheckShape_cache;
            JSObjectCheckShapeData s11_ = this.jSObjectCheckShape_cache;
            if (!(s9_ != null && s9_.next_ != null || s11_ != null && s11_.next_ != null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[17];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doBoolean";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "doJSLazyString";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doString";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "doInt";
        s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        s = new Object[3];
        s[0] = "doDouble";
        s[1] = (state & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[5] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        s[1] = (state & 0x20) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[6] = s;
        s = new Object[3];
        s[0] = "doNumber";
        s[1] = (state & 0x40) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[7] = s;
        s = new Object[3];
        s[0] = "doSymbol";
        s[1] = (state & 0x80) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[8] = s;
        s = new Object[3];
        s[0] = "doJSObjectNoCheckShape";
        if ((state & 0x100) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            JSObjectNoCheckShapeData s9_ = this.jSObjectNoCheckShape_cache;
            while (s9_ != null) {
                cached.add(Arrays.asList(s9_.shape_));
                s9_ = s9_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = (exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[9] = s;
        s = new Object[3];
        s[0] = "doJSObjectNoCheck";
        s[1] = (state & 0x200) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[10] = s;
        s = new Object[3];
        s[0] = "doJSObjectCheckShape";
        if ((state & 0x400) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            JSObjectCheckShapeData s11_ = this.jSObjectCheckShape_cache;
            while (s11_ != null) {
                cached.add(Arrays.asList(s11_.shape_));
                s11_ = s11_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = (exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[11] = s;
        s = new Object[3];
        s[0] = "doJSObjectCheckJSClass";
        if ((state & 0x800) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.jSObjectCheckJSClass_cachedClass_));
            s[2] = cached;
        } else {
            s[1] = (exclude & 4) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[12] = s;
        s = new Object[3];
        s[0] = "doJSObjectCheck";
        s[1] = (state & 0x1000) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[13] = s;
        s = new Object[3];
        s[0] = "doNullOrUndefined";
        s[1] = (state & 0x2000) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[14] = s;
        s = new Object[3];
        s[0] = "doForeignTruffleObject";
        s[1] = (state & 0x4000) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[15] = s;
        s = new Object[3];
        s[0] = "doJavaGeneric";
        s[1] = (state & 0x8000) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[16] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static JSToObjectNode create(JSContext context, boolean checkForNullOrUndefined, boolean fromWith, boolean allowForeign) {
        return new JSToObjectNodeGen(context, checkForNullOrUndefined, fromWith, allowForeign);
    }

    @GeneratedBy(value=JSToObjectNode.JSToObjectWrapperNode.class)
    public static final class JSToObjectWrapperNodeGen
    extends JSToObjectNode.JSToObjectWrapperNode
    implements Introspection.Provider {
        private JSToObjectWrapperNodeGen(JavaScriptNode operand, JSToObjectNode toObjectNode) {
            super(operand, toObjectNode);
        }

        @Override
        public Object execute(VirtualFrame frameValue, Object operandNodeValue) {
            return this.doDefault(operandNodeValue);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object operandNodeValue_ = this.operandNode.execute(frameValue);
            return this.doDefault(operandNodeValue_);
        }

        @Override
        public DynamicObject executeDynamicObject(Object operandNodeValue) {
            return (DynamicObject)this.execute(null, operandNodeValue);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "doDefault";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static JSToObjectNode.JSToObjectWrapperNode create(JavaScriptNode operand, JSToObjectNode toObjectNode) {
            return new JSToObjectWrapperNodeGen(operand, toObjectNode);
        }
    }

    @GeneratedBy(value=JSToObjectNode.class)
    private static final class JSObjectCheckShapeData {
        @CompilerDirectives.CompilationFinal
        JSObjectCheckShapeData next_;
        @CompilerDirectives.CompilationFinal
        Shape shape_;

        JSObjectCheckShapeData(JSObjectCheckShapeData next_) {
            this.next_ = next_;
        }
    }

    @GeneratedBy(value=JSToObjectNode.class)
    private static final class JSObjectNoCheckShapeData {
        @CompilerDirectives.CompilationFinal
        JSObjectNoCheckShapeData next_;
        @CompilerDirectives.CompilationFinal
        Shape shape_;

        JSObjectNoCheckShapeData(JSObjectNoCheckShapeData next_) {
            this.next_ = next_;
        }
    }
}

