/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import com.oracle.truffle.js.runtime.BigInt;

@GeneratedBy(value=JSToNumericNode.class)
public final class JSToNumericNodeGen
extends JSToNumericNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private int state_;

    private JSToNumericNodeGen() {
    }

    @Override
    public Object execute(Object arg0Value) {
        int state = this.state_;
        if ((state & 1) != 0 && arg0Value instanceof Integer) {
            int arg0Value_ = (Integer)arg0Value;
            return JSToNumericNode.doInt(arg0Value_);
        }
        if ((state & 2) != 0 && JSTypesGen.isImplicitDouble((state & 0x1E0) >>> 5, arg0Value)) {
            double arg0Value_ = JSTypesGen.asImplicitDouble((state & 0x1E0) >>> 5, arg0Value);
            return JSToNumericNode.doDouble(arg0Value_);
        }
        if ((state & 4) != 0 && arg0Value instanceof BigInt) {
            BigInt arg0Value_ = (BigInt)arg0Value;
            return this.doBigInt(arg0Value_);
        }
        if ((state & 0x18) != 0) {
            if ((state & 8) != 0 && JSGuards.isJSBigInt(arg0Value)) {
                return this.doJSBigInt(arg0Value);
            }
            if ((state & 0x10) != 0 && !JSGuards.isJSBigInt(arg0Value)) {
                return this.doOther(arg0Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    private Object executeAndSpecialize(Object arg0Value) {
        int state = this.state_;
        if (arg0Value instanceof Integer) {
            int arg0Value_ = (Integer)arg0Value;
            this.state_ = state |= 1;
            return JSToNumericNode.doInt(arg0Value_);
        }
        int doubleCast0 = JSTypesGen.specializeImplicitDouble(arg0Value);
        if (doubleCast0 != 0) {
            double arg0Value_ = JSTypesGen.asImplicitDouble(doubleCast0, arg0Value);
            state |= doubleCast0 << 5;
            this.state_ = state |= 2;
            return JSToNumericNode.doDouble(arg0Value_);
        }
        if (arg0Value instanceof BigInt) {
            BigInt arg0Value_ = (BigInt)arg0Value;
            this.state_ = state |= 4;
            return this.doBigInt(arg0Value_);
        }
        if (JSGuards.isJSBigInt(arg0Value)) {
            this.state_ = state |= 8;
            return this.doJSBigInt(arg0Value);
        }
        if (!JSGuards.isJSBigInt(arg0Value)) {
            this.state_ = state |= 0x10;
            return this.doOther(arg0Value);
        }
        throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
    }

    public NodeCost getCost() {
        int state = this.state_;
        if ((state & 0x1F) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 0x1F & (state & 0x1F) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        Object[] data = new Object[6];
        data[0] = 0;
        int state = this.state_;
        Object[] s = new Object[3];
        s[0] = "doInt";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "doDouble";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "doJSBigInt";
        s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        s = new Object[3];
        s[0] = "doOther";
        s[1] = (state & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[5] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static JSToNumericNode create() {
        return new JSToNumericNodeGen();
    }

    @GeneratedBy(value=JSToNumericNode.JSToNumericWrapperNode.class)
    public static final class JSToNumericWrapperNodeGen
    extends JSToNumericNode.JSToNumericWrapperNode
    implements Introspection.Provider {
        private JSToNumericWrapperNodeGen(JavaScriptNode operand) {
            super(operand);
        }

        @Override
        public Object execute(VirtualFrame frameValue, Object operandNodeValue) {
            return this.doDefault(operandNodeValue);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object operandNodeValue_ = this.operandNode.execute(frameValue);
            return this.doDefault(operandNodeValue_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public Introspection getIntrospectionData() {
            Object[] data = new Object[2];
            data[0] = 0;
            Object[] s = new Object[3];
            s[0] = "doDefault";
            s[1] = (byte)1;
            data[1] = s;
            return Introspection.Provider.create((Object[])data);
        }

        public static JSToNumericNode.JSToNumericWrapperNode create(JavaScriptNode operand) {
            return new JSToNumericWrapperNodeGen(operand);
        }
    }
}

