/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.GetMethodNode;
import com.oracle.truffle.js.nodes.access.GetPrototypeNode;
import com.oracle.truffle.js.nodes.access.IsJSObjectNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.binary.InstanceofNodeGen;
import com.oracle.truffle.js.nodes.binary.JSBinaryNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSException;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.Set;

public abstract class InstanceofNode
extends JSBinaryNode {
    protected final JSContext context;
    @Node.Child
    private OrdinaryHasInstanceNode ordinaryHasInstanceNode;

    protected InstanceofNode(JSContext context, JavaScriptNode left, JavaScriptNode right) {
        super(left, right);
        this.context = context;
    }

    public static InstanceofNode create(JSContext context) {
        return InstanceofNode.create(context, null, null);
    }

    public static InstanceofNode create(JSContext context, JavaScriptNode left, JavaScriptNode right) {
        return InstanceofNodeGen.create(context, left, right);
    }

    @Override
    public boolean isResultAlwaysOfType(Class<?> clazz) {
        return clazz == Boolean.TYPE;
    }

    public abstract boolean executeBoolean(Object var1, Object var2);

    GetMethodNode createGetMethodHasInstance() {
        return GetMethodNode.create(this.context, null, Symbol.SYMBOL_HAS_INSTANCE);
    }

    @Specialization(guards={"isObjectNode.executeBoolean(target)"}, limit="1")
    protected boolean doJSObject(Object obj, DynamicObject target, @Cached(value="create()") IsJSObjectNode isObjectNode, @Cached(value="createGetMethodHasInstance()") GetMethodNode getMethodHasInstanceNode, @Cached(value="create()") JSToBooleanNode toBooleanNode, @Cached(value="createCall()") JSFunctionCallNode callHasInstanceNode, @Cached(value="createBinaryProfile()") ConditionProfile hasInstanceProfile, @Cached(value="create()") BranchProfile errorBranch, @Cached(value="create()") BranchProfile proxyBranch) {
        Object hasInstance = getMethodHasInstanceNode.executeWithTarget(target);
        if (hasInstanceProfile.profile(hasInstance != Undefined.instance)) {
            Object res = callHasInstanceNode.executeCall(JSArguments.createOneArg(target, hasInstance, obj));
            return toBooleanNode.executeBoolean(res);
        }
        if (!InstanceofNode.isCallable(target, proxyBranch)) {
            errorBranch.enter();
            throw Errors.createTypeErrorInvalidInstanceofTarget(target, this);
        }
        if (this.ordinaryHasInstanceNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.ordinaryHasInstanceNode = (OrdinaryHasInstanceNode)this.insert(OrdinaryHasInstanceNode.create(this.context));
        }
        return this.ordinaryHasInstanceNode.executeBoolean(obj, target);
    }

    private static boolean isCallable(DynamicObject target, BranchProfile proxyBranch) {
        if (JSFunction.isJSFunction(target)) {
            return true;
        }
        if (JSProxy.isProxy(target)) {
            proxyBranch.enter();
            return JSRuntime.isCallableProxy(target);
        }
        return false;
    }

    @Specialization(guards={"isNullOrUndefined(target)"})
    protected boolean doNullOrUndefinedTarget(Object obj, DynamicObject target) {
        throw Errors.createTypeErrorInvalidInstanceofTarget(target, this);
    }

    @Specialization
    protected boolean doStringTarget(Object obj, String target) {
        throw Errors.createTypeErrorInvalidInstanceofTarget(target, this);
    }

    @Specialization
    protected boolean doDoubleTarget(Object obj, double target) {
        throw Errors.createTypeErrorInvalidInstanceofTarget(target, this);
    }

    @Specialization
    protected boolean doBooleanTarget(Object obj, boolean target) {
        throw Errors.createTypeErrorInvalidInstanceofTarget(target, this);
    }

    @Specialization
    protected boolean doBigIntTarget(Object obj, BigInt target) {
        throw Errors.createTypeErrorInvalidInstanceofTarget(target, this);
    }

    @Specialization
    protected boolean doSymbolTarget(Object obj, Symbol target) {
        throw Errors.createTypeErrorInvalidInstanceofTarget(target, this);
    }

    @Specialization(guards={"isForeignObject(target)", "isJSType(instance)"})
    protected boolean doForeignTargetJSType(DynamicObject instance, Object target) {
        return false;
    }

    @Specialization(guards={"isForeignObject(target)", "!isJSType(instance)"}, limit="3")
    protected boolean doForeignTargetOther(Object instance, Object target, @CachedLibrary(value="target") InteropLibrary interop) {
        try {
            return interop.isMetaInstance(target, instance);
        }
        catch (UnsupportedMessageException e) {
            throw Errors.createTypeErrorInvalidInstanceofTarget(target, this);
        }
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return InstanceofNodeGen.create(this.context, InstanceofNode.cloneUninitialized(this.getLeft(), materializedTags), InstanceofNode.cloneUninitialized(this.getRight(), materializedTags));
    }

    public static abstract class IsBoundFunctionCacheNode
    extends JavaScriptBaseNode {
        final boolean multiContext;

        public abstract boolean executeBoolean(DynamicObject var1);

        protected IsBoundFunctionCacheNode(boolean multiContext) {
            this.multiContext = multiContext;
        }

        public static IsBoundFunctionCacheNode create(JSContext context) {
            return InstanceofNodeGen.IsBoundFunctionCacheNodeGen.create(context.isMultiContext());
        }

        @Specialization(guards={"!multiContext", "func == cachedFunction"}, limit="1")
        protected static boolean doCachedInstance(DynamicObject func, @Cached(value="func") DynamicObject cachedFunction, @Cached(value="isBoundFunction(func)") boolean cachedIsBound) {
            assert (IsBoundFunctionCacheNode.isBoundFunction(func) == cachedIsBound);
            return cachedIsBound;
        }

        @Specialization(guards={"cachedShape.check(func)"}, replaces={"doCachedInstance"})
        protected static boolean doCachedShape(DynamicObject func, @Cached(value="func.getShape()") Shape cachedShape, @Cached(value="isBoundFunction(func)") boolean cachedIsBound) {
            assert (IsBoundFunctionCacheNode.isBoundFunction(func) == cachedIsBound);
            return cachedIsBound;
        }

        @Specialization(replaces={"doCachedShape"})
        protected static boolean isBoundFunction(DynamicObject func) {
            assert (JSFunction.isJSFunction(func));
            return JSFunction.isBoundFunction(func);
        }
    }

    public static abstract class OrdinaryHasInstanceNode
    extends JavaScriptBaseNode {
        protected final JSContext context;
        @CompilerDirectives.CompilationFinal
        private boolean lessThan4 = true;
        @Node.Child
        private PropertyGetNode getPrototypeNode;
        @Node.Child
        private IsBoundFunctionCacheNode boundFuncCacheNode;

        public abstract boolean executeBoolean(Object var1, Object var2);

        protected OrdinaryHasInstanceNode(JSContext context) {
            this.context = context;
            this.boundFuncCacheNode = IsBoundFunctionCacheNode.create(context);
        }

        public static OrdinaryHasInstanceNode create(JSContext context) {
            return InstanceofNodeGen.OrdinaryHasInstanceNodeGen.create(context);
        }

        private DynamicObject getConstructorPrototype(DynamicObject rhs, BranchProfile invalidPrototypeBranch) {
            Object proto;
            if (this.getPrototypeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getPrototypeNode = (PropertyGetNode)this.insert(PropertyGetNode.create("prototype", this.context));
            }
            if (!JSRuntime.isObject(proto = this.getPrototypeNode.getValue(rhs))) {
                invalidPrototypeBranch.enter();
                throw this.createTypeErrorInvalidPrototype(rhs, proto);
            }
            return (DynamicObject)proto;
        }

        @Specialization(guards={"!isCallable(check)"})
        protected boolean doNotCallable(Object obj, Object check) {
            return false;
        }

        @Specialization(guards={"isJSFunction(check)", "isBoundFunction(check)"})
        protected boolean doIsBound(Object obj, DynamicObject check, @Cached(value="create(context)") InstanceofNode instanceofNode) {
            DynamicObject boundTargetFunction = JSFunction.getBoundTargetFunction(check);
            return instanceofNode.executeBoolean(obj, boundTargetFunction);
        }

        @Specialization(guards={"!isJSObject(left)", "isJSFunction(right)", "!isBoundFunction(right)"})
        protected boolean doNotAnObject(Object left, DynamicObject right) {
            return false;
        }

        @Specialization(guards={"!isJSObject(left)", "isJSProxy(right)", "isCallableProxy(right)"})
        protected boolean doNotAnObjectProxy(Object left, DynamicObject right) {
            return false;
        }

        @Specialization(guards={"isObjectNode.executeBoolean(left)", "isJSFunction(right)", "!isBoundFunction(right)"}, limit="1")
        protected boolean doJSObject(DynamicObject left, DynamicObject right, @Cached @Cached.Shared(value="isObjectNode") IsJSObjectNode isObjectNode, @Cached @Cached.Shared(value="getPrototype1Node") GetPrototypeNode getPrototype1Node, @Cached @Cached.Shared(value="getPrototype2Node") GetPrototypeNode getPrototype2Node, @Cached @Cached.Shared(value="getPrototype3Node") GetPrototypeNode getPrototype3Node, @Cached @Cached.Shared(value="firstTrue") BranchProfile firstTrue, @Cached @Cached.Shared(value="firstFalse") BranchProfile firstFalse, @Cached @Cached.Shared(value="need2Hops") BranchProfile need2Hops, @Cached @Cached.Shared(value="need3Hops") BranchProfile need3Hops, @Cached @Cached.Shared(value="errorBranch") BranchProfile errorBranch, @Cached @Cached.Shared(value="invalidPrototypeBranch") BranchProfile invalidPrototypeBranch) {
            DynamicObject ctorPrototype = this.getConstructorPrototype(right, invalidPrototypeBranch);
            if (this.lessThan4) {
                DynamicObject proto = getPrototype1Node.executeJSObject(left);
                if (proto == ctorPrototype) {
                    firstTrue.enter();
                    return true;
                }
                if (proto == Null.instance) {
                    firstFalse.enter();
                    return false;
                }
                need2Hops.enter();
                proto = getPrototype2Node.executeJSObject(proto);
                if (proto == ctorPrototype) {
                    return true;
                }
                if (proto == Null.instance) {
                    return false;
                }
                need3Hops.enter();
                proto = getPrototype3Node.executeJSObject(proto);
                if (proto == ctorPrototype) {
                    return true;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.lessThan4 = false;
            }
            return this.doJSObject4(left, ctorPrototype, getPrototype3Node, errorBranch);
        }

        @Specialization(guards={"isObjectNode.executeBoolean(left)", "isJSProxy(right)", "isCallableProxy(right)"}, limit="1")
        protected boolean doJSObjectProxy(DynamicObject left, DynamicObject right, @Cached @Cached.Shared(value="isObjectNode") IsJSObjectNode isObjectNode, @Cached @Cached.Shared(value="getPrototype1Node") GetPrototypeNode getPrototype1Node, @Cached @Cached.Shared(value="getPrototype2Node") GetPrototypeNode getPrototype2Node, @Cached @Cached.Shared(value="getPrototype3Node") GetPrototypeNode getPrototype3Node, @Cached @Cached.Shared(value="firstTrue") BranchProfile firstTrue, @Cached @Cached.Shared(value="firstFalse") BranchProfile firstFalse, @Cached @Cached.Shared(value="need2Hops") BranchProfile need2Hops, @Cached @Cached.Shared(value="need3Hops") BranchProfile need3Hops, @Cached @Cached.Shared(value="errorBranch") BranchProfile errorBranch, @Cached @Cached.Shared(value="invalidPrototypeBranch") BranchProfile invalidPrototypeBranch) {
            return this.doJSObject(left, right, isObjectNode, getPrototype1Node, getPrototype2Node, getPrototype3Node, firstTrue, firstFalse, need2Hops, need3Hops, errorBranch, invalidPrototypeBranch);
        }

        private boolean doJSObject4(DynamicObject obj, DynamicObject check, GetPrototypeNode getLoopedPrototypeNode, BranchProfile errorBranch) {
            DynamicObject proto = obj;
            int counter = 0;
            while ((proto = getLoopedPrototypeNode.executeJSObject(proto)) != Null.instance) {
                if (++counter > this.context.getContextOptions().getMaxPrototypeChainLength()) {
                    errorBranch.enter();
                    throw Errors.createRangeError("prototype chain length exceeded");
                }
                if (proto != check) continue;
                return true;
            }
            return false;
        }

        protected boolean isBoundFunction(DynamicObject func) {
            assert (JSFunction.isJSFunction(func));
            return this.boundFuncCacheNode.executeBoolean(func);
        }

        @CompilerDirectives.TruffleBoundary
        private JSException createTypeErrorInvalidPrototype(DynamicObject obj, Object proto) {
            return Errors.createTypeError("\"prototype\" of " + JSRuntime.safeToString(obj) + " is not an Object, it is " + JSRuntime.safeToString(proto), this);
        }
    }
}

