/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.joni.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.js.runtime.joni.interop.ToLongNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=ToLongNode.class)
public final class ToLongNodeGen
extends ToLongNode {
    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @Node.Child
    private Boxed0Data boxed0_cache;

    private ToLongNodeGen() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ExplodeLoop
    public long execute(Object arg0Value) throws UnsupportedTypeException {
        int state = this.state_;
        if ((state & 1) != 0 && arg0Value instanceof Long) {
            long arg0Value_ = (Long)arg0Value;
            return ToLongNode.doPrimitive(arg0Value_);
        }
        if ((state & 6) != 0) {
            if ((state & 2) != 0) {
                Boxed0Data s2_ = this.boxed0_cache;
                while (s2_ != null) {
                    if (s2_.args_.accepts(arg0Value) && s2_.args_.fitsInLong(arg0Value)) {
                        return ToLongNode.doBoxed(arg0Value, s2_.args_);
                    }
                    s2_ = s2_.next_;
                }
            }
            if ((state & 4) != 0) {
                Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
                try {
                    if (((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value)).fitsInLong(arg0Value)) {
                        long l = ToLongNode.doBoxed(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value));
                        return l;
                    }
                }
                finally {
                    NodeUtil.popEncapsulatingNode((Node)prev_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long executeAndSpecialize(Object arg0Value) throws UnsupportedTypeException {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            if (arg0Value instanceof Long) {
                long arg0Value_ = (Long)arg0Value;
                this.state_ = state |= 1;
                lock.unlock();
                hasLock = false;
                long l = ToLongNode.doPrimitive(arg0Value_);
                return l;
            }
            if (exclude == 0) {
                InteropLibrary args__;
                int count2_ = 0;
                Boxed0Data s2_ = this.boxed0_cache;
                if ((state & 2) != 0) {
                    while (!(s2_ == null || s2_.args_.accepts(arg0Value) && s2_.args_.fitsInLong(arg0Value))) {
                        s2_ = s2_.next_;
                        ++count2_;
                    }
                }
                if (s2_ == null && (args__ = (InteropLibrary)super.insert((Node)INTEROP_LIBRARY_.create(arg0Value))).fitsInLong(arg0Value) && count2_ < 2) {
                    s2_ = (Boxed0Data)super.insert((Node)new Boxed0Data(this.boxed0_cache));
                    s2_.args_ = s2_.insertAccessor(args__);
                    this.boxed0_cache = s2_;
                    this.state_ = state |= 2;
                }
                if (s2_ != null) {
                    lock.unlock();
                    hasLock = false;
                    long l = ToLongNode.doBoxed(arg0Value, s2_.args_);
                    return l;
                }
            }
            Node prev_ = NodeUtil.pushEncapsulatingNode((Node)this);
            try {
                InteropLibrary boxed1_args__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value);
                if (boxed1_args__.fitsInLong(arg0Value)) {
                    this.exclude_ = exclude |= 1;
                    this.boxed0_cache = null;
                    state &= 0xFFFFFFFD;
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    long l = ToLongNode.doBoxed(arg0Value, boxed1_args__);
                    return l;
                }
            }
            finally {
                NodeUtil.popEncapsulatingNode((Node)prev_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        Boxed0Data s2_;
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0 && ((s2_ = this.boxed0_cache) == null || s2_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static ToLongNode create() {
        return new ToLongNodeGen();
    }

    public static ToLongNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=ToLongNode.class)
    private static final class Uncached
    extends ToLongNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long execute(Object arg0Value) throws UnsupportedTypeException {
            if (arg0Value instanceof Long) {
                long arg0Value_ = (Long)arg0Value;
                return ToLongNode.doPrimitive(arg0Value_);
            }
            if (((InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value)).fitsInLong(arg0Value)) {
                return ToLongNode.doBoxed(arg0Value, (InteropLibrary)INTEROP_LIBRARY_.getUncached(arg0Value));
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{null}, new Object[]{arg0Value});
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=ToLongNode.class)
    private static final class Boxed0Data
    extends Node {
        @Node.Child
        Boxed0Data next_;
        @Node.Child
        InteropLibrary args_;

        Boxed0Data(Boxed0Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

