/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.joni;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.js.runtime.joni.JoniCompiledRegex;
import com.oracle.truffle.js.runtime.joni.JoniRegexExecRootNode;
import com.oracle.truffle.js.runtime.joni.JoniRegexFlags;
import com.oracle.truffle.js.runtime.joni.JoniUnsupportedRegexException;
import com.oracle.truffle.js.runtime.joni.PatternAnalyzer;
import com.oracle.truffle.js.runtime.joni.interop.ToStringNode;
import com.oracle.truffle.regex.nashorn.regexp.RegExpScanner;
import com.oracle.truffle.regex.nashorn.regexp.joni.Regex;
import com.oracle.truffle.regex.nashorn.regexp.joni.Syntax;
import com.oracle.truffle.regex.nashorn.regexp.joni.exception.SyntaxException;
import java.util.regex.PatternSyntaxException;

@ExportLibrary(value=InteropLibrary.class)
public final class JoniRegexEngine
implements TruffleObject {
    private final TruffleLanguage<?> language;
    private CallTarget searchSimpleCallTarget;
    private CallTarget searchGroupCallTarget;
    private CallTarget matchSimpleCallTarget;
    private CallTarget matchGroupCallTarget;

    public JoniRegexEngine(TruffleLanguage<?> language) {
        this.language = language;
    }

    private CallTarget getSearchSimpleCallTarget() {
        if (this.searchSimpleCallTarget == null) {
            this.searchSimpleCallTarget = Truffle.getRuntime().createCallTarget((RootNode)new JoniRegexExecRootNode.Simple(this.language, false));
        }
        return this.searchSimpleCallTarget;
    }

    private CallTarget getSearchGroupCallTarget() {
        if (this.searchGroupCallTarget == null) {
            this.searchGroupCallTarget = Truffle.getRuntime().createCallTarget((RootNode)new JoniRegexExecRootNode.Groups(this.language, false));
        }
        return this.searchGroupCallTarget;
    }

    private CallTarget getMatchSimpleCallTarget() {
        if (this.matchSimpleCallTarget == null) {
            this.matchSimpleCallTarget = Truffle.getRuntime().createCallTarget((RootNode)new JoniRegexExecRootNode.Simple(this.language, true));
        }
        return this.matchSimpleCallTarget;
    }

    private CallTarget getMatchGroupCallTarget() {
        if (this.matchGroupCallTarget == null) {
            this.matchGroupCallTarget = Truffle.getRuntime().createCallTarget((RootNode)new JoniRegexExecRootNode.Groups(this.language, true));
        }
        return this.matchGroupCallTarget;
    }

    @CompilerDirectives.TruffleBoundary
    public Object compile(String pattern, String flags) {
        try {
            JoniRegexFlags parsedFlags = JoniRegexFlags.parseFlags(flags);
            Regex implementation = JoniRegexEngine.createJoniRegex(pattern, parsedFlags);
            boolean group = PatternAnalyzer.containsGroup(pattern);
            CallTarget callTarget = parsedFlags.isSticky() ? (group ? this.getMatchGroupCallTarget() : this.getMatchSimpleCallTarget()) : (group ? this.getSearchGroupCallTarget() : this.getSearchSimpleCallTarget());
            return new JoniCompiledRegex(pattern, parsedFlags, implementation, callTarget);
        }
        catch (JoniUnsupportedRegexException e) {
            e.setReason("Joni: " + e.getReason());
            e.setRegex(pattern, flags);
            throw e;
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static Regex createJoniRegex(String pattern, JoniRegexFlags flags) {
        try {
            char[] chars = RegExpScanner.scan(pattern).getJavaPattern().toCharArray();
            return new Regex(chars, 0, chars.length, JoniRegexEngine.getOptions(flags), Syntax.JAVASCRIPT);
        }
        catch (SyntaxException | PatternSyntaxException e) {
            throw new JoniUnsupportedRegexException(e.getMessage(), e);
        }
    }

    private static int getOptions(JoniRegexFlags flags) {
        int option = 8;
        if (flags.isUnicode()) {
            throw new JoniUnsupportedRegexException("unicode mode not supported");
        }
        if (flags.isIgnoreCase()) {
            option |= 1;
        }
        if (flags.isMultiline()) {
            option &= 0xFFFFFFF7;
            option |= 0x40;
        }
        if (flags.isDotAll()) {
            option |= 4;
        }
        return option;
    }

    @ExportMessage
    public boolean isExecutable() {
        return true;
    }

    @ExportMessage
    Object execute(Object[] args, @Cached ToStringNode patternToStringNode, @Cached ToStringNode flagsToStringNode) throws ArityException, UnsupportedTypeException {
        if (args.length != 1 && args.length != 2) {
            CompilerDirectives.transferToInterpreter();
            throw ArityException.create((int)2, (int)args.length);
        }
        String pattern = patternToStringNode.execute(args[0]);
        String flags = args.length == 2 ? flagsToStringNode.execute(args[1]) : "";
        return this.compile(pattern, flags);
    }
}

