/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.joni;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.js.runtime.joni.JoniCompiledRegex;
import com.oracle.truffle.js.runtime.joni.JoniCompiledRegexDispatchNode;
import com.oracle.truffle.js.runtime.joni.result.JoniRegexResult;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JoniCompiledRegexDispatchNode.class)
public final class JoniCompiledRegexDispatchNodeGen
extends JoniCompiledRegexDispatchNode {
    private static final Uncached UNCACHED = new Uncached();
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @Node.Child
    private CachedData cached_cache;
    @Node.Child
    private IndirectCallNode generic_indirectCallNode_;

    private JoniCompiledRegexDispatchNodeGen() {
    }

    @Override
    @ExplodeLoop
    public JoniRegexResult execute(JoniCompiledRegex arg0Value, String arg1Value, int arg2Value) {
        int state = this.state_;
        if (state != 0) {
            if ((state & 1) != 0) {
                CachedData s1_ = this.cached_cache;
                while (s1_ != null) {
                    if (arg0Value == s1_.cachedReceiver_) {
                        return JoniCompiledRegexDispatchNode.doCached(arg0Value, arg1Value, arg2Value, s1_.cachedReceiver_, s1_.directCallNode_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state & 2) != 0) {
                return JoniCompiledRegexDispatchNode.doGeneric(arg0Value, arg1Value, arg2Value, this.generic_indirectCallNode_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JoniRegexResult executeAndSpecialize(JoniCompiledRegex arg0Value, String arg1Value, int arg2Value) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        int oldState = state;
        int oldExclude = exclude;
        int oldCacheCount = state == 0 ? 0 : this.countCaches();
        try {
            if (exclude == 0) {
                int count1_ = 0;
                CachedData s1_ = this.cached_cache;
                if ((state & 1) != 0) {
                    while (s1_ != null && arg0Value != s1_.cachedReceiver_) {
                        s1_ = s1_.next_;
                        ++count1_;
                    }
                }
                if (s1_ == null && count1_ < 4) {
                    s1_ = (CachedData)super.insert((Node)new CachedData(this.cached_cache));
                    s1_.cachedReceiver_ = arg0Value;
                    s1_.directCallNode_ = s1_.insertAccessor(DirectCallNode.create((CallTarget)s1_.cachedReceiver_.getRegexCallTarget()));
                    this.cached_cache = s1_;
                    this.state_ = state |= 1;
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    JoniRegexResult joniRegexResult = JoniCompiledRegexDispatchNode.doCached(arg0Value, arg1Value, arg2Value, s1_.cachedReceiver_, s1_.directCallNode_);
                    return joniRegexResult;
                }
            }
            this.generic_indirectCallNode_ = (IndirectCallNode)super.insert((Node)IndirectCallNode.create());
            this.exclude_ = exclude |= 1;
            this.cached_cache = null;
            state &= 0xFFFFFFFE;
            this.state_ = state |= 2;
            lock.unlock();
            hasLock = false;
            JoniRegexResult joniRegexResult = JoniCompiledRegexDispatchNode.doGeneric(arg0Value, arg1Value, arg2Value, this.generic_indirectCallNode_);
            return joniRegexResult;
        }
        finally {
            if (oldState != 0 || oldExclude != 0) {
                this.checkForPolymorphicSpecialize(oldState, oldExclude, oldCacheCount);
            }
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    private void checkForPolymorphicSpecialize(int oldState, int oldExclude, int oldCacheCount) {
        int newState = this.state_;
        int newExclude = this.exclude_;
        if ((oldState ^ newState) != 0 || (oldExclude ^ newExclude) != 0 || oldCacheCount < this.countCaches()) {
            this.reportPolymorphicSpecialize();
        }
    }

    private int countCaches() {
        int cacheCount = 0;
        CachedData s1_ = this.cached_cache;
        while (s1_ != null) {
            ++cacheCount;
            s1_ = s1_.next_;
        }
        return cacheCount;
    }

    public NodeCost getCost() {
        CachedData s1_;
        int state = this.state_;
        if (state == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & state - 1) == 0 && ((s1_ = this.cached_cache) == null || s1_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public static JoniCompiledRegexDispatchNode create() {
        return new JoniCompiledRegexDispatchNodeGen();
    }

    public static JoniCompiledRegexDispatchNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=JoniCompiledRegexDispatchNode.class)
    private static final class Uncached
    extends JoniCompiledRegexDispatchNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public JoniRegexResult execute(JoniCompiledRegex arg0Value, String arg1Value, int arg2Value) {
            return JoniCompiledRegexDispatchNode.doGeneric(arg0Value, arg1Value, arg2Value, IndirectCallNode.getUncached());
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }

    @GeneratedBy(value=JoniCompiledRegexDispatchNode.class)
    private static final class CachedData
    extends Node {
        @Node.Child
        CachedData next_;
        @CompilerDirectives.CompilationFinal
        JoniCompiledRegex cachedReceiver_;
        @Node.Child
        DirectCallNode directCallNode_;

        CachedData(CachedData next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

