/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.builtins.intl.NumberFormatFunctionBuiltins;
import com.oracle.truffle.js.builtins.intl.NumberFormatPrototypeBuiltins;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.LargeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSBuiltinObject;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.IntlUtil;
import com.oracle.truffle.js.runtime.util.LazyValue;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Currency;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;

public final class JSNumberFormat
extends JSBuiltinObject
implements JSConstructorFactory.WithFunctions,
PrototypeSupplier {
    public static final String CLASS_NAME = "NumberFormat";
    public static final String PROTOTYPE_NAME = "NumberFormat.prototype";
    private static final HiddenKey INTERNAL_STATE_ID = new HiddenKey("_internalState");
    private static final Property INTERNAL_STATE_PROPERTY;
    static final HiddenKey BOUND_OBJECT_KEY;
    public static final JSNumberFormat INSTANCE;
    public static final List<String> BCP47_CU_KEYS;
    private static final LazyValue<UnmodifiableEconomicMap<NumberFormat.Field, String>> fieldToTypeMap;

    private JSNumberFormat() {
    }

    public static boolean isSupportedCurrencyKey(String cuKey) {
        return BCP47_CU_KEYS.contains(cuKey);
    }

    public static boolean isJSNumberFormat(Object obj) {
        return JSObject.isDynamicObject(obj) && JSNumberFormat.isJSNumberFormat((DynamicObject)obj);
    }

    public static boolean isJSNumberFormat(DynamicObject obj) {
        return JSNumberFormat.isInstance(obj, (JSClass)INSTANCE);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return this.getClassName();
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject ctor) {
        JSContext ctx = realm.getContext();
        DynamicObject numberFormatPrototype = JSObject.createInit(realm, realm.getObjectPrototype(), (JSClass)JSUserObject.INSTANCE);
        JSObjectUtil.putConstructorProperty(ctx, numberFormatPrototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, numberFormatPrototype, NumberFormatPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putConstantAccessorProperty(ctx, numberFormatPrototype, "format", JSNumberFormat.createFormatFunctionGetter(realm, ctx), Undefined.instance);
        JSObjectUtil.putDataProperty(ctx, numberFormatPrototype, Symbol.SYMBOL_TO_STRING_TAG, "Object", JSAttributes.configurableNotEnumerableNotWritable());
        return numberFormatPrototype;
    }

    @CompilerDirectives.TruffleBoundary
    public static int currencyDigits(String currencyCode) {
        if (currencyCode == null) {
            return 2;
        }
        try {
            Currency currency = Currency.getInstance(currencyCode);
            return currency != null ? currency.getDefaultFractionDigits() : 2;
        }
        catch (IllegalArgumentException e) {
            return 2;
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isWellFormedCurrencyCode(String currency) {
        if (currency == null || currency.length() != 3) {
            return false;
        }
        String normalized = IntlUtil.toUpperCase(currency);
        char a = normalized.charAt(0);
        char b = normalized.charAt(1);
        char c = normalized.charAt(2);
        return a >= 'A' && a <= 'Z' && b >= 'A' && b <= 'Z' && c >= 'A' && c <= 'Z';
    }

    @Override
    public Shape makeInitialShape(JSContext ctx, DynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, ctx);
        initialShape = initialShape.addProperty(INTERNAL_STATE_PROPERTY);
        return initialShape;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm, NumberFormatFunctionBuiltins.BUILTINS);
    }

    public static DynamicObject create(JSContext context) {
        InternalState state = new InternalState();
        DynamicObject result = JSObject.create(context, context.getNumberFormatFactory(), state);
        assert (JSNumberFormat.isJSNumberFormat(result));
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public static void setLocaleAndNumberingSystem(JSContext ctx, BasicInternalState state, String[] locales) {
        String selectedTag = IntlUtil.selectedLocale(ctx, locales);
        Locale selectedLocale = selectedTag != null ? Locale.forLanguageTag(selectedTag) : ctx.getLocale();
        Locale strippedLocale = selectedLocale.stripExtensions();
        if (strippedLocale.toLanguageTag().equals("und")) {
            selectedLocale = ctx.getLocale();
            strippedLocale = selectedLocale.stripExtensions();
        }
        if (selectedLocale.getUnicodeLocaleKeys().contains("nu")) {
            String unicodeLocaleType = selectedLocale.getUnicodeLocaleType("nu");
            if (IntlUtil.isSupportedNumberSystemKey(unicodeLocaleType)) {
                state.numberingSystem = unicodeLocaleType;
            } else {
                selectedLocale = IntlUtil.withoutUnicodeExtension(selectedLocale, "nu");
            }
        }
        state.locale = strippedLocale.toLanguageTag();
        state.javaLocale = IntlUtil.withoutUnicodeExtension(selectedLocale, "cu");
    }

    @CompilerDirectives.TruffleBoundary
    public static void setupInternalNumberFormat(InternalState state) {
        state.numberFormat = state.style.equals("currency") ? NumberFormat.getCurrencyInstance((Locale)state.javaLocale) : (state.style.equals("percent") ? NumberFormat.getPercentInstance((Locale)state.javaLocale) : NumberFormat.getInstance((Locale)state.javaLocale));
    }

    public static NumberFormat getNumberFormatProperty(DynamicObject obj) {
        return JSNumberFormat.getInternalState((DynamicObject)obj).numberFormat;
    }

    @CompilerDirectives.TruffleBoundary
    public static String format(DynamicObject numberFormatObj, Object n) {
        NumberFormat numberFormat = JSNumberFormat.getNumberFormatProperty(numberFormatObj);
        Number x = JSNumberFormat.toInternalNumberRepresentation(JSRuntime.toNumeric(n));
        return numberFormat.format((Object)x);
    }

    private static UnmodifiableEconomicMap<NumberFormat.Field, String> initializeFieldToTypeMap() {
        CompilerAsserts.neverPartOfCompilation();
        EconomicMap map = EconomicMap.create((int)6);
        map.put((Object)NumberFormat.Field.INTEGER, (Object)"integer");
        map.put((Object)NumberFormat.Field.DECIMAL_SEPARATOR, (Object)"decimal");
        map.put((Object)NumberFormat.Field.FRACTION, (Object)"fraction");
        map.put((Object)NumberFormat.Field.GROUPING_SEPARATOR, (Object)"group");
        map.put((Object)NumberFormat.Field.CURRENCY, (Object)"currency");
        map.put((Object)NumberFormat.Field.PERCENT, (Object)"percentSign");
        return map;
    }

    private static String fieldToType(NumberFormat.Field field) {
        return (String)fieldToTypeMap.get().get((Object)field);
    }

    @CompilerDirectives.TruffleBoundary
    public static DynamicObject formatToParts(JSContext context, DynamicObject numberFormatObj, Object n) {
        NumberFormat numberFormat = JSNumberFormat.getNumberFormatProperty(numberFormatObj);
        Number x = JSNumberFormat.toInternalNumberRepresentation(JSRuntime.toNumeric(n));
        List<DynamicObject> resultParts = JSNumberFormat.innerFormatToParts(context, numberFormat, x, null);
        return JSArray.createConstant(context, resultParts.toArray());
    }

    static List<DynamicObject> innerFormatToParts(JSContext context, NumberFormat numberFormat, Number x, String unit) {
        ArrayList<DynamicObject> resultParts = new ArrayList<DynamicObject>();
        AttributedCharacterIterator fit = numberFormat.formatToCharacterIterator((Object)x);
        String formatted = numberFormat.format((Object)x);
        int i = fit.getBeginIndex();
        while (i < fit.getEndIndex()) {
            fit.setIndex(i);
            Map<AttributedCharacterIterator.Attribute, Object> attributes = fit.getAttributes();
            Set<AttributedCharacterIterator.Attribute> attKeySet = attributes.keySet();
            if (!attKeySet.isEmpty()) {
                Iterator<AttributedCharacterIterator.Attribute> iterator = attKeySet.iterator();
                if (!iterator.hasNext()) continue;
                AttributedCharacterIterator.Attribute a = iterator.next();
                if (a instanceof NumberFormat.Field) {
                    String type;
                    String value = formatted.substring(fit.getRunStart(), fit.getRunLimit());
                    if (a == NumberFormat.Field.INTEGER) {
                        double xDouble = x.doubleValue();
                        type = Double.isNaN(xDouble) ? "nan" : (Double.isInfinite(xDouble) ? "infinite" : "integer");
                    } else if (a == NumberFormat.Field.SIGN) {
                        type = JSNumberFormat.isPlusSign(value) ? "plusSign" : "minusSign";
                    } else {
                        type = JSNumberFormat.fieldToType((NumberFormat.Field)a);
                        assert (type != null);
                    }
                    resultParts.add(IntlUtil.makePart(context, type, value, unit));
                    i = fit.getRunLimit();
                    continue;
                }
                throw Errors.shouldNotReachHere();
            }
            String value = formatted.substring(fit.getRunStart(), fit.getRunLimit());
            resultParts.add(IntlUtil.makePart(context, "literal", value, unit));
            i = fit.getRunLimit();
        }
        return resultParts;
    }

    private static boolean isPlusSign(String str) {
        return str.length() == 1 && str.charAt(0) == '+';
    }

    private static Number toInternalNumberRepresentation(Object o) {
        if (o instanceof LargeInteger) {
            return ((LargeInteger)o).doubleValue();
        }
        if (o instanceof Number) {
            return (Number)o;
        }
        if (o instanceof BigInt) {
            return ((BigInt)o).bigIntegerValue();
        }
        throw Errors.shouldNotReachHere();
    }

    @CompilerDirectives.TruffleBoundary
    public static DynamicObject resolvedOptions(JSContext context, DynamicObject numberFormatObj) {
        InternalState state = JSNumberFormat.getInternalState(numberFormatObj);
        return state.toResolvedOptionsObject(context);
    }

    public static InternalState getInternalState(DynamicObject numberFormatObj) {
        return (InternalState)INTERNAL_STATE_PROPERTY.get(numberFormatObj, JSNumberFormat.isJSNumberFormat(numberFormatObj));
    }

    private static CallTarget createGetFormatCallTarget(final JSContext context) {
        return Truffle.getRuntime().createCallTarget((RootNode)new JavaScriptRootNode(context.getLanguage(), null, null){
            private final BranchProfile errorBranch;
            @CompilerDirectives.CompilationFinal
            private TruffleLanguage.ContextReference<JSRealm> realmRef;
            @Node.Child
            private PropertySetNode setBoundObjectNode;
            {
                super(lang, sourceSection, frameDescriptor);
                this.errorBranch = BranchProfile.create();
                this.setBoundObjectNode = PropertySetNode.createSetHidden(BOUND_OBJECT_KEY, context);
            }

            public Object execute(VirtualFrame frame) {
                Object[] frameArgs = frame.getArguments();
                Object numberFormatObj = JSArguments.getThisObject(frameArgs);
                if (JSNumberFormat.isJSNumberFormat(numberFormatObj)) {
                    InternalState state = JSNumberFormat.getInternalState((DynamicObject)numberFormatObj);
                    if (state == null || !state.initialized) {
                        this.errorBranch.enter();
                        throw Errors.createTypeErrorMethodCalledOnNonObjectOrWrongType("format");
                    }
                    if (state.boundFormatFunction == null) {
                        if (this.realmRef == null) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            this.realmRef = this.lookupContextReference(JavaScriptLanguage.class);
                        }
                        JSFunctionData formatFunctionData = context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.NumberFormatFormat, c -> JSNumberFormat.createFormatFunctionData(c));
                        DynamicObject formatFn = JSFunction.create((JSRealm)this.realmRef.get(), formatFunctionData);
                        this.setBoundObjectNode.setValue(formatFn, numberFormatObj);
                        state.boundFormatFunction = formatFn;
                    }
                    return state.boundFormatFunction;
                }
                this.errorBranch.enter();
                throw Errors.createTypeErrorTypeXExpected(JSNumberFormat.CLASS_NAME);
            }
        });
    }

    private static JSFunctionData createFormatFunctionData(final JSContext context) {
        return JSFunctionData.createCallOnly(context, (CallTarget)Truffle.getRuntime().createCallTarget((RootNode)new JavaScriptRootNode(context.getLanguage(), null, null){
            @Node.Child
            private PropertyGetNode getBoundObjectNode;
            {
                super(lang, sourceSection, frameDescriptor);
                this.getBoundObjectNode = PropertyGetNode.createGetHidden(BOUND_OBJECT_KEY, context);
            }

            public Object execute(VirtualFrame frame) {
                Object[] arguments = frame.getArguments();
                DynamicObject thisObj = (DynamicObject)this.getBoundObjectNode.getValue(JSArguments.getFunctionObject(arguments));
                assert (JSNumberFormat.isJSNumberFormat(thisObj));
                DynamicObject n = JSArguments.getUserArgumentCount(arguments) > 0 ? JSArguments.getUserArgument(arguments, 0) : Undefined.instance;
                return JSNumberFormat.format(thisObj, n);
            }
        }), 1, "");
    }

    private static DynamicObject createFormatFunctionGetter(JSRealm realm, JSContext context) {
        JSFunctionData fd = realm.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.NumberFormatGetFormat, c -> {
            CallTarget ct = JSNumberFormat.createGetFormatCallTarget(context);
            return JSFunctionData.create(context, ct, ct, 0, "get format", false, false, false, true);
        });
        return JSFunction.create(realm, fd);
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getNumberFormatPrototype();
    }

    static {
        BOUND_OBJECT_KEY = new HiddenKey(CLASS_NAME);
        INSTANCE = new JSNumberFormat();
        BCP47_CU_KEYS = Arrays.asList("ADP", "AED", "AFA", "AFN", "ALK", "ALL", "AMD", "ANG", "AOA", "AOK", "AON", "AOR", "ARA", "ARL", "ARM", "ARP", "ARS", "ATS", "AUD", "AWG", "AZM", "AZN", "BAD", "BAM", "BAN", "BBD", "BDT", "BEC", "BEF", "BEL", "BGL", "BGM", "BGN", "BGO", "BHD", "BIF", "BMD", "BND", "BOB", "BOL", "BOP", "BOV", "BRB", "BRC", "BRE", "BRL", "BRN", "BRR", "BRZ", "BSD", "BTN", "BUK", "BWP", "BYB", "BYN", "BYR", "BZD", "CAD", "CDF", "CHE", "CHF", "CHW", "CLE", "CLF", "CLP", "CNH", "CNX", "CNY", "COP", "COU", "CRC", "CSD", "CSK", "CUC", "CUP", "CVE", "CYP", "CZK", "DDM", "DEM", "DJF", "DKK", "DOP", "DZD", "ECS", "ECV", "EEK", "EGP", "ERN", "ESA", "ESB", "ESP", "ETB", "EUR", "FIM", "FJD", "FKP", "FRF", "GBP", "GEK", "GEL", "GHC", "GHS", "GIP", "GMD", "GNF", "GNS", "GQE", "GRD", "GTQ", "GWE", "GWP", "GYD", "HKD", "HNL", "HRD", "HRK", "HTG", "HUF", "IDR", "IEP", "ILP", "ILR", "ILS", "INR", "IQD", "IRR", "ISJ", "ISK", "ITL", "JMD", "JOD", "JPY", "KES", "KGS", "KHR", "KMF", "KPW", "KRH", "KRO", "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LTL", "LTT", "LUC", "LUF", "LUL", "LVL", "LVR", "LYD", "MAD", "MAF", "MCF", "MDC", "MDL", "MGA", "MGF", "MKD", "MKN", "MLF", "MMK", "MNT", "MOP", "MRO", "MTL", "MTP", "MUR", "MVP", "MVR", "MWK", "MXN", "MXP", "MXV", "MYR", "MZE", "MZM", "MZN", "NAD", "NGN", "NIC", "NIO", "NLG", "NOK", "NPR", "NZD", "OMR", "PAB", "PEI", "PEN", "PES", "PGK", "PHP", "PKR", "PLN", "PLZ", "PTE", "PYG", "QAR", "RHD", "ROL", "RON", "RSD", "RUB", "RUR", "RWF", "SAR", "SBD", "SCR", "SDD", "SDG", "SDP", "SEK", "SGD", "SHP", "SIT", "SKK", "SLL", "SOS", "SRD", "SRG", "SSP", "STD", "STN", "SUR", "SVC", "SYP", "SZL", "THB", "TJR", "TJS", "TMM", "TMT", "TND", "TOP", "TPE", "TRL", "TRY", "TTD", "TWD", "TZS", "UAH", "UAK", "UGS", "UGX", "USD", "USN", "USS", "UYI", "UYP", "UYU", "UZS", "VEB", "VEF", "VND", "VNN", "VUV", "WST", "XAF", "XAG", "XAU", "XBA", "XBB", "XBC", "XBD", "XCD", "XDR", "XEU", "XFO", "XFU", "XOF", "XPD", "XPF", "XPT", "XRE", "XSU", "XTS", "XUA", "XXX", "YDD", "YER", "YUD", "YUM", "YUN", "YUR", "ZAL", "ZAR", "ZMK", "ZMW", "ZRN", "ZRZ", "ZWD", "ZWL", "ZWR");
        Shape.Allocator allocator = JSShape.makeAllocator(JSObject.LAYOUT);
        INTERNAL_STATE_PROPERTY = JSObjectUtil.makeHiddenProperty(INTERNAL_STATE_ID, allocator.locationForType(InternalState.class, EnumSet.of(LocationModifier.NonNull, LocationModifier.Final)));
        fieldToTypeMap = new LazyValue<UnmodifiableEconomicMap>(JSNumberFormat::initializeFieldToTypeMap);
    }

    public static class InternalState
    extends BasicInternalState {
        private String style = "decimal";
        private String currency;
        private String currencyDisplay;
        private boolean useGrouping = true;
        DynamicObject boundFormatFunction = null;

        @Override
        void fillResolvedOptions(JSContext context, DynamicObject result) {
            JSObjectUtil.defineDataProperty(result, "locale", this.locale, JSAttributes.getDefault());
            JSObjectUtil.defineDataProperty(result, "numberingSystem", this.numberingSystem, JSAttributes.getDefault());
            JSObjectUtil.defineDataProperty(result, "style", this.style, JSAttributes.getDefault());
            if (this.currency != null) {
                JSObjectUtil.defineDataProperty(result, "currency", this.currency, JSAttributes.getDefault());
            }
            if (this.currencyDisplay != null) {
                JSObjectUtil.defineDataProperty(result, "currencyDisplay", this.currencyDisplay, JSAttributes.getDefault());
            }
            super.fillResolvedOptions(context, result);
            JSObjectUtil.defineDataProperty(result, "useGrouping", this.useGrouping, JSAttributes.getDefault());
        }

        @CompilerDirectives.TruffleBoundary
        public void setGroupingUsed(boolean useGrouping) {
            this.useGrouping = useGrouping;
            this.numberFormat.setGroupingUsed(useGrouping);
        }

        public String getStyle() {
            return this.style;
        }

        public String getCurrency() {
            return this.currency;
        }

        public String getCurrencyDisplay() {
            return this.currencyDisplay;
        }

        public void setStyle(String style) {
            this.style = style;
        }

        public void setCurrency(String currency) {
            this.currency = currency;
        }

        public void setCurrencyDisplay(String currencyDisplay) {
            this.currencyDisplay = currencyDisplay;
        }
    }

    public static class BasicInternalState {
        protected boolean initialized = false;
        protected NumberFormat numberFormat;
        protected Locale javaLocale;
        protected String locale;
        protected String numberingSystem = "latn";
        protected int minimumIntegerDigits = 1;
        protected int minimumFractionDigits = 0;
        protected int maximumFractionDigits = 3;
        protected Integer minimumSignificantDigits;
        protected Integer maximumSignificantDigits;

        DynamicObject toResolvedOptionsObject(JSContext context) {
            DynamicObject resolvedOptions = JSUserObject.create(context);
            this.fillResolvedOptions(context, resolvedOptions);
            return resolvedOptions;
        }

        void fillResolvedOptions(JSContext context, DynamicObject result) {
            JSObjectUtil.defineDataProperty(result, "minimumIntegerDigits", this.minimumIntegerDigits, JSAttributes.getDefault());
            JSObjectUtil.defineDataProperty(result, "minimumFractionDigits", this.minimumFractionDigits, JSAttributes.getDefault());
            JSObjectUtil.defineDataProperty(result, "maximumFractionDigits", this.maximumFractionDigits, JSAttributes.getDefault());
            if (this.minimumSignificantDigits != null) {
                JSObjectUtil.defineDataProperty(result, "minimumSignificantDigits", this.minimumSignificantDigits, JSAttributes.getDefault());
            }
            if (this.maximumSignificantDigits != null) {
                JSObjectUtil.defineDataProperty(result, "maximumSignificantDigits", this.maximumSignificantDigits, JSAttributes.getDefault());
            }
        }

        @CompilerDirectives.TruffleBoundary
        public void setIntegerAndFractionsDigits(int minimumIntegerDigits, int minimumFractionDigits, int maximumFractionDigits) {
            this.minimumIntegerDigits = minimumIntegerDigits;
            this.minimumFractionDigits = minimumFractionDigits;
            this.maximumFractionDigits = maximumFractionDigits;
            this.numberFormat.setMinimumIntegerDigits(minimumIntegerDigits);
            this.numberFormat.setMinimumFractionDigits(minimumFractionDigits);
            this.numberFormat.setMaximumFractionDigits(maximumFractionDigits);
        }

        @CompilerDirectives.TruffleBoundary
        public void setSignificantDigits(int minimumSignificantDigits, int maximumSignificantDigits) {
            this.minimumSignificantDigits = minimumSignificantDigits;
            this.maximumSignificantDigits = maximumSignificantDigits;
            if (this.numberFormat instanceof DecimalFormat) {
                DecimalFormat df = (DecimalFormat)this.numberFormat;
                df.setMinimumSignificantDigits(minimumSignificantDigits);
                df.setMaximumSignificantDigits(maximumSignificantDigits);
            }
        }

        public boolean isInitialized() {
            return this.initialized;
        }

        public NumberFormat getNumberFormat() {
            return this.numberFormat;
        }

        public Locale getJavaLocale() {
            return this.javaLocale;
        }

        public String getLocale() {
            return this.locale;
        }

        public String getNumberingSystem() {
            return this.numberingSystem;
        }

        public int getMinimumIntegerDigits() {
            return this.minimumIntegerDigits;
        }

        public int getMinimumFractionDigits() {
            return this.minimumFractionDigits;
        }

        public int getMaximumFractionDigits() {
            return this.maximumFractionDigits;
        }

        public Integer getMinimumSignificantDigits() {
            return this.minimumSignificantDigits;
        }

        public Integer getMaximumSignificantDigits() {
            return this.maximumSignificantDigits;
        }

        public void setInitialized(boolean initialized) {
            this.initialized = initialized;
        }

        public void setNumberFormat(NumberFormat numberFormat) {
            this.numberFormat = numberFormat;
        }

        public void setJavaLocale(Locale javaLocale) {
            this.javaLocale = javaLocale;
        }

        public void setLocale(String locale) {
            this.locale = locale;
        }

        public void setNumberingSystem(String numberingSystem) {
            this.numberingSystem = numberingSystem;
        }

        public void setMinimumIntegerDigits(int minimumIntegerDigits) {
            this.minimumIntegerDigits = minimumIntegerDigits;
        }

        public void setMinimumFractionDigits(int minimumFractionDigits) {
            this.minimumFractionDigits = minimumFractionDigits;
        }

        public void setMaximumFractionDigits(int maximumFractionDigits) {
            this.maximumFractionDigits = maximumFractionDigits;
        }

        public void setMinimumSignificantDigits(Integer minimumSignificantDigits) {
            this.minimumSignificantDigits = minimumSignificantDigits;
        }

        public void setMaximumSignificantDigits(Integer maximumSignificantDigits) {
            this.maximumSignificantDigits = maximumSignificantDigits;
        }
    }
}

