/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JSTruffleOptions;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSDictionaryObject;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.objects.Accessor;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSProperty;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.DefinePropertyUtil;
import com.oracle.truffle.js.runtime.util.IteratorUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class JSBuiltinObject
extends JSClass {
    protected JSBuiltinObject() {
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean defineOwnProperty(DynamicObject thisObj, Object key, PropertyDescriptor desc, boolean doThrow) {
        return DefinePropertyUtil.ordinaryDefineOwnProperty(thisObj, key, desc, doThrow);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getOwnHelper(DynamicObject store, Object thisObj, Object key) {
        Property entry = DefinePropertyUtil.getPropertyByKey(store, key);
        if (entry != null) {
            return JSProperty.getValue(entry, store, thisObj, false);
        }
        return null;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getOwnHelper(DynamicObject store, Object thisObj, long index) {
        return this.getOwnHelper(store, thisObj, String.valueOf(index));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getHelper(DynamicObject store, Object thisObj, Object key) {
        Object value = this.getOwnHelper(store, thisObj, key);
        if (value != null) {
            return value;
        }
        return JSBuiltinObject.getPropertyHelperGeneric(thisObj, store, key);
    }

    @CompilerDirectives.TruffleBoundary
    private static Object getPropertyHelperGeneric(Object thisObj, DynamicObject store, Object key) {
        DynamicObject prototype = JSObject.getPrototype(store);
        if (prototype != Null.instance) {
            return JSObject.getJSClass(prototype).getHelper(prototype, thisObj, key);
        }
        return null;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Object getHelper(DynamicObject store, Object thisObj, long index) {
        Object value = this.getOwnHelper(store, thisObj, index);
        if (value != null) {
            return value;
        }
        return JSBuiltinObject.getPropertyHelperGeneric(thisObj, store, index);
    }

    @CompilerDirectives.TruffleBoundary
    private static Object getPropertyHelperGeneric(Object thisObj, DynamicObject store, long index) {
        DynamicObject prototype = JSObject.getPrototype(store);
        if (prototype != Null.instance) {
            return JSObject.getJSClass(prototype).getHelper(prototype, thisObj, index);
        }
        return null;
    }

    @Override
    public Object getMethodHelper(DynamicObject store, Object thisObj, Object name) {
        return this.getHelper(store, thisObj, name);
    }

    @Override
    public List<Object> getOwnPropertyKeys(DynamicObject thisObj, boolean strings, boolean symbols) {
        return JSBuiltinObject.ordinaryOwnPropertyKeys(thisObj, strings, symbols);
    }

    protected static List<Object> ordinaryOwnPropertyKeys(DynamicObject thisObj) {
        return JSBuiltinObject.ordinaryOwnPropertyKeys(thisObj, true, true);
    }

    @CompilerDirectives.TruffleBoundary
    protected static List<Object> ordinaryOwnPropertyKeys(DynamicObject thisObj, boolean strings, boolean symbols) {
        if (JSTruffleOptions.FastOwnKeys) {
            List<Object> all = IteratorUtil.convertList(JSShape.getProperties(thisObj.getShape()), Property::getKey);
            return JSBuiltinObject.filterOwnPropertyKeys(all, strings, symbols);
        }
        return JSBuiltinObject.ordinaryOwnPropertyKeysSlow(thisObj, strings, symbols);
    }

    protected static List<Object> ordinaryOwnPropertyKeysSlow(DynamicObject thisObj, boolean strings, boolean symbols) {
        CompilerAsserts.neverPartOfCompilation();
        List keyList = thisObj.getShape().getKeyList();
        ArrayList<Object> list = new ArrayList<Object>(keyList.size());
        for (Object key : keyList) {
            if (!symbols && key instanceof Symbol || !strings && key instanceof String) continue;
            list.add(key);
        }
        Collections.sort(list, JSRuntime::comparePropertyKeys);
        return list;
    }

    @Override
    public boolean hasOnlyShapeProperties(DynamicObject obj) {
        return false;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean delete(DynamicObject thisObj, Object key, boolean isStrict) {
        return JSBuiltinObject.deletePropertyDefault(thisObj, key, isStrict);
    }

    protected static boolean deletePropertyDefault(DynamicObject object, Object key, boolean isStrict) {
        Property foundProperty = object.getShape().getProperty(key);
        if (foundProperty != null) {
            if (!JSProperty.isConfigurable(foundProperty)) {
                if (isStrict) {
                    throw Errors.createTypeErrorNotConfigurableProperty(key);
                }
                return false;
            }
            return object.delete(key);
        }
        return true;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean delete(DynamicObject thisObj, long index, boolean isStrict) {
        return JSBuiltinObject.deletePropertyDefault(thisObj, String.valueOf(index), isStrict);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean hasOwnProperty(DynamicObject thisObj, Object key) {
        return thisObj.getShape().hasProperty(key);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean hasOwnProperty(DynamicObject thisObj, long index) {
        return this.hasOwnProperty(thisObj, String.valueOf(index));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean hasProperty(DynamicObject thisObj, long index) {
        if (this.hasOwnProperty(thisObj, index)) {
            return true;
        }
        if (JSObject.getPrototype(thisObj) != Null.instance) {
            return JSObject.hasProperty(JSObject.getPrototype(thisObj), index);
        }
        return false;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean hasProperty(DynamicObject thisObj, Object key) {
        if (this.hasOwnProperty(thisObj, key)) {
            return true;
        }
        DynamicObject prototype = JSObject.getPrototype(thisObj);
        if (prototype != Null.instance) {
            return JSObject.hasProperty(prototype, key);
        }
        return false;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean set(DynamicObject thisObj, long index, Object value, Object receiver, boolean isStrict) {
        return JSBuiltinObject.ordinarySetIndex(thisObj, index, value, receiver, isStrict);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean set(DynamicObject thisObj, Object key, Object value, Object receiver, boolean isStrict) {
        return JSBuiltinObject.ordinarySet(thisObj, key, value, receiver, isStrict);
    }

    protected static boolean ordinarySetIndex(DynamicObject thisObj, long index, Object value, Object receiver, boolean isStrict) {
        String key = Boundaries.stringValueOf(index);
        if (receiver != thisObj) {
            return JSBuiltinObject.ordinarySetWithReceiver(thisObj, key, value, receiver, isStrict);
        }
        Property entry = DefinePropertyUtil.getPropertyByKey(thisObj, key);
        if (entry != null) {
            return JSProperty.setValue(entry, thisObj, receiver, value, isStrict);
        }
        return JSBuiltinObject.setPropertySlow(thisObj, key, value, receiver, isStrict, true);
    }

    protected static boolean ordinarySet(DynamicObject thisObj, Object key, Object value, Object receiver, boolean isStrict) {
        if (receiver != thisObj) {
            return JSBuiltinObject.ordinarySetWithReceiver(thisObj, key, value, receiver, isStrict);
        }
        Property entry = DefinePropertyUtil.getPropertyByKey(thisObj, key);
        if (entry != null) {
            return JSProperty.setValue(entry, thisObj, receiver, value, isStrict);
        }
        return JSBuiltinObject.setPropertySlow(thisObj, key, value, receiver, isStrict, false);
    }

    protected static boolean ordinarySetWithReceiver(DynamicObject target, Object key, Object value, Object receiver, boolean isStrict) {
        assert (JSRuntime.isPropertyKey(key));
        PropertyDescriptor descriptor = JSObject.getOwnProperty(target, key);
        boolean result = JSBuiltinObject.performOrdinarySetWithOwnDescriptor(target, key, value, receiver, descriptor, isStrict);
        assert (!isStrict || result) : "should have thrown";
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    protected static boolean performOrdinarySetWithOwnDescriptor(DynamicObject target, Object key, Object value, Object receiver, PropertyDescriptor desc, boolean isStrict) {
        PropertyDescriptor descriptor = desc;
        if (descriptor == null) {
            DynamicObject parent = JSObject.getPrototype(target);
            if (parent != Null.instance) {
                return JSObject.setWithReceiver(parent, key, value, receiver, isStrict);
            }
            descriptor = PropertyDescriptor.undefinedDataDesc;
        }
        if (descriptor.isDataDescriptor()) {
            if (!descriptor.getWritable()) {
                if (isStrict) {
                    throw Errors.createTypeErrorNotWritableProperty(key, target);
                }
                return false;
            }
            if (!JSRuntime.isObject(receiver)) {
                if (isStrict) {
                    throw Errors.createTypeErrorSetNonObjectReceiver(receiver, key);
                }
                return false;
            }
            DynamicObject receiverObj = (DynamicObject)receiver;
            PropertyDescriptor existingDesc = JSObject.getOwnProperty(receiverObj, key);
            if (existingDesc != null) {
                if (existingDesc.isAccessorDescriptor()) {
                    if (isStrict) {
                        throw Errors.createTypeErrorCannotRedefineProperty(key);
                    }
                    return false;
                }
                if (!existingDesc.getWritable()) {
                    if (isStrict) {
                        throw Errors.createTypeErrorNotWritableProperty(key, receiverObj);
                    }
                    return false;
                }
                PropertyDescriptor valueDesc = PropertyDescriptor.createData(value);
                return JSObject.defineOwnProperty(receiverObj, key, valueDesc, isStrict);
            }
            return JSRuntime.createDataProperty(receiverObj, key, value, isStrict);
        }
        assert (descriptor.isAccessorDescriptor());
        Object setter = descriptor.getSet();
        if (setter == Undefined.instance || setter == null) {
            if (isStrict) {
                throw Errors.createTypeErrorCannotSetAccessorProperty(key, target);
            }
            return false;
        }
        JSRuntime.call(setter, receiver, new Object[]{value});
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    protected static boolean setPropertySlow(DynamicObject thisObj, Object key, Object value, Object receiver, boolean isStrict, boolean isIndex) {
        assert (JSRuntime.isPropertyKey(key));
        DynamicObject current = JSObject.getPrototype(thisObj);
        while (current != Null.instance) {
            if (JSProxy.isProxy(current)) {
                return JSObject.setWithReceiver(current, key, value, receiver, isStrict);
            }
            PropertyDescriptor desc = JSObject.getOwnProperty(current, key);
            if (desc != null) {
                if (desc.isDataDescriptor() && !desc.getWritable()) {
                    if (isStrict) {
                        throw Errors.createTypeErrorNotWritableProperty(key, current);
                    }
                    return false;
                }
                if (!desc.isAccessorDescriptor()) break;
                return JSBuiltinObject.invokeAccessorPropertySetter(desc, thisObj, key, value, receiver, isStrict);
            }
            current = JSObject.getPrototype(current);
        }
        assert (thisObj == receiver);
        DynamicObject receiverObj = (DynamicObject)receiver;
        if (!JSObject.isExtensible(receiverObj)) {
            if (isStrict) {
                throw Errors.createTypeErrorNotExtensible(receiverObj, key);
            }
            return false;
        }
        if (JSTruffleOptions.DictionaryObject) {
            boolean isDictionaryObject = JSDictionaryObject.isJSDictionaryObject(thisObj);
            if (!isDictionaryObject && JSBuiltinObject.isDictionaryObjectCandidate(thisObj, isIndex)) {
                JSDictionaryObject.makeDictionaryObject(thisObj, "set");
                isDictionaryObject = true;
            }
            if (isDictionaryObject) {
                JSDictionaryObject.getHashMap(thisObj).put(key, (Object)PropertyDescriptor.createDataDefault(value));
                return true;
            }
        }
        JSContext context = JSObject.getJSContext(thisObj);
        JSObjectUtil.putDataProperty(context, thisObj, key, value, JSAttributes.getDefault());
        return true;
    }

    protected static boolean invokeAccessorPropertySetter(PropertyDescriptor desc, DynamicObject thisObj, Object key, Object value, Object receiver, boolean isStrict) {
        CompilerAsserts.neverPartOfCompilation();
        assert (desc.isAccessorDescriptor());
        DynamicObject setter = (DynamicObject)desc.getSet();
        if (setter != Undefined.instance) {
            JSRuntime.call(setter, receiver, new Object[]{value});
            return true;
        }
        if (isStrict) {
            throw Errors.createTypeErrorCannotSetAccessorProperty(key, thisObj);
        }
        return false;
    }

    private static boolean isDictionaryObjectCandidate(DynamicObject thisObj, boolean isIndex) {
        if (!JSTruffleOptions.DictionaryObject) {
            return false;
        }
        if (!JSUserObject.isJSUserObject(thisObj)) {
            return false;
        }
        int count = thisObj.getShape().getPropertyCount();
        return count == 0 && isIndex || count == JSTruffleOptions.DictionaryObjectTransitionThreshold;
    }

    @Override
    public PropertyDescriptor getOwnProperty(DynamicObject thisObj, Object key) {
        return JSBuiltinObject.ordinaryGetOwnProperty(thisObj, key);
    }

    public static PropertyDescriptor ordinaryGetOwnProperty(DynamicObject thisObj, Object key) {
        assert (JSRuntime.isPropertyKey(key));
        Property prop = thisObj.getShape().getProperty(key);
        if (prop == null) {
            return null;
        }
        return JSBuiltinObject.ordinaryGetOwnPropertyIntl(thisObj, key, prop);
    }

    @CompilerDirectives.TruffleBoundary
    public static PropertyDescriptor ordinaryGetOwnPropertyIntl(DynamicObject thisObj, Object key, Property prop) {
        PropertyDescriptor desc;
        if (JSProperty.isData(prop)) {
            desc = PropertyDescriptor.createData(JSObject.get(thisObj, key));
            desc.setWritable(JSProperty.isWritable(prop));
        } else if (JSProperty.isAccessor(prop)) {
            Accessor acc = (Accessor)prop.get(thisObj, false);
            desc = PropertyDescriptor.createAccessor(acc.getGetter(), acc.getSetter());
        } else {
            desc = PropertyDescriptor.createEmpty();
        }
        desc.setEnumerable(JSProperty.isEnumerable(prop));
        desc.setConfigurable(JSProperty.isConfigurable(prop));
        return desc;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean setIntegrityLevel(DynamicObject thisObj, boolean freeze) {
        Shape newShape;
        Shape shape = thisObj.getShape();
        if (thisObj.updateShape()) {
            shape = thisObj.getShape();
        }
        Shape shape2 = newShape = freeze ? JSShape.freeze(shape) : JSShape.seal(shape);
        if (shape != newShape) {
            thisObj.setShapeAndGrow(shape, newShape);
            thisObj.updateShape();
        }
        return JSObject.preventExtensions(thisObj);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean preventExtensions(DynamicObject thisObj) {
        Shape newShape;
        Shape shape = thisObj.getShape();
        if (thisObj.updateShape()) {
            shape = thisObj.getShape();
        }
        if (shape != (newShape = JSShape.makeNotExtensible(shape))) {
            thisObj.setShapeAndGrow(shape, newShape);
            thisObj.updateShape();
        }
        return true;
    }

    @Override
    public final boolean isExtensible(DynamicObject thisObj) {
        return JSShape.isExtensible(thisObj.getShape());
    }

    @Override
    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    @Override
    public String safeToString(DynamicObject obj, int depth, JSContext context) {
        if (context.isOptionNashornCompatibilityMode()) {
            return this.defaultToString(obj);
        }
        return JSRuntime.objectToConsoleString(obj, this.getClassName(obj), depth);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public final DynamicObject getPrototypeOf(DynamicObject thisObj) {
        return (DynamicObject)JSShape.getPrototypeProperty(thisObj.getShape()).get(thisObj, false);
    }

    @Override
    public boolean setPrototypeOf(DynamicObject thisObj, DynamicObject newPrototype) {
        return JSBuiltinObject.setPrototypeStatic(thisObj, newPrototype);
    }

    @CompilerDirectives.TruffleBoundary
    static boolean setPrototypeStatic(DynamicObject thisObj, DynamicObject newPrototype) {
        if (!JSBuiltinObject.checkProtoCycle(thisObj, newPrototype)) {
            return false;
        }
        Shape shape = thisObj.getShape();
        DynamicObject oldPrototype = JSObject.getPrototype(thisObj);
        if (oldPrototype == newPrototype) {
            return true;
        }
        if (!JSShape.isExtensible(shape)) {
            return false;
        }
        if (JSShape.isPrototypeInShape(shape)) {
            JSObjectUtil.setPrototype(thisObj, newPrototype);
        } else {
            JSShape.getPrototypeProperty(shape).setSafe(thisObj, (Object)newPrototype, null);
        }
        return true;
    }

    public static boolean checkProtoCycle(DynamicObject thisObj, DynamicObject newPrototype) {
        DynamicObject check = newPrototype;
        while (check != Null.instance) {
            if (check == thisObj) {
                return false;
            }
            if (JSProxy.isProxy(check)) {
                return true;
            }
            check = JSObject.getPrototype(check);
        }
        return true;
    }

    protected static void putConstructorSpeciesGetter(JSRealm realm, DynamicObject constructor) {
        JSObjectUtil.putConstantAccessorProperty(realm.getContext(), constructor, Symbol.SYMBOL_SPECIES, JSBuiltinObject.createSymbolSpeciesGetterFunction(realm), Undefined.instance);
    }

    protected static DynamicObject createSymbolSpeciesGetterFunction(JSRealm realm) {
        return JSFunction.create(realm, JSFunctionData.createCallOnly(realm.getContext(), realm.getContext().getSpeciesGetterFunctionCallTarget(), 0, "get [Symbol.species]"));
    }

    @Override
    public String getBuiltinToStringTag(DynamicObject object) {
        return "Object";
    }

    @Override
    public boolean usesOrdinaryGetOwnProperty() {
        return true;
    }

    @Override
    public boolean usesOrdinaryIsExtensible() {
        return true;
    }
}

