/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime;

import com.oracle.truffle.api.TruffleOptions;
import java.util.HashMap;
import java.util.Map;

public final class JSTruffleOptions {
    public static final String TRUFFLE_JS_OPTION_PREFIX = "truffle.js.";
    public static final String JS_OPTION_PREFIX = "js.";
    private static final String PARSER_OPTION_PREFIX = "parser.";
    public static final String ProfileTimeKey = "ProfileTime";
    private static Map<String, String> graaljsOptions = JSTruffleOptions.readGraaljsOptions();
    public static final boolean SubstrateVM = JSTruffleOptions.booleanOption("SubstrateVM", TruffleOptions.AOT);
    public static final boolean ReturnOptimizer = JSTruffleOptions.booleanOption("ReturnOptimizer", true);
    public static final boolean ReturnValueInFrame = JSTruffleOptions.booleanOption("ReturnValueInFrame", true);
    public static final boolean LocalVarIncDecNode = JSTruffleOptions.booleanOption("LocalVarIncDecNode", true);
    public static final boolean OptimizeApplyArguments = JSTruffleOptions.booleanOption("OptimizeApplyArguments", true);
    public static final boolean PrintAst = JSTruffleOptions.booleanOption("PrintAst", false);
    public static final boolean PrintParse = JSTruffleOptions.booleanOption("PrintParse", false);
    public static final boolean OptimizeNoFallthroughSwitch = JSTruffleOptions.booleanOption("OptimizeNoFallthroughSwitch", true);
    public static final boolean ManyBlockScopes = JSTruffleOptions.booleanOption("ManyBlockScopes", false);
    public static final boolean YieldResultInFrame = JSTruffleOptions.booleanOption("YieldResultInFrame", true);
    public static int PropertyCacheLimit = JSTruffleOptions.integerOption("PropertyCacheLimit", 5);
    public static int FunctionCacheLimit = JSTruffleOptions.integerOption("FunctionCacheLimit", 4);
    public static final boolean AssertFinalPropertySpecialization = JSTruffleOptions.booleanOption("AssertFinalPropertySpecialization", false);
    public static final boolean FunctionCacheOnInstance = JSTruffleOptions.booleanOption("FunctionCacheOnInstance", true);
    public static final boolean DictionaryObject = JSTruffleOptions.booleanOption("DictionaryObject", true);
    public static final int DictionaryObjectThreshold = JSTruffleOptions.integerOption("DictionaryObjectThreshold", 256);
    public static final int DictionaryObjectTransitionThreshold = JSTruffleOptions.integerOption("DictionaryObjectThreshold", 1024);
    public static final boolean TraceDictionaryObject = JSTruffleOptions.booleanOption("TraceDictionaryObject", false);
    public static final boolean MergeShapes = JSTruffleOptions.booleanOption("MergeShapes", true);
    public static final boolean SkipPrototypeShapeCheck = JSTruffleOptions.booleanOption("SkipPrototypeShapeCheck", true);
    public static final boolean SkipGlobalShapeCheck = JSTruffleOptions.booleanOption("SkipGlobalShapeCheck", true);
    public static final boolean SkipFinalShapeCheck = JSTruffleOptions.booleanOption("SkipFinalShapeCheck", true);
    public static final boolean LeafShapeAssumption = JSTruffleOptions.booleanOption("LeafShapeAssumption", true);
    public static final boolean LazyStrings = JSTruffleOptions.booleanOption("LazyStrings", true);
    public static final boolean RestrictForceSplittingBuiltins = JSTruffleOptions.booleanOption("RestrictForceSplittingBuiltins", true);
    public static final int MinLazyStringLength = JSTruffleOptions.integerOption("MinLazyStringLength", 20);
    public static final int ConcatToLeafLimit = JSTruffleOptions.integerOption("ConcatToLeafLimit", MinLazyStringLength / 2);
    public static final int MaxCompiledRegexCacheLength = JSTruffleOptions.integerOption("MaxCompiledRegexCacheLength", 4);
    public static final boolean TrimCompiledRegexCache = JSTruffleOptions.booleanOption("TrimCompiledRegexCache", true);
    public static final int StackTraceLimit = JSTruffleOptions.integerOption("StackTraceLimit", 10);
    public static final int StringLengthLimit = JSTruffleOptions.integerOption("StringLengthLimit", 1073741799);
    public static final int MaxTypedArrayLength = JSTruffleOptions.integerOption("MaxTypedArrayLength", 0x3FFFFFFF);
    public static final int MaxApplyArgumentLength = JSTruffleOptions.integerOption("MaxApplyArgumentLength", 10000000);
    public static final int MaxExpectedPrototypeChainLength = JSTruffleOptions.integerOption("MaxExpectedPrototypeChainLength", 32766);
    public static final boolean UseSuperOperations = JSTruffleOptions.booleanOption("UseSuperOperations", true);
    public static final boolean FastOwnKeys = JSTruffleOptions.booleanOption("FastOwnKeys", true);
    public static final boolean FillExceptionStack = JSTruffleOptions.booleanOption("FillExceptionStack", true);
    public static final boolean EagerStackTrace = JSTruffleOptions.booleanOption("EagerStackTrace", false);
    public static final int InitialArraySize = JSTruffleOptions.integerOption("array.InitialArraySize", 8);
    public static final int MaxArrayHoleSize = JSTruffleOptions.integerOption("array.MaxArrayHoleSize", 5000);
    public static final int MaxFlatArraySize = JSTruffleOptions.integerOption("array.MaxFlatArraySize", 1000000);
    public static final boolean TrackArrayAllocationSites = JSTruffleOptions.booleanOption("array.TrackAllocationSites", false);
    public static final int BigArrayThreshold = JSTruffleOptions.integerOption("array.BigArrayThreshold", 10000);
    public static final boolean MarkElementsNonNull = JSTruffleOptions.booleanOption("array.MarkElementsNonNull", true);
    public static final boolean DirectByteBuffer = JSTruffleOptions.booleanOption("DirectByteBuffer", false);
    public static final int ECMAScript5 = 5;
    public static final int ECMAScript6 = 6;
    public static final int ECMAScript2015 = 6;
    public static final int ECMAScript2016 = 7;
    public static final int ECMAScript2017 = 8;
    public static final int ECMAScript2018 = 9;
    public static final int ECMAScript2019 = 10;
    public static final int ECMAScript2020 = 11;
    public static final int ECMAScript2021 = 12;
    public static final int ECMAScriptNumberYearDelta = 2009;
    public static final int LatestECMAScriptVersion = 10;
    public static final int MaxECMAScriptVersion = JSTruffleOptions.integerOption("ECMAScriptVersion", 12);
    public static final boolean AnnexB = JSTruffleOptions.booleanOption("AnnexB", true);
    public static final boolean U180EWhitespace = false;
    public static final boolean TruffleJSONParser = JSTruffleOptions.booleanOption("TruffleJSONParser", true);
    public static final boolean DumpHeapOnExit = JSTruffleOptions.booleanOption("DumpHeapOnExit", false);
    public static final String HeapDumpFileName = JSTruffleOptions.stringOption("HeapDumpFileName", null);
    public static final boolean TracePolymorphicPropertyAccess = JSTruffleOptions.booleanOption("TracePolymorphicPropertyAccess", false);
    public static final boolean TraceMegamorphicPropertyAccess = JSTruffleOptions.booleanOption("TraceMegamorphicPropertyAccess", false);
    public static final boolean TraceFunctionCache = JSTruffleOptions.booleanOption("TraceFunctionCache", false);
    public static final boolean TraceArrayTransitions = JSTruffleOptions.booleanOption("TraceArrayTransitions", false);
    public static final boolean TraceArrayWrites = JSTruffleOptions.booleanOption("TraceArrayWrites", false);
    public static final boolean ProfileTime = JSTruffleOptions.booleanOption("ProfileTime", false);
    public static final boolean PrintCumulativeTime = JSTruffleOptions.booleanOption("PrintCumulativeTime", false);
    public static final String DebugPropertyName = JSTruffleOptions.stringOption("DebugPropertyName", "Debug");
    public static final boolean DebugCounters = JSTruffleOptions.booleanOption("DebugCounters", false);
    public static final boolean LazyFunctionData = JSTruffleOptions.booleanOption("LazyFunctionData", true);
    public static final boolean LazyTranslation = JSTruffleOptions.booleanOption("LazyTranslation", false);
    public static final boolean InlineTrivialBuiltins = JSTruffleOptions.booleanOption("InlineTrivialBuiltins", true);
    public static final boolean DetailedCallTargetNames = JSTruffleOptions.booleanOption("DetailedCallTargetNames", false);
    public static final boolean TestCloneUninitialized = JSTruffleOptions.booleanOption("TestCloneUninitialized", false);
    public static final int MaxConsolePrintProperties = 20;
    public static final int SpreadArgumentPlaceholderCount = JSTruffleOptions.integerOption("SpreadArgumentPlaceholderCount", 3);
    public static final boolean UseTRegex = JSTruffleOptions.booleanOption("UseTRegex", true);
    public static final boolean RegexRegressionTestMode = JSTruffleOptions.booleanOption("RegexRegressionTestMode", false);
    public static final boolean InteropCompletePromises = JSTruffleOptions.booleanOption("InteropCompletePromises", false);

    private JSTruffleOptions() {
    }

    private static Object checkUnknownOptions() {
        boolean unknownOptions = false;
        if (graaljsOptions.size() > 0) {
            for (String key : graaljsOptions.keySet()) {
                if (key.startsWith(PARSER_OPTION_PREFIX)) continue;
                System.out.println("unknown option: truffle.js." + key);
                unknownOptions = true;
            }
        }
        if (unknownOptions) {
            throw new RuntimeException("exit due to unknown options");
        }
        graaljsOptions = null;
        return null;
    }

    private static Map<String, String> readGraaljsOptions() {
        HashMap<String, String> options = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String strKey = entry.getKey().toString();
            if (!strKey.startsWith(TRUFFLE_JS_OPTION_PREFIX)) continue;
            options.put(strKey.substring(TRUFFLE_JS_OPTION_PREFIX.length()), entry.getValue().toString());
        }
        return options;
    }

    private static String readProperty(String name) {
        return graaljsOptions.remove(name);
    }

    public static String getOptionName(String key) {
        return TRUFFLE_JS_OPTION_PREFIX + key;
    }

    private static boolean booleanOption(String name, boolean defaultValue) {
        String value = JSTruffleOptions.readProperty(name);
        return value == null ? defaultValue : value.equalsIgnoreCase("true");
    }

    private static Integer integerOption(String name, int defaultValue) {
        try {
            String prop = JSTruffleOptions.readProperty(name);
            if (prop == null) {
                return defaultValue;
            }
            return Integer.decode(prop);
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    private static String stringOption(String name, String defaultValue) {
        String value = JSTruffleOptions.readProperty(name);
        return value == null ? defaultValue : value;
    }

    static {
        JSTruffleOptions.checkUnknownOptions();
    }
}

