/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.parser.env;

import com.oracle.js.parser.ir.Symbol;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.NodeFactory;
import com.oracle.truffle.js.nodes.ReadNode;
import com.oracle.truffle.js.nodes.RepeatableNode;
import com.oracle.truffle.js.nodes.access.EvalVariableNode;
import com.oracle.truffle.js.nodes.access.JSTargetableNode;
import com.oracle.truffle.js.nodes.access.JSWriteFrameSlotNode;
import com.oracle.truffle.js.nodes.access.PropertyNode;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import com.oracle.truffle.js.nodes.access.WriteElementNode;
import com.oracle.truffle.js.nodes.access.WriteNode;
import com.oracle.truffle.js.nodes.access.WritePropertyNode;
import com.oracle.truffle.js.parser.env.BlockEnvironment;
import com.oracle.truffle.js.parser.env.DebugEnvironment;
import com.oracle.truffle.js.parser.env.FunctionEnvironment;
import com.oracle.truffle.js.parser.env.GlobalEnvironment;
import com.oracle.truffle.js.parser.env.WithEnvironment;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.util.Pair;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public abstract class Environment {
    public static final String ARGUMENTS_NAME = "arguments";
    public static final String THIS_NAME = "this";
    public static final String SUPER_NAME = "super";
    public static final String NEW_TARGET_NAME = "new.target";
    private final Environment parent;
    protected final NodeFactory factory;
    protected final JSContext context;

    public Environment(Environment parent, NodeFactory factory, JSContext context) {
        this.parent = parent;
        this.factory = factory;
        this.context = context;
    }

    public FrameSlot declareLocalVar(Object name) {
        return this.function().declareLocalVar(name);
    }

    public FrameSlot declareVar(Object name) {
        return this.function().declareVar(name);
    }

    public boolean hasLocalVar(String name) {
        return this.getFunctionFrameDescriptor().getIdentifiers().contains(name);
    }

    public VarRef findThisVar() {
        return this.findInternalSlot("<this>", true);
    }

    public VarRef findSuperVar() {
        assert (!this.function().isGlobal());
        return this.findInternalSlot("<super>");
    }

    public VarRef findArgumentsVar() {
        assert (!this.function().isGlobal());
        return this.findInternalSlot("<arguments>");
    }

    public VarRef findNewTargetVar() {
        assert (!this.function().isGlobal());
        return this.findInternalSlot("<new.target>");
    }

    public VarRef findAsyncContextVar() {
        assert (!this.function().isGlobal());
        this.declareLocalVar("<asynccontext>");
        return this.findInternalSlot("<asynccontext>");
    }

    public VarRef findAsyncResultVar() {
        assert (!this.function().isGlobal());
        this.declareLocalVar("<asyncresult>");
        return this.findInternalSlot("<asyncresult>");
    }

    public VarRef findYieldValueVar() {
        assert (!this.function().isGlobal());
        this.declareLocalVar("<yieldvalue>");
        return this.findInternalSlot("<yieldvalue>");
    }

    public VarRef findDynamicScopeVar() {
        assert (!this.function().isGlobal());
        return this.findInternalSlot("<evalscope>");
    }

    protected final JavaScriptNode createLocal(FrameSlot frameSlot, int level, int scopeLevel) {
        return this.factory.createLocal(frameSlot, level, scopeLevel, this.getParentSlots(level, scopeLevel), false);
    }

    protected final JavaScriptNode createLocal(FrameSlot frameSlot, int level, int scopeLevel, boolean checkTDZ) {
        return this.factory.createLocal(frameSlot, level, scopeLevel, this.getParentSlots(level, scopeLevel), checkTDZ);
    }

    protected final VarRef findInternalSlot(String name) {
        return this.findInternalSlot(name, false);
    }

    protected final VarRef findInternalSlot(String name, boolean allowDebug) {
        Environment current = this;
        int frameLevel = 0;
        int scopeLevel = 0;
        do {
            FrameSlot slot;
            if ((slot = current.findBlockFrameSlot(name)) != null) {
                return this.newFrameSlotVarRef(slot, scopeLevel, frameLevel, name, current);
            }
            if (current instanceof FunctionEnvironment) {
                ++frameLevel;
                scopeLevel = 0;
                continue;
            }
            if (current instanceof BlockEnvironment) {
                ++scopeLevel;
                continue;
            }
            if (current instanceof DebugEnvironment && !allowDebug) break;
        } while ((current = current.getParent()) != null);
        return null;
    }

    public final VarRef findLocalVar(String name) {
        return this.findVar(name, true, true, false, true);
    }

    public final VarRef findVar(String name, boolean skipWith) {
        return this.findVar(name, skipWith, skipWith, false, false);
    }

    public final VarRef findVar(String name, boolean skipWith, boolean skipEval, boolean skipBlockScoped, boolean skipGlobal) {
        assert (!name.equals("null"));
        Environment current = this;
        int frameLevel = 0;
        int scopeLevel = 0;
        WrapClosure wrapClosure = null;
        int wrapFrameLevel = 0;
        do {
            if (current instanceof WithEnvironment) {
                if (skipWith) continue;
                wrapClosure = this.makeWithWrapClosure(wrapClosure, name, ((WithEnvironment)current).getWithVarName());
                wrapFrameLevel = frameLevel;
                continue;
            }
            if (current instanceof GlobalEnvironment) {
                GlobalEnvironment globalEnv = (GlobalEnvironment)current;
                if (globalEnv.hasLexicalDeclaration(name) && !GlobalEnvironment.isGlobalObjectConstant(name)) {
                    return this.wrapIn(wrapClosure, wrapFrameLevel, new GlobalLexVarRef(name, globalEnv.hasConstDeclaration(name)));
                }
                if (globalEnv.hasVarDeclaration(name) || GlobalEnvironment.isGlobalObjectConstant(name)) continue;
                wrapClosure = this.makeGlobalWrapClosure(wrapClosure, name);
                continue;
            }
            FrameSlot slot = current.findBlockFrameSlot(name);
            if (!(slot == null || skipBlockScoped && (JSFrameUtil.isConst(slot) || JSFrameUtil.isLet(slot)))) {
                return this.wrapIn(wrapClosure, wrapFrameLevel, this.newFrameSlotVarRef(slot, scopeLevel, frameLevel, name, current));
            }
            if (current instanceof FunctionEnvironment) {
                FunctionEnvironment fnEnv = current.function();
                if (fnEnv.isNamedFunctionExpression() && fnEnv.getFunctionName().equals(name)) {
                    return this.wrapIn(wrapClosure, wrapFrameLevel, new FunctionCalleeVarRef(scopeLevel, frameLevel, name, current));
                }
                if (!skipEval && fnEnv.isDynamicallyScoped()) {
                    wrapClosure = this.makeEvalWrapClosure(wrapClosure, name, frameLevel, scopeLevel, current);
                    wrapFrameLevel = frameLevel;
                }
                if (!fnEnv.isGlobal() && !fnEnv.isEval() && name.equals(ARGUMENTS_NAME)) {
                    if (fnEnv.hasArgumentsSlot()) {
                        return this.wrapIn(wrapClosure, wrapFrameLevel, new ArgumentsVarRef(scopeLevel, frameLevel, name, current));
                    }
                    assert (fnEnv.isArrowFunction());
                }
                ++frameLevel;
                scopeLevel = 0;
                continue;
            }
            if (!(current instanceof BlockEnvironment)) continue;
            ++scopeLevel;
        } while ((current = current.getParent()) != null);
        if (skipGlobal) {
            return null;
        }
        return this.wrapIn(wrapClosure, wrapFrameLevel, new GlobalVarRef(name));
    }

    void ensureFrameLevelAvailable(int frameLevel) {
        int level = 0;
        for (FunctionEnvironment currentFunction = this.function(); currentFunction != null && level < frameLevel; currentFunction = currentFunction.getParentFunction(), ++level) {
            currentFunction.setNeedsParentFrame(true);
        }
    }

    private WrapClosure makeEvalWrapClosure(WrapClosure wrapClosure, final String name, final int frameLevel, final int scopeLevel, Environment current) {
        final FrameSlot dynamicScopeSlot = current.findBlockFrameSlot("<evalscope>");
        assert (dynamicScopeSlot != null);
        return WrapClosure.compose(wrapClosure, new WrapClosure(){

            @Override
            public JavaScriptNode apply(JavaScriptNode delegateNode, WrapAccess access) {
                JSTargetableNode scopeAccessNode;
                JavaScriptNode dynamicScopeNode = Environment.this.createLocal(dynamicScopeSlot, frameLevel, scopeLevel);
                if (access == WrapAccess.Delete) {
                    scopeAccessNode = Environment.this.factory.createDeleteProperty(null, Environment.this.factory.createConstantString(name), Environment.this.isStrictMode(), Environment.this.context);
                } else if (access == WrapAccess.Write) {
                    assert (delegateNode instanceof WriteNode) : delegateNode;
                    scopeAccessNode = Environment.this.factory.createWriteProperty(null, name, null, Environment.this.context, Environment.this.isStrictMode());
                } else if (access == WrapAccess.Read) {
                    assert (delegateNode instanceof ReadNode || delegateNode instanceof RepeatableNode) : delegateNode;
                    scopeAccessNode = Environment.this.factory.createProperty(Environment.this.context, null, name);
                } else {
                    throw new IllegalArgumentException();
                }
                return new EvalVariableNode(Environment.this.context, name, delegateNode, dynamicScopeNode, scopeAccessNode);
            }
        });
    }

    private WrapClosure makeWithWrapClosure(WrapClosure wrapClosure, final String name, final String withVarName) {
        return WrapClosure.compose(wrapClosure, new WrapClosure(){

            @Override
            public JavaScriptNode apply(JavaScriptNode delegateNode, WrapAccess access) {
                JSTargetableNode withAccessNode;
                if (access == WrapAccess.Delete) {
                    withAccessNode = Environment.this.factory.createDeleteProperty(null, Environment.this.factory.createConstantString(name), Environment.this.isStrictMode(), Environment.this.context);
                } else if (access == WrapAccess.Write) {
                    assert (delegateNode instanceof WriteNode) : delegateNode;
                    withAccessNode = Environment.this.factory.createWriteProperty(null, name, null, Environment.this.context, Environment.this.isStrictMode());
                } else if (access == WrapAccess.Read) {
                    assert (delegateNode instanceof ReadNode || delegateNode instanceof RepeatableNode) : delegateNode;
                    withAccessNode = Environment.this.factory.createProperty(Environment.this.context, null, name);
                } else {
                    throw new IllegalArgumentException();
                }
                JavaScriptNode withTarget = Environment.this.factory.createWithTarget(Environment.this.context, name, Environment.this.findInternalSlot(withVarName).createReadNode());
                return Environment.this.factory.createWithVarWrapper(name, withTarget, withAccessNode, delegateNode);
            }

            @Override
            public Pair<Supplier<JavaScriptNode>, UnaryOperator<JavaScriptNode>> applyCompound(Pair<Supplier<JavaScriptNode>, UnaryOperator<JavaScriptNode>> suppliers) {
                VarRef withTargetTempVar = Environment.this.createTempVar();
                VarRef withObjVar = Environment.this.findInternalSlot(withVarName);
                Supplier<JavaScriptNode> innerReadSupplier = suppliers.getFirst();
                UnaryOperator<JavaScriptNode> innerWriteSupplier = suppliers.getSecond();
                Supplier<JavaScriptNode> readSupplier = () -> {
                    PropertyNode readWithProperty = Environment.this.factory.createProperty(Environment.this.context, null, name);
                    return Environment.this.factory.createWithVarWrapper(name, withTargetTempVar.createReadNode(), readWithProperty, (JavaScriptNode)((Object)((Object)innerReadSupplier.get())));
                };
                UnaryOperator writeSupplier = rhs -> {
                    JavaScriptNode withTarget = Environment.this.factory.createWithTarget(Environment.this.context, name, withObjVar.createReadNode());
                    WritePropertyNode writeWithProperty = Environment.this.factory.createWriteProperty(null, name, null, Environment.this.context, Environment.this.isStrictMode());
                    return Environment.this.factory.createWithVarWrapper(name, withTargetTempVar.createWriteNode(withTarget), writeWithProperty, (JavaScriptNode)((Object)((Object)innerWriteSupplier.apply((JavaScriptNode)((Object)rhs)))));
                };
                return new Pair<Supplier<JavaScriptNode>, UnaryOperator<JavaScriptNode>>(readSupplier, writeSupplier);
            }
        });
    }

    private WrapClosure makeGlobalWrapClosure(WrapClosure wrapClosure, final String name) {
        return WrapClosure.compose(wrapClosure, new WrapClosure(){

            @Override
            public JavaScriptNode apply(JavaScriptNode delegateNode, WrapAccess access) {
                JSTargetableNode scopeAccessNode;
                if (access == WrapAccess.Delete) {
                    scopeAccessNode = Environment.this.factory.createDeleteProperty(null, Environment.this.factory.createConstantString(name), Environment.this.isStrictMode(), Environment.this.context);
                } else if (access == WrapAccess.Write) {
                    assert (delegateNode instanceof WriteNode) : delegateNode;
                    scopeAccessNode = Environment.this.factory.createWriteProperty(null, name, null, Environment.this.context, true);
                } else if (access == WrapAccess.Read) {
                    assert (delegateNode instanceof ReadNode || delegateNode instanceof RepeatableNode) : delegateNode;
                    scopeAccessNode = Environment.this.factory.createProperty(Environment.this.context, null, name);
                } else {
                    throw new IllegalArgumentException();
                }
                JavaScriptNode globalScope = Environment.this.factory.createGlobalScope(Environment.this.context);
                return Environment.this.factory.createGlobalVarWrapper(name, delegateNode, globalScope, scopeAccessNode);
            }
        });
    }

    private VarRef wrapIn(WrapClosure wrapClosure, int wrapFrameLevel, VarRef wrappee) {
        if (wrapClosure != null) {
            this.ensureFrameLevelAvailable(wrapFrameLevel);
            return new WrappedVarRef(wrappee.getName(), wrappee, wrapClosure);
        }
        return wrappee;
    }

    protected abstract FrameSlot findBlockFrameSlot(String var1);

    public FrameDescriptor getBlockFrameDescriptor() {
        return this.getFunctionFrameDescriptor();
    }

    private VarRef newFrameSlotVarRef(FrameSlot slot, int scopeLevel, int frameLevel, String name, Environment current) {
        if (current instanceof DebugEnvironment) {
            return new LazyFrameSlotVarRef(slot, scopeLevel, frameLevel, name, current);
        }
        return new FrameSlotVarRef(slot, scopeLevel, frameLevel, name, current);
    }

    private JavaScriptNode findLocalVarNodeForArguments(Environment current, int frameLevel, int scopeLevel) {
        assert (current.function().getArgumentsSlot() != null);
        JavaScriptNode argumentsVarNode = this.createReadArgumentObject(current, frameLevel, scopeLevel);
        if (this.function().isDirectArgumentsAccess()) {
            FunctionEnvironment currentFunction = current.function();
            JavaScriptNode createArgumentsObjectNode = this.factory.createArgumentsObjectNode(this.context, this.isStrictMode(), currentFunction.getLeadingArgumentCount(), currentFunction.getTrailingArgumentCount());
            JSWriteFrameSlotNode writeNode = this.factory.createWriteFrameSlot(currentFunction.getArgumentsSlot(), frameLevel, scopeLevel, this.getParentSlots(frameLevel, scopeLevel), createArgumentsObjectNode);
            return this.factory.createAccessArgumentsArrayDirectly(writeNode, argumentsVarNode, currentFunction.getLeadingArgumentCount(), currentFunction.getTrailingArgumentCount());
        }
        return argumentsVarNode;
    }

    private JavaScriptNode createReadLocalVarNodeFromSlot(Environment current, int frameLevel, FrameSlot slot, int scopeLevel, boolean checkTDZ) {
        FunctionEnvironment currentFunction = current.function();
        if (currentFunction.getArgumentsSlot() != null && !currentFunction.isStrictMode() && currentFunction.hasSimpleParameterList() && currentFunction.isParam(slot)) {
            return this.createReadParameterFromMappedArguments(current, frameLevel, scopeLevel, slot);
        }
        JavaScriptNode readNode = this.createLocal(slot, frameLevel, scopeLevel, checkTDZ);
        if (JSFrameUtil.isImportBinding(slot)) {
            return this.factory.createReadImportBinding(readNode);
        }
        return readNode;
    }

    private JavaScriptNode createWriteLocalVarNodeFromSlot(Environment current, int frameLevel, FrameSlot slot, int scopeLevel, boolean checkTDZ, JavaScriptNode rhs) {
        FunctionEnvironment currentFunction = current.function();
        if (currentFunction.getArgumentsSlot() != null && !currentFunction.isStrictMode() && currentFunction.hasSimpleParameterList() && currentFunction.isParam(slot)) {
            return this.createWriteParameterFromMappedArguments(current, frameLevel, scopeLevel, slot, rhs);
        }
        return this.factory.createWriteFrameSlot(slot, frameLevel, scopeLevel, this.getParentSlots(frameLevel, scopeLevel), rhs, checkTDZ);
    }

    private JavaScriptNode createReadParameterFromMappedArguments(Environment current, int frameLevel, int scopeLevel, FrameSlot slot) {
        assert (current.function().hasSimpleParameterList());
        assert (!current.function().isDirectArgumentsAccess());
        int parameterIndex = current.function().getParameterIndex(slot);
        JavaScriptNode readArgumentsObject = this.createReadArgumentObject(current, frameLevel, scopeLevel);
        ReadElementNode readArgumentsObjectElement = this.factory.createReadElementNode(this.context, this.factory.copy(readArgumentsObject), this.factory.createConstantInteger(parameterIndex));
        return this.factory.createGuardDisconnectedArgumentRead(parameterIndex, readArgumentsObjectElement, readArgumentsObject, slot);
    }

    private JavaScriptNode createWriteParameterFromMappedArguments(Environment current, int frameLevel, int scopeLevel, FrameSlot slot, JavaScriptNode rhs) {
        assert (current.function().hasSimpleParameterList());
        assert (!current.function().isDirectArgumentsAccess());
        int parameterIndex = current.function().getParameterIndex(slot);
        JavaScriptNode readArgumentsObject = this.createReadArgumentObject(current, frameLevel, scopeLevel);
        WriteElementNode writeArgumentsObjectElement = this.factory.createWriteElementNode(this.factory.copy(readArgumentsObject), this.factory.createConstantInteger(parameterIndex), null, this.context, false);
        return this.factory.createGuardDisconnectedArgumentWrite(parameterIndex, writeArgumentsObjectElement, readArgumentsObject, rhs, slot);
    }

    private JavaScriptNode createReadArgumentObject(Environment current, int frameLevel, int scopeLevel) {
        return this.createLocal(current.function().getArgumentsSlot(), frameLevel, scopeLevel);
    }

    public Environment getParent() {
        return this.parent;
    }

    public abstract FunctionEnvironment function();

    public VarRef createTempVar() {
        FrameSlot var = this.declareTempVar("tmp");
        return this.findTempVar(var);
    }

    public VarRef findTempVar(final FrameSlot var) {
        return new VarRef((String)var.getIdentifier()){

            @Override
            public boolean isGlobal() {
                return false;
            }

            @Override
            public boolean isFunctionLocal() {
                return false;
            }

            @Override
            public FrameSlot getFrameSlot() {
                return var;
            }

            @Override
            public JavaScriptNode createReadNode() {
                return Environment.this.factory.createLocal(var, 0, Environment.this.getScopeLevel(), Environment.this.getParentSlots());
            }

            @Override
            public JavaScriptNode createWriteNode(JavaScriptNode rhs) {
                return Environment.this.factory.createWriteFrameSlot(var, 0, Environment.this.getScopeLevel(), Environment.this.getParentSlots(), rhs);
            }
        };
    }

    private FrameSlot declareTempVar(String prefix) {
        return this.declareLocalVar("<" + prefix + this.getFunctionFrameDescriptor().getSize() + ">");
    }

    public FrameDescriptor getFunctionFrameDescriptor() {
        return this.function().getFunctionFrameDescriptor();
    }

    public boolean isStrictMode() {
        return this.function().isStrictMode();
    }

    public int getScopeLevel() {
        return 0;
    }

    public FrameSlot[] getParentSlots() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public final FrameSlot[] getParentSlots(int frameLevel, int scopeLevel) {
        if (scopeLevel == 0) {
            return ScopeFrameNode.EMPTY_FRAME_SLOT_ARRAY;
        }
        if (frameLevel > 0) {
            return this.function().getParent().getParentSlots(frameLevel - 1, scopeLevel);
        }
        FrameSlot[] parentSlots = this.getParentSlots();
        assert (parentSlots.length >= scopeLevel);
        if (parentSlots.length == scopeLevel) {
            return parentSlots;
        }
        return Arrays.copyOf(parentSlots, scopeLevel);
    }

    public void addFrameSlotsFromSymbols(Iterable<Symbol> symbols) {
        this.addFrameSlotsFromSymbols(symbols, false);
    }

    public void addFrameSlotsFromSymbols(Iterable<Symbol> symbols, boolean onlyBlockScoped) {
        for (Symbol symbol : symbols) {
            if (!symbol.isBlockScoped() && (onlyBlockScoped || !symbol.isVar() || symbol.isParam() || symbol.isGlobal())) continue;
            this.addFrameSlotFromSymbol(symbol);
        }
    }

    public void addFrameSlotFromSymbol(Symbol symbol) {
        assert (!this.getBlockFrameDescriptor().getIdentifiers().contains(symbol.getName()) || this instanceof FunctionEnvironment);
        int flags = symbol.getFlags() & 0x4103;
        this.getBlockFrameDescriptor().findOrAddFrameSlot((Object)symbol.getName(), (Object)FrameSlotFlags.of(flags), FrameSlotKind.Illegal);
    }

    public boolean isDynamicallyScoped() {
        return false;
    }

    public boolean isDynamicScopeContext() {
        return this.getParent() == null ? false : this.getParent().isDynamicScopeContext();
    }

    public Environment getVariableEnvironment() {
        return this.function().getVariableEnvironment();
    }

    private static final class FrameSlotFlags {
        private static final Map<Integer, Integer> cachedFlags = new ConcurrentHashMap<Integer, Integer>();

        private FrameSlotFlags() {
        }

        static Integer of(int flags) {
            Integer boxed = flags;
            if (flags >= 128) {
                Integer cached = cachedFlags.get(boxed);
                if (cached != null) {
                    return cached;
                }
                cached = cachedFlags.putIfAbsent(boxed, boxed);
                if (cached != null) {
                    return cached;
                }
            }
            return boxed;
        }
    }

    class LazyFrameSlotVarRef
    extends AbstractFrameVarRef {
        protected final FrameSlot frameSlot;

        LazyFrameSlotVarRef(FrameSlot frameSlot, int scopeLevel, int frameLevel, String name, Environment current) {
            super(scopeLevel, frameLevel, name, current);
            this.frameSlot = frameSlot;
        }

        @Override
        public FrameSlot getFrameSlot() {
            return this.frameSlot;
        }

        @Override
        public JavaScriptNode createReadNode() {
            return Environment.this.factory.createLazyReadFrameSlot(this.frameSlot.getIdentifier());
        }

        @Override
        public JavaScriptNode createWriteNode(JavaScriptNode rhs) {
            return Environment.this.factory.createLazyWriteFrameSlot(this.frameSlot.getIdentifier(), rhs);
        }
    }

    public class WrappedVarRef
    extends VarRef {
        private final VarRef wrappee;
        private final WrapClosure wrapClosure;

        public WrappedVarRef(String name, VarRef wrappee, WrapClosure wrapClosure) {
            super(name);
            this.wrappee = wrappee;
            this.wrapClosure = wrapClosure;
            assert (!(wrappee instanceof WrappedVarRef));
        }

        @Override
        public JavaScriptNode createReadNode() {
            return this.wrapClosure.apply(this.wrappee.createReadNode(), WrapAccess.Read);
        }

        @Override
        public JavaScriptNode createWriteNode(JavaScriptNode rhs) {
            JavaScriptNode writeNode = this.wrappee.isConst() ? Environment.this.factory.createWriteConstantVariable(rhs, true) : this.wrappee.createWriteNode(rhs);
            return this.wrapClosure.apply(writeNode, WrapAccess.Write);
        }

        @Override
        public JavaScriptNode createDeleteNode() {
            return this.wrapClosure.apply(this.wrappee.createDeleteNode(), WrapAccess.Delete);
        }

        @Override
        public Pair<Supplier<JavaScriptNode>, UnaryOperator<JavaScriptNode>> createCompoundAssignNode() {
            return this.wrapClosure.applyCompound(this.wrappee.createCompoundAssignNode());
        }

        @Override
        public boolean isFunctionLocal() {
            return this.wrappee.isFunctionLocal();
        }

        @Override
        public FrameSlot getFrameSlot() {
            return null;
        }

        @Override
        public boolean isGlobal() {
            return this.wrappee.isGlobal();
        }

        public VarRef getWrappee() {
            return this.wrappee;
        }

        @Override
        public VarRef withTDZCheck() {
            return new WrappedVarRef(this.name, this.wrappee.withTDZCheck(), this.wrapClosure);
        }

        @Override
        public VarRef withRequired(boolean required) {
            return new WrappedVarRef(this.name, this.wrappee.withRequired(required), this.wrapClosure);
        }
    }

    public class GlobalLexVarRef
    extends VarRef {
        private final boolean isConst;
        private final boolean required;
        private final boolean checkTDZ;

        public GlobalLexVarRef(String name, boolean isConst) {
            this(name, isConst, true, false);
        }

        private GlobalLexVarRef(String name, boolean isConst, boolean required, boolean checkTDZ) {
            super(name);
            assert (!name.equals("null") && !name.equals("undefined"));
            this.isConst = isConst;
            this.required = required;
            this.checkTDZ = checkTDZ;
        }

        @Override
        public JavaScriptNode createReadNode() {
            if (!this.required) {
                JavaScriptNode globalScope = Environment.this.factory.createGlobalScopeTDZCheck(Environment.this.context, this.name, this.checkTDZ);
                return Environment.this.factory.createReadProperty(Environment.this.context, globalScope, this.name);
            }
            return Environment.this.factory.createReadLexicalGlobal(this.name, this.checkTDZ, Environment.this.context);
        }

        @Override
        public JavaScriptNode createWriteNode(JavaScriptNode rhs) {
            JavaScriptNode globalScope = Environment.this.factory.createGlobalScopeTDZCheck(Environment.this.context, this.name, this.checkTDZ);
            return Environment.this.factory.createWriteProperty(globalScope, this.name, rhs, this.required, Environment.this.context, true);
        }

        @Override
        public boolean isFunctionLocal() {
            return Environment.this.function().isGlobal();
        }

        @Override
        public FrameSlot getFrameSlot() {
            return null;
        }

        @Override
        public boolean isGlobal() {
            return true;
        }

        @Override
        public boolean isConst() {
            return this.isConst;
        }

        @Override
        public JavaScriptNode createDeleteNode() {
            JavaScriptNode element = Environment.this.factory.createConstantString(this.name);
            JavaScriptNode object = Environment.this.factory.createGlobalScope(Environment.this.context);
            return Environment.this.factory.createDeleteProperty(object, element, Environment.this.isStrictMode(), Environment.this.context);
        }

        @Override
        public VarRef withRequired(boolean required) {
            if (this.required != required) {
                return new GlobalLexVarRef(this.name, this.isConst, required, this.checkTDZ);
            }
            return this;
        }

        @Override
        public VarRef withTDZCheck() {
            if (!this.checkTDZ) {
                return new GlobalLexVarRef(this.name, this.isConst, this.required, true);
            }
            return this;
        }
    }

    public class GlobalVarRef
    extends VarRef {
        private final boolean required;

        public GlobalVarRef(String name) {
            this(name, true);
        }

        private GlobalVarRef(String name, boolean required) {
            super(name);
            assert (!name.equals("null"));
            this.required = required;
        }

        @Override
        public JavaScriptNode createReadNode() {
            if (this.name.equals("undefined")) {
                return Environment.this.factory.createConstantUndefined();
            }
            if (!this.required) {
                return Environment.this.factory.createReadProperty(Environment.this.context, Environment.this.factory.createGlobalObject(Environment.this.context), this.name);
            }
            return Environment.this.factory.createReadGlobalProperty(Environment.this.context, this.name);
        }

        @Override
        public JavaScriptNode createWriteNode(JavaScriptNode rhs) {
            return Environment.this.factory.createWriteProperty(Environment.this.factory.createGlobalObject(Environment.this.context), this.name, rhs, this.required, Environment.this.context, Environment.this.isStrictMode());
        }

        @Override
        public boolean isFunctionLocal() {
            return false;
        }

        @Override
        public FrameSlot getFrameSlot() {
            return null;
        }

        @Override
        public boolean isGlobal() {
            return true;
        }

        @Override
        public JavaScriptNode createDeleteNode() {
            JavaScriptNode element = Environment.this.factory.createConstantString(this.name);
            JavaScriptNode object = Environment.this.factory.createGlobalObject(Environment.this.context);
            return Environment.this.factory.createDeleteProperty(object, element, Environment.this.isStrictMode(), Environment.this.context);
        }

        @Override
        public VarRef withRequired(boolean required) {
            if (this.required != required) {
                return new GlobalVarRef(this.name, required);
            }
            return this;
        }
    }

    private final class ArgumentsVarRef
    extends AbstractArgumentsVarRef {
        ArgumentsVarRef(int scopeLevel, int frameLevel, String name, Environment current) {
            super(scopeLevel, frameLevel, name, current);
        }

        @Override
        public JavaScriptNode createReadNode() {
            return Environment.this.findLocalVarNodeForArguments(this.current, this.frameLevel, this.scopeLevel);
        }

        @Override
        public JavaScriptNode createWriteNode(JavaScriptNode rhs) {
            assert (!this.current.function().isDirectArgumentsAccess());
            return Environment.this.factory.createWriteFrameSlot(this.current.function().getArgumentsSlot(), this.frameLevel, this.scopeLevel, Environment.this.getParentSlots(this.frameLevel, this.scopeLevel), rhs);
        }
    }

    private final class FunctionCalleeVarRef
    extends AbstractArgumentsVarRef {
        FunctionCalleeVarRef(int scopeLevel, int frameLevel, String name, Environment current) {
            super(scopeLevel, frameLevel, name, current);
        }

        @Override
        public JavaScriptNode createReadNode() {
            return Environment.this.factory.createAccessCallee(this.frameLevel);
        }

        @Override
        public JavaScriptNode createWriteNode(JavaScriptNode rhs) {
            return Environment.this.factory.createWriteConstantVariable(rhs, Environment.this.isStrictMode());
        }
    }

    private abstract class AbstractArgumentsVarRef
    extends AbstractFrameVarRef {
        AbstractArgumentsVarRef(int scopeLevel, int frameLevel, String name, Environment current) {
            super(scopeLevel, frameLevel, name, current);
        }

        @Override
        public FrameSlot getFrameSlot() {
            return null;
        }
    }

    public class FrameSlotVarRef
    extends AbstractFrameVarRef {
        protected final FrameSlot frameSlot;
        private final boolean checkTDZ;

        public FrameSlotVarRef(FrameSlot frameSlot, int scopeLevel, int frameLevel, String name, Environment current) {
            this(frameSlot, scopeLevel, frameLevel, name, current, JSFrameUtil.needsTemporalDeadZoneCheck(frameSlot, frameLevel));
        }

        public FrameSlotVarRef(FrameSlot frameSlot, int scopeLevel, int frameLevel, String name, Environment current, boolean checkTDZ) {
            super(scopeLevel, frameLevel, name, current);
            this.frameSlot = frameSlot;
            this.checkTDZ = checkTDZ;
        }

        @Override
        public FrameSlot getFrameSlot() {
            return this.frameSlot;
        }

        @Override
        public boolean isConst() {
            return JSFrameUtil.isConst(this.frameSlot);
        }

        @Override
        public JavaScriptNode createReadNode() {
            return Environment.this.createReadLocalVarNodeFromSlot(this.current, this.frameLevel, this.frameSlot, this.scopeLevel, this.checkTDZ);
        }

        @Override
        public JavaScriptNode createWriteNode(JavaScriptNode rhs) {
            return Environment.this.createWriteLocalVarNodeFromSlot(this.current, this.frameLevel, this.frameSlot, this.scopeLevel, this.checkTDZ, rhs);
        }

        @Override
        public VarRef withTDZCheck() {
            if (this.checkTDZ || !JSFrameUtil.hasTemporalDeadZone(this.frameSlot)) {
                return this;
            }
            return new FrameSlotVarRef(this.frameSlot, this.scopeLevel, this.frameLevel, this.name, this.current, true);
        }
    }

    public abstract class AbstractFrameVarRef
    extends VarRef {
        protected final int scopeLevel;
        protected final int frameLevel;
        protected final Environment current;

        public AbstractFrameVarRef(int scopeLevel, int frameLevel, String name, Environment current) {
            super(name);
            this.scopeLevel = scopeLevel;
            this.frameLevel = frameLevel;
            this.current = current;
            Environment.this.ensureFrameLevelAvailable(frameLevel);
        }

        public int getScopeLevel() {
            return this.scopeLevel;
        }

        public int getFrameLevel() {
            return this.frameLevel;
        }

        @Override
        public boolean isFunctionLocal() {
            return this.frameLevel == 0;
        }

        @Override
        public boolean isGlobal() {
            return false;
        }
    }

    public abstract class VarRef {
        protected final String name;

        protected VarRef(String name) {
            this.name = name;
        }

        public abstract JavaScriptNode createReadNode();

        public abstract JavaScriptNode createWriteNode(JavaScriptNode var1);

        public abstract boolean isFunctionLocal();

        public boolean isFrameVar() {
            return this.getFrameSlot() != null;
        }

        public abstract boolean isGlobal();

        public boolean isConst() {
            return false;
        }

        public FrameSlot getFrameSlot() {
            return null;
        }

        public String getName() {
            return this.name;
        }

        public JavaScriptNode createDeleteNode() {
            return Environment.this.factory.createConstantBoolean(false);
        }

        public Pair<Supplier<JavaScriptNode>, UnaryOperator<JavaScriptNode>> createCompoundAssignNode() {
            return new Pair<Supplier<JavaScriptNode>, UnaryOperator<JavaScriptNode>>(this::createReadNode, rhs -> this.withRequired(false).createWriteNode((JavaScriptNode)((Object)rhs)));
        }

        public VarRef withTDZCheck() {
            return this;
        }

        public VarRef withRequired(boolean required) {
            return this;
        }
    }

    @FunctionalInterface
    static interface WrapClosure {
        public JavaScriptNode apply(JavaScriptNode var1, WrapAccess var2);

        default public Pair<Supplier<JavaScriptNode>, UnaryOperator<JavaScriptNode>> applyCompound(Pair<Supplier<JavaScriptNode>, UnaryOperator<JavaScriptNode>> suppliers) {
            Supplier<JavaScriptNode> readSupplier = suppliers.getFirst();
            UnaryOperator<JavaScriptNode> writeSupplier = suppliers.getSecond();
            return new Pair<Supplier<JavaScriptNode>, UnaryOperator<JavaScriptNode>>(() -> this.apply((JavaScriptNode)((Object)((Object)readSupplier.get())), WrapAccess.Read), rhs -> this.apply((JavaScriptNode)((Object)((Object)writeSupplier.apply((JavaScriptNode)((Object)rhs)))), WrapAccess.Write));
        }

        public static WrapClosure compose(final WrapClosure inner, final WrapClosure before) {
            Objects.requireNonNull(before);
            if (inner == null) {
                return before;
            }
            return new WrapClosure(){

                @Override
                public JavaScriptNode apply(JavaScriptNode v, WrapAccess w) {
                    return inner.apply(before.apply(v, w), w);
                }

                @Override
                public Pair<Supplier<JavaScriptNode>, UnaryOperator<JavaScriptNode>> applyCompound(Pair<Supplier<JavaScriptNode>, UnaryOperator<JavaScriptNode>> suppliers) {
                    return inner.applyCompound(before.applyCompound(suppliers));
                }
            };
        }
    }

    static enum WrapAccess {
        Read,
        Write,
        Delete;

    }
}

