/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.function;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.function.AbstractFunctionArgumentsNode;
import com.oracle.truffle.js.nodes.function.JSFunctionArgumentsNode;
import com.oracle.truffle.js.nodes.function.SpreadArgumentNode;
import com.oracle.truffle.js.runtime.JSTruffleOptions;
import com.oracle.truffle.js.runtime.util.SimpleArrayList;

class SpreadFunctionArgumentsNode
extends JSFunctionArgumentsNode {
    private final BranchProfile growProfile = BranchProfile.create();

    protected SpreadFunctionArgumentsNode(JavaScriptNode[] args) {
        super(args);
    }

    @Override
    public int getCount(VirtualFrame frame) {
        return this.args.length;
    }

    @Override
    @ExplodeLoop
    public Object[] executeFillObjectArray(VirtualFrame frame, Object[] arguments, int fixedArgumentsLength) {
        int i;
        SimpleArrayList<Object> argList = SimpleArrayList.create(fixedArgumentsLength + this.args.length + JSTruffleOptions.SpreadArgumentPlaceholderCount);
        for (i = 0; i < fixedArgumentsLength; ++i) {
            argList.addUnchecked(arguments[i]);
        }
        for (i = 0; i < this.args.length; ++i) {
            if (this.args[i] instanceof SpreadArgumentNode) {
                ((SpreadArgumentNode)this.args[i]).executeToList(frame, argList, this.growProfile);
                continue;
            }
            argList.add(this.args[i].execute(frame), this.growProfile);
        }
        return argList.toArray();
    }

    @Override
    protected AbstractFunctionArgumentsNode copyUninitialized() {
        return new SpreadFunctionArgumentsNode(JavaScriptNode.cloneUninitialized(this.args));
    }
}

