/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.function;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.js.nodes.JSNodeUtil;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.arguments.AccessArgumentsArrayDirectlyNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.instrumentation.JSTags;
import com.oracle.truffle.js.runtime.JSContext;
import java.util.Set;

public class CallApplyArgumentsNode
extends JavaScriptNode {
    private final JSContext context;
    @Node.Child
    private JSFunctionCallNode.InvokeNode callNode;

    protected CallApplyArgumentsNode(JSContext context, JSFunctionCallNode callNode) {
        this.context = context;
        this.callNode = (JSFunctionCallNode.InvokeNode)callNode;
    }

    @Override
    public final Object execute(VirtualFrame frame) {
        Object target = this.callNode.executeTarget(frame);
        Object function = this.callNode.executeFunctionWithTarget(frame, target);
        if (function != this.context.getRealm().getApplyFunctionObject()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.replaceWithOrdinaryCall();
        }
        return this.callNode.executeCall(this.callNode.createArguments(frame, target, function));
    }

    public InstrumentableNode materializeInstrumentableNodes(Set<Class<? extends Tag>> materializedTags) {
        if (materializedTags.contains(StandardTags.ExpressionTag.class) || materializedTags.contains(JSTags.FunctionCallTag.class)) {
            this.replaceWithOrdinaryCall();
            return (InstrumentableNode)NodeUtil.cloneNode((Node)this.callNode);
        }
        return this;
    }

    private void replaceWithOrdinaryCall() {
        this.atomic(() -> {
            for (JavaScriptNode n : this.callNode.getArgumentNodes()) {
                JavaScriptNode node = JSNodeUtil.getWrappedNode(n);
                if (!(node instanceof AccessArgumentsArrayDirectlyNode)) continue;
                ((AccessArgumentsArrayDirectlyNode)node).replaceWithDefaultArguments();
            }
            this.replace(this.callNode, "not the built-in apply function");
        });
    }

    public static JavaScriptNode create(JSContext context, JSFunctionCallNode callNode) {
        return new CallApplyArgumentsNode(context, callNode);
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        return CallApplyArgumentsNode.create(this.context, CallApplyArgumentsNode.cloneUninitialized(this.callNode));
    }
}

