/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.control;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSReadFrameSlotNode;
import com.oracle.truffle.js.nodes.access.WriteNode;
import com.oracle.truffle.js.nodes.control.AsyncGeneratorYieldStarNode;
import com.oracle.truffle.js.nodes.control.AwaitNode;
import com.oracle.truffle.js.nodes.control.ReturnException;
import com.oracle.truffle.js.nodes.control.ReturnNode;
import com.oracle.truffle.js.nodes.control.YieldNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.UserScriptException;
import com.oracle.truffle.js.runtime.objects.Completion;

public class AsyncGeneratorYieldNode
extends AwaitNode {
    @Node.Child
    protected ReturnNode returnNode;
    @Node.Child
    private YieldNode.YieldResultNode generatorYieldNode;

    protected AsyncGeneratorYieldNode(JSContext context, JavaScriptNode expression, JSReadFrameSlotNode readAsyncContextNode, JSReadFrameSlotNode readYieldResultNode, ReturnNode returnNode) {
        super(context, expression, readAsyncContextNode, readYieldResultNode);
        this.returnNode = returnNode;
        this.generatorYieldNode = new YieldNode.ExceptionYieldResultNode();
    }

    public static AsyncGeneratorYieldNode createYield(JSContext context, JavaScriptNode expression, JSReadFrameSlotNode readAsyncContextNode, JSReadFrameSlotNode readAsyncResultNode, ReturnNode returnNode) {
        return new AsyncGeneratorYieldNode(context, expression, readAsyncContextNode, readAsyncResultNode, returnNode);
    }

    public static AsyncGeneratorYieldNode createYieldStar(JSContext context, JavaScriptNode expression, JSReadFrameSlotNode readAsyncContextNode, JSReadFrameSlotNode readAsyncResultNode, ReturnNode returnNode, JavaScriptNode readTemp, WriteNode writeTemp) {
        return new AsyncGeneratorYieldStarNode(context, expression, readAsyncContextNode, readAsyncResultNode, returnNode, readTemp, writeTemp);
    }

    @Override
    public Object resume(VirtualFrame frame) {
        int state = this.getStateAsInt(frame);
        boolean awaitValue = true;
        int suspendedYield = 2;
        int awaitResumptionValue = 3;
        if (state == 0) {
            Object value = this.expression.execute(frame);
            this.setState(frame, 1);
            return this.suspendAwait(frame, value);
        }
        if (state == 1) {
            Object awaited = this.resumeAwait(frame);
            this.setState(frame, 2);
            return this.suspendYield(frame, awaited);
        }
        assert (state >= 2);
        this.setState(frame, 0);
        if (state == 2) {
            Completion completion = this.resumeYield(frame);
            if (completion.isNormal()) {
                return completion.getValue();
            }
            if (completion.isThrow()) {
                throw UserScriptException.create(completion.getValue(), this);
            }
            assert (completion.isReturn());
            this.setState(frame, 3);
            return this.suspendAwait(frame, completion.getValue());
        }
        assert (state == 3);
        Object awaited = this.resumeAwait(frame);
        return this.returnValue(frame, awaited);
    }

    protected final Object suspendYield(VirtualFrame frame, Object awaited) {
        return this.generatorYieldNode.generatorYield(frame, awaited);
    }

    protected final Completion resumeYield(VirtualFrame frame) {
        return (Completion)this.readAsyncResultNode.execute(frame);
    }

    protected final Object returnValue(VirtualFrame frame, Object value) {
        assert (this.getStateAsInt(frame) == 0);
        if (this.returnNode instanceof ReturnNode.FrameReturnNode) {
            ((WriteNode)((Object)this.returnNode.expression)).executeWrite(frame, value);
        }
        throw new ReturnException(value);
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        return AsyncGeneratorYieldNode.createYield(this.context, AsyncGeneratorYieldNode.cloneUninitialized(this.expression), AsyncGeneratorYieldNode.cloneUninitialized(this.readAsyncContextNode), AsyncGeneratorYieldNode.cloneUninitialized(this.readAsyncResultNode), AsyncGeneratorYieldNode.cloneUninitialized(this.returnNode));
    }
}

