/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSConstantNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNodeGen;
import com.oracle.truffle.js.nodes.unary.JSUnaryNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.objects.JSLazyString;

@ImportStatic(value={JSRuntime.class})
public abstract class JSToBooleanNode
extends JSUnaryNode {
    protected JSToBooleanNode(JavaScriptNode operand) {
        super(operand);
    }

    @Override
    public final Object execute(VirtualFrame frame) {
        return this.executeBoolean(frame);
    }

    @Override
    public abstract boolean executeBoolean(VirtualFrame var1);

    public abstract boolean executeBoolean(Object var1);

    @Override
    public boolean isResultAlwaysOfType(Class<?> clazz) {
        return clazz == Boolean.TYPE;
    }

    public static JSToBooleanNode create() {
        return JSToBooleanNodeGen.create(null);
    }

    public static JavaScriptNode create(JavaScriptNode child) {
        Object constantOperand;
        JSConstantNode replacement = null;
        if (child.isResultAlwaysOfType(Boolean.TYPE)) {
            return child;
        }
        if (child instanceof JSConstantNode.JSConstantIntegerNode) {
            int value = ((JSConstantNode.JSConstantIntegerNode)child).executeInt(null);
            replacement = JSConstantNode.createBoolean(value != 0);
        } else if (child instanceof JSConstantNode.JSConstantBigIntNode) {
            BigInt value = ((JSConstantNode.JSConstantBigIntNode)child).executeBigInt(null);
            replacement = JSConstantNode.createBoolean(value.compareTo(BigInt.ZERO) != 0);
        } else if (child instanceof JSConstantNode && (constantOperand = ((JSConstantNode)child).getValue()) != null && JSRuntime.isJSPrimitive(constantOperand)) {
            replacement = JSConstantNode.createBoolean(JSRuntime.toBoolean(constantOperand));
        }
        if (replacement == null) {
            return JSToBooleanNodeGen.create(child);
        }
        JSToBooleanNode.transferSourceSectionAndTags(child, replacement);
        return replacement;
    }

    @Specialization
    protected boolean doBoolean(boolean value) {
        return value;
    }

    @Specialization(guards={"isJSNull(value)"})
    protected boolean doNull(Object value) {
        return false;
    }

    @Specialization(guards={"isUndefined(value)"})
    protected boolean doUndefined(Object value) {
        return false;
    }

    @Specialization
    protected boolean doInt(int value) {
        return value != 0;
    }

    @Specialization
    protected boolean doLong(long value) {
        return value != 0L;
    }

    @Specialization
    protected boolean doDouble(double value) {
        return value != 0.0 && !Double.isNaN(value);
    }

    @Specialization
    protected boolean doBigInt(BigInt value) {
        return value.compareTo(BigInt.ZERO) != 0;
    }

    @Specialization
    protected boolean doLazyString(JSLazyString value) {
        return !value.isEmpty();
    }

    @Specialization
    protected boolean doString(String value) {
        return value.length() > 0;
    }

    @Specialization(guards={"isJSObject(value)"})
    protected boolean doObject(DynamicObject value) {
        return true;
    }

    @Specialization
    protected boolean doSymbol(Symbol value) {
        return true;
    }

    @Specialization(guards={"isForeignObject(value)"}, limit="5")
    protected boolean doForeignObject(Object value, @CachedLibrary(value="value") InteropLibrary interop) {
        if (interop.isNull(value)) {
            return false;
        }
        try {
            if (interop.isBoolean(value)) {
                return interop.asBoolean(value);
            }
            if (interop.isString(value)) {
                return !interop.asString(value).isEmpty();
            }
            if (interop.isNumber(value)) {
                if (interop.fitsInInt(value)) {
                    return this.doInt(interop.asInt(value));
                }
                if (interop.fitsInLong(value)) {
                    return this.doLong(interop.asLong(value));
                }
                if (interop.fitsInDouble(value)) {
                    return this.doDouble(interop.asDouble(value));
                }
                return true;
            }
        }
        catch (UnsupportedMessageException e) {
            throw Errors.createTypeErrorUnboxException(value, (InteropException)e, this);
        }
        return true;
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        return JSToBooleanNodeGen.create(JSToBooleanNode.cloneUninitialized(this.getOperand()));
    }
}

