/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.arguments;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.arguments.ArgumentsObjectNode;
import com.oracle.truffle.js.runtime.JSArguments;

public final class AccessArgumentsArrayDirectlyNode
extends JavaScriptNode {
    private final int leadingArgCount;
    private final int trailingArgCount;
    @Node.Child
    private JavaScriptNode writeArgumentsNode;
    @Node.Child
    private JavaScriptNode readArgumentsNode;
    @CompilerDirectives.CompilationFinal
    private volatile boolean directArrayAccess = true;
    private final ConditionProfile initializedProfile = ConditionProfile.createBinaryProfile();

    public AccessArgumentsArrayDirectlyNode(JavaScriptNode writeArgumentsNode, JavaScriptNode readArgumentsNode, int leadingArgCount, int trailingArgCount) {
        this.leadingArgCount = leadingArgCount;
        this.trailingArgCount = trailingArgCount;
        this.writeArgumentsNode = writeArgumentsNode;
        this.readArgumentsNode = readArgumentsNode;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        if (this.directArrayAccess) {
            return this.asObjectArray(frame);
        }
        return this.asArgumentsObject(frame);
    }

    private Object[] asObjectArray(VirtualFrame frame) {
        return JSArguments.extractUserArguments(frame.getArguments(), this.leadingArgCount, this.trailingArgCount);
    }

    private Object asArgumentsObject(VirtualFrame frame) {
        Object argumentsArray = this.readArgumentsNode.execute(frame);
        if (this.initializedProfile.profile(ArgumentsObjectNode.isInitialized(argumentsArray))) {
            return argumentsArray;
        }
        return this.writeArgumentsNode.execute(frame);
    }

    public void replaceWithDefaultArguments() {
        CompilerAsserts.neverPartOfCompilation();
        this.directArrayAccess = false;
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        AccessArgumentsArrayDirectlyNode copy = new AccessArgumentsArrayDirectlyNode(AccessArgumentsArrayDirectlyNode.cloneUninitialized(this.writeArgumentsNode), AccessArgumentsArrayDirectlyNode.cloneUninitialized(this.readArgumentsNode), this.leadingArgCount, this.trailingArgCount);
        copy.directArrayAccess = this.directArrayAccess;
        return copy;
    }
}

