/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.instrumentation.JSTags;
import com.oracle.truffle.js.nodes.intl.CreateRegExpNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.RegexCompilerInterface;
import com.oracle.truffle.js.runtime.util.TRegexUtil;

public class RegExpLiteralNode
extends JavaScriptNode {
    private final JSContext context;
    private final String pattern;
    private final String flags;
    @CompilerDirectives.CompilationFinal
    private Object regex;
    @Node.Child
    private CreateRegExpNode createRegExpNode;
    @Node.Child
    private TRegexUtil.CompileRegexNode compileRegExpNode;

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.LiteralTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }

    public Object getNodeObject() {
        return JSTags.createNodeObjectDescriptor("literalType", JSTags.LiteralTag.Type.RegExpLiteral.name());
    }

    RegExpLiteralNode(JSContext context, String pattern, String flags) {
        this.context = context;
        this.pattern = pattern;
        this.flags = flags;
    }

    public static RegExpLiteralNode create(JSContext context, String pattern, String flags) {
        return new RegExpLiteralNode(context, pattern, flags);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        if (this.regex == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.regex = RegexCompilerInterface.compile(this.pattern, this.flags, this.context, this.getCompileRegExpNode());
        }
        return this.getCreateRegExpNode().execute(this.regex);
    }

    private TRegexUtil.CompileRegexNode getCompileRegExpNode() {
        if (this.compileRegExpNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.compileRegExpNode = (TRegexUtil.CompileRegexNode)this.insert(TRegexUtil.CompileRegexNode.create());
        }
        return this.compileRegExpNode;
    }

    private CreateRegExpNode getCreateRegExpNode() {
        if (this.createRegExpNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.createRegExpNode = (CreateRegExpNode)this.insert(CreateRegExpNode.create(this.context));
        }
        return this.createRegExpNode;
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        return RegExpLiteralNode.create(this.context, this.pattern, this.flags);
    }
}

