/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.IsObjectNodeGen;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.LargeInteger;
import com.oracle.truffle.js.runtime.Symbol;

public abstract class IsObjectNode
extends JavaScriptBaseNode {
    public abstract boolean executeBoolean(Object var1);

    @Specialization(guards={"isJSNull(operand)"})
    protected static boolean doNull(Object operand) {
        return false;
    }

    @Specialization(guards={"isUndefined(operand)"})
    protected static boolean doUndefined(Object operand) {
        return false;
    }

    @Specialization
    protected static boolean doBoolean(boolean operand) {
        return false;
    }

    @Specialization
    protected static boolean doInt(int operand) {
        return false;
    }

    @Specialization
    protected static boolean doLong(long operand) {
        return false;
    }

    @Specialization
    protected static boolean doLargeInt(LargeInteger operand) {
        return false;
    }

    @Specialization
    protected static boolean doDouble(double operand) {
        return false;
    }

    @Specialization
    protected static boolean doSymbol(Symbol operand) {
        return false;
    }

    @Specialization
    protected static boolean doBigInt(BigInt operand) {
        return false;
    }

    @Specialization
    protected static boolean doString(CharSequence operand) {
        return false;
    }

    @Specialization(guards={"isJSObject(operand)"})
    protected static boolean doIsObject(DynamicObject operand) {
        return true;
    }

    @Specialization(guards={"isForeignObject(operand)"}, limit="5")
    protected static boolean doForeignObject(Object operand, @CachedLibrary(value="operand") InteropLibrary interop) {
        if (interop.isNull(operand)) {
            return false;
        }
        if (interop.isBoolean(operand)) {
            return false;
        }
        if (interop.isString(operand)) {
            return false;
        }
        return !interop.isNumber(operand);
    }

    public static IsObjectNode create() {
        return IsObjectNodeGen.create();
    }
}

