/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Executed;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.InitializeInstanceFieldsNodeGen;
import com.oracle.truffle.js.nodes.access.PrivateFieldAddNode;
import com.oracle.truffle.js.nodes.access.WriteElementNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.function.SetFunctionNameNode;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.objects.Undefined;

public abstract class InitializeInstanceFieldsNode
extends JavaScriptNode {
    @Node.Child
    @Executed
    protected JavaScriptNode targetNode;
    @Node.Child
    @Executed
    protected JavaScriptNode sourceNode;
    protected final JSContext context;

    protected InitializeInstanceFieldsNode(JSContext context, JavaScriptNode targetNode, JavaScriptNode sourceNode) {
        this.context = context;
        this.targetNode = targetNode;
        this.sourceNode = sourceNode;
    }

    public static JavaScriptNode create(JSContext context, JavaScriptNode targetNode, JavaScriptNode sourceNode) {
        return InitializeInstanceFieldsNodeGen.create(context, targetNode, sourceNode);
    }

    public static InitializeInstanceFieldsNode create(JSContext context) {
        return InitializeInstanceFieldsNodeGen.create(context, null, null);
    }

    public abstract Object executeEvaluated(Object var1, Object[][] var2);

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL)
    @Specialization
    protected static Object doObject(Object target, Object[][] fields, @Cached(value="createFieldNodes(fields, context)") DefineFieldNode[] fieldNodes) {
        int size = fieldNodes.length;
        assert (size == fields.length);
        for (int i = 0; i < size; ++i) {
            Object[] field = fields[i];
            Object key = field[0];
            Object initializer = field[1];
            fieldNodes[i].defineField(target, key, initializer);
        }
        return target;
    }

    @Fallback
    protected static Object doOther(Object target, Object source) {
        return target;
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        return InitializeInstanceFieldsNode.create(this.context, InitializeInstanceFieldsNode.cloneUninitialized(this.targetNode), InitializeInstanceFieldsNode.cloneUninitialized(this.sourceNode));
    }

    static DefineFieldNode[] createFieldNodes(Object[] fields, JSContext context) {
        CompilerAsserts.neverPartOfCompilation();
        int size = fields.length;
        DefineFieldNode[] fieldNodes = new DefineFieldNode[size];
        for (int i = 0; i < size; ++i) {
            Object[] field = (Object[])fields[i];
            Object key = field[0];
            Object initializer = field[1];
            boolean isAnonymousFunctionDefinition = (Boolean)field[2];
            JavaScriptBaseNode writeNode = key instanceof HiddenKey ? PrivateFieldAddNode.create(context) : WriteElementNode.create(context, true, true);
            JSFunctionCallNode callNode = null;
            if (initializer != Undefined.instance) {
                callNode = JSFunctionCallNode.createCall();
            }
            SetFunctionNameNode setFunctionNameNode = null;
            if (isAnonymousFunctionDefinition) {
                setFunctionNameNode = SetFunctionNameNode.create();
            }
            fieldNodes[i] = new DefineFieldNode(writeNode, callNode, setFunctionNameNode);
        }
        return fieldNodes;
    }

    static final class DefineFieldNode
    extends JavaScriptBaseNode {
        @Node.Child
        JavaScriptBaseNode writeNode;
        @Node.Child
        JSFunctionCallNode callNode;
        @Node.Child
        SetFunctionNameNode setFunctionNameNode;

        DefineFieldNode(JavaScriptBaseNode writeNode, JSFunctionCallNode callNode, SetFunctionNameNode setFunctionNameNode) {
            this.writeNode = writeNode;
            this.callNode = callNode;
            this.setFunctionNameNode = setFunctionNameNode;
        }

        void defineField(Object target, Object key, Object initializer) {
            assert (this.callNode != null == (initializer != Undefined.instance));
            Object value = Undefined.instance;
            if (this.callNode != null) {
                value = this.callNode.executeCall(JSArguments.createZeroArg(target, initializer));
                if (this.setFunctionNameNode != null) {
                    this.setFunctionNameNode.execute(value, key);
                }
            }
            if (this.writeNode instanceof PrivateFieldAddNode) {
                assert (key instanceof HiddenKey) : key;
                ((PrivateFieldAddNode)this.writeNode).execute(target, key, value);
            } else {
                assert (JSRuntime.isPropertyKey(key)) : key;
                ((WriteElementNode)this.writeNode).executeWithTargetAndIndexAndValue(target, key, value);
            }
        }
    }
}

