/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Executed;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.GlobalScopeNode;
import com.oracle.truffle.js.nodes.access.GlobalScopeTDZCheckNodeGen;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSTruffleOptions;
import com.oracle.truffle.js.runtime.objects.Dead;

@ImportStatic(value={JSTruffleOptions.class})
abstract class GlobalScopeTDZCheckNode
extends GlobalScopeNode {
    final String varName;
    @Node.Child
    @Executed
    JavaScriptNode scopeNode;

    GlobalScopeTDZCheckNode(JSContext context, String varName) {
        super(context);
        this.varName = varName;
        this.scopeNode = GlobalScopeNode.create(context);
    }

    @Specialization(guards={"scope.getShape() == cachedShape"}, assumptions={"cachedShape.getValidAssumption()"}, limit="PropertyCacheLimit")
    final Object doCached(DynamicObject scope, @Cached(value="scope.getShape()") Shape cachedShape, @Cached(value="isDead(cachedShape)") boolean dead) {
        assert (dead == (scope.get((Object)this.varName) == Dead.instance()));
        if (dead) {
            throw Errors.createReferenceErrorNotDefined(this.context, this.varName, this);
        }
        return scope;
    }

    @Specialization(replaces={"doCached"})
    final Object doUncached(Object scope, @Cached(value="create(varName, context)") PropertyGetNode getNode, @Cached(value="create()") BranchProfile deadBranch) {
        if (getNode.getValue(scope) == Dead.instance()) {
            deadBranch.enter();
            throw Errors.createReferenceErrorNotDefined(this.context, this.varName, this);
        }
        return scope;
    }

    final boolean isDead(Shape shape) {
        Property property = shape.getProperty((Object)this.varName);
        return property != null && property.getLocation().isDeclared();
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        return GlobalScopeTDZCheckNodeGen.create(this.context, this.varName);
    }
}

