/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.simd;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.builtins.simd.JSConstructSIMDTypeNodeGen;
import com.oracle.truffle.js.builtins.simd.SIMDTypeFunctionBuiltins;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.JSSIMD;
import com.oracle.truffle.js.runtime.builtins.SIMDType;
import java.util.NoSuchElementException;

public abstract class JSConstructSIMDTypeNode
extends SIMDTypeFunctionBuiltins.JSBasicSimdOperation {
    protected JSConstructSIMDTypeNode(JSContext context, JSBuiltin builtin) {
        super(context, builtin, JSConstructSIMDTypeNode.findSIMDTypeFactory(builtin.getName()).createSimdType());
    }

    public static Object create(JSContext context, JSBuiltin builtin, JavaScriptNode[] createArgumentNodes) {
        return JSConstructSIMDTypeNodeGen.create(context, builtin, createArgumentNodes);
    }

    private static SIMDType.SIMDTypeFactory<? extends SIMDType> findSIMDTypeFactory(String name) {
        for (SIMDType.SIMDTypeFactory<? extends SIMDType> simdTypeFactory : SIMDType.FACTORIES) {
            if (!simdTypeFactory.getName().equals(name)) continue;
            return simdTypeFactory;
        }
        throw new NoSuchElementException(name);
    }

    @ExplodeLoop
    @Specialization
    protected Object doConstructSIMDInt32(Object[] args) {
        int i;
        DynamicObject t = JSSIMD.createSIMD(this.getContext(), this.simdContext);
        for (i = 0; i < Math.min(args.length, this.numberOfElements); ++i) {
            Object elem = args[i];
            JSConstructSIMDTypeNode.setLane(t, i, this.cast(i, elem));
        }
        for (i = args.length; i < this.numberOfElements; ++i) {
            JSConstructSIMDTypeNode.setLane(t, i, this.cast(i, 0));
        }
        return t;
    }
}

