/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.js.builtins.EnumerateIteratorPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.interop.JSForeignToJSTypeNode;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.Iterator;

public final class EnumerateIteratorPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<EnumerateIteratorPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new EnumerateIteratorPrototypeBuiltins();

    protected EnumerateIteratorPrototypeBuiltins() {
        super("[[Enumerate]].prototype", EnumerateIteratorPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, EnumerateIteratorPrototype builtinEnum) {
        switch (builtinEnum) {
            case next: {
                return EnumerateIteratorPrototypeBuiltinsFactory.EnumerateNextNodeGen.create(context, builtin, EnumerateIteratorPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static abstract class EnumerateNextNode
    extends JSBuiltinNode {
        @Node.Child
        private PropertySetNode setValueNode;
        @Node.Child
        private PropertySetNode setDoneNode;
        @Node.Child
        private PropertyGetNode getIteratorNode;
        @Node.Child
        private JSForeignToJSTypeNode importValueNode;
        private final BranchProfile errorBranch;
        private final ValueProfile iteratorProfile;

        public EnumerateNextNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.setValueNode = PropertySetNode.create("value", false, context, false);
            this.setDoneNode = PropertySetNode.create("done", false, context, false);
            this.getIteratorNode = PropertyGetNode.createGetHidden(JSRuntime.ENUMERATE_ITERATOR_ID, context);
            this.importValueNode = JSForeignToJSTypeNode.create();
            this.errorBranch = BranchProfile.create();
            this.iteratorProfile = ValueProfile.createClassProfile();
        }

        @Specialization
        public DynamicObject execute(Object target) {
            Object iteratorValue = this.getIteratorNode.getValue(target);
            if (iteratorValue == Undefined.instance) {
                this.errorBranch.enter();
                throw Errors.createTypeError("Enumerate iterator required");
            }
            Iterator iterator = (Iterator)this.iteratorProfile.profile(iteratorValue);
            if (Boundaries.iteratorHasNext(iterator)) {
                Object nextValue = Boundaries.iteratorNext(iterator);
                Object importedValue = this.importValueNode.executeWithTarget(nextValue);
                return this.createIterResultObject(importedValue, false);
            }
            return this.createIterResultObject(Undefined.instance, true);
        }

        private DynamicObject createIterResultObject(Object value, boolean done) {
            DynamicObject iterResultObject = JSUserObject.create(this.getContext());
            this.setValueNode.setValue(iterResultObject, value);
            this.setDoneNode.setValueBoolean(iterResultObject, done);
            return iterResultObject;
        }
    }

    public static enum EnumerateIteratorPrototype implements BuiltinEnum<EnumerateIteratorPrototype>
    {
        next(0);

        private final int length;

        private EnumerateIteratorPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }
}

