// CheckStyle: start generated
package com.oracle.truffle.js.runtime.truffleinterop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.js.runtime.truffleinterop.InteropFunction;

@GeneratedBy(InteropFunction.class)
final class InteropFunctionGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    static  {
        LibraryExport.register(InteropFunction.class, new InteropLibraryExports());
    }

    private InteropFunctionGen() {
    }

    @GeneratedBy(InteropFunction.class)
    private static final class InteropLibraryExports extends LibraryExport<InteropLibrary> {

        private InteropLibraryExports() {
            super(InteropLibrary.class, InteropFunction.class, false);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert receiver instanceof InteropFunction;
            InteropLibrary uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert receiver instanceof InteropFunction;
            return new Cached(receiver);
        }

        @GeneratedBy(InteropFunction.class)
        private static final class Cached extends InteropLibrary {

            @Child private InteropLibrary receiverFunctionInteropLibrary_;
            private final Class<? extends InteropFunction> receiverClass_;

            Cached(Object receiver) {
                this.receiverFunctionInteropLibrary_ = insert(INTEROP_LIBRARY_.create((((InteropFunction) receiver).function)));
                this.receiverClass_ = ((InteropFunction) receiver).getClass();
            }

            @Override
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export 'com.oracle.truffle.js.runtime.truffleinterop.InteropFunction'. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver.getClass() == this.receiverClass_)) {
                    return false;
                } else if (!this.receiverFunctionInteropLibrary_.accepts((((InteropFunction) receiver).function))) {
                    return false;
                } else {
                    return true;
                }
            }

            @Override
            public boolean hasMembers(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return (CompilerDirectives.castExact(receiver, receiverClass_)).hasMembers();
            }

            @Override
            public Object getMembers(Object arg0Value_, boolean arg1Value) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                return arg0Value.getMembers(arg1Value, this.receiverFunctionInteropLibrary_);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                return arg0Value.isMemberInvocable(arg1Value, this.receiverFunctionInteropLibrary_);
            }

            @Override
            public Object invokeMember(Object arg0Value_, String arg1Value, Object... arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                return arg0Value.invokeMember(arg1Value, arg2Value, this.receiverFunctionInteropLibrary_);
            }

            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                return arg0Value.isMemberReadable(arg1Value, this.receiverFunctionInteropLibrary_);
            }

            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                return arg0Value.readMember(arg1Value, this.receiverFunctionInteropLibrary_);
            }

            @Override
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                return arg0Value.isMemberModifiable(arg1Value, this.receiverFunctionInteropLibrary_);
            }

            @Override
            public boolean isMemberInsertable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                return arg0Value.isMemberInsertable(arg1Value, this.receiverFunctionInteropLibrary_);
            }

            @Override
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                arg0Value.writeMember(arg1Value, arg2Value, this.receiverFunctionInteropLibrary_);
                return;
            }

            @Override
            public boolean isMemberRemovable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                return arg0Value.isMemberRemovable(arg1Value, this.receiverFunctionInteropLibrary_);
            }

            @Override
            public void removeMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                arg0Value.removeMember(arg1Value, this.receiverFunctionInteropLibrary_);
                return;
            }

            @Override
            public boolean hasMemberReadSideEffects(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                return arg0Value.hasMemberReadSideEffects(arg1Value, this.receiverFunctionInteropLibrary_);
            }

            @Override
            public boolean hasMemberWriteSideEffects(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                return arg0Value.hasMemberWriteSideEffects(arg1Value, this.receiverFunctionInteropLibrary_);
            }

            @Override
            public boolean isInstantiable(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                return arg0Value.isInstantiable(this.receiverFunctionInteropLibrary_);
            }

            @Override
            public Object instantiate(Object arg0Value_, Object... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = CompilerDirectives.castExact(arg0Value_, receiverClass_);
                return arg0Value.instantiate(arg1Value, this.receiverFunctionInteropLibrary_);
            }

        }
        @GeneratedBy(InteropFunction.class)
        private static final class Uncached extends InteropLibrary {

            private final Class<? extends InteropFunction> receiverClass_;

            Uncached(Object receiver) {
                this.receiverClass_ = ((InteropFunction) receiver).getClass();
            }

            @TruffleBoundary
            @Override
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export 'com.oracle.truffle.js.runtime.truffleinterop.InteropFunction'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver.getClass() == this.receiverClass_;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public boolean hasMembers(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((InteropFunction) receiver) .hasMembers();
            }

            @TruffleBoundary
            @Override
            public Object getMembers(Object arg0Value_, boolean arg1Value) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction) arg0Value_;
                return arg0Value.getMembers(arg1Value, INTEROP_LIBRARY_.getUncached((arg0Value.function)));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction) arg0Value_;
                return arg0Value.isMemberInvocable(arg1Value, INTEROP_LIBRARY_.getUncached((arg0Value.function)));
            }

            @TruffleBoundary
            @Override
            public Object invokeMember(Object arg0Value_, String arg1Value, Object... arg2Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException, UnknownIdentifierException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction) arg0Value_;
                return arg0Value.invokeMember(arg1Value, arg2Value, INTEROP_LIBRARY_.getUncached((arg0Value.function)));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction) arg0Value_;
                return arg0Value.isMemberReadable(arg1Value, INTEROP_LIBRARY_.getUncached((arg0Value.function)));
            }

            @TruffleBoundary
            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction) arg0Value_;
                return arg0Value.readMember(arg1Value, INTEROP_LIBRARY_.getUncached((arg0Value.function)));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction) arg0Value_;
                return arg0Value.isMemberModifiable(arg1Value, INTEROP_LIBRARY_.getUncached((arg0Value.function)));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberInsertable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction) arg0Value_;
                return arg0Value.isMemberInsertable(arg1Value, INTEROP_LIBRARY_.getUncached((arg0Value.function)));
            }

            @TruffleBoundary
            @Override
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction) arg0Value_;
                arg0Value.writeMember(arg1Value, arg2Value, INTEROP_LIBRARY_.getUncached((arg0Value.function)));
                return;
            }

            @TruffleBoundary
            @Override
            public boolean isMemberRemovable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction) arg0Value_;
                return arg0Value.isMemberRemovable(arg1Value, INTEROP_LIBRARY_.getUncached((arg0Value.function)));
            }

            @TruffleBoundary
            @Override
            public void removeMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction) arg0Value_;
                arg0Value.removeMember(arg1Value, INTEROP_LIBRARY_.getUncached((arg0Value.function)));
                return;
            }

            @TruffleBoundary
            @Override
            public boolean hasMemberReadSideEffects(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction) arg0Value_;
                return arg0Value.hasMemberReadSideEffects(arg1Value, INTEROP_LIBRARY_.getUncached((arg0Value.function)));
            }

            @TruffleBoundary
            @Override
            public boolean hasMemberWriteSideEffects(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction) arg0Value_;
                return arg0Value.hasMemberWriteSideEffects(arg1Value, INTEROP_LIBRARY_.getUncached((arg0Value.function)));
            }

            @TruffleBoundary
            @Override
            public boolean isInstantiable(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction) arg0Value_;
                return arg0Value.isInstantiable(INTEROP_LIBRARY_.getUncached((arg0Value.function)));
            }

            @TruffleBoundary
            @Override
            public Object instantiate(Object arg0Value_, Object... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction) arg0Value_;
                return arg0Value.instantiate(arg1Value, INTEROP_LIBRARY_.getUncached((arg0Value.function)));
            }

        }
    }
}
