// CheckStyle: start generated
package com.oracle.truffle.js.runtime.truffleinterop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.TruffleLanguage.ContextReference;
import com.oracle.truffle.api.TruffleLanguage.LanguageReference;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.interop.ExportValueNode;
import com.oracle.truffle.js.nodes.interop.ExportValueNodeGen;
import com.oracle.truffle.js.nodes.interop.JSInteropExecuteNode;
import com.oracle.truffle.js.nodes.interop.JSInteropExecuteNodeGen;
import com.oracle.truffle.js.nodes.promise.UnwrapPromiseNode;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.truffleinterop.InteropAsyncFunction;
import com.oracle.truffle.js.runtime.truffleinterop.InteropFunction;
import java.util.concurrent.locks.Lock;

@GeneratedBy(InteropAsyncFunction.class)
final class InteropAsyncFunctionGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    static  {
        LibraryExport.register(InteropAsyncFunction.class, new InteropLibraryExports());
    }

    private InteropAsyncFunctionGen() {
    }

    @GeneratedBy(InteropAsyncFunction.class)
    private static final class InteropLibraryExports extends LibraryExport<InteropLibrary> {

        private InteropLibraryExports() {
            super(InteropLibrary.class, InteropAsyncFunction.class, false);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert receiver instanceof InteropAsyncFunction;
            InteropLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert receiver instanceof InteropAsyncFunction;
            return new Cached(receiver);
        }

        @GeneratedBy(InteropAsyncFunction.class)
        private static final class Cached extends InteropLibrary {

            @Child private InteropLibrary receiverFunctionInteropLibrary_;
            @CompilationFinal private int state_;
            @CompilationFinal private LanguageReference<JavaScriptLanguage> javaScriptLanguageReference_;
            @CompilationFinal private ContextReference<JSRealm> javaScriptLanguageContextReference_;
            @Child private JSInteropExecuteNode executeNode__callNode_;
            @Child private ExportValueNode executeNode__exportNode_;
            @Child private UnwrapPromiseNode executeNode__unwrapPromise_;

            Cached(Object receiver) {
                this.receiverFunctionInteropLibrary_ = insert(INTEROP_LIBRARY_.create((((InteropAsyncFunction) receiver).function)));
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof InteropAsyncFunction) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export 'com.oracle.truffle.js.runtime.truffleinterop.InteropAsyncFunction'. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof InteropAsyncFunction)) {
                    return false;
                } else if (!this.receiverFunctionInteropLibrary_.accepts((((InteropAsyncFunction) receiver).function))) {
                    return false;
                } else {
                    return true;
                }
            }

            @Override
            public boolean hasMembers(Object receiver) {
                assert assertAdopted();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((InteropFunction) receiver).hasMembers();
            }

            @Override
            public Object getMembers(Object arg0Value_, boolean arg1Value) throws UnsupportedMessageException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction) arg0Value_;
                return arg0Value.getMembers(arg1Value, this.receiverFunctionInteropLibrary_);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction) arg0Value_;
                return arg0Value.isMemberInvocable(arg1Value, this.receiverFunctionInteropLibrary_);
            }

            @Override
            public Object invokeMember(Object arg0Value_, String arg1Value, Object... arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction) arg0Value_;
                return arg0Value.invokeMember(arg1Value, arg2Value, this.receiverFunctionInteropLibrary_);
            }

            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction) arg0Value_;
                return arg0Value.isMemberReadable(arg1Value, this.receiverFunctionInteropLibrary_);
            }

            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction) arg0Value_;
                return arg0Value.readMember(arg1Value, this.receiverFunctionInteropLibrary_);
            }

            @Override
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction) arg0Value_;
                return arg0Value.isMemberModifiable(arg1Value, this.receiverFunctionInteropLibrary_);
            }

            @Override
            public boolean isMemberInsertable(Object arg0Value_, String arg1Value) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction) arg0Value_;
                return arg0Value.isMemberInsertable(arg1Value, this.receiverFunctionInteropLibrary_);
            }

            @Override
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction) arg0Value_;
                arg0Value.writeMember(arg1Value, arg2Value, this.receiverFunctionInteropLibrary_);
                return;
            }

            @Override
            public boolean isMemberRemovable(Object arg0Value_, String arg1Value) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction) arg0Value_;
                return arg0Value.isMemberRemovable(arg1Value, this.receiverFunctionInteropLibrary_);
            }

            @Override
            public void removeMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction) arg0Value_;
                arg0Value.removeMember(arg1Value, this.receiverFunctionInteropLibrary_);
                return;
            }

            @Override
            public boolean hasMemberReadSideEffects(Object arg0Value_, String arg1Value) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction) arg0Value_;
                return arg0Value.hasMemberReadSideEffects(arg1Value, this.receiverFunctionInteropLibrary_);
            }

            @Override
            public boolean hasMemberWriteSideEffects(Object arg0Value_, String arg1Value) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction) arg0Value_;
                return arg0Value.hasMemberWriteSideEffects(arg1Value, this.receiverFunctionInteropLibrary_);
            }

            @Override
            public boolean isInstantiable(Object arg0Value_) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction) arg0Value_;
                return arg0Value.isInstantiable(this.receiverFunctionInteropLibrary_);
            }

            @Override
            public Object instantiate(Object arg0Value_, Object... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction) arg0Value_;
                return arg0Value.instantiate(arg1Value, this.receiverFunctionInteropLibrary_);
            }

            @Override
            public boolean isExecutable(Object receiver) {
                assert assertAdopted();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((InteropAsyncFunction) receiver).isExecutable();
            }

            @Override
            public Object execute(Object arg0Value_, Object... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropAsyncFunction arg0Value = (InteropAsyncFunction) arg0Value_;
                int state = state_;
                if (state != 0 /* is-active execute(InteropAsyncFunction, Object[], JavaScriptLanguage, JSRealm, JSInteropExecuteNode, ExportValueNode, UnwrapPromiseNode) */) {
                    return arg0Value.execute(arg1Value, this.javaScriptLanguageReference_.get(), this.javaScriptLanguageContextReference_.get(), this.executeNode__callNode_, this.executeNode__exportNode_, this.executeNode__unwrapPromise_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object executeNode_AndSpecialize(InteropAsyncFunction arg0Value, Object[] arg1Value) throws UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                int state = state_;
                try {
                    LanguageReference<JavaScriptLanguage> javaScriptLanguageReference__ = this.javaScriptLanguageReference_;
                    if (javaScriptLanguageReference__ == null) {
                        this.javaScriptLanguageReference_ = javaScriptLanguageReference__ = super.lookupLanguageReference(JavaScriptLanguage.class);
                    }
                    ContextReference<JSRealm> javaScriptLanguageContextReference__ = this.javaScriptLanguageContextReference_;
                    if (javaScriptLanguageContextReference__ == null) {
                        this.javaScriptLanguageContextReference_ = javaScriptLanguageContextReference__ = super.lookupContextReference(JavaScriptLanguage.class);
                    }
                    this.executeNode__callNode_ = super.insert((JSInteropExecuteNodeGen.create()));
                    this.executeNode__exportNode_ = super.insert((ExportValueNode.create()));
                    this.executeNode__unwrapPromise_ = super.insert((UnwrapPromiseNode.create(javaScriptLanguageContextReference__.get().getContext())));
                    this.state_ = state = state | 0b1 /* add-active execute(InteropAsyncFunction, Object[], JavaScriptLanguage, JSRealm, JSInteropExecuteNode, ExportValueNode, UnwrapPromiseNode) */;
                    lock.unlock();
                    hasLock = false;
                    return arg0Value.execute(arg1Value, javaScriptLanguageReference__.get(), javaScriptLanguageContextReference__.get(), this.executeNode__callNode_, this.executeNode__exportNode_, this.executeNode__unwrapPromise_);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

        }
        @GeneratedBy(InteropAsyncFunction.class)
        private static final class Uncached extends InteropLibrary {

            private final LanguageReference<JavaScriptLanguage> javaScriptLanguageReference_ = lookupLanguageReference(JavaScriptLanguage.class);
            private final ContextReference<JSRealm> javaScriptLanguageContextReference_ = lookupContextReference(JavaScriptLanguage.class);

            Uncached() {
            }

            @TruffleBoundary
            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof InteropAsyncFunction) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export 'com.oracle.truffle.js.runtime.truffleinterop.InteropAsyncFunction'. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof InteropAsyncFunction;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public boolean hasMembers(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((InteropFunction) receiver) .hasMembers();
            }

            @TruffleBoundary
            @Override
            public Object getMembers(Object arg0Value_, boolean arg1Value) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction) arg0Value_;
                return arg0Value.getMembers(arg1Value, INTEROP_LIBRARY_.getUncached((arg0Value.function)));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction) arg0Value_;
                return arg0Value.isMemberInvocable(arg1Value, INTEROP_LIBRARY_.getUncached((arg0Value.function)));
            }

            @TruffleBoundary
            @Override
            public Object invokeMember(Object arg0Value_, String arg1Value, Object... arg2Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException, UnknownIdentifierException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction) arg0Value_;
                return arg0Value.invokeMember(arg1Value, arg2Value, INTEROP_LIBRARY_.getUncached((arg0Value.function)));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction) arg0Value_;
                return arg0Value.isMemberReadable(arg1Value, INTEROP_LIBRARY_.getUncached((arg0Value.function)));
            }

            @TruffleBoundary
            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction) arg0Value_;
                return arg0Value.readMember(arg1Value, INTEROP_LIBRARY_.getUncached((arg0Value.function)));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction) arg0Value_;
                return arg0Value.isMemberModifiable(arg1Value, INTEROP_LIBRARY_.getUncached((arg0Value.function)));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberInsertable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction) arg0Value_;
                return arg0Value.isMemberInsertable(arg1Value, INTEROP_LIBRARY_.getUncached((arg0Value.function)));
            }

            @TruffleBoundary
            @Override
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction) arg0Value_;
                arg0Value.writeMember(arg1Value, arg2Value, INTEROP_LIBRARY_.getUncached((arg0Value.function)));
                return;
            }

            @TruffleBoundary
            @Override
            public boolean isMemberRemovable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction) arg0Value_;
                return arg0Value.isMemberRemovable(arg1Value, INTEROP_LIBRARY_.getUncached((arg0Value.function)));
            }

            @TruffleBoundary
            @Override
            public void removeMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction) arg0Value_;
                arg0Value.removeMember(arg1Value, INTEROP_LIBRARY_.getUncached((arg0Value.function)));
                return;
            }

            @TruffleBoundary
            @Override
            public boolean hasMemberReadSideEffects(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction) arg0Value_;
                return arg0Value.hasMemberReadSideEffects(arg1Value, INTEROP_LIBRARY_.getUncached((arg0Value.function)));
            }

            @TruffleBoundary
            @Override
            public boolean hasMemberWriteSideEffects(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction) arg0Value_;
                return arg0Value.hasMemberWriteSideEffects(arg1Value, INTEROP_LIBRARY_.getUncached((arg0Value.function)));
            }

            @TruffleBoundary
            @Override
            public boolean isInstantiable(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction) arg0Value_;
                return arg0Value.isInstantiable(INTEROP_LIBRARY_.getUncached((arg0Value.function)));
            }

            @TruffleBoundary
            @Override
            public Object instantiate(Object arg0Value_, Object... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropFunction arg0Value = (InteropFunction) arg0Value_;
                return arg0Value.instantiate(arg1Value, INTEROP_LIBRARY_.getUncached((arg0Value.function)));
            }

            @TruffleBoundary
            @Override
            public boolean isExecutable(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((InteropAsyncFunction) receiver) .isExecutable();
            }

            @TruffleBoundary
            @Override
            public Object execute(Object arg0Value_, Object... arg1Value) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                InteropAsyncFunction arg0Value = (InteropAsyncFunction) arg0Value_;
                return arg0Value.execute(arg1Value, this.javaScriptLanguageReference_.get(), this.javaScriptLanguageContextReference_.get(), (JSInteropExecuteNodeGen.getUncached()), (ExportValueNodeGen.getUncached()), (UnwrapPromiseNode.getUncached()));
            }

        }
    }
}
