// CheckStyle: start generated
package com.oracle.truffle.js.runtime.joni;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.js.runtime.joni.JoniCompiledRegex;
import com.oracle.truffle.js.runtime.joni.JoniCompiledRegexDispatchNode;
import com.oracle.truffle.js.runtime.joni.result.JoniRegexResult;
import java.util.concurrent.locks.Lock;

@GeneratedBy(JoniCompiledRegexDispatchNode.class)
public final class JoniCompiledRegexDispatchNodeGen extends JoniCompiledRegexDispatchNode {

    private static final Uncached UNCACHED = new Uncached();

    @CompilationFinal private int state_;
    @CompilationFinal private int exclude_;
    @Child private CachedData cached_cache;
    @Child private IndirectCallNode generic_indirectCallNode_;

    private JoniCompiledRegexDispatchNodeGen() {
    }

    @ExplodeLoop
    @Override
    public JoniRegexResult execute(JoniCompiledRegex arg0Value, String arg1Value, int arg2Value) {
        int state = state_;
        if (state != 0 /* is-active doCached(JoniCompiledRegex, String, int, JoniCompiledRegex, DirectCallNode) || doGeneric(JoniCompiledRegex, String, int, IndirectCallNode) */) {
            if ((state & 0b1) != 0 /* is-active doCached(JoniCompiledRegex, String, int, JoniCompiledRegex, DirectCallNode) */) {
                CachedData s1_ = this.cached_cache;
                while (s1_ != null) {
                    if ((arg0Value == s1_.cachedReceiver_)) {
                        return JoniCompiledRegexDispatchNode.doCached(arg0Value, arg1Value, arg2Value, s1_.cachedReceiver_, s1_.directCallNode_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state & 0b10) != 0 /* is-active doGeneric(JoniCompiledRegex, String, int, IndirectCallNode) */) {
                return JoniCompiledRegexDispatchNode.doGeneric(arg0Value, arg1Value, arg2Value, this.generic_indirectCallNode_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value, arg1Value, arg2Value);
    }

    private JoniRegexResult executeAndSpecialize(JoniCompiledRegex arg0Value, String arg1Value, int arg2Value) {
        Lock lock = getLock();
        boolean hasLock = true;
        lock.lock();
        int state = state_;
        int exclude = exclude_;
        int oldState = state;
        int oldExclude = exclude;
        int oldCacheCount = state == 0 ? 0 : countCaches();
        try {
            if ((exclude) == 0 /* is-not-excluded doCached(JoniCompiledRegex, String, int, JoniCompiledRegex, DirectCallNode) */) {
                int count1_ = 0;
                CachedData s1_ = this.cached_cache;
                if ((state & 0b1) != 0 /* is-active doCached(JoniCompiledRegex, String, int, JoniCompiledRegex, DirectCallNode) */) {
                    while (s1_ != null) {
                        if ((arg0Value == s1_.cachedReceiver_)) {
                            break;
                        }
                        s1_ = s1_.next_;
                        count1_++;
                    }
                }
                if (s1_ == null) {
                    // assert (arg0Value == s1_.cachedReceiver_);
                    if (count1_ < (4)) {
                        s1_ = super.insert(new CachedData(cached_cache));
                        s1_.cachedReceiver_ = (arg0Value);
                        s1_.directCallNode_ = s1_.insertAccessor((DirectCallNode.create(s1_.cachedReceiver_.getRegexCallTarget())));
                        this.cached_cache = s1_;
                        this.state_ = state = state | 0b1 /* add-active doCached(JoniCompiledRegex, String, int, JoniCompiledRegex, DirectCallNode) */;
                    }
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    return JoniCompiledRegexDispatchNode.doCached(arg0Value, arg1Value, arg2Value, s1_.cachedReceiver_, s1_.directCallNode_);
                }
            }
            this.generic_indirectCallNode_ = super.insert((IndirectCallNode.create()));
            this.exclude_ = exclude = exclude | 0b1 /* add-excluded doCached(JoniCompiledRegex, String, int, JoniCompiledRegex, DirectCallNode) */;
            this.cached_cache = null;
            state = state & 0xfffffffe /* remove-active doCached(JoniCompiledRegex, String, int, JoniCompiledRegex, DirectCallNode) */;
            this.state_ = state = state | 0b10 /* add-active doGeneric(JoniCompiledRegex, String, int, IndirectCallNode) */;
            lock.unlock();
            hasLock = false;
            return JoniCompiledRegexDispatchNode.doGeneric(arg0Value, arg1Value, arg2Value, this.generic_indirectCallNode_);
        } finally {
            if (oldState != 0 || oldExclude != 0) {
                checkForPolymorphicSpecialize(oldState, oldExclude, oldCacheCount);
            }
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    private void checkForPolymorphicSpecialize(int oldState, int oldExclude, int oldCacheCount) {
        int newState = this.state_;
        int newExclude = this.exclude_;
        if ((oldState ^ newState) != 0 || (oldExclude ^ newExclude) != 0 || oldCacheCount < countCaches()) {
            this.reportPolymorphicSpecialize();
        }
    }

    private int countCaches() {
        int cacheCount = 0;
        CachedData s1_ = this.cached_cache;
        while (s1_ != null) {
            cacheCount++;
            s1_= s1_.next_;
        }
        return cacheCount;
    }

    @Override
    public NodeCost getCost() {
        int state = state_;
        if (state == 0b0) {
            return NodeCost.UNINITIALIZED;
        } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
            CachedData s1_ = this.cached_cache;
            if ((s1_ == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    public static JoniCompiledRegexDispatchNode create() {
        return new JoniCompiledRegexDispatchNodeGen();
    }

    public static JoniCompiledRegexDispatchNode getUncached() {
        return JoniCompiledRegexDispatchNodeGen.UNCACHED;
    }

    @GeneratedBy(JoniCompiledRegexDispatchNode.class)
    private static final class CachedData extends Node {

        @Child CachedData next_;
        @CompilationFinal JoniCompiledRegex cachedReceiver_;
        @Child DirectCallNode directCallNode_;

        CachedData(CachedData next_) {
            this.next_ = next_;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return super.insert(node);
        }

    }
    @GeneratedBy(JoniCompiledRegexDispatchNode.class)
    private static final class Uncached extends JoniCompiledRegexDispatchNode {

        @TruffleBoundary
        @Override
        public JoniRegexResult execute(JoniCompiledRegex arg0Value, String arg1Value, int arg2Value) {
            return JoniCompiledRegexDispatchNode.doGeneric(arg0Value, arg1Value, arg2Value, (IndirectCallNode.getUncached()));
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
}
