// CheckStyle: start generated
package com.oracle.truffle.js.runtime.joni;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.js.runtime.joni.AbstractConstantKeysObject;
import com.oracle.truffle.js.runtime.joni.AbstractConstantKeysObject.IsReadableCacheNode;
import com.oracle.truffle.js.runtime.joni.AbstractConstantKeysObject.ReadCacheNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(AbstractConstantKeysObject.class)
public final class AbstractConstantKeysObjectFactory {

    @GeneratedBy(IsReadableCacheNode.class)
    public static final class IsReadableCacheNodeGen extends IsReadableCacheNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private int state_;
        @CompilationFinal private int exclude_;
        @CompilationFinal private CacheIdentityData cacheIdentity_cache;
        @CompilationFinal private CacheEqualsData cacheEquals_cache;

        private IsReadableCacheNodeGen() {
        }

        @ExplodeLoop
        @Override
        public boolean execute(AbstractConstantKeysObject arg0Value, String arg1Value) {
            int state = state_;
            if (state != 0 /* is-active cacheIdentity(AbstractConstantKeysObject, String, String, boolean) || cacheEquals(AbstractConstantKeysObject, String, String, boolean) || isReadable(AbstractConstantKeysObject, String) */) {
                if ((state & 0b1) != 0 /* is-active cacheIdentity(AbstractConstantKeysObject, String, String, boolean) */) {
                    CacheIdentityData s1_ = this.cacheIdentity_cache;
                    while (s1_ != null) {
                        if ((arg1Value == s1_.cachedSymbol_)) {
                            return IsReadableCacheNode.cacheIdentity(arg0Value, arg1Value, s1_.cachedSymbol_, s1_.result_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 0b10) != 0 /* is-active cacheEquals(AbstractConstantKeysObject, String, String, boolean) */) {
                    CacheEqualsData s2_ = this.cacheEquals_cache;
                    while (s2_ != null) {
                        if ((arg1Value.equals(s2_.cachedSymbol_))) {
                            return IsReadableCacheNode.cacheEquals(arg0Value, arg1Value, s2_.cachedSymbol_, s2_.result_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state & 0b100) != 0 /* is-active isReadable(AbstractConstantKeysObject, String) */) {
                    return IsReadableCacheNode.isReadable(arg0Value, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private boolean executeAndSpecialize(AbstractConstantKeysObject arg0Value, String arg1Value) {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            int exclude = exclude_;
            try {
                if (((exclude & 0b1)) == 0 /* is-not-excluded cacheIdentity(AbstractConstantKeysObject, String, String, boolean) */) {
                    int count1_ = 0;
                    CacheIdentityData s1_ = this.cacheIdentity_cache;
                    if ((state & 0b1) != 0 /* is-active cacheIdentity(AbstractConstantKeysObject, String, String, boolean) */) {
                        while (s1_ != null) {
                            if ((arg1Value == s1_.cachedSymbol_)) {
                                break;
                            }
                            s1_ = s1_.next_;
                            count1_++;
                        }
                    }
                    if (s1_ == null) {
                        // assert (arg1Value == s1_.cachedSymbol_);
                        if (count1_ < (8)) {
                            s1_ = new CacheIdentityData(cacheIdentity_cache);
                            s1_.cachedSymbol_ = (arg1Value);
                            s1_.result_ = (IsReadableCacheNode.isReadable(arg0Value, s1_.cachedSymbol_));
                            this.cacheIdentity_cache = s1_;
                            this.state_ = state = state | 0b1 /* add-active cacheIdentity(AbstractConstantKeysObject, String, String, boolean) */;
                        }
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return IsReadableCacheNode.cacheIdentity(arg0Value, arg1Value, s1_.cachedSymbol_, s1_.result_);
                    }
                }
                if (((exclude & 0b10)) == 0 /* is-not-excluded cacheEquals(AbstractConstantKeysObject, String, String, boolean) */) {
                    int count2_ = 0;
                    CacheEqualsData s2_ = this.cacheEquals_cache;
                    if ((state & 0b10) != 0 /* is-active cacheEquals(AbstractConstantKeysObject, String, String, boolean) */) {
                        while (s2_ != null) {
                            if ((arg1Value.equals(s2_.cachedSymbol_))) {
                                break;
                            }
                            s2_ = s2_.next_;
                            count2_++;
                        }
                    }
                    if (s2_ == null) {
                        // assert (arg1Value.equals(s2_.cachedSymbol_));
                        if (count2_ < (8)) {
                            s2_ = new CacheEqualsData(cacheEquals_cache);
                            s2_.cachedSymbol_ = (arg1Value);
                            s2_.result_ = (IsReadableCacheNode.isReadable(arg0Value, s2_.cachedSymbol_));
                            this.cacheEquals_cache = s2_;
                            this.exclude_ = exclude = exclude | 0b1 /* add-excluded cacheIdentity(AbstractConstantKeysObject, String, String, boolean) */;
                            this.cacheIdentity_cache = null;
                            state = state & 0xfffffffe /* remove-active cacheIdentity(AbstractConstantKeysObject, String, String, boolean) */;
                            this.state_ = state = state | 0b10 /* add-active cacheEquals(AbstractConstantKeysObject, String, String, boolean) */;
                        }
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return IsReadableCacheNode.cacheEquals(arg0Value, arg1Value, s2_.cachedSymbol_, s2_.result_);
                    }
                }
                this.exclude_ = exclude = exclude | 0b11 /* add-excluded cacheIdentity(AbstractConstantKeysObject, String, String, boolean), cacheEquals(AbstractConstantKeysObject, String, String, boolean) */;
                this.cacheIdentity_cache = null;
                this.cacheEquals_cache = null;
                state = state & 0xfffffffc /* remove-active cacheIdentity(AbstractConstantKeysObject, String, String, boolean), cacheEquals(AbstractConstantKeysObject, String, String, boolean) */;
                this.state_ = state = state | 0b100 /* add-active isReadable(AbstractConstantKeysObject, String) */;
                lock.unlock();
                hasLock = false;
                return IsReadableCacheNode.isReadable(arg0Value, arg1Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                CacheIdentityData s1_ = this.cacheIdentity_cache;
                CacheEqualsData s2_ = this.cacheEquals_cache;
                if ((s1_ == null || s1_.next_ == null) && (s2_ == null || s2_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static IsReadableCacheNode create() {
            return new IsReadableCacheNodeGen();
        }

        public static IsReadableCacheNode getUncached() {
            return IsReadableCacheNodeGen.UNCACHED;
        }

        @GeneratedBy(IsReadableCacheNode.class)
        private static final class CacheIdentityData {

            @CompilationFinal CacheIdentityData next_;
            @CompilationFinal String cachedSymbol_;
            @CompilationFinal boolean result_;

            CacheIdentityData(CacheIdentityData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(IsReadableCacheNode.class)
        private static final class CacheEqualsData {

            @CompilationFinal CacheEqualsData next_;
            @CompilationFinal String cachedSymbol_;
            @CompilationFinal boolean result_;

            CacheEqualsData(CacheEqualsData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(IsReadableCacheNode.class)
        private static final class Uncached extends IsReadableCacheNode {

            @TruffleBoundary
            @Override
            public boolean execute(AbstractConstantKeysObject arg0Value, String arg1Value) {
                return IsReadableCacheNode.isReadable(arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
    @GeneratedBy(ReadCacheNode.class)
    public static final class ReadCacheNodeGen extends ReadCacheNode {

        private static final Uncached UNCACHED = new Uncached();

        @CompilationFinal private int state_;
        @CompilationFinal private int exclude_;
        @CompilationFinal private ReadIdentityData readIdentity_cache;
        @CompilationFinal private ReadEqualsData readEquals_cache;

        private ReadCacheNodeGen() {
        }

        @ExplodeLoop
        @Override
        public Object execute(AbstractConstantKeysObject arg0Value, String arg1Value) throws UnknownIdentifierException {
            int state = state_;
            if (state != 0 /* is-active readIdentity(AbstractConstantKeysObject, String, String) || readEquals(AbstractConstantKeysObject, String, String) || read(AbstractConstantKeysObject, String) */) {
                if ((state & 0b1) != 0 /* is-active readIdentity(AbstractConstantKeysObject, String, String) */) {
                    ReadIdentityData s1_ = this.readIdentity_cache;
                    while (s1_ != null) {
                        if ((arg1Value == s1_.cachedSymbol_)) {
                            return readIdentity(arg0Value, arg1Value, s1_.cachedSymbol_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state & 0b10) != 0 /* is-active readEquals(AbstractConstantKeysObject, String, String) */) {
                    ReadEqualsData s2_ = this.readEquals_cache;
                    while (s2_ != null) {
                        if ((arg1Value.equals(s2_.cachedSymbol_))) {
                            return readEquals(arg0Value, arg1Value, s2_.cachedSymbol_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state & 0b100) != 0 /* is-active read(AbstractConstantKeysObject, String) */) {
                    return ReadCacheNode.read(arg0Value, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private Object executeAndSpecialize(AbstractConstantKeysObject arg0Value, String arg1Value) throws UnknownIdentifierException {
            Lock lock = getLock();
            boolean hasLock = true;
            lock.lock();
            int state = state_;
            int exclude = exclude_;
            try {
                if (((exclude & 0b1)) == 0 /* is-not-excluded readIdentity(AbstractConstantKeysObject, String, String) */) {
                    int count1_ = 0;
                    ReadIdentityData s1_ = this.readIdentity_cache;
                    if ((state & 0b1) != 0 /* is-active readIdentity(AbstractConstantKeysObject, String, String) */) {
                        while (s1_ != null) {
                            if ((arg1Value == s1_.cachedSymbol_)) {
                                break;
                            }
                            s1_ = s1_.next_;
                            count1_++;
                        }
                    }
                    if (s1_ == null) {
                        // assert (arg1Value == s1_.cachedSymbol_);
                        if (count1_ < (8)) {
                            s1_ = new ReadIdentityData(readIdentity_cache);
                            s1_.cachedSymbol_ = (arg1Value);
                            this.readIdentity_cache = s1_;
                            this.state_ = state = state | 0b1 /* add-active readIdentity(AbstractConstantKeysObject, String, String) */;
                        }
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return readIdentity(arg0Value, arg1Value, s1_.cachedSymbol_);
                    }
                }
                if (((exclude & 0b10)) == 0 /* is-not-excluded readEquals(AbstractConstantKeysObject, String, String) */) {
                    int count2_ = 0;
                    ReadEqualsData s2_ = this.readEquals_cache;
                    if ((state & 0b10) != 0 /* is-active readEquals(AbstractConstantKeysObject, String, String) */) {
                        while (s2_ != null) {
                            if ((arg1Value.equals(s2_.cachedSymbol_))) {
                                break;
                            }
                            s2_ = s2_.next_;
                            count2_++;
                        }
                    }
                    if (s2_ == null) {
                        // assert (arg1Value.equals(s2_.cachedSymbol_));
                        if (count2_ < (8)) {
                            s2_ = new ReadEqualsData(readEquals_cache);
                            s2_.cachedSymbol_ = (arg1Value);
                            this.readEquals_cache = s2_;
                            this.exclude_ = exclude = exclude | 0b1 /* add-excluded readIdentity(AbstractConstantKeysObject, String, String) */;
                            this.readIdentity_cache = null;
                            state = state & 0xfffffffe /* remove-active readIdentity(AbstractConstantKeysObject, String, String) */;
                            this.state_ = state = state | 0b10 /* add-active readEquals(AbstractConstantKeysObject, String, String) */;
                        }
                    }
                    if (s2_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return readEquals(arg0Value, arg1Value, s2_.cachedSymbol_);
                    }
                }
                this.exclude_ = exclude = exclude | 0b11 /* add-excluded readIdentity(AbstractConstantKeysObject, String, String), readEquals(AbstractConstantKeysObject, String, String) */;
                this.readIdentity_cache = null;
                this.readEquals_cache = null;
                state = state & 0xfffffffc /* remove-active readIdentity(AbstractConstantKeysObject, String, String), readEquals(AbstractConstantKeysObject, String, String) */;
                this.state_ = state = state | 0b100 /* add-active read(AbstractConstantKeysObject, String) */;
                lock.unlock();
                hasLock = false;
                return ReadCacheNode.read(arg0Value, arg1Value);
            } finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        @Override
        public NodeCost getCost() {
            int state = state_;
            if (state == 0b0) {
                return NodeCost.UNINITIALIZED;
            } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
                ReadIdentityData s1_ = this.readIdentity_cache;
                ReadEqualsData s2_ = this.readEquals_cache;
                if ((s1_ == null || s1_.next_ == null) && (s2_ == null || s2_.next_ == null)) {
                    return NodeCost.MONOMORPHIC;
                }
            }
            return NodeCost.POLYMORPHIC;
        }

        public static ReadCacheNode create() {
            return new ReadCacheNodeGen();
        }

        public static ReadCacheNode getUncached() {
            return ReadCacheNodeGen.UNCACHED;
        }

        @GeneratedBy(ReadCacheNode.class)
        private static final class ReadIdentityData {

            @CompilationFinal ReadIdentityData next_;
            @CompilationFinal String cachedSymbol_;

            ReadIdentityData(ReadIdentityData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(ReadCacheNode.class)
        private static final class ReadEqualsData {

            @CompilationFinal ReadEqualsData next_;
            @CompilationFinal String cachedSymbol_;

            ReadEqualsData(ReadEqualsData next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(ReadCacheNode.class)
        private static final class Uncached extends ReadCacheNode {

            @TruffleBoundary
            @Override
            public Object execute(AbstractConstantKeysObject arg0Value, String arg1Value) throws UnknownIdentifierException {
                return ReadCacheNode.read(arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

        }
    }
}
