// CheckStyle: start generated
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.TruffleLanguage.ContextReference;
import com.oracle.truffle.api.TruffleLanguage.LanguageReference;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.access.WriteElementNode;
import com.oracle.truffle.js.nodes.interop.ExportValueNode;
import com.oracle.truffle.js.nodes.interop.ExportValueNodeGen;
import com.oracle.truffle.js.nodes.interop.JSForeignToJSTypeNode;
import com.oracle.truffle.js.nodes.interop.JSForeignToJSTypeNodeGen;
import com.oracle.truffle.js.nodes.interop.JSInteropExecuteNode;
import com.oracle.truffle.js.nodes.interop.JSInteropExecuteNodeGen;
import com.oracle.truffle.js.nodes.interop.JSInteropInstantiateNode;
import com.oracle.truffle.js.nodes.interop.JSInteropInstantiateNodeGen;
import com.oracle.truffle.js.nodes.interop.JSInteropInvokeNode;
import com.oracle.truffle.js.nodes.interop.JSInteropInvokeNodeGen;
import com.oracle.truffle.js.nodes.interop.KeyInfoNode;
import com.oracle.truffle.js.nodes.interop.KeyInfoNodeGen;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNodeGen;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSClass.GetArraySize;
import com.oracle.truffle.js.runtime.builtins.JSClass.GetMembers;
import com.oracle.truffle.js.runtime.objects.JSObject;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.concurrent.locks.Lock;

@GeneratedBy(JSClass.class)
final class JSClassGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    static  {
        LibraryExport.register(JSClass.class, new InteropLibraryExports());
    }

    private JSClassGen() {
    }

    @GeneratedBy(JSClass.class)
    private static final class InteropLibraryExports extends LibraryExport<InteropLibrary> {

        private InteropLibraryExports() {
            super(InteropLibrary.class, DynamicObject.class, false);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert receiver instanceof DynamicObject;
            InteropLibrary uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert receiver instanceof DynamicObject;
            return new Cached(receiver);
        }

        @GeneratedBy(JSClass.class)
        private static final class Cached extends InteropLibrary {

            @Child private DynamicDispatchLibrary dynamicDispatch_;
            @CompilationFinal private long state_;
            @CompilationFinal private int exclude_;
            @Child private KeyInfoNode keyInfo;
            @Child private JSForeignToJSTypeNode importValue;
            @Child private ExportValueNode exportValue;
            @Child private InteropLibrary numberLib;
            @CompilationFinal private LanguageReference<JavaScriptLanguage> javaScriptLanguageReference_;
            @CompilationFinal private ContextReference<JSRealm> javaScriptLanguageContextReference_;
            @CompilationFinal private GetMembersNonArrayCachedData getMembers_nonArrayCached_cache;
            @Child private ReadElementNode readMemberNode__readNode_;
            @CompilationFinal private boolean readMemberNode__bindMemberFunctions_;
            @Child private ExportValueNode readMemberNode__exportNode_;
            @Child private WriteElementNode writeMemberNode__writeNode_;
            @Child private ReadElementNode readArrayElementNode__readNode_;
            @Child private WriteElementNode writeArrayElementNode__writeNode_;
            @Child private JSInteropExecuteNode executeNode__callNode_;
            @Child private IsCallableNode isExecutableNode__isCallable_;
            @Child private JSInteropInstantiateNode instantiateNode__callNode_;
            @Child private JSInteropInvokeNode invokeMemberNode__callNode_;

            Cached(Object receiver) {
                this.dynamicDispatch_ = insert(DYNAMIC_DISPATCH_LIBRARY_.create(receiver));
            }

            @Override
            public boolean accepts(Object receiver) {
                return dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == JSClass.class;
            }

            @ExplodeLoop
            @Override
            public Object getMembers(Object arg0Value_, boolean arg1Value) throws UnsupportedMessageException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0b111111) != 0 /* is-active fastArray(DynamicObject, boolean) || slowArray(DynamicObject, boolean) || typedArray(DynamicObject, boolean) || argumentsObject(DynamicObject, boolean) || nonArrayCached(DynamicObject, boolean, JSClass) || nonArray(DynamicObject, boolean) */) {
                    if ((state & 0b1) != 0 /* is-active fastArray(DynamicObject, boolean) */) {
                        if ((JSGuards.isJSFastArray(arg0Value))) {
                            return GetMembers.fastArray(arg0Value, arg1Value);
                        }
                    }
                    if ((state & 0b10) != 0 /* is-active slowArray(DynamicObject, boolean) */) {
                        if ((JSGuards.isJSArray(arg0Value)) && (!(JSGuards.isJSFastArray(arg0Value)))) {
                            return GetMembers.slowArray(arg0Value, arg1Value);
                        }
                    }
                    if ((state & 0b100) != 0 /* is-active typedArray(DynamicObject, boolean) */) {
                        if ((JSGuards.isJSArrayBufferView(arg0Value))) {
                            return GetMembers.typedArray(arg0Value, arg1Value);
                        }
                    }
                    if ((state & 0b1000) != 0 /* is-active argumentsObject(DynamicObject, boolean) */) {
                        if ((JSGuards.isJSArgumentsObject(arg0Value))) {
                            return GetMembers.argumentsObject(arg0Value, arg1Value);
                        }
                    }
                    if ((state & 0b10000) != 0 /* is-active nonArrayCached(DynamicObject, boolean, JSClass) */) {
                        GetMembersNonArrayCachedData s5_ = this.getMembers_nonArrayCached_cache;
                        while (s5_ != null) {
                            assert (s5_.cachedJSClass_ != null);
                            if ((JSObject.getJSClass(arg0Value) == s5_.cachedJSClass_)) {
                                return GetMembers.nonArrayCached(arg0Value, arg1Value, s5_.cachedJSClass_);
                            }
                            s5_ = s5_.next_;
                        }
                    }
                    if ((state & 0b100000) != 0 /* is-active nonArray(DynamicObject, boolean) */) {
                        if ((!(JSGuards.isJSArray(arg0Value))) && (!(JSGuards.isJSArrayBufferView(arg0Value))) && (!(JSGuards.isJSArgumentsObject(arg0Value)))) {
                            return GetMembers.nonArray(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return getMembersAndSpecialize(arg0Value, arg1Value);
            }

            private Object getMembersAndSpecialize(DynamicObject arg0Value, boolean arg1Value) throws UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                int exclude = exclude_;
                try {
                    if ((JSGuards.isJSFastArray(arg0Value))) {
                        this.state_ = state = state | 0b1 /* add-active fastArray(DynamicObject, boolean) */;
                        lock.unlock();
                        hasLock = false;
                        return GetMembers.fastArray(arg0Value, arg1Value);
                    }
                    if ((JSGuards.isJSArray(arg0Value)) && (!(JSGuards.isJSFastArray(arg0Value)))) {
                        this.state_ = state = state | 0b10 /* add-active slowArray(DynamicObject, boolean) */;
                        lock.unlock();
                        hasLock = false;
                        return GetMembers.slowArray(arg0Value, arg1Value);
                    }
                    if ((JSGuards.isJSArrayBufferView(arg0Value))) {
                        this.state_ = state = state | 0b100 /* add-active typedArray(DynamicObject, boolean) */;
                        lock.unlock();
                        hasLock = false;
                        return GetMembers.typedArray(arg0Value, arg1Value);
                    }
                    if ((JSGuards.isJSArgumentsObject(arg0Value))) {
                        this.state_ = state = state | 0b1000 /* add-active argumentsObject(DynamicObject, boolean) */;
                        lock.unlock();
                        hasLock = false;
                        return GetMembers.argumentsObject(arg0Value, arg1Value);
                    }
                    if ((exclude) == 0 /* is-not-excluded nonArrayCached(DynamicObject, boolean, JSClass) */) {
                        int count5_ = 0;
                        GetMembersNonArrayCachedData s5_ = this.getMembers_nonArrayCached_cache;
                        if ((state & 0b10000) != 0 /* is-active nonArrayCached(DynamicObject, boolean, JSClass) */) {
                            while (s5_ != null) {
                                assert (s5_.cachedJSClass_ != null);
                                if ((JSObject.getJSClass(arg0Value) == s5_.cachedJSClass_)) {
                                    break;
                                }
                                s5_ = s5_.next_;
                                count5_++;
                            }
                        }
                        if (s5_ == null) {
                            {
                                JSClass cachedJSClass__ = (GetMembers.getNonArrayJSClass(arg0Value));
                                if ((cachedJSClass__ != null) && (JSObject.getJSClass(arg0Value) == cachedJSClass__) && count5_ < (3)) {
                                    s5_ = new GetMembersNonArrayCachedData(getMembers_nonArrayCached_cache);
                                    s5_.cachedJSClass_ = cachedJSClass__;
                                    this.getMembers_nonArrayCached_cache = s5_;
                                    this.state_ = state = state | 0b10000 /* add-active nonArrayCached(DynamicObject, boolean, JSClass) */;
                                }
                            }
                        }
                        if (s5_ != null) {
                            lock.unlock();
                            hasLock = false;
                            return GetMembers.nonArrayCached(arg0Value, arg1Value, s5_.cachedJSClass_);
                        }
                    }
                    if ((!(JSGuards.isJSArray(arg0Value))) && (!(JSGuards.isJSArrayBufferView(arg0Value))) && (!(JSGuards.isJSArgumentsObject(arg0Value)))) {
                        this.exclude_ = exclude = exclude | 0b1 /* add-excluded nonArrayCached(DynamicObject, boolean, JSClass) */;
                        this.getMembers_nonArrayCached_cache = null;
                        state = state & 0xffffffffffffffefL /* remove-active nonArrayCached(DynamicObject, boolean, JSClass) */;
                        this.state_ = state = state | 0b100000 /* add-active nonArray(DynamicObject, boolean) */;
                        lock.unlock();
                        hasLock = false;
                        return GetMembers.nonArray(arg0Value, arg1Value);
                    }
                    throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public NodeCost getCost() {
                long state = state_;
                if ((state & 0b111111) == 0b0) {
                    return NodeCost.UNINITIALIZED;
                } else if (((state & 0b111111) & ((state & 0b111111) - 1)) == 0 /* is-single-active  */) {
                    GetMembersNonArrayCachedData s5_ = this.getMembers_nonArrayCached_cache;
                    if ((s5_ == null || s5_.next_ == null)) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            @Override
            public long getArraySize(Object arg0Value_) throws UnsupportedMessageException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0b1111000000) != 0 /* is-active array(DynamicObject) || typedArray(DynamicObject) || argumentsObject(DynamicObject) || unsupported(DynamicObject) */) {
                    if ((state & 0b1000000) != 0 /* is-active array(DynamicObject) */) {
                        if ((JSGuards.isJSArray(arg0Value))) {
                            return GetArraySize.array(arg0Value);
                        }
                    }
                    if ((state & 0b10000000) != 0 /* is-active typedArray(DynamicObject) */) {
                        if ((JSGuards.isJSArrayBufferView(arg0Value))) {
                            return GetArraySize.typedArray(arg0Value);
                        }
                    }
                    if ((state & 0b100000000) != 0 /* is-active argumentsObject(DynamicObject) */) {
                        if ((JSGuards.isJSArgumentsObject(arg0Value))) {
                            return GetArraySize.argumentsObject(arg0Value);
                        }
                    }
                    if ((state & 0b1000000000) != 0 /* is-active unsupported(DynamicObject) */) {
                        if (getArraySizeFallbackGuard_(state, arg0Value)) {
                            return GetArraySize.unsupported(arg0Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return getArraySizeAndSpecialize(arg0Value);
            }

            private long getArraySizeAndSpecialize(DynamicObject arg0Value) throws UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if ((JSGuards.isJSArray(arg0Value))) {
                        this.state_ = state = state | 0b1000000 /* add-active array(DynamicObject) */;
                        lock.unlock();
                        hasLock = false;
                        return GetArraySize.array(arg0Value);
                    }
                    if ((JSGuards.isJSArrayBufferView(arg0Value))) {
                        this.state_ = state = state | 0b10000000 /* add-active typedArray(DynamicObject) */;
                        lock.unlock();
                        hasLock = false;
                        return GetArraySize.typedArray(arg0Value);
                    }
                    if ((JSGuards.isJSArgumentsObject(arg0Value))) {
                        this.state_ = state = state | 0b100000000 /* add-active argumentsObject(DynamicObject) */;
                        lock.unlock();
                        hasLock = false;
                        return GetArraySize.argumentsObject(arg0Value);
                    }
                    this.state_ = state = state | 0b1000000000 /* add-active unsupported(DynamicObject) */;
                    lock.unlock();
                    hasLock = false;
                    return GetArraySize.unsupported(arg0Value);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isNull(Object receiver) {
                assert assertAdopted();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.isNull(((DynamicObject) dynamicDispatch_.cast(receiver)));
            }

            @Override
            public boolean hasMembers(Object receiver) {
                assert assertAdopted();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.hasMembers(((DynamicObject) dynamicDispatch_.cast(receiver)));
            }

            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0b10000000000) != 0 /* is-active readMember(DynamicObject, String, LanguageReference<JavaScriptLanguage>, ReadElementNode, boolean, ExportValueNode) */) {
                    return JSClass.readMember(arg0Value, arg1Value, this.javaScriptLanguageReference_, this.readMemberNode__readNode_, this.readMemberNode__bindMemberFunctions_, this.readMemberNode__exportNode_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readMemberNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object readMemberNode_AndSpecialize(DynamicObject arg0Value, String arg1Value) throws UnknownIdentifierException, UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    LanguageReference<JavaScriptLanguage> javaScriptLanguageReference__ = this.javaScriptLanguageReference_;
                    if (javaScriptLanguageReference__ == null) {
                        this.javaScriptLanguageReference_ = javaScriptLanguageReference__ = super.lookupLanguageReference(JavaScriptLanguage.class);
                    }
                    this.readMemberNode__readNode_ = super.insert((ReadElementNode.create(javaScriptLanguageReference__.get().getJSContext())));
                    this.readMemberNode__bindMemberFunctions_ = (javaScriptLanguageReference__.get().bindMemberFunctions());
                    this.readMemberNode__exportNode_ = super.insert((ExportValueNode.create()));
                    this.state_ = state = state | 0b10000000000 /* add-active readMember(DynamicObject, String, LanguageReference<JavaScriptLanguage>, ReadElementNode, boolean, ExportValueNode) */;
                    lock.unlock();
                    hasLock = false;
                    return JSClass.readMember(arg0Value, arg1Value, javaScriptLanguageReference__, this.readMemberNode__readNode_, this.readMemberNode__bindMemberFunctions_, this.readMemberNode__exportNode_);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0b100000000000) != 0 /* is-active isMemberReadable(DynamicObject, String, KeyInfoNode) */) {
                    return JSClass.isMemberReadable(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberReadableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberReadableNode_AndSpecialize(DynamicObject arg0Value, String arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert((KeyInfoNodeGen.create()));
                    }
                    this.state_ = state = state | 0b100000000000 /* add-active isMemberReadable(DynamicObject, String, KeyInfoNode) */;
                    lock.unlock();
                    hasLock = false;
                    return JSClass.isMemberReadable(arg0Value, arg1Value, this.keyInfo);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0b1000000000000) != 0 /* is-active writeMember(DynamicObject, String, Object, KeyInfoNode, JSForeignToJSTypeNode, LanguageReference<JavaScriptLanguage>, WriteElementNode) */) {
                    JSClass.writeMember(arg0Value, arg1Value, arg2Value, this.keyInfo, this.importValue, this.javaScriptLanguageReference_, this.writeMemberNode__writeNode_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeMemberNode_AndSpecialize(DynamicObject arg0Value, String arg1Value, Object arg2Value) throws UnknownIdentifierException, UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert((KeyInfoNodeGen.create()));
                    }
                    if (this.importValue == null) {
                        this.importValue = super.insert((JSForeignToJSTypeNode.create()));
                    }
                    LanguageReference<JavaScriptLanguage> javaScriptLanguageReference__ = this.javaScriptLanguageReference_;
                    if (javaScriptLanguageReference__ == null) {
                        this.javaScriptLanguageReference_ = javaScriptLanguageReference__ = super.lookupLanguageReference(JavaScriptLanguage.class);
                    }
                    this.writeMemberNode__writeNode_ = super.insert((WriteElementNode.createCachedInterop(javaScriptLanguageReference__)));
                    this.state_ = state = state | 0b1000000000000 /* add-active writeMember(DynamicObject, String, Object, KeyInfoNode, JSForeignToJSTypeNode, LanguageReference<JavaScriptLanguage>, WriteElementNode) */;
                    lock.unlock();
                    hasLock = false;
                    JSClass.writeMember(arg0Value, arg1Value, arg2Value, this.keyInfo, this.importValue, javaScriptLanguageReference__, this.writeMemberNode__writeNode_);
                    return;
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0b10000000000000) != 0 /* is-active isMemberModifiable(DynamicObject, String, KeyInfoNode) */) {
                    return JSClass.isMemberModifiable(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberModifiableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberModifiableNode_AndSpecialize(DynamicObject arg0Value, String arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert((KeyInfoNodeGen.create()));
                    }
                    this.state_ = state = state | 0b10000000000000 /* add-active isMemberModifiable(DynamicObject, String, KeyInfoNode) */;
                    lock.unlock();
                    hasLock = false;
                    return JSClass.isMemberModifiable(arg0Value, arg1Value, this.keyInfo);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isMemberInsertable(Object arg0Value_, String arg1Value) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0b100000000000000) != 0 /* is-active isMemberInsertable(DynamicObject, String, KeyInfoNode) */) {
                    return JSClass.isMemberInsertable(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberInsertableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberInsertableNode_AndSpecialize(DynamicObject arg0Value, String arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert((KeyInfoNodeGen.create()));
                    }
                    this.state_ = state = state | 0b100000000000000 /* add-active isMemberInsertable(DynamicObject, String, KeyInfoNode) */;
                    lock.unlock();
                    hasLock = false;
                    return JSClass.isMemberInsertable(arg0Value, arg1Value, this.keyInfo);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void removeMember(Object receiver, String member) throws UnsupportedMessageException, UnknownIdentifierException {
                assert assertAdopted();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                JSClass.removeMember(((DynamicObject) dynamicDispatch_.cast(receiver)), member);
                return;
            }

            @Override
            public boolean isMemberRemovable(Object arg0Value_, String arg1Value) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0b1000000000000000) != 0 /* is-active isMemberRemovable(DynamicObject, String, KeyInfoNode) */) {
                    return JSClass.isMemberRemovable(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberRemovableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberRemovableNode_AndSpecialize(DynamicObject arg0Value, String arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert((KeyInfoNodeGen.create()));
                    }
                    this.state_ = state = state | 0b1000000000000000 /* add-active isMemberRemovable(DynamicObject, String, KeyInfoNode) */;
                    lock.unlock();
                    hasLock = false;
                    return JSClass.isMemberRemovable(arg0Value, arg1Value, this.keyInfo);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean hasArrayElements(Object receiver) {
                assert assertAdopted();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.hasArrayElements(((DynamicObject) dynamicDispatch_.cast(receiver)));
            }

            @Override
            public Object readArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x10000L) != 0 /* is-active readArrayElement(DynamicObject, long, LanguageReference<JavaScriptLanguage>, ReadElementNode, ExportValueNode) */) {
                    return JSClass.readArrayElement(arg0Value, arg1Value, this.javaScriptLanguageReference_, this.readArrayElementNode__readNode_, this.exportValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readArrayElementNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object readArrayElementNode_AndSpecialize(DynamicObject arg0Value, long arg1Value) throws InvalidArrayIndexException, UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    LanguageReference<JavaScriptLanguage> javaScriptLanguageReference__ = this.javaScriptLanguageReference_;
                    if (javaScriptLanguageReference__ == null) {
                        this.javaScriptLanguageReference_ = javaScriptLanguageReference__ = super.lookupLanguageReference(JavaScriptLanguage.class);
                    }
                    this.readArrayElementNode__readNode_ = super.insert((ReadElementNode.create(javaScriptLanguageReference__.get().getJSContext())));
                    if (this.exportValue == null) {
                        this.exportValue = super.insert((ExportValueNode.create()));
                    }
                    this.state_ = state = state | 0x10000L /* add-active readArrayElement(DynamicObject, long, LanguageReference<JavaScriptLanguage>, ReadElementNode, ExportValueNode) */;
                    lock.unlock();
                    hasLock = false;
                    return JSClass.readArrayElement(arg0Value, arg1Value, javaScriptLanguageReference__, this.readArrayElementNode__readNode_, this.exportValue);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x20000L) != 0 /* is-active isArrayElementReadable(DynamicObject, long, KeyInfoNode) */) {
                    return JSClass.isArrayElementReadable(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isArrayElementReadableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isArrayElementReadableNode_AndSpecialize(DynamicObject arg0Value, long arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert((KeyInfoNodeGen.create()));
                    }
                    this.state_ = state = state | 0x20000L /* add-active isArrayElementReadable(DynamicObject, long, KeyInfoNode) */;
                    lock.unlock();
                    hasLock = false;
                    return JSClass.isArrayElementReadable(arg0Value, arg1Value, this.keyInfo);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws UnsupportedMessageException, UnsupportedTypeException, InvalidArrayIndexException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x40000L) != 0 /* is-active writeArrayElement(DynamicObject, long, Object, KeyInfoNode, JSForeignToJSTypeNode, LanguageReference<JavaScriptLanguage>, WriteElementNode) */) {
                    JSClass.writeArrayElement(arg0Value, arg1Value, arg2Value, this.keyInfo, this.importValue, this.javaScriptLanguageReference_, this.writeArrayElementNode__writeNode_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeArrayElementNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeArrayElementNode_AndSpecialize(DynamicObject arg0Value, long arg1Value, Object arg2Value) throws InvalidArrayIndexException, UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert((KeyInfoNodeGen.create()));
                    }
                    if (this.importValue == null) {
                        this.importValue = super.insert((JSForeignToJSTypeNode.create()));
                    }
                    LanguageReference<JavaScriptLanguage> javaScriptLanguageReference__ = this.javaScriptLanguageReference_;
                    if (javaScriptLanguageReference__ == null) {
                        this.javaScriptLanguageReference_ = javaScriptLanguageReference__ = super.lookupLanguageReference(JavaScriptLanguage.class);
                    }
                    this.writeArrayElementNode__writeNode_ = super.insert((WriteElementNode.createCachedInterop(javaScriptLanguageReference__)));
                    this.state_ = state = state | 0x40000L /* add-active writeArrayElement(DynamicObject, long, Object, KeyInfoNode, JSForeignToJSTypeNode, LanguageReference<JavaScriptLanguage>, WriteElementNode) */;
                    lock.unlock();
                    hasLock = false;
                    JSClass.writeArrayElement(arg0Value, arg1Value, arg2Value, this.keyInfo, this.importValue, javaScriptLanguageReference__, this.writeArrayElementNode__writeNode_);
                    return;
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isArrayElementModifiable(Object arg0Value_, long arg1Value) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x80000L) != 0 /* is-active isArrayElementModifiable(DynamicObject, long, KeyInfoNode) */) {
                    return JSClass.isArrayElementModifiable(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isArrayElementModifiableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isArrayElementModifiableNode_AndSpecialize(DynamicObject arg0Value, long arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert((KeyInfoNodeGen.create()));
                    }
                    this.state_ = state = state | 0x80000L /* add-active isArrayElementModifiable(DynamicObject, long, KeyInfoNode) */;
                    lock.unlock();
                    hasLock = false;
                    return JSClass.isArrayElementModifiable(arg0Value, arg1Value, this.keyInfo);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isArrayElementInsertable(Object arg0Value_, long arg1Value) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x100000L) != 0 /* is-active isArrayElementInsertable(DynamicObject, long, KeyInfoNode) */) {
                    return JSClass.isArrayElementInsertable(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isArrayElementInsertableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isArrayElementInsertableNode_AndSpecialize(DynamicObject arg0Value, long arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert((KeyInfoNodeGen.create()));
                    }
                    this.state_ = state = state | 0x100000L /* add-active isArrayElementInsertable(DynamicObject, long, KeyInfoNode) */;
                    lock.unlock();
                    hasLock = false;
                    return JSClass.isArrayElementInsertable(arg0Value, arg1Value, this.keyInfo);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public void removeArrayElement(Object receiver, long index) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert assertAdopted();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                JSClass.removeArrayElement(((DynamicObject) dynamicDispatch_.cast(receiver)), index);
                return;
            }

            @Override
            public boolean isArrayElementRemovable(Object arg0Value_, long arg1Value) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x200000L) != 0 /* is-active isArrayElementRemovable(DynamicObject, long, KeyInfoNode) */) {
                    return JSClass.isArrayElementRemovable(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isArrayElementRemovableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isArrayElementRemovableNode_AndSpecialize(DynamicObject arg0Value, long arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert((KeyInfoNodeGen.create()));
                    }
                    this.state_ = state = state | 0x200000L /* add-active isArrayElementRemovable(DynamicObject, long, KeyInfoNode) */;
                    lock.unlock();
                    hasLock = false;
                    return JSClass.isArrayElementRemovable(arg0Value, arg1Value, this.keyInfo);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public Object execute(Object arg0Value_, Object... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x400000L) != 0 /* is-active execute(DynamicObject, Object[], JavaScriptLanguage, JSRealm, JSInteropExecuteNode, ExportValueNode) */) {
                    return JSClass.execute(arg0Value, arg1Value, this.javaScriptLanguageReference_.get(), this.javaScriptLanguageContextReference_.get(), this.executeNode__callNode_, this.exportValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object executeNode_AndSpecialize(DynamicObject arg0Value, Object[] arg1Value) throws UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    LanguageReference<JavaScriptLanguage> javaScriptLanguageReference__ = this.javaScriptLanguageReference_;
                    if (javaScriptLanguageReference__ == null) {
                        this.javaScriptLanguageReference_ = javaScriptLanguageReference__ = super.lookupLanguageReference(JavaScriptLanguage.class);
                    }
                    ContextReference<JSRealm> javaScriptLanguageContextReference__ = this.javaScriptLanguageContextReference_;
                    if (javaScriptLanguageContextReference__ == null) {
                        this.javaScriptLanguageContextReference_ = javaScriptLanguageContextReference__ = super.lookupContextReference(JavaScriptLanguage.class);
                    }
                    this.executeNode__callNode_ = super.insert((JSInteropExecuteNodeGen.create()));
                    if (this.exportValue == null) {
                        this.exportValue = super.insert((ExportValueNode.create()));
                    }
                    this.state_ = state = state | 0x400000L /* add-active execute(DynamicObject, Object[], JavaScriptLanguage, JSRealm, JSInteropExecuteNode, ExportValueNode) */;
                    lock.unlock();
                    hasLock = false;
                    return JSClass.execute(arg0Value, arg1Value, javaScriptLanguageReference__.get(), javaScriptLanguageContextReference__.get(), this.executeNode__callNode_, this.exportValue);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isExecutable(Object arg0Value_) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x800000L) != 0 /* is-active isExecutable(DynamicObject, IsCallableNode) */) {
                    return JSClass.isExecutable(arg0Value, this.isExecutableNode__isCallable_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isExecutableNode_AndSpecialize(arg0Value);
            }

            private boolean isExecutableNode_AndSpecialize(DynamicObject arg0Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    this.isExecutableNode__isCallable_ = super.insert((IsCallableNode.create()));
                    this.state_ = state = state | 0x800000L /* add-active isExecutable(DynamicObject, IsCallableNode) */;
                    lock.unlock();
                    hasLock = false;
                    return JSClass.isExecutable(arg0Value, this.isExecutableNode__isCallable_);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public Object instantiate(Object arg0Value_, Object... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x1000000L) != 0 /* is-active instantiate(DynamicObject, Object[], JavaScriptLanguage, JSRealm, JSInteropInstantiateNode, ExportValueNode) */) {
                    return JSClass.instantiate(arg0Value, arg1Value, this.javaScriptLanguageReference_.get(), this.javaScriptLanguageContextReference_.get(), this.instantiateNode__callNode_, this.exportValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return instantiateNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object instantiateNode_AndSpecialize(DynamicObject arg0Value, Object[] arg1Value) throws UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    LanguageReference<JavaScriptLanguage> javaScriptLanguageReference__ = this.javaScriptLanguageReference_;
                    if (javaScriptLanguageReference__ == null) {
                        this.javaScriptLanguageReference_ = javaScriptLanguageReference__ = super.lookupLanguageReference(JavaScriptLanguage.class);
                    }
                    ContextReference<JSRealm> javaScriptLanguageContextReference__ = this.javaScriptLanguageContextReference_;
                    if (javaScriptLanguageContextReference__ == null) {
                        this.javaScriptLanguageContextReference_ = javaScriptLanguageContextReference__ = super.lookupContextReference(JavaScriptLanguage.class);
                    }
                    this.instantiateNode__callNode_ = super.insert((JSInteropInstantiateNodeGen.create()));
                    if (this.exportValue == null) {
                        this.exportValue = super.insert((ExportValueNode.create()));
                    }
                    this.state_ = state = state | 0x1000000L /* add-active instantiate(DynamicObject, Object[], JavaScriptLanguage, JSRealm, JSInteropInstantiateNode, ExportValueNode) */;
                    lock.unlock();
                    hasLock = false;
                    return JSClass.instantiate(arg0Value, arg1Value, javaScriptLanguageReference__.get(), javaScriptLanguageContextReference__.get(), this.instantiateNode__callNode_, this.exportValue);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isInstantiable(Object receiver) {
                assert assertAdopted();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.isInstantiable(((DynamicObject) dynamicDispatch_.cast(receiver)));
            }

            @Override
            public Object invokeMember(Object arg0Value_, String arg1Value, Object... arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x2000000L) != 0 /* is-active invokeMember(DynamicObject, String, Object[], JavaScriptLanguage, JSRealm, JSInteropInvokeNode, ExportValueNode) */) {
                    return JSClass.invokeMember(arg0Value, arg1Value, arg2Value, this.javaScriptLanguageReference_.get(), this.javaScriptLanguageContextReference_.get(), this.invokeMemberNode__callNode_, this.exportValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return invokeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private Object invokeMemberNode_AndSpecialize(DynamicObject arg0Value, String arg1Value, Object[] arg2Value) throws UnsupportedMessageException, UnknownIdentifierException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    LanguageReference<JavaScriptLanguage> javaScriptLanguageReference__ = this.javaScriptLanguageReference_;
                    if (javaScriptLanguageReference__ == null) {
                        this.javaScriptLanguageReference_ = javaScriptLanguageReference__ = super.lookupLanguageReference(JavaScriptLanguage.class);
                    }
                    ContextReference<JSRealm> javaScriptLanguageContextReference__ = this.javaScriptLanguageContextReference_;
                    if (javaScriptLanguageContextReference__ == null) {
                        this.javaScriptLanguageContextReference_ = javaScriptLanguageContextReference__ = super.lookupContextReference(JavaScriptLanguage.class);
                    }
                    this.invokeMemberNode__callNode_ = super.insert((JSInteropInvokeNode.create()));
                    if (this.exportValue == null) {
                        this.exportValue = super.insert((ExportValueNode.create()));
                    }
                    this.state_ = state = state | 0x2000000L /* add-active invokeMember(DynamicObject, String, Object[], JavaScriptLanguage, JSRealm, JSInteropInvokeNode, ExportValueNode) */;
                    lock.unlock();
                    hasLock = false;
                    return JSClass.invokeMember(arg0Value, arg1Value, arg2Value, javaScriptLanguageReference__.get(), javaScriptLanguageContextReference__.get(), this.invokeMemberNode__callNode_, this.exportValue);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x4000000L) != 0 /* is-active isMemberInvocable(DynamicObject, String, KeyInfoNode) */) {
                    return JSClass.isMemberInvocable(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberInvocableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberInvocableNode_AndSpecialize(DynamicObject arg0Value, String arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert((KeyInfoNodeGen.create()));
                    }
                    this.state_ = state = state | 0x4000000L /* add-active isMemberInvocable(DynamicObject, String, KeyInfoNode) */;
                    lock.unlock();
                    hasLock = false;
                    return JSClass.isMemberInvocable(arg0Value, arg1Value, this.keyInfo);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean hasMemberReadSideEffects(Object arg0Value_, String arg1Value) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x8000000L) != 0 /* is-active hasMemberReadSideEffects(DynamicObject, String, KeyInfoNode) */) {
                    return JSClass.hasMemberReadSideEffects(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return hasMemberReadSideEffectsNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean hasMemberReadSideEffectsNode_AndSpecialize(DynamicObject arg0Value, String arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert((KeyInfoNodeGen.create()));
                    }
                    this.state_ = state = state | 0x8000000L /* add-active hasMemberReadSideEffects(DynamicObject, String, KeyInfoNode) */;
                    lock.unlock();
                    hasLock = false;
                    return JSClass.hasMemberReadSideEffects(arg0Value, arg1Value, this.keyInfo);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean hasMemberWriteSideEffects(Object arg0Value_, String arg1Value) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x10000000L) != 0 /* is-active hasMemberWriteSideEffects(DynamicObject, String, KeyInfoNode) */) {
                    return JSClass.hasMemberWriteSideEffects(arg0Value, arg1Value, this.keyInfo);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return hasMemberWriteSideEffectsNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean hasMemberWriteSideEffectsNode_AndSpecialize(DynamicObject arg0Value, String arg1Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.keyInfo == null) {
                        this.keyInfo = super.insert((KeyInfoNodeGen.create()));
                    }
                    this.state_ = state = state | 0x10000000L /* add-active hasMemberWriteSideEffects(DynamicObject, String, KeyInfoNode) */;
                    lock.unlock();
                    hasLock = false;
                    return JSClass.hasMemberWriteSideEffects(arg0Value, arg1Value, this.keyInfo);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isString(Object receiver) {
                assert assertAdopted();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.isString(((DynamicObject) dynamicDispatch_.cast(receiver)));
            }

            @Override
            public String asString(Object receiver) throws UnsupportedMessageException {
                assert assertAdopted();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.asString(((DynamicObject) dynamicDispatch_.cast(receiver)));
            }

            @Override
            public boolean isBoolean(Object receiver) {
                assert assertAdopted();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.isBoolean(((DynamicObject) dynamicDispatch_.cast(receiver)));
            }

            @Override
            public boolean asBoolean(Object receiver) throws UnsupportedMessageException {
                assert assertAdopted();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.asBoolean(((DynamicObject) dynamicDispatch_.cast(receiver)));
            }

            @Override
            public boolean isNumber(Object receiver) {
                assert assertAdopted();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.isNumber(((DynamicObject) dynamicDispatch_.cast(receiver)));
            }

            @Override
            public boolean fitsInByte(Object arg0Value_) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x20000000L) != 0 /* is-active fitsInByte(DynamicObject, InteropLibrary) */) {
                    return JSClass.fitsInByte(arg0Value, this.numberLib);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return fitsInByteNode_AndSpecialize(arg0Value);
            }

            private boolean fitsInByteNode_AndSpecialize(DynamicObject arg0Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.numberLib == null) {
                        this.numberLib = super.insert((INTEROP_LIBRARY_.createDispatched(1)));
                    }
                    this.state_ = state = state | 0x20000000L /* add-active fitsInByte(DynamicObject, InteropLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    return JSClass.fitsInByte(arg0Value, this.numberLib);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean fitsInShort(Object arg0Value_) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x40000000L) != 0 /* is-active fitsInShort(DynamicObject, InteropLibrary) */) {
                    return JSClass.fitsInShort(arg0Value, this.numberLib);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return fitsInShortNode_AndSpecialize(arg0Value);
            }

            private boolean fitsInShortNode_AndSpecialize(DynamicObject arg0Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.numberLib == null) {
                        this.numberLib = super.insert((INTEROP_LIBRARY_.createDispatched(1)));
                    }
                    this.state_ = state = state | 0x40000000L /* add-active fitsInShort(DynamicObject, InteropLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    return JSClass.fitsInShort(arg0Value, this.numberLib);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean fitsInInt(Object arg0Value_) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x80000000L) != 0 /* is-active fitsInInt(DynamicObject, InteropLibrary) */) {
                    return JSClass.fitsInInt(arg0Value, this.numberLib);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return fitsInIntNode_AndSpecialize(arg0Value);
            }

            private boolean fitsInIntNode_AndSpecialize(DynamicObject arg0Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.numberLib == null) {
                        this.numberLib = super.insert((INTEROP_LIBRARY_.createDispatched(1)));
                    }
                    this.state_ = state = state | 0x80000000L /* add-active fitsInInt(DynamicObject, InteropLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    return JSClass.fitsInInt(arg0Value, this.numberLib);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean fitsInLong(Object arg0Value_) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x100000000L) != 0 /* is-active fitsInLong(DynamicObject, InteropLibrary) */) {
                    return JSClass.fitsInLong(arg0Value, this.numberLib);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return fitsInLongNode_AndSpecialize(arg0Value);
            }

            private boolean fitsInLongNode_AndSpecialize(DynamicObject arg0Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.numberLib == null) {
                        this.numberLib = super.insert((INTEROP_LIBRARY_.createDispatched(1)));
                    }
                    this.state_ = state = state | 0x100000000L /* add-active fitsInLong(DynamicObject, InteropLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    return JSClass.fitsInLong(arg0Value, this.numberLib);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean fitsInFloat(Object arg0Value_) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x200000000L) != 0 /* is-active fitsInFloat(DynamicObject, InteropLibrary) */) {
                    return JSClass.fitsInFloat(arg0Value, this.numberLib);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return fitsInFloatNode_AndSpecialize(arg0Value);
            }

            private boolean fitsInFloatNode_AndSpecialize(DynamicObject arg0Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.numberLib == null) {
                        this.numberLib = super.insert((INTEROP_LIBRARY_.createDispatched(1)));
                    }
                    this.state_ = state = state | 0x200000000L /* add-active fitsInFloat(DynamicObject, InteropLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    return JSClass.fitsInFloat(arg0Value, this.numberLib);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean fitsInDouble(Object arg0Value_) {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x400000000L) != 0 /* is-active fitsInDouble(DynamicObject, InteropLibrary) */) {
                    return JSClass.fitsInDouble(arg0Value, this.numberLib);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return fitsInDoubleNode_AndSpecialize(arg0Value);
            }

            private boolean fitsInDoubleNode_AndSpecialize(DynamicObject arg0Value) {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.numberLib == null) {
                        this.numberLib = super.insert((INTEROP_LIBRARY_.createDispatched(1)));
                    }
                    this.state_ = state = state | 0x400000000L /* add-active fitsInDouble(DynamicObject, InteropLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    return JSClass.fitsInDouble(arg0Value, this.numberLib);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public byte asByte(Object arg0Value_) throws UnsupportedMessageException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x800000000L) != 0 /* is-active asByte(DynamicObject, InteropLibrary) */) {
                    return JSClass.asByte(arg0Value, this.numberLib);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return asByteNode_AndSpecialize(arg0Value);
            }

            private byte asByteNode_AndSpecialize(DynamicObject arg0Value) throws UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.numberLib == null) {
                        this.numberLib = super.insert((INTEROP_LIBRARY_.createDispatched(1)));
                    }
                    this.state_ = state = state | 0x800000000L /* add-active asByte(DynamicObject, InteropLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    return JSClass.asByte(arg0Value, this.numberLib);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public short asShort(Object arg0Value_) throws UnsupportedMessageException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x1000000000L) != 0 /* is-active asShort(DynamicObject, InteropLibrary) */) {
                    return JSClass.asShort(arg0Value, this.numberLib);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return asShortNode_AndSpecialize(arg0Value);
            }

            private short asShortNode_AndSpecialize(DynamicObject arg0Value) throws UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.numberLib == null) {
                        this.numberLib = super.insert((INTEROP_LIBRARY_.createDispatched(1)));
                    }
                    this.state_ = state = state | 0x1000000000L /* add-active asShort(DynamicObject, InteropLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    return JSClass.asShort(arg0Value, this.numberLib);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public int asInt(Object arg0Value_) throws UnsupportedMessageException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x2000000000L) != 0 /* is-active asInt(DynamicObject, InteropLibrary) */) {
                    return JSClass.asInt(arg0Value, this.numberLib);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return asIntNode_AndSpecialize(arg0Value);
            }

            private int asIntNode_AndSpecialize(DynamicObject arg0Value) throws UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.numberLib == null) {
                        this.numberLib = super.insert((INTEROP_LIBRARY_.createDispatched(1)));
                    }
                    this.state_ = state = state | 0x2000000000L /* add-active asInt(DynamicObject, InteropLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    return JSClass.asInt(arg0Value, this.numberLib);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public long asLong(Object arg0Value_) throws UnsupportedMessageException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x4000000000L) != 0 /* is-active asLong(DynamicObject, InteropLibrary) */) {
                    return JSClass.asLong(arg0Value, this.numberLib);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return asLongNode_AndSpecialize(arg0Value);
            }

            private long asLongNode_AndSpecialize(DynamicObject arg0Value) throws UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.numberLib == null) {
                        this.numberLib = super.insert((INTEROP_LIBRARY_.createDispatched(1)));
                    }
                    this.state_ = state = state | 0x4000000000L /* add-active asLong(DynamicObject, InteropLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    return JSClass.asLong(arg0Value, this.numberLib);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public float asFloat(Object arg0Value_) throws UnsupportedMessageException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x8000000000L) != 0 /* is-active asFloat(DynamicObject, InteropLibrary) */) {
                    return JSClass.asFloat(arg0Value, this.numberLib);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return asFloatNode_AndSpecialize(arg0Value);
            }

            private float asFloatNode_AndSpecialize(DynamicObject arg0Value) throws UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.numberLib == null) {
                        this.numberLib = super.insert((INTEROP_LIBRARY_.createDispatched(1)));
                    }
                    this.state_ = state = state | 0x8000000000L /* add-active asFloat(DynamicObject, InteropLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    return JSClass.asFloat(arg0Value, this.numberLib);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public double asDouble(Object arg0Value_) throws UnsupportedMessageException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x10000000000L) != 0 /* is-active asDouble(DynamicObject, InteropLibrary) */) {
                    return JSClass.asDouble(arg0Value, this.numberLib);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return asDoubleNode_AndSpecialize(arg0Value);
            }

            private double asDoubleNode_AndSpecialize(DynamicObject arg0Value) throws UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    if (this.numberLib == null) {
                        this.numberLib = super.insert((INTEROP_LIBRARY_.createDispatched(1)));
                    }
                    this.state_ = state = state | 0x10000000000L /* add-active asDouble(DynamicObject, InteropLibrary) */;
                    lock.unlock();
                    hasLock = false;
                    return JSClass.asDouble(arg0Value, this.numberLib);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public boolean isDate(Object receiver) {
                assert assertAdopted();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.isDate(((DynamicObject) dynamicDispatch_.cast(receiver)));
            }

            @Override
            public boolean isTime(Object receiver) {
                assert assertAdopted();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.isDate(((DynamicObject) dynamicDispatch_.cast(receiver)));
            }

            @Override
            public boolean isTimeZone(Object receiver) {
                assert assertAdopted();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.isDate(((DynamicObject) dynamicDispatch_.cast(receiver)));
            }

            @Override
            public Instant asInstant(Object receiver) throws UnsupportedMessageException {
                assert assertAdopted();
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.asInstant(((DynamicObject) dynamicDispatch_.cast(receiver)));
            }

            @Override
            public LocalDate asDate(Object arg0Value_) throws UnsupportedMessageException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x20000000000L) != 0 /* is-active asDate(DynamicObject, ContextReference<JSRealm>) */) {
                    return JSClass.asDate(arg0Value, this.javaScriptLanguageContextReference_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return asDateNode_AndSpecialize(arg0Value);
            }

            private LocalDate asDateNode_AndSpecialize(DynamicObject arg0Value) throws UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    ContextReference<JSRealm> javaScriptLanguageContextReference__ = this.javaScriptLanguageContextReference_;
                    if (javaScriptLanguageContextReference__ == null) {
                        this.javaScriptLanguageContextReference_ = javaScriptLanguageContextReference__ = super.lookupContextReference(JavaScriptLanguage.class);
                    }
                    this.state_ = state = state | 0x20000000000L /* add-active asDate(DynamicObject, ContextReference<JSRealm>) */;
                    lock.unlock();
                    hasLock = false;
                    return JSClass.asDate(arg0Value, javaScriptLanguageContextReference__);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public LocalTime asTime(Object arg0Value_) throws UnsupportedMessageException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x40000000000L) != 0 /* is-active asTime(DynamicObject, ContextReference<JSRealm>) */) {
                    return JSClass.asTime(arg0Value, this.javaScriptLanguageContextReference_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return asTimeNode_AndSpecialize(arg0Value);
            }

            private LocalTime asTimeNode_AndSpecialize(DynamicObject arg0Value) throws UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    ContextReference<JSRealm> javaScriptLanguageContextReference__ = this.javaScriptLanguageContextReference_;
                    if (javaScriptLanguageContextReference__ == null) {
                        this.javaScriptLanguageContextReference_ = javaScriptLanguageContextReference__ = super.lookupContextReference(JavaScriptLanguage.class);
                    }
                    this.state_ = state = state | 0x40000000000L /* add-active asTime(DynamicObject, ContextReference<JSRealm>) */;
                    lock.unlock();
                    hasLock = false;
                    return JSClass.asTime(arg0Value, javaScriptLanguageContextReference__);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            @Override
            public ZoneId asTimeZone(Object arg0Value_) throws UnsupportedMessageException {
                assert assertAdopted();
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) dynamicDispatch_.cast(arg0Value_);
                long state = state_;
                if ((state & 0x80000000000L) != 0 /* is-active asTimeZone(DynamicObject, ContextReference<JSRealm>) */) {
                    return JSClass.asTimeZone(arg0Value, this.javaScriptLanguageContextReference_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return asTimeZoneNode_AndSpecialize(arg0Value);
            }

            private ZoneId asTimeZoneNode_AndSpecialize(DynamicObject arg0Value) throws UnsupportedMessageException {
                Lock lock = getLock();
                boolean hasLock = true;
                lock.lock();
                long state = state_;
                try {
                    ContextReference<JSRealm> javaScriptLanguageContextReference__ = this.javaScriptLanguageContextReference_;
                    if (javaScriptLanguageContextReference__ == null) {
                        this.javaScriptLanguageContextReference_ = javaScriptLanguageContextReference__ = super.lookupContextReference(JavaScriptLanguage.class);
                    }
                    this.state_ = state = state | 0x80000000000L /* add-active asTimeZone(DynamicObject, ContextReference<JSRealm>) */;
                    lock.unlock();
                    hasLock = false;
                    return JSClass.asTimeZone(arg0Value, javaScriptLanguageContextReference__);
                } finally {
                    if (hasLock) {
                        lock.unlock();
                    }
                }
            }

            private static boolean getArraySizeFallbackGuard_(long state, DynamicObject arg0Value) {
                if (((state & 0b1000000)) == 0 /* is-not-active array(DynamicObject) */ && (JSGuards.isJSArray(arg0Value))) {
                    return false;
                }
                if (((state & 0b10000000)) == 0 /* is-not-active typedArray(DynamicObject) */ && (JSGuards.isJSArrayBufferView(arg0Value))) {
                    return false;
                }
                if (((state & 0b100000000)) == 0 /* is-not-active argumentsObject(DynamicObject) */ && (JSGuards.isJSArgumentsObject(arg0Value))) {
                    return false;
                }
                return true;
            }

            @GeneratedBy(JSClass.class)
            private static final class GetMembersNonArrayCachedData {

                @CompilationFinal GetMembersNonArrayCachedData next_;
                @CompilationFinal JSClass cachedJSClass_;

                GetMembersNonArrayCachedData(GetMembersNonArrayCachedData next_) {
                    this.next_ = next_;
                }

            }
        }
        @GeneratedBy(JSClass.class)
        private static final class Uncached extends InteropLibrary {

            @Child private DynamicDispatchLibrary dynamicDispatch_;
            private final LanguageReference<JavaScriptLanguage> javaScriptLanguageReference_ = lookupLanguageReference(JavaScriptLanguage.class);
            private final ContextReference<JSRealm> javaScriptLanguageContextReference_ = lookupContextReference(JavaScriptLanguage.class);

            Uncached(Object receiver) {
                this.dynamicDispatch_ = DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
            }

            @TruffleBoundary
            @Override
            public boolean accepts(Object receiver) {
                return dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == JSClass.class;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public Object getMembers(Object arg0Value_, boolean arg1Value) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) arg0Value_;
                if ((JSGuards.isJSFastArray(arg0Value))) {
                    return GetMembers.fastArray(arg0Value, arg1Value);
                }
                if ((JSGuards.isJSArray(arg0Value)) && (!(JSGuards.isJSFastArray(arg0Value)))) {
                    return GetMembers.slowArray(arg0Value, arg1Value);
                }
                if ((JSGuards.isJSArrayBufferView(arg0Value))) {
                    return GetMembers.typedArray(arg0Value, arg1Value);
                }
                if ((JSGuards.isJSArgumentsObject(arg0Value))) {
                    return GetMembers.argumentsObject(arg0Value, arg1Value);
                }
                if ((!(JSGuards.isJSArray(arg0Value))) && (!(JSGuards.isJSArrayBufferView(arg0Value))) && (!(JSGuards.isJSArgumentsObject(arg0Value)))) {
                    return GetMembers.nonArray(arg0Value, arg1Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public long getArraySize(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) arg0Value_;
                if ((JSGuards.isJSArray(arg0Value))) {
                    return GetArraySize.array(arg0Value);
                }
                if ((JSGuards.isJSArrayBufferView(arg0Value))) {
                    return GetArraySize.typedArray(arg0Value);
                }
                if ((JSGuards.isJSArgumentsObject(arg0Value))) {
                    return GetArraySize.argumentsObject(arg0Value);
                }
                return GetArraySize.unsupported(arg0Value);
            }

            @TruffleBoundary
            @Override
            public boolean isNull(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.isNull(((DynamicObject) receiver) );
            }

            @TruffleBoundary
            @Override
            public boolean hasMembers(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.hasMembers(((DynamicObject) receiver) );
            }

            @TruffleBoundary
            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnknownIdentifierException, UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) arg0Value_;
                return JSClass.readMember(arg0Value, arg1Value, this.javaScriptLanguageReference_, (JSClass.getUncachedRead()), (this.javaScriptLanguageReference_.get().bindMemberFunctions()), (ExportValueNodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) arg0Value_;
                return JSClass.isMemberReadable(arg0Value, arg1Value, (KeyInfoNodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnknownIdentifierException, UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) arg0Value_;
                JSClass.writeMember(arg0Value, arg1Value, arg2Value, (KeyInfoNodeGen.getUncached()), (JSForeignToJSTypeNodeGen.getUncached()), this.javaScriptLanguageReference_, (JSClass.getUncachedWrite()));
                return;
            }

            @TruffleBoundary
            @Override
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) arg0Value_;
                return JSClass.isMemberModifiable(arg0Value, arg1Value, (KeyInfoNodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberInsertable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) arg0Value_;
                return JSClass.isMemberInsertable(arg0Value, arg1Value, (KeyInfoNodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public void removeMember(Object receiver, String member) throws UnsupportedMessageException, UnknownIdentifierException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                JSClass.removeMember(((DynamicObject) receiver) , member);
                return;
            }

            @TruffleBoundary
            @Override
            public boolean isMemberRemovable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) arg0Value_;
                return JSClass.isMemberRemovable(arg0Value, arg1Value, (KeyInfoNodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean hasArrayElements(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.hasArrayElements(((DynamicObject) receiver) );
            }

            @TruffleBoundary
            @Override
            public Object readArrayElement(Object arg0Value_, long arg1Value) throws InvalidArrayIndexException, UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) arg0Value_;
                return JSClass.readArrayElement(arg0Value, arg1Value, this.javaScriptLanguageReference_, (JSClass.getUncachedRead()), (ExportValueNodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) arg0Value_;
                return JSClass.isArrayElementReadable(arg0Value, arg1Value, (KeyInfoNodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws InvalidArrayIndexException, UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) arg0Value_;
                JSClass.writeArrayElement(arg0Value, arg1Value, arg2Value, (KeyInfoNodeGen.getUncached()), (JSForeignToJSTypeNodeGen.getUncached()), this.javaScriptLanguageReference_, (JSClass.getUncachedWrite()));
                return;
            }

            @TruffleBoundary
            @Override
            public boolean isArrayElementModifiable(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) arg0Value_;
                return JSClass.isArrayElementModifiable(arg0Value, arg1Value, (KeyInfoNodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean isArrayElementInsertable(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) arg0Value_;
                return JSClass.isArrayElementInsertable(arg0Value, arg1Value, (KeyInfoNodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public void removeArrayElement(Object receiver, long index) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                JSClass.removeArrayElement(((DynamicObject) receiver) , index);
                return;
            }

            @TruffleBoundary
            @Override
            public boolean isArrayElementRemovable(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) arg0Value_;
                return JSClass.isArrayElementRemovable(arg0Value, arg1Value, (KeyInfoNodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public Object execute(Object arg0Value_, Object... arg1Value) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) arg0Value_;
                return JSClass.execute(arg0Value, arg1Value, this.javaScriptLanguageReference_.get(), this.javaScriptLanguageContextReference_.get(), (JSInteropExecuteNodeGen.getUncached()), (ExportValueNodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean isExecutable(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) arg0Value_;
                return JSClass.isExecutable(arg0Value, (IsCallableNodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public Object instantiate(Object arg0Value_, Object... arg1Value) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) arg0Value_;
                return JSClass.instantiate(arg0Value, arg1Value, this.javaScriptLanguageReference_.get(), this.javaScriptLanguageContextReference_.get(), (JSInteropInstantiateNodeGen.getUncached()), (ExportValueNodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean isInstantiable(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.isInstantiable(((DynamicObject) receiver) );
            }

            @TruffleBoundary
            @Override
            public Object invokeMember(Object arg0Value_, String arg1Value, Object... arg2Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) arg0Value_;
                return JSClass.invokeMember(arg0Value, arg1Value, arg2Value, this.javaScriptLanguageReference_.get(), this.javaScriptLanguageContextReference_.get(), (JSInteropInvokeNodeGen.getUncached()), (ExportValueNodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) arg0Value_;
                return JSClass.isMemberInvocable(arg0Value, arg1Value, (KeyInfoNodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean hasMemberReadSideEffects(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) arg0Value_;
                return JSClass.hasMemberReadSideEffects(arg0Value, arg1Value, (KeyInfoNodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean hasMemberWriteSideEffects(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) arg0Value_;
                return JSClass.hasMemberWriteSideEffects(arg0Value, arg1Value, (KeyInfoNodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean isString(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.isString(((DynamicObject) receiver) );
            }

            @TruffleBoundary
            @Override
            public String asString(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.asString(((DynamicObject) receiver) );
            }

            @TruffleBoundary
            @Override
            public boolean isBoolean(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.isBoolean(((DynamicObject) receiver) );
            }

            @TruffleBoundary
            @Override
            public boolean asBoolean(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.asBoolean(((DynamicObject) receiver) );
            }

            @TruffleBoundary
            @Override
            public boolean isNumber(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.isNumber(((DynamicObject) receiver) );
            }

            @TruffleBoundary
            @Override
            public boolean fitsInByte(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) arg0Value_;
                return JSClass.fitsInByte(arg0Value, (INTEROP_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean fitsInShort(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) arg0Value_;
                return JSClass.fitsInShort(arg0Value, (INTEROP_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean fitsInInt(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) arg0Value_;
                return JSClass.fitsInInt(arg0Value, (INTEROP_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean fitsInLong(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) arg0Value_;
                return JSClass.fitsInLong(arg0Value, (INTEROP_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean fitsInFloat(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) arg0Value_;
                return JSClass.fitsInFloat(arg0Value, (INTEROP_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean fitsInDouble(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) arg0Value_;
                return JSClass.fitsInDouble(arg0Value, (INTEROP_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public byte asByte(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) arg0Value_;
                return JSClass.asByte(arg0Value, (INTEROP_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public short asShort(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) arg0Value_;
                return JSClass.asShort(arg0Value, (INTEROP_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public int asInt(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) arg0Value_;
                return JSClass.asInt(arg0Value, (INTEROP_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public long asLong(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) arg0Value_;
                return JSClass.asLong(arg0Value, (INTEROP_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public float asFloat(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) arg0Value_;
                return JSClass.asFloat(arg0Value, (INTEROP_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public double asDouble(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) arg0Value_;
                return JSClass.asDouble(arg0Value, (INTEROP_LIBRARY_.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean isDate(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.isDate(((DynamicObject) receiver) );
            }

            @TruffleBoundary
            @Override
            public boolean isTime(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.isDate(((DynamicObject) receiver) );
            }

            @TruffleBoundary
            @Override
            public boolean isTimeZone(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.isDate(((DynamicObject) receiver) );
            }

            @TruffleBoundary
            @Override
            public Instant asInstant(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return JSClass.asInstant(((DynamicObject) receiver) );
            }

            @TruffleBoundary
            @Override
            public LocalDate asDate(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) arg0Value_;
                return JSClass.asDate(arg0Value, this.javaScriptLanguageContextReference_);
            }

            @TruffleBoundary
            @Override
            public LocalTime asTime(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) arg0Value_;
                return JSClass.asTime(arg0Value, this.javaScriptLanguageContextReference_);
            }

            @TruffleBoundary
            @Override
            public ZoneId asTimeZone(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                DynamicObject arg0Value = (DynamicObject) arg0Value_;
                return JSClass.asTimeZone(arg0Value, this.javaScriptLanguageContextReference_);
            }

        }
    }
}
