// CheckStyle: start generated
package com.oracle.truffle.js.nodes.unary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.Introspection.Provider;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.unary.RequireConstructorNode;

@GeneratedBy(RequireConstructorNode.class)
@SuppressWarnings("unused")
public final class RequireConstructorNodeGen extends RequireConstructorNode implements Provider {

    @CompilationFinal private int state_;

    private RequireConstructorNodeGen(JavaScriptNode argumentNode) {
        super(argumentNode);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state = state_;
        Object argumentNodeValue_ = super.argumentNode.execute(frameValue);
        boolean isConstructorNodeValue_ = super.isConstructorNode.executeBoolean(argumentNodeValue_);
        if (state != 0 /* is-active constructor(Object, boolean) || typeError(Object, boolean) */) {
            if ((state & 0b1) != 0 /* is-active constructor(Object, boolean) */) {
                if ((isConstructorNodeValue_)) {
                    return RequireConstructorNode.constructor(argumentNodeValue_, isConstructorNodeValue_);
                }
            }
            if ((state & 0b10) != 0 /* is-active typeError(Object, boolean) */) {
                if (fallbackGuard_(state, argumentNodeValue_, isConstructorNodeValue_)) {
                    return typeError(argumentNodeValue_, isConstructorNodeValue_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(argumentNodeValue_, isConstructorNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        execute(frameValue);
        return;
    }

    private Object executeAndSpecialize(Object argumentNodeValue, boolean isConstructorNodeValue) {
        int state = state_;
        if ((isConstructorNodeValue)) {
            this.state_ = state = state | 0b1 /* add-active constructor(Object, boolean) */;
            return RequireConstructorNode.constructor(argumentNodeValue, isConstructorNodeValue);
        }
        this.state_ = state = state | 0b10 /* add-active typeError(Object, boolean) */;
        return typeError(argumentNodeValue, isConstructorNodeValue);
    }

    @Override
    public NodeCost getCost() {
        int state = state_;
        if (state == 0b0) {
            return NodeCost.UNINITIALIZED;
        } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[3];
        Object[] s;
        data[0] = 0;
        int state = state_;
        s = new Object[3];
        s[0] = "constructor";
        if ((state & 0b1) != 0 /* is-active constructor(Object, boolean) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "typeError";
        if ((state & 0b10) != 0 /* is-active typeError(Object, boolean) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[2] = s;
        return Provider.create(data);
    }

    private static boolean fallbackGuard_(int state, Object argumentNodeValue, boolean isConstructorNodeValue) {
        if (((state & 0b1)) == 0 /* is-not-active constructor(Object, boolean) */ && (isConstructorNodeValue)) {
            return false;
        }
        return true;
    }

    public static RequireConstructorNode create(JavaScriptNode argumentNode) {
        return new RequireConstructorNodeGen(argumentNode);
    }

}
