// CheckStyle: start generated
package com.oracle.truffle.js.nodes.unary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.Introspection.Provider;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.unary.JSIsNullOrUndefinedNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.LargeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.objects.JSLazyString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.locks.Lock;

@GeneratedBy(JSIsNullOrUndefinedNode.class)
@SuppressWarnings("unused")
public final class JSIsNullOrUndefinedNodeGen extends JSIsNullOrUndefinedNode implements Provider {

    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    @CompilationFinal private int state_;
    @CompilationFinal private int exclude_;
    @CompilationFinal private JSObjectCachedShapeData jSObjectCachedShape_cache;
    @CompilationFinal private JSObjectCachedTypeData jSObjectCachedType_cache;
    @CompilationFinal private ConditionProfile jSObject_resultProfile_;
    @CompilationFinal private JSValueCachedData jSValueCached_cache;
    @Child private InteropLibrary foreign0_interop_;

    private JSIsNullOrUndefinedNodeGen(JavaScriptNode operand, boolean isUndefined, boolean isLeft) {
        super(operand, isUndefined, isLeft);
    }

    @ExplodeLoop
    @Override
    public Object execute(VirtualFrame frameValue, Object operandNodeValue) {
        int state = state_;
        if ((state & 0b11) != 0 /* is-active doNull(Object) || doUndefined(Object) */) {
            if ((state & 0b1) != 0 /* is-active doNull(Object) */) {
                if ((JSGuards.isJSNull(operandNodeValue))) {
                    return JSIsNullOrUndefinedNode.doNull(operandNodeValue);
                }
            }
            if ((state & 0b10) != 0 /* is-active doUndefined(Object) */) {
                if ((JSGuards.isUndefined(operandNodeValue))) {
                    return JSIsNullOrUndefinedNode.doUndefined(operandNodeValue);
                }
            }
        }
        if ((state & 0b100) != 0 /* is-active doSymbol(Symbol) */ && operandNodeValue instanceof Symbol) {
            Symbol operandNodeValue_ = (Symbol) operandNodeValue;
            return JSIsNullOrUndefinedNode.doSymbol(operandNodeValue_);
        }
        if ((state & 0b1000) != 0 /* is-active doLazyString(JSLazyString) */ && operandNodeValue instanceof JSLazyString) {
            JSLazyString operandNodeValue_ = (JSLazyString) operandNodeValue;
            return JSIsNullOrUndefinedNode.doLazyString(operandNodeValue_);
        }
        if ((state & 0b10000) != 0 /* is-active doLargeInteger(LargeInteger) */ && operandNodeValue instanceof LargeInteger) {
            LargeInteger operandNodeValue_ = (LargeInteger) operandNodeValue;
            return JSIsNullOrUndefinedNode.doLargeInteger(operandNodeValue_);
        }
        if ((state & 0b100000) != 0 /* is-active doBigInt(BigInt) */ && operandNodeValue instanceof BigInt) {
            BigInt operandNodeValue_ = (BigInt) operandNodeValue;
            return JSIsNullOrUndefinedNode.doBigInt(operandNodeValue_);
        }
        if ((state & 0b111000000) != 0 /* is-active doJSObjectCachedShape(DynamicObject, boolean, Shape) || doJSObjectCachedType(DynamicObject, boolean, ObjectType) || doJSObject(DynamicObject, ConditionProfile) */ && JSTypes.isDynamicObject(operandNodeValue)) {
            DynamicObject operandNodeValue_ = (DynamicObject) operandNodeValue;
            if ((state & 0b1000000) != 0 /* is-active doJSObjectCachedShape(DynamicObject, boolean, Shape) */) {
                JSObjectCachedShapeData s7_ = this.jSObjectCachedShape_cache;
                while (s7_ != null) {
                    assert (s7_.isJSObject_);
                    if ((operandNodeValue_.getShape() == s7_.cachedShape_)) {
                        return JSIsNullOrUndefinedNode.doJSObjectCachedShape(operandNodeValue_, s7_.isJSObject_, s7_.cachedShape_);
                    }
                    s7_ = s7_.next_;
                }
            }
            if ((state & 0b10000000) != 0 /* is-active doJSObjectCachedType(DynamicObject, boolean, ObjectType) */) {
                JSObjectCachedTypeData s8_ = this.jSObjectCachedType_cache;
                while (s8_ != null) {
                    assert (s8_.isJSObject_);
                    if ((operandNodeValue_.getShape().getObjectType() == s8_.cachedType_)) {
                        return JSIsNullOrUndefinedNode.doJSObjectCachedType(operandNodeValue_, s8_.isJSObject_, s8_.cachedType_);
                    }
                    s8_ = s8_.next_;
                }
            }
            if ((state & 0b100000000) != 0 /* is-active doJSObject(DynamicObject, ConditionProfile) */) {
                if ((JSGuards.isJSType(operandNodeValue_))) {
                    return JSIsNullOrUndefinedNode.doJSObject(operandNodeValue_, this.jSObject_resultProfile_);
                }
            }
        }
        if ((state & 0b1000000000) != 0 /* is-active doJSValueCached(Object, Class<>) */ && (operandNodeValue != null)) {
            JSValueCachedData s10_ = this.jSValueCached_cache;
            while (s10_ != null) {
                assert (s10_.cachedClass_ != null);
                if ((s10_.cachedClass_ == operandNodeValue.getClass())) {
                    return JSIsNullOrUndefinedNode.doJSValueCached(operandNodeValue, s10_.cachedClass_);
                }
                s10_ = s10_.next_;
            }
        }
        if ((state & 0b10000000000) != 0 /* is-active doJSValueJSObject(DynamicObject) */ && JSTypes.isDynamicObject(operandNodeValue)) {
            DynamicObject operandNodeValue_ = (DynamicObject) operandNodeValue;
            if ((JSGuards.isJSType(operandNodeValue_))) {
                return JSIsNullOrUndefinedNode.doJSValueJSObject(operandNodeValue_);
            }
        }
        if ((state & 0b11100000000000) != 0 /* is-active doJSValue(Object) || doForeign(Object, InteropLibrary) || doForeign(Object, InteropLibrary) */) {
            if ((state & 0b100000000000) != 0 /* is-active doJSValue(Object) */) {
                if ((!(JSGuards.isTruffleObject(operandNodeValue)))) {
                    return JSIsNullOrUndefinedNode.doJSValue(operandNodeValue);
                }
            }
            if ((state & 0b1000000000000) != 0 /* is-active doForeign(Object, InteropLibrary) */) {
                if ((this.foreign0_interop_.accepts(operandNodeValue)) && (JSGuards.isForeignObject(operandNodeValue))) {
                    return doForeign(operandNodeValue, this.foreign0_interop_);
                }
            }
            if ((state & 0b10000000000000) != 0 /* is-active doForeign(Object, InteropLibrary) */) {
                if ((JSGuards.isForeignObject(operandNodeValue))) {
                    return this.foreign1Boundary(state, operandNodeValue);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(operandNodeValue);
    }

    @TruffleBoundary
    private Object foreign1Boundary(int state, Object operandNodeValue) {
        Node prev_ = NodeUtil.pushEncapsulatingNode(this);
        try {
            return doForeign(operandNodeValue, (INTEROP_LIBRARY_.getUncached(operandNodeValue)));
        } finally {
            NodeUtil.popEncapsulatingNode(prev_);
        }
    }

    @ExplodeLoop
    @Override
    public boolean executeBoolean(Object operandNodeValue) {
        int state = state_;
        if ((state & 0b11) != 0 /* is-active doNull(Object) || doUndefined(Object) */) {
            if ((state & 0b1) != 0 /* is-active doNull(Object) */) {
                if ((JSGuards.isJSNull(operandNodeValue))) {
                    return JSIsNullOrUndefinedNode.doNull(operandNodeValue);
                }
            }
            if ((state & 0b10) != 0 /* is-active doUndefined(Object) */) {
                if ((JSGuards.isUndefined(operandNodeValue))) {
                    return JSIsNullOrUndefinedNode.doUndefined(operandNodeValue);
                }
            }
        }
        if ((state & 0b100) != 0 /* is-active doSymbol(Symbol) */ && operandNodeValue instanceof Symbol) {
            Symbol operandNodeValue_ = (Symbol) operandNodeValue;
            return JSIsNullOrUndefinedNode.doSymbol(operandNodeValue_);
        }
        if ((state & 0b1000) != 0 /* is-active doLazyString(JSLazyString) */ && operandNodeValue instanceof JSLazyString) {
            JSLazyString operandNodeValue_ = (JSLazyString) operandNodeValue;
            return JSIsNullOrUndefinedNode.doLazyString(operandNodeValue_);
        }
        if ((state & 0b10000) != 0 /* is-active doLargeInteger(LargeInteger) */ && operandNodeValue instanceof LargeInteger) {
            LargeInteger operandNodeValue_ = (LargeInteger) operandNodeValue;
            return JSIsNullOrUndefinedNode.doLargeInteger(operandNodeValue_);
        }
        if ((state & 0b100000) != 0 /* is-active doBigInt(BigInt) */ && operandNodeValue instanceof BigInt) {
            BigInt operandNodeValue_ = (BigInt) operandNodeValue;
            return JSIsNullOrUndefinedNode.doBigInt(operandNodeValue_);
        }
        if ((state & 0b111000000) != 0 /* is-active doJSObjectCachedShape(DynamicObject, boolean, Shape) || doJSObjectCachedType(DynamicObject, boolean, ObjectType) || doJSObject(DynamicObject, ConditionProfile) */ && JSTypes.isDynamicObject(operandNodeValue)) {
            DynamicObject operandNodeValue_ = (DynamicObject) operandNodeValue;
            if ((state & 0b1000000) != 0 /* is-active doJSObjectCachedShape(DynamicObject, boolean, Shape) */) {
                JSObjectCachedShapeData s7_ = this.jSObjectCachedShape_cache;
                while (s7_ != null) {
                    assert (s7_.isJSObject_);
                    if ((operandNodeValue_.getShape() == s7_.cachedShape_)) {
                        return JSIsNullOrUndefinedNode.doJSObjectCachedShape(operandNodeValue_, s7_.isJSObject_, s7_.cachedShape_);
                    }
                    s7_ = s7_.next_;
                }
            }
            if ((state & 0b10000000) != 0 /* is-active doJSObjectCachedType(DynamicObject, boolean, ObjectType) */) {
                JSObjectCachedTypeData s8_ = this.jSObjectCachedType_cache;
                while (s8_ != null) {
                    assert (s8_.isJSObject_);
                    if ((operandNodeValue_.getShape().getObjectType() == s8_.cachedType_)) {
                        return JSIsNullOrUndefinedNode.doJSObjectCachedType(operandNodeValue_, s8_.isJSObject_, s8_.cachedType_);
                    }
                    s8_ = s8_.next_;
                }
            }
            if ((state & 0b100000000) != 0 /* is-active doJSObject(DynamicObject, ConditionProfile) */) {
                if ((JSGuards.isJSType(operandNodeValue_))) {
                    return JSIsNullOrUndefinedNode.doJSObject(operandNodeValue_, this.jSObject_resultProfile_);
                }
            }
        }
        if ((state & 0b1000000000) != 0 /* is-active doJSValueCached(Object, Class<>) */ && (operandNodeValue != null)) {
            JSValueCachedData s10_ = this.jSValueCached_cache;
            while (s10_ != null) {
                assert (s10_.cachedClass_ != null);
                if ((s10_.cachedClass_ == operandNodeValue.getClass())) {
                    return JSIsNullOrUndefinedNode.doJSValueCached(operandNodeValue, s10_.cachedClass_);
                }
                s10_ = s10_.next_;
            }
        }
        if ((state & 0b10000000000) != 0 /* is-active doJSValueJSObject(DynamicObject) */ && JSTypes.isDynamicObject(operandNodeValue)) {
            DynamicObject operandNodeValue_ = (DynamicObject) operandNodeValue;
            if ((JSGuards.isJSType(operandNodeValue_))) {
                return JSIsNullOrUndefinedNode.doJSValueJSObject(operandNodeValue_);
            }
        }
        if ((state & 0b11100000000000) != 0 /* is-active doJSValue(Object) || doForeign(Object, InteropLibrary) || doForeign(Object, InteropLibrary) */) {
            if ((state & 0b100000000000) != 0 /* is-active doJSValue(Object) */) {
                if ((!(JSGuards.isTruffleObject(operandNodeValue)))) {
                    return JSIsNullOrUndefinedNode.doJSValue(operandNodeValue);
                }
            }
            if ((state & 0b1000000000000) != 0 /* is-active doForeign(Object, InteropLibrary) */) {
                if ((this.foreign0_interop_.accepts(operandNodeValue)) && (JSGuards.isForeignObject(operandNodeValue))) {
                    return doForeign(operandNodeValue, this.foreign0_interop_);
                }
            }
            if ((state & 0b10000000000000) != 0 /* is-active doForeign(Object, InteropLibrary) */) {
                if ((JSGuards.isForeignObject(operandNodeValue))) {
                    return this.foreign1Boundary0(state, operandNodeValue);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(operandNodeValue);
    }

    @TruffleBoundary
    private boolean foreign1Boundary0(int state, Object operandNodeValue) {
        Node prev_ = NodeUtil.pushEncapsulatingNode(this);
        try {
            return doForeign(operandNodeValue, (INTEROP_LIBRARY_.getUncached(operandNodeValue)));
        } finally {
            NodeUtil.popEncapsulatingNode(prev_);
        }
    }

    @ExplodeLoop
    @Override
    public Object execute(VirtualFrame frameValue) {
        int state = state_;
        Object operandNodeValue_ = super.operandNode.execute(frameValue);
        if ((state & 0b11) != 0 /* is-active doNull(Object) || doUndefined(Object) */) {
            if ((state & 0b1) != 0 /* is-active doNull(Object) */) {
                if ((JSGuards.isJSNull(operandNodeValue_))) {
                    return JSIsNullOrUndefinedNode.doNull(operandNodeValue_);
                }
            }
            if ((state & 0b10) != 0 /* is-active doUndefined(Object) */) {
                if ((JSGuards.isUndefined(operandNodeValue_))) {
                    return JSIsNullOrUndefinedNode.doUndefined(operandNodeValue_);
                }
            }
        }
        if ((state & 0b100) != 0 /* is-active doSymbol(Symbol) */ && operandNodeValue_ instanceof Symbol) {
            Symbol operandNodeValue__ = (Symbol) operandNodeValue_;
            return JSIsNullOrUndefinedNode.doSymbol(operandNodeValue__);
        }
        if ((state & 0b1000) != 0 /* is-active doLazyString(JSLazyString) */ && operandNodeValue_ instanceof JSLazyString) {
            JSLazyString operandNodeValue__ = (JSLazyString) operandNodeValue_;
            return JSIsNullOrUndefinedNode.doLazyString(operandNodeValue__);
        }
        if ((state & 0b10000) != 0 /* is-active doLargeInteger(LargeInteger) */ && operandNodeValue_ instanceof LargeInteger) {
            LargeInteger operandNodeValue__ = (LargeInteger) operandNodeValue_;
            return JSIsNullOrUndefinedNode.doLargeInteger(operandNodeValue__);
        }
        if ((state & 0b100000) != 0 /* is-active doBigInt(BigInt) */ && operandNodeValue_ instanceof BigInt) {
            BigInt operandNodeValue__ = (BigInt) operandNodeValue_;
            return JSIsNullOrUndefinedNode.doBigInt(operandNodeValue__);
        }
        if ((state & 0b111000000) != 0 /* is-active doJSObjectCachedShape(DynamicObject, boolean, Shape) || doJSObjectCachedType(DynamicObject, boolean, ObjectType) || doJSObject(DynamicObject, ConditionProfile) */ && JSTypes.isDynamicObject(operandNodeValue_)) {
            DynamicObject operandNodeValue__ = (DynamicObject) operandNodeValue_;
            if ((state & 0b1000000) != 0 /* is-active doJSObjectCachedShape(DynamicObject, boolean, Shape) */) {
                JSObjectCachedShapeData s7_ = this.jSObjectCachedShape_cache;
                while (s7_ != null) {
                    assert (s7_.isJSObject_);
                    if ((operandNodeValue__.getShape() == s7_.cachedShape_)) {
                        return JSIsNullOrUndefinedNode.doJSObjectCachedShape(operandNodeValue__, s7_.isJSObject_, s7_.cachedShape_);
                    }
                    s7_ = s7_.next_;
                }
            }
            if ((state & 0b10000000) != 0 /* is-active doJSObjectCachedType(DynamicObject, boolean, ObjectType) */) {
                JSObjectCachedTypeData s8_ = this.jSObjectCachedType_cache;
                while (s8_ != null) {
                    assert (s8_.isJSObject_);
                    if ((operandNodeValue__.getShape().getObjectType() == s8_.cachedType_)) {
                        return JSIsNullOrUndefinedNode.doJSObjectCachedType(operandNodeValue__, s8_.isJSObject_, s8_.cachedType_);
                    }
                    s8_ = s8_.next_;
                }
            }
            if ((state & 0b100000000) != 0 /* is-active doJSObject(DynamicObject, ConditionProfile) */) {
                if ((JSGuards.isJSType(operandNodeValue__))) {
                    return JSIsNullOrUndefinedNode.doJSObject(operandNodeValue__, this.jSObject_resultProfile_);
                }
            }
        }
        if ((state & 0b1000000000) != 0 /* is-active doJSValueCached(Object, Class<>) */ && (operandNodeValue_ != null)) {
            JSValueCachedData s10_ = this.jSValueCached_cache;
            while (s10_ != null) {
                assert (s10_.cachedClass_ != null);
                if ((s10_.cachedClass_ == operandNodeValue_.getClass())) {
                    return JSIsNullOrUndefinedNode.doJSValueCached(operandNodeValue_, s10_.cachedClass_);
                }
                s10_ = s10_.next_;
            }
        }
        if ((state & 0b10000000000) != 0 /* is-active doJSValueJSObject(DynamicObject) */ && JSTypes.isDynamicObject(operandNodeValue_)) {
            DynamicObject operandNodeValue__ = (DynamicObject) operandNodeValue_;
            if ((JSGuards.isJSType(operandNodeValue__))) {
                return JSIsNullOrUndefinedNode.doJSValueJSObject(operandNodeValue__);
            }
        }
        if ((state & 0b11100000000000) != 0 /* is-active doJSValue(Object) || doForeign(Object, InteropLibrary) || doForeign(Object, InteropLibrary) */) {
            if ((state & 0b100000000000) != 0 /* is-active doJSValue(Object) */) {
                if ((!(JSGuards.isTruffleObject(operandNodeValue_)))) {
                    return JSIsNullOrUndefinedNode.doJSValue(operandNodeValue_);
                }
            }
            if ((state & 0b1000000000000) != 0 /* is-active doForeign(Object, InteropLibrary) */) {
                if ((this.foreign0_interop_.accepts(operandNodeValue_)) && (JSGuards.isForeignObject(operandNodeValue_))) {
                    return doForeign(operandNodeValue_, this.foreign0_interop_);
                }
            }
            if ((state & 0b10000000000000) != 0 /* is-active doForeign(Object, InteropLibrary) */) {
                if ((JSGuards.isForeignObject(operandNodeValue_))) {
                    return this.foreign1Boundary1(state, operandNodeValue_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(operandNodeValue_);
    }

    @TruffleBoundary
    private Object foreign1Boundary1(int state, Object operandNodeValue_) {
        Node prev_ = NodeUtil.pushEncapsulatingNode(this);
        try {
            return doForeign(operandNodeValue_, (INTEROP_LIBRARY_.getUncached(operandNodeValue_)));
        } finally {
            NodeUtil.popEncapsulatingNode(prev_);
        }
    }

    @ExplodeLoop
    @Override
    public boolean executeBoolean(VirtualFrame frameValue) {
        int state = state_;
        Object operandNodeValue_ = super.operandNode.execute(frameValue);
        if ((state & 0b11) != 0 /* is-active doNull(Object) || doUndefined(Object) */) {
            if ((state & 0b1) != 0 /* is-active doNull(Object) */) {
                if ((JSGuards.isJSNull(operandNodeValue_))) {
                    return JSIsNullOrUndefinedNode.doNull(operandNodeValue_);
                }
            }
            if ((state & 0b10) != 0 /* is-active doUndefined(Object) */) {
                if ((JSGuards.isUndefined(operandNodeValue_))) {
                    return JSIsNullOrUndefinedNode.doUndefined(operandNodeValue_);
                }
            }
        }
        if ((state & 0b100) != 0 /* is-active doSymbol(Symbol) */ && operandNodeValue_ instanceof Symbol) {
            Symbol operandNodeValue__ = (Symbol) operandNodeValue_;
            return JSIsNullOrUndefinedNode.doSymbol(operandNodeValue__);
        }
        if ((state & 0b1000) != 0 /* is-active doLazyString(JSLazyString) */ && operandNodeValue_ instanceof JSLazyString) {
            JSLazyString operandNodeValue__ = (JSLazyString) operandNodeValue_;
            return JSIsNullOrUndefinedNode.doLazyString(operandNodeValue__);
        }
        if ((state & 0b10000) != 0 /* is-active doLargeInteger(LargeInteger) */ && operandNodeValue_ instanceof LargeInteger) {
            LargeInteger operandNodeValue__ = (LargeInteger) operandNodeValue_;
            return JSIsNullOrUndefinedNode.doLargeInteger(operandNodeValue__);
        }
        if ((state & 0b100000) != 0 /* is-active doBigInt(BigInt) */ && operandNodeValue_ instanceof BigInt) {
            BigInt operandNodeValue__ = (BigInt) operandNodeValue_;
            return JSIsNullOrUndefinedNode.doBigInt(operandNodeValue__);
        }
        if ((state & 0b111000000) != 0 /* is-active doJSObjectCachedShape(DynamicObject, boolean, Shape) || doJSObjectCachedType(DynamicObject, boolean, ObjectType) || doJSObject(DynamicObject, ConditionProfile) */ && JSTypes.isDynamicObject(operandNodeValue_)) {
            DynamicObject operandNodeValue__ = (DynamicObject) operandNodeValue_;
            if ((state & 0b1000000) != 0 /* is-active doJSObjectCachedShape(DynamicObject, boolean, Shape) */) {
                JSObjectCachedShapeData s7_ = this.jSObjectCachedShape_cache;
                while (s7_ != null) {
                    assert (s7_.isJSObject_);
                    if ((operandNodeValue__.getShape() == s7_.cachedShape_)) {
                        return JSIsNullOrUndefinedNode.doJSObjectCachedShape(operandNodeValue__, s7_.isJSObject_, s7_.cachedShape_);
                    }
                    s7_ = s7_.next_;
                }
            }
            if ((state & 0b10000000) != 0 /* is-active doJSObjectCachedType(DynamicObject, boolean, ObjectType) */) {
                JSObjectCachedTypeData s8_ = this.jSObjectCachedType_cache;
                while (s8_ != null) {
                    assert (s8_.isJSObject_);
                    if ((operandNodeValue__.getShape().getObjectType() == s8_.cachedType_)) {
                        return JSIsNullOrUndefinedNode.doJSObjectCachedType(operandNodeValue__, s8_.isJSObject_, s8_.cachedType_);
                    }
                    s8_ = s8_.next_;
                }
            }
            if ((state & 0b100000000) != 0 /* is-active doJSObject(DynamicObject, ConditionProfile) */) {
                if ((JSGuards.isJSType(operandNodeValue__))) {
                    return JSIsNullOrUndefinedNode.doJSObject(operandNodeValue__, this.jSObject_resultProfile_);
                }
            }
        }
        if ((state & 0b1000000000) != 0 /* is-active doJSValueCached(Object, Class<>) */ && (operandNodeValue_ != null)) {
            JSValueCachedData s10_ = this.jSValueCached_cache;
            while (s10_ != null) {
                assert (s10_.cachedClass_ != null);
                if ((s10_.cachedClass_ == operandNodeValue_.getClass())) {
                    return JSIsNullOrUndefinedNode.doJSValueCached(operandNodeValue_, s10_.cachedClass_);
                }
                s10_ = s10_.next_;
            }
        }
        if ((state & 0b10000000000) != 0 /* is-active doJSValueJSObject(DynamicObject) */ && JSTypes.isDynamicObject(operandNodeValue_)) {
            DynamicObject operandNodeValue__ = (DynamicObject) operandNodeValue_;
            if ((JSGuards.isJSType(operandNodeValue__))) {
                return JSIsNullOrUndefinedNode.doJSValueJSObject(operandNodeValue__);
            }
        }
        if ((state & 0b11100000000000) != 0 /* is-active doJSValue(Object) || doForeign(Object, InteropLibrary) || doForeign(Object, InteropLibrary) */) {
            if ((state & 0b100000000000) != 0 /* is-active doJSValue(Object) */) {
                if ((!(JSGuards.isTruffleObject(operandNodeValue_)))) {
                    return JSIsNullOrUndefinedNode.doJSValue(operandNodeValue_);
                }
            }
            if ((state & 0b1000000000000) != 0 /* is-active doForeign(Object, InteropLibrary) */) {
                if ((this.foreign0_interop_.accepts(operandNodeValue_)) && (JSGuards.isForeignObject(operandNodeValue_))) {
                    return doForeign(operandNodeValue_, this.foreign0_interop_);
                }
            }
            if ((state & 0b10000000000000) != 0 /* is-active doForeign(Object, InteropLibrary) */) {
                if ((JSGuards.isForeignObject(operandNodeValue_))) {
                    return this.foreign1Boundary2(state, operandNodeValue_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(operandNodeValue_);
    }

    @TruffleBoundary
    private boolean foreign1Boundary2(int state, Object operandNodeValue_) {
        Node prev_ = NodeUtil.pushEncapsulatingNode(this);
        try {
            return doForeign(operandNodeValue_, (INTEROP_LIBRARY_.getUncached(operandNodeValue_)));
        } finally {
            NodeUtil.popEncapsulatingNode(prev_);
        }
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        executeBoolean(frameValue);
        return;
    }

    private boolean executeAndSpecialize(Object operandNodeValue) {
        Lock lock = getLock();
        boolean hasLock = true;
        lock.lock();
        int state = state_;
        int exclude = exclude_;
        try {
            if ((JSGuards.isJSNull(operandNodeValue))) {
                this.state_ = state = state | 0b1 /* add-active doNull(Object) */;
                lock.unlock();
                hasLock = false;
                return JSIsNullOrUndefinedNode.doNull(operandNodeValue);
            }
            if ((JSGuards.isUndefined(operandNodeValue))) {
                this.state_ = state = state | 0b10 /* add-active doUndefined(Object) */;
                lock.unlock();
                hasLock = false;
                return JSIsNullOrUndefinedNode.doUndefined(operandNodeValue);
            }
            if (operandNodeValue instanceof Symbol) {
                Symbol operandNodeValue_ = (Symbol) operandNodeValue;
                this.state_ = state = state | 0b100 /* add-active doSymbol(Symbol) */;
                lock.unlock();
                hasLock = false;
                return JSIsNullOrUndefinedNode.doSymbol(operandNodeValue_);
            }
            if (operandNodeValue instanceof JSLazyString) {
                JSLazyString operandNodeValue_ = (JSLazyString) operandNodeValue;
                this.state_ = state = state | 0b1000 /* add-active doLazyString(JSLazyString) */;
                lock.unlock();
                hasLock = false;
                return JSIsNullOrUndefinedNode.doLazyString(operandNodeValue_);
            }
            if (operandNodeValue instanceof LargeInteger) {
                LargeInteger operandNodeValue_ = (LargeInteger) operandNodeValue;
                this.state_ = state = state | 0b10000 /* add-active doLargeInteger(LargeInteger) */;
                lock.unlock();
                hasLock = false;
                return JSIsNullOrUndefinedNode.doLargeInteger(operandNodeValue_);
            }
            if (operandNodeValue instanceof BigInt) {
                BigInt operandNodeValue_ = (BigInt) operandNodeValue;
                this.state_ = state = state | 0b100000 /* add-active doBigInt(BigInt) */;
                lock.unlock();
                hasLock = false;
                return JSIsNullOrUndefinedNode.doBigInt(operandNodeValue_);
            }
            if (JSTypes.isDynamicObject(operandNodeValue)) {
                DynamicObject operandNodeValue_ = (DynamicObject) operandNodeValue;
                if (((exclude & 0b1)) == 0 /* is-not-excluded doJSObjectCachedShape(DynamicObject, boolean, Shape) */) {
                    int count7_ = 0;
                    JSObjectCachedShapeData s7_ = this.jSObjectCachedShape_cache;
                    if ((state & 0b1000000) != 0 /* is-active doJSObjectCachedShape(DynamicObject, boolean, Shape) */) {
                        while (s7_ != null) {
                            assert (s7_.isJSObject_);
                            if ((operandNodeValue_.getShape() == s7_.cachedShape_)) {
                                break;
                            }
                            s7_ = s7_.next_;
                            count7_++;
                        }
                    }
                    if (s7_ == null) {
                        {
                            boolean isJSObject__ = (JSGuards.isJSType(operandNodeValue_));
                            if ((isJSObject__)) {
                                Shape cachedShape__ = (operandNodeValue_.getShape());
                                if ((operandNodeValue_.getShape() == cachedShape__) && count7_ < (JSIsNullOrUndefinedNode.MAX_SHAPE_COUNT)) {
                                    s7_ = new JSObjectCachedShapeData(jSObjectCachedShape_cache);
                                    s7_.isJSObject_ = isJSObject__;
                                    s7_.cachedShape_ = cachedShape__;
                                    this.jSObjectCachedShape_cache = s7_;
                                    this.state_ = state = state | 0b1000000 /* add-active doJSObjectCachedShape(DynamicObject, boolean, Shape) */;
                                }
                            }
                        }
                    }
                    if (s7_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return JSIsNullOrUndefinedNode.doJSObjectCachedShape(operandNodeValue_, s7_.isJSObject_, s7_.cachedShape_);
                    }
                }
                if (((exclude & 0b10)) == 0 /* is-not-excluded doJSObjectCachedType(DynamicObject, boolean, ObjectType) */) {
                    int count8_ = 0;
                    JSObjectCachedTypeData s8_ = this.jSObjectCachedType_cache;
                    if ((state & 0b10000000) != 0 /* is-active doJSObjectCachedType(DynamicObject, boolean, ObjectType) */) {
                        while (s8_ != null) {
                            assert (s8_.isJSObject_);
                            if ((operandNodeValue_.getShape().getObjectType() == s8_.cachedType_)) {
                                break;
                            }
                            s8_ = s8_.next_;
                            count8_++;
                        }
                    }
                    if (s8_ == null) {
                        {
                            boolean isJSObject__ = (JSGuards.isJSType(operandNodeValue_));
                            if ((isJSObject__)) {
                                ObjectType cachedType__ = (operandNodeValue_.getShape().getObjectType());
                                if ((operandNodeValue_.getShape().getObjectType() == cachedType__) && count8_ < (JSIsNullOrUndefinedNode.MAX_TYPE_COUNT)) {
                                    s8_ = new JSObjectCachedTypeData(jSObjectCachedType_cache);
                                    s8_.isJSObject_ = isJSObject__;
                                    s8_.cachedType_ = cachedType__;
                                    this.jSObjectCachedType_cache = s8_;
                                    this.exclude_ = exclude = exclude | 0b1 /* add-excluded doJSObjectCachedShape(DynamicObject, boolean, Shape) */;
                                    this.jSObjectCachedShape_cache = null;
                                    state = state & 0xffffffbf /* remove-active doJSObjectCachedShape(DynamicObject, boolean, Shape) */;
                                    this.state_ = state = state | 0b10000000 /* add-active doJSObjectCachedType(DynamicObject, boolean, ObjectType) */;
                                }
                            }
                        }
                    }
                    if (s8_ != null) {
                        lock.unlock();
                        hasLock = false;
                        return JSIsNullOrUndefinedNode.doJSObjectCachedType(operandNodeValue_, s8_.isJSObject_, s8_.cachedType_);
                    }
                }
                if ((JSGuards.isJSType(operandNodeValue_))) {
                    this.jSObject_resultProfile_ = (ConditionProfile.createBinaryProfile());
                    this.exclude_ = exclude = exclude | 0b11 /* add-excluded doJSObjectCachedShape(DynamicObject, boolean, Shape), doJSObjectCachedType(DynamicObject, boolean, ObjectType) */;
                    this.jSObjectCachedShape_cache = null;
                    this.jSObjectCachedType_cache = null;
                    state = state & 0xffffff3f /* remove-active doJSObjectCachedShape(DynamicObject, boolean, Shape), doJSObjectCachedType(DynamicObject, boolean, ObjectType) */;
                    this.state_ = state = state | 0b100000000 /* add-active doJSObject(DynamicObject, ConditionProfile) */;
                    lock.unlock();
                    hasLock = false;
                    return JSIsNullOrUndefinedNode.doJSObject(operandNodeValue_, this.jSObject_resultProfile_);
                }
            }
            if (((exclude & 0b100)) == 0 /* is-not-excluded doJSValueCached(Object, Class<>) */ && (operandNodeValue != null)) {
                int count10_ = 0;
                JSValueCachedData s10_ = this.jSValueCached_cache;
                if ((state & 0b1000000000) != 0 /* is-active doJSValueCached(Object, Class<>) */) {
                    while (s10_ != null) {
                        assert (s10_.cachedClass_ != null);
                        if ((s10_.cachedClass_ == operandNodeValue.getClass())) {
                            break;
                        }
                        s10_ = s10_.next_;
                        count10_++;
                    }
                }
                if (s10_ == null) {
                    {
                        Class<?> cachedClass__ = (JSGuards.getNonTruffleObjectClass(operandNodeValue));
                        if ((cachedClass__ != null) && (cachedClass__ == operandNodeValue.getClass()) && count10_ < (JSIsNullOrUndefinedNode.MAX_CLASSES)) {
                            s10_ = new JSValueCachedData(jSValueCached_cache);
                            s10_.cachedClass_ = cachedClass__;
                            this.jSValueCached_cache = s10_;
                            this.state_ = state = state | 0b1000000000 /* add-active doJSValueCached(Object, Class<>) */;
                        }
                    }
                }
                if (s10_ != null) {
                    lock.unlock();
                    hasLock = false;
                    return JSIsNullOrUndefinedNode.doJSValueCached(operandNodeValue, s10_.cachedClass_);
                }
            }
            if (JSTypes.isDynamicObject(operandNodeValue)) {
                DynamicObject operandNodeValue_ = (DynamicObject) operandNodeValue;
                if ((JSGuards.isJSType(operandNodeValue_))) {
                    this.exclude_ = exclude = exclude | 0b100 /* add-excluded doJSValueCached(Object, Class<>) */;
                    this.jSValueCached_cache = null;
                    state = state & 0xfffffdff /* remove-active doJSValueCached(Object, Class<>) */;
                    this.state_ = state = state | 0b10000000000 /* add-active doJSValueJSObject(DynamicObject) */;
                    lock.unlock();
                    hasLock = false;
                    return JSIsNullOrUndefinedNode.doJSValueJSObject(operandNodeValue_);
                }
            }
            if ((!(JSGuards.isTruffleObject(operandNodeValue)))) {
                this.exclude_ = exclude = exclude | 0b100 /* add-excluded doJSValueCached(Object, Class<>) */;
                this.jSValueCached_cache = null;
                state = state & 0xfffffdff /* remove-active doJSValueCached(Object, Class<>) */;
                this.state_ = state = state | 0b100000000000 /* add-active doJSValue(Object) */;
                lock.unlock();
                hasLock = false;
                return JSIsNullOrUndefinedNode.doJSValue(operandNodeValue);
            }
            if (((exclude & 0b1000)) == 0 /* is-not-excluded doForeign(Object, InteropLibrary) */) {
                boolean Foreign0_duplicateFound_ = false;
                if ((state & 0b1000000000000) != 0 /* is-active doForeign(Object, InteropLibrary) */) {
                    if ((this.foreign0_interop_.accepts(operandNodeValue)) && (JSGuards.isForeignObject(operandNodeValue))) {
                        Foreign0_duplicateFound_ = true;
                    }
                }
                if (!Foreign0_duplicateFound_) {
                    if ((JSGuards.isForeignObject(operandNodeValue)) && ((state & 0b1000000000000)) == 0 /* is-not-active doForeign(Object, InteropLibrary) */) {
                        // assert (this.foreign0_interop_.accepts(operandNodeValue));
                        this.foreign0_interop_ = super.insert((INTEROP_LIBRARY_.create(operandNodeValue)));
                        this.state_ = state = state | 0b1000000000000 /* add-active doForeign(Object, InteropLibrary) */;
                        Foreign0_duplicateFound_ = true;
                    }
                }
                if (Foreign0_duplicateFound_) {
                    lock.unlock();
                    hasLock = false;
                    return doForeign(operandNodeValue, this.foreign0_interop_);
                }
            }
            {
                Node prev_ = NodeUtil.pushEncapsulatingNode(this);
                try {
                    if ((JSGuards.isForeignObject(operandNodeValue))) {
                        this.exclude_ = exclude = exclude | 0b1000 /* add-excluded doForeign(Object, InteropLibrary) */;
                        state = state & 0xffffefff /* remove-active doForeign(Object, InteropLibrary) */;
                        this.state_ = state = state | 0b10000000000000 /* add-active doForeign(Object, InteropLibrary) */;
                        lock.unlock();
                        hasLock = false;
                        return doForeign(operandNodeValue, (INTEROP_LIBRARY_.getUncached(operandNodeValue)));
                    }
                } finally {
                    NodeUtil.popEncapsulatingNode(prev_);
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {super.operandNode}, operandNodeValue);
        } finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    @Override
    public NodeCost getCost() {
        int state = state_;
        if (state == 0b0) {
            return NodeCost.UNINITIALIZED;
        } else if ((state & (state - 1)) == 0 /* is-single-active  */) {
            JSObjectCachedShapeData s7_ = this.jSObjectCachedShape_cache;
            JSObjectCachedTypeData s8_ = this.jSObjectCachedType_cache;
            JSValueCachedData s10_ = this.jSValueCached_cache;
            if ((s7_ == null || s7_.next_ == null) && (s8_ == null || s8_.next_ == null) && (s10_ == null || s10_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    @Override
    public Introspection getIntrospectionData() {
        Object[] data = new Object[15];
        Object[] s;
        data[0] = 0;
        int state = state_;
        int exclude = exclude_;
        s = new Object[3];
        s[0] = "doNull";
        if ((state & 0b1) != 0 /* is-active doNull(Object) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[1] = s;
        s = new Object[3];
        s[0] = "doUndefined";
        if ((state & 0b10) != 0 /* is-active doUndefined(Object) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "doSymbol";
        if ((state & 0b100) != 0 /* is-active doSymbol(Symbol) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[3] = s;
        s = new Object[3];
        s[0] = "doLazyString";
        if ((state & 0b1000) != 0 /* is-active doLazyString(JSLazyString) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[4] = s;
        s = new Object[3];
        s[0] = "doLargeInteger";
        if ((state & 0b10000) != 0 /* is-active doLargeInteger(LargeInteger) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[5] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        if ((state & 0b100000) != 0 /* is-active doBigInt(BigInt) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[6] = s;
        s = new Object[3];
        s[0] = "doJSObjectCachedShape";
        if ((state & 0b1000000) != 0 /* is-active doJSObjectCachedShape(DynamicObject, boolean, Shape) */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            JSObjectCachedShapeData s7_ = this.jSObjectCachedShape_cache;
            while (s7_ != null) {
                cached.add(Arrays.asList(s7_.isJSObject_, s7_.cachedShape_));
                s7_ = s7_.next_;
            }
            s[2] = cached;
        } else if ((exclude & 0b1) != 0 /* is-excluded doJSObjectCachedShape(DynamicObject, boolean, Shape) */) {
            s[1] = (byte)0b10 /* excluded */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[7] = s;
        s = new Object[3];
        s[0] = "doJSObjectCachedType";
        if ((state & 0b10000000) != 0 /* is-active doJSObjectCachedType(DynamicObject, boolean, ObjectType) */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            JSObjectCachedTypeData s8_ = this.jSObjectCachedType_cache;
            while (s8_ != null) {
                cached.add(Arrays.asList(s8_.isJSObject_, s8_.cachedType_));
                s8_ = s8_.next_;
            }
            s[2] = cached;
        } else if ((exclude & 0b10) != 0 /* is-excluded doJSObjectCachedType(DynamicObject, boolean, ObjectType) */) {
            s[1] = (byte)0b10 /* excluded */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[8] = s;
        s = new Object[3];
        s[0] = "doJSObject";
        if ((state & 0b100000000) != 0 /* is-active doJSObject(DynamicObject, ConditionProfile) */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            cached.add(Arrays.asList(this.jSObject_resultProfile_));
            s[2] = cached;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[9] = s;
        s = new Object[3];
        s[0] = "doJSValueCached";
        if ((state & 0b1000000000) != 0 /* is-active doJSValueCached(Object, Class<>) */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            JSValueCachedData s10_ = this.jSValueCached_cache;
            while (s10_ != null) {
                cached.add(Arrays.asList(s10_.cachedClass_));
                s10_ = s10_.next_;
            }
            s[2] = cached;
        } else if ((exclude & 0b100) != 0 /* is-excluded doJSValueCached(Object, Class<>) */) {
            s[1] = (byte)0b10 /* excluded */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[10] = s;
        s = new Object[3];
        s[0] = "doJSValueJSObject";
        if ((state & 0b10000000000) != 0 /* is-active doJSValueJSObject(DynamicObject) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[11] = s;
        s = new Object[3];
        s[0] = "doJSValue";
        if ((state & 0b100000000000) != 0 /* is-active doJSValue(Object) */) {
            s[1] = (byte)0b01 /* active */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[12] = s;
        s = new Object[3];
        s[0] = "doForeign";
        if ((state & 0b1000000000000) != 0 /* is-active doForeign(Object, InteropLibrary) */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            cached.add(Arrays.asList(this.foreign0_interop_));
            s[2] = cached;
        } else if ((exclude & 0b1000) != 0 /* is-excluded doForeign(Object, InteropLibrary) */) {
            s[1] = (byte)0b10 /* excluded */;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[13] = s;
        s = new Object[3];
        s[0] = "doForeign";
        if ((state & 0b10000000000000) != 0 /* is-active doForeign(Object, InteropLibrary) */) {
            s[1] = (byte)0b01 /* active */;
            ArrayList<Object> cached = new ArrayList<>();
            cached.add(Arrays.asList(INTEROP_LIBRARY_.getUncached()));
            s[2] = cached;
        } else {
            s[1] = (byte)0b00 /* inactive */;
        }
        data[14] = s;
        return Provider.create(data);
    }

    public static JSIsNullOrUndefinedNode create(JavaScriptNode operand, boolean isUndefined, boolean isLeft) {
        return new JSIsNullOrUndefinedNodeGen(operand, isUndefined, isLeft);
    }

    @GeneratedBy(JSIsNullOrUndefinedNode.class)
    private static final class JSObjectCachedShapeData {

        @CompilationFinal JSObjectCachedShapeData next_;
        @CompilationFinal boolean isJSObject_;
        @CompilationFinal Shape cachedShape_;

        JSObjectCachedShapeData(JSObjectCachedShapeData next_) {
            this.next_ = next_;
        }

    }
    @GeneratedBy(JSIsNullOrUndefinedNode.class)
    private static final class JSObjectCachedTypeData {

        @CompilationFinal JSObjectCachedTypeData next_;
        @CompilationFinal boolean isJSObject_;
        @CompilationFinal ObjectType cachedType_;

        JSObjectCachedTypeData(JSObjectCachedTypeData next_) {
            this.next_ = next_;
        }

    }
    @GeneratedBy(JSIsNullOrUndefinedNode.class)
    private static final class JSValueCachedData {

        @CompilationFinal JSValueCachedData next_;
        @CompilationFinal Class<?> cachedClass_;

        JSValueCachedData(JSValueCachedData next_) {
            this.next_ = next_;
        }

    }
}
